/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.api.component.impl;

import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.variant.AndroidResources;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.features.AndroidResourcesCreationConfig;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.errors.IssueReporter;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.google.common.base.Strings;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0004\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0000\u001a/\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u0002H\u000bH\u0000\u00a2\u0006\u0002\u0010\u0010\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0011"}, d2={"ENABLE_LEGACY_API", "", "getENABLE_LEGACY_API", "()Ljava/lang/String;", "getAndroidResources", "Lcom/android/build/api/variant/AndroidResources;", "Lcom/android/build/api/component/impl/ComponentImpl;", "isTestApk", "", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "warnAboutAccessingVariantApiValueForDisabledFeature", "T", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "featureName", "apiName", "value", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "gradle-core"})
@JvmName(name="ComponentUtils")
public final class ComponentUtils {
    @NotNull
    private static final String ENABLE_LEGACY_API = "Turn on with by putting '" + BooleanOption.ENABLE_LEGACY_API.getPropertyName() + "=true in gradle.properties'\nUsing this deprecated API may still fail, depending on usage of the new Variant API, like computing applicationId via a task output.";

    @NotNull
    public static final String getENABLE_LEGACY_API() {
        return ENABLE_LEGACY_API;
    }

    @NotNull
    public static final AndroidResources getAndroidResources(@NotNull ComponentImpl<?> $this$getAndroidResources) {
        Intrinsics.checkNotNullParameter($this$getAndroidResources, (String)"<this>");
        AndroidResourcesCreationConfig androidResourcesCreationConfig2 = $this$getAndroidResources.getAndroidResourcesCreationConfig();
        if (androidResourcesCreationConfig2 == null || (androidResourcesCreationConfig2 = androidResourcesCreationConfig2.getAndroidResources()) == null) {
            androidResourcesCreationConfig2 = $this$getAndroidResources.getAssetsCreationConfig().getAndroidResources();
        }
        return androidResourcesCreationConfig2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isTestApk(@NotNull ApkCreationConfig $this$isTestApk) {
        Intrinsics.checkNotNullParameter((Object)$this$isTestApk, (String)"<this>");
        ProjectOptions projectOptions = $this$isTestApk.getServices().getProjectOptions();
        Boolean bl = projectOptions.get(OptionalBooleanOption.IDE_TEST_ONLY);
        if (bl == null) {
            boolean bl2;
            if (!Strings.isNullOrEmpty((String)projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI))) return true;
            if (projectOptions.get(IntegerOption.IDE_TARGET_DEVICE_API) != null) return true;
            AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)$this$isTestApk.getGlobal().getCompileSdkHashString());
            if (androidVersion != null) {
                if (androidVersion.isPreview()) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if ($this$isTestApk.getMinSdkVersion().getCodename() != null) return true;
            if ($this$isTestApk.getTargetSdkVersion().getCodename() == null) return false;
            return true;
        }
        boolean bl3 = bl;
        return bl3;
    }

    public static final <T> T warnAboutAccessingVariantApiValueForDisabledFeature(@NotNull ComponentCreationConfig $this$warnAboutAccessingVariantApiValueForDisabledFeature, @NotNull String featureName2, @NotNull String apiName, T value) {
        Intrinsics.checkNotNullParameter((Object)$this$warnAboutAccessingVariantApiValueForDisabledFeature, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)featureName2, (String)"featureName");
        Intrinsics.checkNotNullParameter((Object)apiName, (String)"apiName");
        IssueReporter.reportWarning$default((IssueReporter)$this$warnAboutAccessingVariantApiValueForDisabledFeature.getServices().getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.ACCESSING_DISABLED_FEATURE_VARIANT_API, (String)("Accessing value " + apiName + " in variant " + $this$warnAboutAccessingVariantApiValueForDisabledFeature.getName() + " has no effect as the feature " + featureName2 + " is disabled."), null, null, (int)12, null);
        return value;
    }
}

