/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.dsl.AndroidSourceDirectorySet;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceDirectorySet;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.LibraryCreationConfig;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.utils.StringHelper;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.KotlinVersion;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmOptions;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\u001a&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a*\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u0014\u001a\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0001\u001a(\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0010\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010!\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010#\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010$\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0010\u0010%\u001a\u0004\u0018\u00010 2\u0006\u0010&\u001a\u00020\u0001\u001a,\u0010'\u001a\u00020\u00072\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u000f\u001a \u0010*\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u000fH\u0002\u001a\u001e\u0010,\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020/0.\u001a\u001e\u00100\u001a\u00020\u0007*\u00020\t2\b\u00101\u001a\u0004\u0018\u00010 2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a$\u00102\u001a\u00020\u0007*\u00020\t2\u0006\u00103\u001a\u00020\u00012\u0006\u00104\u001a\u00020\u00012\u0006\u00105\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00066\u00b2\u0006\u0012\u00107\u001a\n\u0012\u0004\u0012\u000208\u0018\u00010.X\u008a\u0084\u0002"}, d2={"KOTLIN_ANDROID_PLUGIN_ID", "", "KOTLIN_KAPT_PLUGIN_ID", "KOTLIN_MPP_PLUGIN_IDS", "", "KSP_PLUGIN_ID", "addComposeArgsToKotlinCompile", "", "task", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "compilerExtension", "Lorg/gradle/api/file/FileCollection;", "useLiveLiterals", "", "configureKotlinCompileForProject", "project", "Lorg/gradle/api/Project;", "action", "Lkotlin/Function1;", "findKaptOrKspConfigurationsForVariant", "Lorg/gradle/api/artifacts/Configuration;", "kaptOrKsp", "getKotlinOptionsValueIfSet", "Lorg/gradle/api/Task;", "extension", "Lcom/android/build/gradle/BaseExtension;", "methodName", "defaultValue", "getKotlinPluginVersion", "getProjectKotlinPluginKotlinVersion", "Lkotlin/KotlinVersion;", "isKotlinAndroidPluginApplied", "isKotlinKaptPluginApplied", "isKotlinPluginApplied", "isKspPluginApplied", "parseKotlinVersion", "currVersion", "recordIrBackendForAnalytics", "allPropertiesList", "composeIsEnabled", "setIrUsedInAnalytics", "useIr", "syncAgpAndKgpSources", "sourceSets", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lcom/android/build/gradle/api/AndroidSourceSet;", "addPluginClasspath", "kotlinVersion", "addPluginOption", "pluginId", "key", "value", "gradle-core", "kotlinSourceSets", ""})
@JvmName(name="KgpUtils")
public final class KgpUtils {
    @NotNull
    public static final String KOTLIN_ANDROID_PLUGIN_ID = "org.jetbrains.kotlin.android";
    @NotNull
    public static final String KOTLIN_KAPT_PLUGIN_ID = "org.jetbrains.kotlin.kapt";
    @NotNull
    public static final String KSP_PLUGIN_ID = "com.google.devtools.ksp";
    @NotNull
    private static final List<String> KOTLIN_MPP_PLUGIN_IDS;

    public static final boolean isKotlinPluginApplied(@NotNull Project project2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        try {
            boolean bl2;
            block5: {
                PluginContainer pluginContainer = project2.getPlugins();
                Intrinsics.checkNotNullExpressionValue((Object)pluginContainer, (String)"project.plugins");
                Iterable $this$any$iv = (Iterable)pluginContainer;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Plugin it = (Plugin)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof KotlinBasePluginWrapper)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (Throwable ignored) {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final KotlinVersion getProjectKotlinPluginKotlinVersion(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String currVersion = KgpUtils.getKotlinPluginVersion(project2);
        if (currVersion == null || Intrinsics.areEqual((Object)currVersion, (Object)"unknown")) {
            return null;
        }
        return KgpUtils.parseKotlinVersion(currVersion);
    }

    @Nullable
    public static final KotlinVersion parseKotlinVersion(@NotNull String currVersion) {
        Intrinsics.checkNotNullParameter((Object)currVersion, (String)"currVersion");
        try {
            String[] stringArray = new String[]{"."};
            List parts = StringsKt.split$default((CharSequence)currVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String major = (String)parts.get(0);
            String minor = (String)parts.get(1);
            String patch = StringsKt.substringBefore$default((String)((String)parts.get(2)), (char)'-', null, (int)2, null);
            return new KotlinVersion(Integer.parseInt(major), Integer.parseInt(minor), Integer.parseInt(patch));
        }
        catch (Throwable e) {
            KotlinVersion kotlinVersion = null;
            return kotlinVersion;
        }
    }

    @Nullable
    public static final String getKotlinPluginVersion(@NotNull Project project2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Plugin plugin = project2.getPlugins().findPlugin("kotlin-android");
        if (plugin == null) {
            return null;
        }
        Plugin plugin2 = plugin;
        try {
            Object element$iv2;
            block5: {
                Method[] methodArray = plugin2.getClass().getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"plugin.javaClass.methods");
                Object[] $this$first$iv = methodArray;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Method it = (Method)element$iv2;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"getKotlinPluginVersion") || Intrinsics.areEqual((Object)it.getName(), (Object)"getPluginVersion"))) {
                        continue;
                    }
                    break block5;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Method method = (Method)element$iv2;
            method.setAccessible(true);
            string = method.invoke((Object)plugin2, new Object[0]).toString();
        }
        catch (Throwable e) {
            string = "unknown";
        }
        return string;
    }

    public static final boolean isKotlinAndroidPluginApplied(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return project2.getPluginManager().hasPlugin(KOTLIN_ANDROID_PLUGIN_ID);
    }

    public static final boolean isKotlinKaptPluginApplied(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return project2.getPluginManager().hasPlugin(KOTLIN_KAPT_PLUGIN_ID);
    }

    public static final boolean isKspPluginApplied(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return project2.getPluginManager().hasPlugin(KSP_PLUGIN_ID);
    }

    public static final void configureKotlinCompileForProject(@NotNull Project project2, @NotNull ComponentCreationConfig creationConfig, @NotNull Function1<? super KotlinCompile, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        String expectedTaskNameOrPrefix = creationConfig.computeTaskName("compile", "Kotlin");
        project2.getTasks().withType(KotlinCompile.class).configureEach(new Action(project2, expectedTaskNameOrPrefix, action){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $expectedTaskNameOrPrefix;
            final /* synthetic */ Function1<KotlinCompile, Unit> $action;
            {
                this.$project = $project;
                this.$expectedTaskNameOrPrefix = $expectedTaskNameOrPrefix;
                this.$action = $action;
            }

            public final void execute(KotlinCompile it) {
                if (Intrinsics.areEqual((Object)it.getProject(), (Object)this.$project)) {
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    if (StringsKt.startsWith$default((String)string, (String)this.$expectedTaskNameOrPrefix, (boolean)false, (int)2, null)) {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        this.$action.invoke((Object)it);
                    }
                }
            }
        });
    }

    public static final void recordIrBackendForAnalytics(@NotNull List<? extends ComponentCreationConfig> allPropertiesList, @NotNull BaseExtension extension2, @NotNull Project project2, boolean composeIsEnabled) {
        Intrinsics.checkNotNullParameter(allPropertiesList, (String)"allPropertiesList");
        Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        for (ComponentCreationConfig componentCreationConfig : allPropertiesList) {
            try {
                KgpUtils.configureKotlinCompileForProject(project2, componentCreationConfig, (Function1<? super KotlinCompile, Unit>)((Function1)new Function1<KotlinCompile, Unit>(composeIsEnabled, componentCreationConfig, project2, extension2){
                    final /* synthetic */ boolean $composeIsEnabled;
                    final /* synthetic */ ComponentCreationConfig $creationConfig;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ BaseExtension $extension;
                    {
                        this.$composeIsEnabled = $composeIsEnabled;
                        this.$creationConfig = $creationConfig;
                        this.$project = $project;
                        this.$extension = $extension;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinCompile task) {
                        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                        try {
                            if (this.$composeIsEnabled) {
                                KgpUtils.access$setIrUsedInAnalytics(this.$creationConfig, this.$project, true);
                                return;
                            }
                            KotlinVersion kotlinVersion = KgpUtils.getProjectKotlinPluginKotlinVersion(this.$project);
                            if (kotlinVersion != null) {
                                boolean irBackendEnabled = !KgpUtils.access$getKotlinOptionsValueIfSet((Task)task, this.$extension, "getUseOldBackend", false);
                                KgpUtils.access$setIrUsedInAnalytics(this.$creationConfig, this.$project, irBackendEnabled);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }));
            }
            catch (Throwable throwable) {}
        }
    }

    private static final boolean getKotlinOptionsValueIfSet(Task task, BaseExtension extension2, String methodName, boolean defaultValue) {
        Method getKotlinOptions = task.getClass().getMethod("getKotlinOptions", new Class[0]);
        Object taskOptions = getKotlinOptions.invoke((Object)task, new Object[0]);
        Method method = taskOptions.getClass().getMethod(methodName, new Class[0]);
        Object object = method.invoke(taskOptions, new Object[0]);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean taskValue = (Boolean)object;
        if (defaultValue != taskValue) {
            return taskValue;
        }
        Intrinsics.checkNotNull((Object)extension2, (String)"null cannot be cast to non-null type org.gradle.api.plugins.ExtensionAware");
        Object kotlinDslOptions = ((ExtensionAware)extension2).getExtensions().getByName("kotlinOptions");
        Object object2 = method.invoke(kotlinDslOptions, new Object[0]);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean globalValue = (Boolean)object2;
        if (defaultValue != globalValue) {
            return globalValue;
        }
        return defaultValue;
    }

    private static final void setIrUsedInAnalytics(ComponentCreationConfig creationConfig, Project project2, boolean useIr) {
        Object object = BuildServicesKt.getBuildService(creationConfig.getServices().getBuildServiceRegistry(), AnalyticsConfiguratorService.class).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBuildService(\n       \u2026                   .get()");
        AnalyticsConfiguratorService buildService = (AnalyticsConfiguratorService)object;
        String string = project2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
        GradleBuildVariant.Builder builder = buildService.getVariantBuilder(string, creationConfig.getName());
        if (builder != null) {
            builder.setKotlinOptions(GradleBuildVariant.KotlinOptions.newBuilder().setUseIr(useIr));
        }
    }

    public static final void addComposeArgsToKotlinCompile(@NotNull KotlinCompile task, @NotNull ComponentCreationConfig creationConfig, @NotNull FileCollection compilerExtension, boolean useLiveLiterals) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)compilerExtension, (String)"compilerExtension");
        boolean debuggable = creationConfig instanceof ApkCreationConfig || creationConfig instanceof LibraryCreationConfig ? creationConfig.getDebuggable() : false;
        Project project2 = task.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"task.project");
        KotlinVersion kotlinVersion = KgpUtils.getProjectKotlinPluginKotlinVersion(project2);
        KgpUtils.addPluginClasspath(task, kotlinVersion, compilerExtension);
        KgpUtils.addPluginOption(task, "androidx.compose.plugins.idea", "enabled", "true");
        if (debuggable) {
            KgpUtils.addPluginOption(task, "androidx.compose.compiler.plugins.kotlin", "sourceInformation", "true");
            if (useLiveLiterals) {
                KgpUtils.addPluginOption(task, "androidx.compose.compiler.plugins.kotlin", "liveLiterals", "true");
            }
        }
        KotlinJvmOptions kotlinJvmOptions = task.getKotlinOptions();
        kotlinJvmOptions.setFreeCompilerArgs(CollectionsKt.plus((Collection)kotlinJvmOptions.getFreeCompilerArgs(), (Object)"-Xallow-unstable-dependencies"));
    }

    private static final void addPluginClasspath(KotlinCompile $this$addPluginClasspath, KotlinVersion kotlinVersion, FileCollection compilerExtension) {
        if (kotlinVersion == null || kotlinVersion.isAtLeast(1, 7)) {
            Object[] objectArray = new Object[]{compilerExtension};
            $this$addPluginClasspath.getPluginClasspath().from(objectArray);
        } else {
            Object[] objectArray = new Object[]{compilerExtension};
            $this$addPluginClasspath.getInputs().files(objectArray).withPropertyName("composeCompilerExtension").withNormalizer(ClasspathNormalizer.class);
            $this$addPluginClasspath.doFirst(new Action(compilerExtension){
                final /* synthetic */ FileCollection $compilerExtension;
                {
                    this.$compilerExtension = $compilerExtension;
                }

                public final void execute(Task it) {
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.tasks.KotlinCompile");
                    KotlinJvmOptions kotlinJvmOptions = ((KotlinCompile)it).getKotlinOptions();
                    Collection collection = kotlinJvmOptions.getFreeCompilerArgs();
                    Set set = this.$compilerExtension.getFiles();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"compilerExtension.files");
                    kotlinJvmOptions.setFreeCompilerArgs(CollectionsKt.plus((Collection)collection, (Object)("-Xplugin=" + ((File)CollectionsKt.single((Iterable)set)).getPath())));
                }
            });
        }
    }

    private static final void addPluginOption(KotlinCompile $this$addPluginOption, String pluginId, String key, String value) {
        KotlinJvmOptions kotlinJvmOptions = $this$addPluginOption.getKotlinOptions();
        Object[] objectArray = new String[]{"-P", "plugin:" + pluginId + ":" + key + "=" + value};
        kotlinJvmOptions.setFreeCompilerArgs(CollectionsKt.plus((Collection)kotlinJvmOptions.getFreeCompilerArgs(), (Iterable)CollectionsKt.listOf((Object[])objectArray)));
    }

    public static final void syncAgpAndKgpSources(@NotNull Project project2, @NotNull NamedDomainObjectContainer<? extends AndroidSourceSet> sourceSets) {
        boolean bl;
        boolean $i$f$any;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(sourceSets, (String)"sourceSets");
            Iterable $this$any$iv = KOTLIN_MPP_PLUGIN_IDS;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!project2.getPluginManager().hasPlugin(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean hasMpp = bl;
        try {
            Class.forName("org.gradle.api.internal.HasConvention");
            $i$f$any = true;
        }
        catch (Throwable ignored) {
            $i$f$any = false;
        }
        boolean hasConventionSupport = $i$f$any;
        Lazy kotlinSourceSets$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NamedDomainObjectContainer<Object>>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            @Nullable
            public final NamedDomainObjectContainer<Object> invoke() {
                Object object = this.$project.getExtensions().findByName("kotlin");
                if (object == null) {
                    return null;
                }
                Object kotlinExtension = object;
                Object object2 = kotlinExtension.getClass().getMethod("getSourceSets", new Class[0]).invoke(kotlinExtension, new Object[0]);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.gradle.api.NamedDomainObjectContainer<kotlin.Any>");
                return (NamedDomainObjectContainer)object2;
            }
        }));
        sourceSets.all(new Action(hasMpp, hasConventionSupport, (Lazy<? extends NamedDomainObjectContainer<Object>>)kotlinSourceSets$delegate){
            final /* synthetic */ boolean $hasMpp;
            final /* synthetic */ boolean $hasConventionSupport;
            final /* synthetic */ Lazy<NamedDomainObjectContainer<Object>> $kotlinSourceSets$delegate;
            {
                this.$hasMpp = $hasMpp;
                this.$hasConventionSupport = $hasConventionSupport;
                this.$kotlinSourceSets$delegate = $kotlinSourceSets$delegate;
            }

            public final void execute(AndroidSourceSet it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                SourceDirectorySet kotlinSourceSet = KgpUtils.access$syncAgpAndKgpSources$findKotlinSourceSet(it, this.$hasMpp, this.$hasConventionSupport, this.$kotlinSourceSets$delegate);
                if (kotlinSourceSet != null) {
                    if (!this.$hasMpp) {
                        Object[] objectArray = new Object[1];
                        AndroidSourceDirectorySet androidSourceDirectorySet = it.getKotlin();
                        Intrinsics.checkNotNull((Object)androidSourceDirectorySet, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.api.DefaultAndroidSourceDirectorySet");
                        objectArray[0] = ((DefaultAndroidSourceDirectorySet)androidSourceDirectorySet).getSrcDirs();
                        kotlinSourceSet.srcDirs(objectArray);
                    }
                    AndroidSourceDirectorySet androidSourceDirectorySet = it.getKotlin();
                    Set set = kotlinSourceSet.getSrcDirs();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"kotlinSourceSet.srcDirs");
                    androidSourceDirectorySet.setSrcDirs((Iterable)set);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Configuration> findKaptOrKspConfigurationsForVariant(@NotNull ComponentCreationConfig creationConfig, @NotNull String kaptOrKsp) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)kaptOrKsp, (String)"kaptOrKsp");
        Iterable $this$mapNotNull$iv = creationConfig.getSources().getSourceProviderNames();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Configuration it$iv$iv;
            String configurationName;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String sourceSetName = (String)element$iv$iv;
            boolean bl2 = false;
            String string = configurationName = !Intrinsics.areEqual((Object)sourceSetName, (Object)"main") ? StringHelper.appendCapitalized((String)kaptOrKsp, (String)sourceSetName) : kaptOrKsp;
            if ((Configuration)creationConfig.getServices().getConfigurations().findByName(configurationName) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final NamedDomainObjectContainer<Object> syncAgpAndKgpSources$lambda-3(Lazy<? extends NamedDomainObjectContainer<Object>> $kotlinSourceSets$delegate) {
        Lazy<? extends NamedDomainObjectContainer<Object>> lazy = $kotlinSourceSets$delegate;
        return (NamedDomainObjectContainer)lazy.getValue();
    }

    private static final SourceDirectorySet syncAgpAndKgpSources$findKotlinSourceSet(AndroidSourceSet $this$syncAgpAndKgpSources_u24findKotlinSourceSet, boolean hasMpp, boolean hasConventionSupport, Lazy<? extends NamedDomainObjectContainer<Object>> kotlinSourceSets$delegate) {
        if (hasMpp) {
            if (!hasConventionSupport) {
                return null;
            }
            Object convention = $this$syncAgpAndKgpSources_u24findKotlinSourceSet.getClass().getMethod("getConvention", new Class[0]).invoke((Object)$this$syncAgpAndKgpSources_u24findKotlinSourceSet, new Object[0]);
            Object object = convention.getClass().getMethod("getPlugins", new Class[0]).invoke(convention, new Object[0]);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            Map plugins = (Map)object;
            Object v = plugins.get("kotlin");
            if (v == null) {
                return null;
            }
            Object kotlinConvention = v;
            Object object2 = kotlinConvention.getClass().getMethod("getKotlin", new Class[0]).invoke(kotlinConvention, new Object[0]);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.gradle.api.file.SourceDirectorySet");
            return (SourceDirectorySet)object2;
        }
        NamedDomainObjectContainer<Object> namedDomainObjectContainer = KgpUtils.syncAgpAndKgpSources$lambda-3(kotlinSourceSets$delegate);
        Object object = namedDomainObjectContainer != null ? namedDomainObjectContainer.findByName($this$syncAgpAndKgpSources_u24findKotlinSourceSet.getName()) : null;
        if (object == null) {
            return null;
        }
        Object kotlinSourceSet = object;
        Object object3 = kotlinSourceSet.getClass().getMethod("getKotlin", new Class[0]).invoke(kotlinSourceSet, new Object[0]);
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.gradle.api.file.SourceDirectorySet");
        return (SourceDirectorySet)object3;
    }

    public static final /* synthetic */ void access$setIrUsedInAnalytics(ComponentCreationConfig creationConfig, Project project2, boolean useIr) {
        KgpUtils.setIrUsedInAnalytics(creationConfig, project2, useIr);
    }

    public static final /* synthetic */ boolean access$getKotlinOptionsValueIfSet(Task task, BaseExtension extension2, String methodName, boolean defaultValue) {
        return KgpUtils.getKotlinOptionsValueIfSet(task, extension2, methodName, defaultValue);
    }

    public static final /* synthetic */ SourceDirectorySet access$syncAgpAndKgpSources$findKotlinSourceSet(AndroidSourceSet $receiver, boolean hasMpp, boolean hasConventionSupport, Lazy kotlinSourceSets$delegate) {
        return KgpUtils.syncAgpAndKgpSources$findKotlinSourceSet($receiver, hasMpp, hasConventionSupport, (Lazy<? extends NamedDomainObjectContainer<Object>>)kotlinSourceSets$delegate);
    }

    static {
        Object[] objectArray = new String[]{"kotlin-multiplatform", "org.jetbrains.kotlin.multiplatform"};
        KOTLIN_MPP_PLUGIN_IDS = CollectionsKt.listOf((Object[])objectArray);
    }
}

