/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.gnumake;

import com.android.build.gradle.external.gnumake.BuildStepInfo;
import com.android.build.gradle.external.gnumake.CommandClassifierUtilsKt;
import com.android.build.gradle.external.gnumake.CommandLine;
import com.android.build.gradle.external.gnumake.CommandLineParser;
import com.android.build.gradle.external.gnumake.CompilerParser;
import com.android.build.gradle.internal.cxx.os.OsBehavior;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

class CommandClassifier {
    private static final NativeCompilerBuildTool sNativeCompilerBuildTool = new NativeCompilerBuildTool();
    @VisibleForTesting
    static final ImmutableList<BuildTool> DEFAULT_CLASSIFIERS = ImmutableList.of((Object)sNativeCompilerBuildTool, (Object)new ArBuildTool(), (Object)new CCacheBuildTool());

    CommandClassifier() {
    }

    @VisibleForTesting
    static List<BuildStepInfo> classify(String commands, OsBehavior os, List<BuildTool> classifiers) {
        List<CommandLine> commandLines = CommandLineParser.parse(commands, os);
        ArrayList<BuildStepInfo> commandSummaries = new ArrayList<BuildStepInfo>();
        for (CommandLine expr : commandLines) {
            for (BuildTool classifier : classifiers) {
                BuildStepInfo buildStepInfo;
                if (!classifier.isMatch(expr) || (buildStepInfo = classifier.createCommand(expr)) == null) continue;
                commandSummaries.add(buildStepInfo);
            }
        }
        return commandSummaries;
    }

    static List<BuildStepInfo> classify(String commands, OsBehavior os) {
        return CommandClassifier.classify(commands, os, DEFAULT_CLASSIFIERS);
    }

    static class NativeCompilerBuildTool
    implements BuildTool {
        NativeCompilerBuildTool() {
        }

        @Override
        public BuildStepInfo createCommand(CommandLine command) {
            boolean inputsAreSourceFiles;
            String[] arr = new String[command.getEscapedFlags().size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = command.getEscapedFlags().get(i);
            }
            OptionSet options = CompilerParser.get().parse(arr);
            ArrayList<String> outputs = new ArrayList<String>();
            List nonOptions = options.nonOptionArguments();
            List<String> inputs = nonOptions.stream().filter(nonOption -> !nonOption.startsWith("-")).filter(nonOption -> nonOption.contains(".")).collect(Collectors.toList());
            if (options.has("o") && options.hasArgument("o")) {
                List outputValues = options.valuesOf("o");
                if (options.valuesOf("o").size() > 1) {
                    throw new RuntimeException(String.format("GNUMAKE: Expected exactly one -o file in compile step: %s\nbut received: \n%s\nin command:\n%s\n", this, Joiner.on((String)"\n").join((Iterable)outputValues), Joiner.on((String)"\n").join(command.getRawFlags())));
                }
                String output2 = (String)options.valueOf("o");
                outputs.add(output2);
            }
            boolean bl = inputsAreSourceFiles = options.has("c") || options.has("S") || options.has("E");
            if (inputsAreSourceFiles && inputs.size() != 1) {
                throw new RuntimeException(String.format("GNUMAKE: Expected exactly one source file in compile step: %s\nbut received: \n%s\nin command:\n%s\n", this, Joiner.on((String)"\n").join(inputs), Joiner.on((String)"\n").join(command.getRawFlags())));
            }
            return new BuildStepInfo(command, inputs, outputs, inputsAreSourceFiles);
        }

        @Override
        public boolean isMatch(CommandLine command) {
            String executable = new File(command.getExecutable()).getName();
            return CommandClassifierUtilsKt.endsWithExecutableName(command, "gcc") || CommandClassifierUtilsKt.endsWithExecutableName(command, "g++") || CommandClassifierUtilsKt.endsWithExecutableName(command, "clang") || CommandClassifierUtilsKt.endsWithExecutableName(command, "clang++") || executable.contains("-gcc-") && !CommandClassifierUtilsKt.endsWithExecutableName(command, "-ar") || executable.contains("-g++-") && !CommandClassifierUtilsKt.endsWithExecutableName(command, "-ar");
        }
    }

    static class CCacheBuildTool
    implements BuildTool {
        CCacheBuildTool() {
        }

        @Override
        public BuildStepInfo createCommand(CommandLine command) {
            CommandLine translated = CCacheBuildTool.translateToCompilerCommandLine(command);
            return sNativeCompilerBuildTool.createCommand(translated);
        }

        @Override
        public boolean isMatch(CommandLine command) {
            if (CommandClassifierUtilsKt.endsWithExecutableName(command, "ccache")) {
                CommandLine translated = CCacheBuildTool.translateToCompilerCommandLine(command);
                return sNativeCompilerBuildTool.isMatch(translated);
            }
            return false;
        }

        private static CommandLine translateToCompilerCommandLine(CommandLine command) {
            ArrayList escaped = Lists.newArrayList(command.getEscapedFlags());
            ArrayList raw = Lists.newArrayList(command.getRawFlags());
            String baseCommand = (String)escaped.get(0);
            escaped.remove(0);
            raw.remove(0);
            return new CommandLine(baseCommand, escaped, raw);
        }
    }

    static class ArBuildTool
    implements BuildTool {
        private static final OptionParser PARSER = new OptionParser("cSE");

        ArBuildTool() {
        }

        private static void checkValidInput(String arg) {
            if (!arg.endsWith(".o")) {
                throw new RuntimeException(arg);
            }
        }

        private static void checkValidOutput(String arg) {
            if (!arg.endsWith(".a")) {
                throw new RuntimeException(arg);
            }
        }

        @Override
        public BuildStepInfo createCommand(CommandLine command) {
            String[] arr = new String[command.getEscapedFlags().size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = command.getEscapedFlags().get(i);
            }
            List options = PARSER.parse(arr).nonOptionArguments();
            if (!((String)options.get(0)).contains("c") || options.size() < 2) {
                return null;
            }
            if (options.size() == 2) {
                return new BuildStepInfo(command, Lists.newArrayList(), Lists.newArrayList());
            }
            ArrayList<String> inputs = new ArrayList<String>();
            ArrayList<String> outputs = new ArrayList<String>();
            String output2 = (String)options.get(1);
            ArBuildTool.checkValidOutput(output2);
            outputs.add(output2);
            for (int i = 2; i < options.size(); ++i) {
                String arg = (String)options.get(i);
                ArBuildTool.checkValidInput(arg);
                inputs.add(arg);
            }
            return new BuildStepInfo(command, inputs, outputs);
        }

        @Override
        public boolean isMatch(CommandLine command) {
            return CommandClassifierUtilsKt.endsWithExecutableName(command, "gcc-ar") || CommandClassifierUtilsKt.endsWithExecutableName(command, "android-ar") || CommandClassifierUtilsKt.endsWithExecutableName(command, "llvm-ar") || CommandClassifierUtilsKt.endsWithExecutableName(command, "androideabi-ar");
        }

        static {
            PARSER.accepts("plugin").withRequiredArg();
            PARSER.accepts("target").withRequiredArg();
            PARSER.accepts("X32_64");
            PARSER.accepts("p").withOptionalArg();
        }
    }

    static interface BuildTool {
        public BuildStepInfo createCommand(CommandLine var1);

        public boolean isMatch(CommandLine var1);
    }
}

