/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profgen;

import com.android.tools.profgen.Apk;
import com.android.tools.profgen.ArtProfile;
import com.android.tools.profgen.DexFile;
import com.android.tools.profgen.DexFileData;
import com.android.tools.profgen.DexMethod;
import com.android.tools.profgen.MethodData;
import com.android.tools.profgen.ObfuscationMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a4\u0010\u0000\u001a\u00020\u00012\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"dumpProfile", "", "file", "Ljava/io/File;", "profile", "Lcom/android/tools/profgen/ArtProfile;", "apk", "Lcom/android/tools/profgen/Apk;", "obf", "Lcom/android/tools/profgen/ObfuscationMap;", "os", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "strict", "", "profgen"})
public final class ProfileDumperKt {
    public static final void dumpProfile(@NotNull Appendable os, @NotNull ArtProfile profile, @NotNull Apk apk, @NotNull ObfuscationMap obf, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)apk, (String)"apk");
        Intrinsics.checkNotNullParameter((Object)obf, (String)"obf");
        for (Map.Entry<DexFile, DexFileData> entry : profile.getProfileData().entrySet()) {
            DexFile file;
            Object v0;
            DexFileData dexFileData2;
            DexFile dexFile;
            block6: {
                dexFile = entry.getKey();
                dexFileData2 = entry.getValue();
                Iterable iterable = apk.getDexes();
                for (Object object : iterable) {
                    DexFile it = (DexFile)object;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)dexFile.getName())) continue;
                    v0 = object;
                    break block6;
                }
                v0 = null;
            }
            if ((DexFile)v0 == null) {
                if (!strict) continue;
                throw new IllegalStateException("Cannot find Dex File " + dexFile.getName());
            }
            for (Map.Entry<Integer, MethodData> entry2 : dexFileData2.getMethods().entrySet()) {
                DexMethod dexMethod;
                int key = ((Number)entry2.getKey()).intValue();
                MethodData method = entry2.getValue();
                if (method.getFlags() == 0) continue;
                Intrinsics.checkNotNullExpressionValue((Object)file.getMethodPool$profgen().get(key), (String)"file.methodPool[key]");
                DexMethod deobfuscated = obf.deobfuscate$profgen(dexMethod);
                method.print(os);
                deobfuscated.print(os);
                os.append('\n');
            }
            Iterator<Object> iterator2 = dexFileData2.getTypeIndexes().iterator();
            while (iterator2.hasNext()) {
                String dexClass;
                Object object;
                int key = ((Number)iterator2.next()).intValue();
                Intrinsics.checkNotNullExpressionValue((Object)file.getTypePool$profgen().get(key), (String)"file.typePool[key]");
                List<String> deobfuscated = obf.deobfuscate$profgen(dexClass);
                object = deobfuscated.iterator();
                while (object.hasNext()) {
                    String type = (String)object.next();
                    os.append(type);
                    os.append('\n');
                }
            }
        }
    }

    public static /* synthetic */ void dumpProfile$default(Appendable appendable, ArtProfile artProfile, Apk apk, ObfuscationMap obfuscationMap, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        ProfileDumperKt.dumpProfile(appendable, artProfile, apk, obfuscationMap, bl);
    }

    public static final void dumpProfile(@NotNull File file, @NotNull ArtProfile profile, @NotNull Apk apk, @NotNull ObfuscationMap obf) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)apk, (String)"apk");
        Intrinsics.checkNotNullParameter((Object)obf, (String)"obf");
        OutputStream outputStream = new FileOutputStream(file);
        Charset charset = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter(outputStream, charset);
        int n = 8192;
        ProfileDumperKt.dumpProfile$default(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n), profile, apk, obf, false, 16, null);
    }
}

