/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.packaging.JarCreatorFactory;
import com.android.build.gradle.internal.packaging.JarCreatorType;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.TaskCategory;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.tasks.ZipMergingTask;
import com.android.builder.packaging.JarCreator;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.MISC, secondaryTaskCategories={TaskCategory.ZIPPING, TaskCategory.MERGING})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R,\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@@X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/tasks/ZipMergingTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "<set-?>", "Lcom/android/build/gradle/internal/packaging/JarCreatorType;", "jarCreatorType", "getJarCreatorType$annotations", "getJarCreatorType", "()Lcom/android/build/gradle/internal/packaging/JarCreatorType;", "setJarCreatorType$gradle_core", "(Lcom/android/build/gradle/internal/packaging/JarCreatorType;)V", "javaResInputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getJavaResInputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "libraryInputFile", "getLibraryInputFile", "outputFile", "getOutputFile", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class ZipMergingTask
extends NonIncrementalTask {
    public JarCreatorType jarCreatorType;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getLibraryInputFile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    @NotNull
    public abstract RegularFileProperty getJavaResInputFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Input
    @NotNull
    public final JarCreatorType getJarCreatorType() {
        JarCreatorType jarCreatorType = this.jarCreatorType;
        if (jarCreatorType != null) {
            return jarCreatorType;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"jarCreatorType");
        return null;
    }

    public final void setJarCreatorType$gradle_core(@NotNull JarCreatorType jarCreatorType) {
        Intrinsics.checkNotNullParameter((Object)((Object)jarCreatorType), (String)"<set-?>");
        this.jarCreatorType = jarCreatorType;
    }

    @VisibleForTesting
    public static /* synthetic */ void getJarCreatorType$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTaskAction() {
        File destinationFile = ((RegularFile)this.getOutputFile().get()).getAsFile();
        FileUtils.cleanOutputDir((File)destinationFile.getParentFile());
        Predicate<String> usedNamesPredicate2 = new Predicate<String>(){
            @NotNull
            private final Set<String> usedNames;
            {
                this.usedNames = new LinkedHashSet<E>();
            }

            @NotNull
            public final Set<String> getUsedNames() {
                return this.usedNames;
            }

            public boolean test(@NotNull String t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return this.usedNames.add(t);
            }
        };
        Path path = destinationFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"destinationFile.toPath()");
        Closeable closeable = (Closeable)JarCreatorFactory.INSTANCE.make(path, usedNamesPredicate2, this.getJarCreatorType());
        Throwable throwable = null;
        try {
            File javaRes;
            JarCreator it = (JarCreator)closeable;
            boolean bl = false;
            it.setCompressionLevel(0);
            File lib = ((RegularFile)this.getLibraryInputFile().get()).getAsFile();
            if (lib.exists()) {
                it.addJar(lib.toPath());
            }
            RegularFile regularFile = (RegularFile)this.getJavaResInputFile().getOrNull();
            File file = javaRes = regularFile != null ? regularFile.getAsFile() : null;
            boolean bl2 = file != null ? file.exists() : false;
            if (bl2) {
                it.addJar(javaRes.toPath());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/tasks/ZipMergingTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/tasks/ZipMergingTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ZipMergingTask, ComponentCreationConfig> {
        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return VariantTaskCreationAction.computeTaskName$default(this, "createFullJar", null, 2, null);
        }

        @Override
        @NotNull
        public Class<ZipMergingTask> getType() {
            return ZipMergingTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ZipMergingTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName(this.creationConfig.getArtifactName("full.jar")).on(InternalArtifactType.FULL_JAR.INSTANCE);
        }

        @Override
        public void configure(@NotNull ZipMergingTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            ArtifactsImpl artifacts = this.creationConfig.getArtifacts();
            artifacts.setTaskInputToFinalProduct(InternalArtifactType.RUNTIME_LIBRARY_CLASSES_JAR.INSTANCE, (Property)task.getLibraryInputFile());
            artifacts.setTaskInputToFinalProduct(InternalArtifactType.LIBRARY_JAVA_RES.INSTANCE, (Property)task.getJavaResInputFile());
            task.setJarCreatorType$gradle_core(this.creationConfig.getGlobal().getJarCreatorType());
        }
    }
}

