/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.plugins;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.dsl.AssetPackBundleExtension;
import com.android.build.api.dsl.SigningConfig;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.errors.DeprecationReporterImpl;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.errors.SyncIssueReporterImpl;
import com.android.build.gradle.internal.lint.LintFromMaven;
import com.android.build.gradle.internal.plugins.AssetPackBundlePlugin;
import com.android.build.gradle.internal.plugins.AssetPackBundlePluginKt;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.NoOpAnalyticsService;
import com.android.build.gradle.internal.res.Aapt2FromMaven;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.services.Aapt2DaemonBuildService;
import com.android.build.gradle.internal.services.Aapt2ThreadPoolBuildService;
import com.android.build.gradle.internal.services.AndroidLocationsBuildService;
import com.android.build.gradle.internal.services.DslServicesImpl;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.tasks.AppMetadataTask;
import com.android.build.gradle.internal.tasks.AssetPackPreBundleTask;
import com.android.build.gradle.internal.tasks.AssetPackUtilKt;
import com.android.build.gradle.internal.tasks.FinalizeBundleTask;
import com.android.build.gradle.internal.tasks.LinkManifestForAssetPackTask;
import com.android.build.gradle.internal.tasks.PackageBundleTask;
import com.android.build.gradle.internal.tasks.ProcessAssetPackManifestTask;
import com.android.build.gradle.internal.tasks.ValidateSigningTask;
import com.android.build.gradle.internal.tasks.factory.TaskConfigAction;
import com.android.build.gradle.internal.tasks.factory.TaskFactory;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryImpl;
import com.android.build.gradle.options.ProjectOptionService;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.errors.IssueReporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J \u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/plugins/AssetPackBundlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "listenerRegistry", "Lorg/gradle/build/event/BuildEventsListenerRegistry;", "getListenerRegistry$annotations", "getListenerRegistry", "()Lorg/gradle/build/event/BuildEventsListenerRegistry;", "apply", "", "project", "createTasks", "projectServices", "Lcom/android/build/gradle/internal/services/ProjectServices;", "extension", "Lcom/android/build/api/dsl/AssetPackBundleExtension;", "registerServices", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "validateInput", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "gradle-core"})
public abstract class AssetPackBundlePlugin
implements Plugin<Project> {
    @Inject
    @NotNull
    public abstract BuildEventsListenerRegistry getListenerRegistry();

    public static /* synthetic */ void getListenerRegistry$annotations() {
    }

    public void apply(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ProjectOptions projectOptions = ((ProjectOptionService)new ProjectOptionService.RegistrationAction(project2).execute().get()).getProjectOptions();
        SyncOptions.EvaluationMode evaluationMode = SyncOptions.getModelQueryMode(projectOptions);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluationMode), (String)"getModelQueryMode(projectOptions)");
        SyncOptions.ErrorFormatMode errorFormatMode = SyncOptions.getErrorFormatMode(projectOptions);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)errorFormatMode), (String)"getErrorFormatMode(projectOptions)");
        Logger logger = project2.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
        SyncIssueReporterImpl syncIssueHandler = new SyncIssueReporterImpl(evaluationMode, errorFormatMode, logger);
        IssueReporter issueReporter2 = syncIssueHandler;
        String string = project2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
        DeprecationReporterImpl deprecationReporter = new DeprecationReporterImpl(issueReporter2, projectOptions, string);
        SyncIssueReporter syncIssueReporter2 = syncIssueHandler;
        DeprecationReporter deprecationReporter2 = deprecationReporter;
        ObjectFactory objectFactory = project2.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        Logger logger2 = project2.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"project.logger");
        ProviderFactory providerFactory = project2.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"project.providers");
        ProjectLayout projectLayout = project2.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
        BuildServiceRegistry buildServiceRegistry = project2.getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
        LintFromMaven lintFromMaven = LintFromMaven.Companion.from(project2, projectOptions, syncIssueHandler);
        Aapt2FromMaven aapt2FromMaven = Aapt2FromMaven.Companion.create(project2, (Function1<? super StringOption, String>)((Function1)new Function1<StringOption, String>((Object)projectOptions){

            @Nullable
            public final String invoke(@NotNull StringOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ProjectOptions)this.receiver).get(p0);
            }
        }));
        int n = project2.getGradle().getStartParameter().getMaxWorkerCount();
        ProjectInfo projectInfo = new ProjectInfo(project2);
        Function1 function1 = (Function1)new Function1<Object, File>((Object)project2){

            public final File invoke(Object p0) {
                return ((Project)this.receiver).file(p0);
            }
        };
        ConfigurationContainer configurationContainer = project2.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
        DependencyHandler dependencyHandler = project2.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyHandler, (String)"project.dependencies");
        ExtraPropertiesExtension extraPropertiesExtension = project2.getExtensions().getExtraProperties();
        Intrinsics.checkNotNullExpressionValue((Object)extraPropertiesExtension, (String)"project.extensions.extraProperties");
        ProjectServices projectServices2 = new ProjectServices(syncIssueReporter2, deprecationReporter2, objectFactory, logger2, providerFactory, projectLayout, projectOptions, buildServiceRegistry, lintFromMaven, aapt2FromMaven, n, projectInfo, (Function1<Object, ? extends File>)function1, configurationContainer, dependencyHandler, extraPropertiesExtension);
        this.registerServices(project2, projectOptions);
        Provider provider2 = projectServices2.getProviderFactory().provider((Callable)apply.dslServices.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"projectServices.providerFactory.provider { null }");
        DslServicesImpl dslServices2 = new DslServicesImpl(projectServices2, provider2, null, 4, null);
        Object[] objectArray = new Object[]{dslServices2};
        AssetPackBundleExtension extension2 = dslServices2.newDecoratedInstance(AssetPackBundleExtension.class, objectArray);
        project2.getExtensions().add(AssetPackBundleExtension.class, "bundle", (Object)extension2);
        project2.afterEvaluate(new Action(this, projectServices2, extension2, project2){
            final /* synthetic */ AssetPackBundlePlugin this$0;
            final /* synthetic */ ProjectServices $projectServices;
            final /* synthetic */ AssetPackBundleExtension $extension;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$projectServices = $projectServices;
                this.$extension = $extension;
                this.$project = $project;
            }

            public final void execute(Project it) {
                AssetPackBundlePlugin.access$validateInput(this.this$0, this.$projectServices.getIssueReporter(), this.$extension);
                AssetPackBundlePlugin.access$createTasks(this.this$0, this.$project, this.$projectServices, this.$extension);
            }
        });
    }

    private final void registerServices(Project project2, ProjectOptions projectOptions) {
        if (projectOptions.isAnalyticsEnabled()) {
            AnalyticsConfiguratorService configuratorService2 = (AnalyticsConfiguratorService)new AnalyticsConfiguratorService.RegistrationAction(project2).execute().get();
            Intrinsics.checkNotNullExpressionValue((Object)configuratorService2, (String)"configuratorService");
            new AnalyticsService.RegistrationAction(project2, configuratorService2, this.getListenerRegistry()).execute();
        } else {
            new NoOpAnalyticsService.RegistrationAction(project2).execute();
        }
        new Aapt2ThreadPoolBuildService.RegistrationAction(project2, projectOptions).execute();
        new Aapt2DaemonBuildService.RegistrationAction(project2, projectOptions).execute();
        SyncOptions.EvaluationMode evaluationMode = SyncOptions.getModelQueryMode(projectOptions);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluationMode), (String)"getModelQueryMode(projectOptions)");
        SyncOptions.ErrorFormatMode errorFormatMode = SyncOptions.getErrorFormatMode(projectOptions);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)errorFormatMode), (String)"getErrorFormatMode(projectOptions)");
        new SyncIssueReporterImpl.GlobalSyncIssueService.RegistrationAction(project2, evaluationMode, errorFormatMode).execute();
        new AndroidLocationsBuildService.RegistrationAction(project2).execute();
        new SdkComponentsBuildService.RegistrationAction(project2, projectOptions).execute();
    }

    private final void validateInput(IssueReporter issueReporter2, AssetPackBundleExtension extension2) {
        SigningConfig signingConfig2;
        ArrayList<String> errors = new ArrayList<String>();
        if (((CharSequence)extension2.getApplicationId()).length() == 0) {
            errors.add("'applicationId' must be specified for asset pack bundle.");
        }
        if (((CharSequence)extension2.getVersionTag()).length() == 0) {
            errors.add("'versionTag' must be specified for asset pack bundle.");
        }
        if (extension2.getVersionCodes().isEmpty()) {
            errors.add("Asset pack bundle must target at least one version code.");
        }
        if (extension2.getAssetPacks().isEmpty()) {
            errors.add("Asset pack bundle must contain at least one asset pack.");
        }
        if (AssetPackBundlePluginKt.access$isPresent(signingConfig2 = extension2.getSigningConfig()) && (signingConfig2.getStoreFile() == null || signingConfig2.getStorePassword() == null || signingConfig2.getKeyAlias() == null || signingConfig2.getKeyPassword() == null)) {
            errors.add("Signing config is specified but incomplete. To make it complete 'storeFile', 'storePassword', 'keyAlias', 'keyPassword' must be specified.");
        }
        if (!((Collection)errors).isEmpty()) {
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (List)errors, (int)4, null);
        }
    }

    private final void createTasks(Project project2, ProjectServices projectServices2, AssetPackBundleExtension extension2) {
        Configuration assetPackFilesConfiguration = (Configuration)project2.getConfigurations().maybeCreate("assetPackFiles");
        Configuration assetPackManifestConfiguration = (Configuration)project2.getConfigurations().maybeCreate("assetPackManifest");
        IssueReporter issueReporter2 = projectServices2.getIssueReporter();
        Set set = extension2.getAssetPacks();
        Intrinsics.checkNotNullExpressionValue((Object)assetPackFilesConfiguration, (String)"assetPackFilesConfiguration");
        Intrinsics.checkNotNullExpressionValue((Object)assetPackManifestConfiguration, (String)"assetPackManifestConfiguration");
        AssetPackUtilKt.populateAssetPacksConfigurations(project2, issueReporter2, set, assetPackFilesConfiguration, assetPackManifestConfiguration);
        TaskContainer taskContainer = project2.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskFactoryImpl tasks = new TaskFactoryImpl(taskContainer);
        ArtifactsImpl artifacts = new ArtifactsImpl(project2, "global");
        tasks.register(new AppMetadataTask.CreationForAssetPackBundleAction(artifacts, projectServices2.getProjectOptions()));
        String string = extension2.getApplicationId();
        ArtifactCollection artifactCollection = assetPackManifestConfiguration.getIncoming().getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"assetPackManifestConfiguration.incoming.artifacts");
        tasks.register(new ProcessAssetPackManifestTask.CreationForAssetPackBundleAction(artifacts, string, artifactCollection));
        tasks.register(new LinkManifestForAssetPackTask.CreationForAssetPackBundleAction(artifacts, projectServices2, extension2.getCompileSdk()));
        tasks.register(new AssetPackPreBundleTask.CreationForAssetPackBundleAction(artifacts, (FileCollection)assetPackFilesConfiguration));
        tasks.register(new PackageBundleTask.CreationForAssetPackBundleAction(projectServices2, artifacts, extension2));
        if (AssetPackBundlePluginKt.access$isPresent(extension2.getSigningConfig())) {
            tasks.register(new ValidateSigningTask.CreationForAssetPackBundleAction(artifacts, extension2.getSigningConfig()));
        }
        tasks.register(new FinalizeBundleTask.CreationForAssetPackBundleAction(projectServices2, artifacts, extension2.getSigningConfig(), AssetPackBundlePluginKt.access$isPresent(extension2.getSigningConfig())));
        TaskFactory.register$default((TaskFactory)tasks, "bundle", null, (TaskConfigAction)new TaskConfigAction<Task>(artifacts){
            final /* synthetic */ ArtifactsImpl $artifacts;
            {
                this.$artifacts = $artifacts;
            }

            public void configure(@NotNull Task task) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                task.setDescription("Assembles asset pack bundle for asset only updates");
                Object[] objectArray = new Object[]{this.$artifacts.get((SingleArtifact)SingleArtifact.BUNDLE.INSTANCE)};
                task.dependsOn(objectArray);
            }
        }, null, 8, null);
    }

    public static final /* synthetic */ void access$validateInput(AssetPackBundlePlugin $this, IssueReporter issueReporter2, AssetPackBundleExtension extension2) {
        $this.validateInput(issueReporter2, extension2);
    }

    public static final /* synthetic */ void access$createTasks(AssetPackBundlePlugin $this, Project project2, ProjectServices projectServices2, AssetPackBundleExtension extension2) {
        $this.createTasks(project2, projectServices2, extension2);
    }
}

