/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.dsl.CompileOptions;
import com.android.build.api.variant.ComponentIdentity;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.ProguardFileType;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.PostProcessingOptions;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.dependency.AndroidAttributes;
import com.android.build.gradle.internal.dependency.ProvidedClasspath;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.packaging.JarCreatorType;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.PublishedConfigSpec;
import com.android.build.gradle.internal.publishing.PublishingSpecs;
import com.android.build.gradle.internal.scope.ArtifactPublishingUtil;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.BaseServices;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.ComponentType;
import com.android.builder.core.ComponentTypeImpl;
import com.android.builder.errors.IssueReporter;
import com.android.builder.internal.packaging.ApkCreatorType;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;

public class VariantScopeImpl
implements VariantScope {
    private final ComponentIdentity componentIdentity;
    private final VariantDslInfo variantDslInfo;
    private final VariantPathHelper pathHelper;
    private final ArtifactsImpl artifacts;
    private final VariantDependencies variantDependencies;
    private final PublishingSpecs.VariantSpec variantPublishingSpec;
    private final String compileSdkVersion;
    private final boolean hasDynamicFeatures;
    private final VariantImpl testedVariantProperties;
    private final Map<Abi, File> ndkDebuggableLibraryFolders = Maps.newHashMap();
    private final PostProcessingOptions postProcessingOptions;
    private final BaseServices baseServices;

    public VariantScopeImpl(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo, VariantDependencies variantDependencies2, VariantPathHelper pathHelper, ArtifactsImpl artifacts, BaseServices baseServices, String compileSdkVersion, boolean hasDynamicFeatures, VariantImpl testedVariantProperties) {
        this.componentIdentity = componentIdentity;
        this.variantDslInfo = variantDslInfo;
        this.variantDependencies = variantDependencies2;
        this.pathHelper = pathHelper;
        this.artifacts = artifacts;
        this.baseServices = baseServices;
        this.variantPublishingSpec = PublishingSpecs.getVariantSpec(variantDslInfo.getComponentType());
        this.compileSdkVersion = compileSdkVersion;
        this.hasDynamicFeatures = hasDynamicFeatures;
        this.testedVariantProperties = testedVariantProperties;
        this.postProcessingOptions = variantDslInfo.getPostProcessingOptions();
        this.configureNdk();
    }

    private void configureNdk() {
        File objFolder = ((Directory)this.pathHelper.intermediatesDir("ndk", this.pathHelper.getDirName(), "obj").get()).getAsFile();
        for (Abi abi : Abi.values()) {
            this.addNdkDebuggableLibraryFolders(abi, new File(objFolder, "local/" + abi.getTag()));
        }
    }

    @Override
    public PublishingSpecs.VariantSpec getPublishingSpec() {
        return this.variantPublishingSpec;
    }

    @Override
    public void publishIntermediateArtifact(Provider<?> artifact, AndroidArtifacts.ArtifactType artifactType, Set<PublishedConfigSpec> configSpecs, LibraryElements libraryElements, boolean isTestFixturesArtifact) {
        Preconditions.checkState((!configSpecs.isEmpty() ? 1 : 0) != 0);
        for (PublishedConfigSpec configSpec : configSpecs) {
            Configuration config2 = this.variantDependencies.getElements(configSpec);
            AndroidArtifacts.PublishedConfigType configType = configSpec.getConfigType();
            if (config2 == null) continue;
            if (configType.isPublicationConfig()) {
                boolean isJavaDocPublication;
                String classifier = null;
                boolean isSourcePublication = configType == AndroidArtifacts.PublishedConfigType.SOURCE_PUBLICATION;
                boolean bl = isJavaDocPublication = configType == AndroidArtifacts.PublishedConfigType.JAVA_DOC_PUBLICATION;
                if (configSpec.isClassifierRequired()) {
                    classifier = isSourcePublication ? this.componentIdentity.getName() + "-" + "sources" : (isJavaDocPublication ? this.componentIdentity.getName() + "-" + "javadoc" : this.componentIdentity.getName());
                } else if (isTestFixturesArtifact) {
                    classifier = "test-fixtures";
                } else if (isSourcePublication) {
                    classifier = "sources";
                } else if (isJavaDocPublication) {
                    classifier = "javadoc";
                }
                ArtifactPublishingUtil.publishArtifactToDefaultVariant(config2, artifact, artifactType, classifier);
                continue;
            }
            ArtifactPublishingUtil.publishArtifactToConfiguration(config2, artifact, artifactType, new AndroidAttributes(null, libraryElements));
        }
    }

    @Override
    public boolean isCrunchPngs() {
        Boolean buildTypeOverride = this.variantDslInfo.isCrunchPngs();
        if (buildTypeOverride != null) {
            return buildTypeOverride;
        }
        Boolean globalOverride = ((AaptOptions)this.variantDslInfo.getAndroidResources()).getCruncherEnabledOverride();
        if (globalOverride != null) {
            return globalOverride;
        }
        return this.variantDslInfo.isCrunchPngsDefault();
    }

    @Override
    public boolean consumesFeatureJars() {
        return this.variantDslInfo.getComponentType().isBaseModule() && this.variantDslInfo.getPostProcessingOptions().codeShrinkerEnabled() && this.hasDynamicFeatures;
    }

    @Override
    public boolean getNeedsJavaResStreams() {
        return this.variantDslInfo.getComponentType().isAar() && !this.variantDslInfo.getTransforms().isEmpty();
    }

    @Override
    public List<File> getConsumerProguardFiles() {
        return this.gatherProguardFiles(ProguardFileType.CONSUMER);
    }

    @Override
    public List<File> getConsumerProguardFilesForFeatures() {
        boolean includeProguardFiles = this.variantDslInfo.getComponentType().isDynamicFeature();
        List<File> consumerProguardFiles = this.getConsumerProguardFiles();
        if (includeProguardFiles) {
            consumerProguardFiles.addAll(this.gatherProguardFiles(ProguardFileType.EXPLICIT));
        }
        return ImmutableList.copyOf(consumerProguardFiles);
    }

    private List<File> gatherProguardFiles(ProguardFileType type) {
        ListProperty regularFiles = this.baseServices.getProjectInfo().getProject().getObjects().listProperty(RegularFile.class);
        this.variantDslInfo.gatherProguardFiles(type, (ListProperty<RegularFile>)regularFiles);
        return ((List)regularFiles.get()).stream().map(RegularFile::getAsFile).collect(Collectors.toList());
    }

    @Override
    public PostprocessingFeatures getPostprocessingFeatures() {
        return this.postProcessingOptions.getPostprocessingFeatures();
    }

    @Override
    public boolean isTestOnly(VariantImpl variant2) {
        ProjectOptions projectOptions = this.baseServices.getProjectOptions();
        Boolean isTestOnlyOverride = projectOptions.get(OptionalBooleanOption.IDE_TEST_ONLY);
        if (isTestOnlyOverride != null) {
            return isTestOnlyOverride;
        }
        return !Strings.isNullOrEmpty((String)projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI)) || !Strings.isNullOrEmpty((String)projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY)) || projectOptions.get(IntegerOption.IDE_TARGET_DEVICE_API) != null || this.isPreviewTargetPlatform() || variant2.getMinSdkVersion().getCodename() != null || variant2.getTargetSdkVersion().getCodename() != null;
    }

    private boolean isPreviewTargetPlatform() {
        AndroidVersion version = AndroidTargetHash.getVersionFromHash((String)this.compileSdkVersion);
        return version != null && version.isPreview();
    }

    @Override
    public boolean isCoreLibraryDesugaringEnabled(ConsumableCreationConfig creationConfig) {
        boolean langDesugarEnabled;
        CompileOptions compileOptions = creationConfig.getGlobal().getCompileOptions();
        boolean libDesugarEnabled = compileOptions.isCoreLibraryDesugaringEnabled();
        boolean multidexEnabled = creationConfig.isMultiDexEnabled();
        VariantScope.Java8LangSupport langSupportType = creationConfig.getJava8LangSupportType();
        boolean bl = langDesugarEnabled = langSupportType == VariantScope.Java8LangSupport.D8 || langSupportType == VariantScope.Java8LangSupport.R8;
        if (libDesugarEnabled && !langDesugarEnabled) {
            creationConfig.getServices().getIssueReporter().reportError(IssueReporter.Type.GENERIC, "In order to use core library desugaring, please enable java 8 language desugaring with D8 or R8.");
        }
        if (libDesugarEnabled && !multidexEnabled) {
            creationConfig.getServices().getIssueReporter().reportError(IssueReporter.Type.GENERIC, "In order to use core library desugaring, please enable multidex.");
        }
        return libDesugarEnabled;
    }

    @Override
    public void addNdkDebuggableLibraryFolders(Abi abi, File searchPath) {
        this.ndkDebuggableLibraryFolders.put(abi, searchPath);
    }

    @Override
    public FileCollection getLocalPackagedJars() {
        return this.getLocalFileDependencies(file -> file.getName().toLowerCase(Locale.US).endsWith(".jar"));
    }

    @Override
    public FileCollection getLocalFileDependencies(Predicate<File> filePredicate) {
        Configuration configuration = this.variantDependencies.getRuntimeClasspath();
        Callable<Collection> dependencies = () -> (Collection)configuration.getAllDependencies().stream().filter(it -> it instanceof SelfResolvingDependency).filter(it -> !(it instanceof ProjectDependency)).map(it -> (SelfResolvingDependency)it).collect(ImmutableList.toImmutableList());
        return this.baseServices.getProjectInfo().getProject().files(new Object[]{() -> ((Collection)dependencies.call()).stream().flatMap(it -> it.resolve().stream()).filter(filePredicate).collect(Collectors.toList())}).builtBy(new Object[]{dependencies});
    }

    @Override
    public FileCollection getProvidedOnlyClasspath() {
        ArtifactCollection compile = this.variantDependencies.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES_JAR);
        ArtifactCollection runtime = this.variantDependencies.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES_JAR);
        return ProvidedClasspath.getProvidedClasspath(compile, runtime);
    }

    @Override
    public Provider<RegularFile> getRJarForUnitTests() {
        ComponentType componentType = this.variantDslInfo.getComponentType();
        Preconditions.checkNotNull((Object)this.testedVariantProperties, (Object)("Variant type does not have a tested variant: " + componentType));
        Preconditions.checkState((componentType == ComponentTypeImpl.UNIT_TEST ? 1 : 0) != 0, (Object)("Expected unit test type but found: " + componentType));
        if (this.testedVariantProperties.getComponentType().isAar()) {
            return this.artifacts.get(InternalArtifactType.COMPILE_AND_RUNTIME_NOT_NAMESPACED_R_CLASS_JAR.INSTANCE);
        }
        Preconditions.checkState((boolean)this.testedVariantProperties.getComponentType().isApk(), (Object)("Expected APK type but found: " + this.testedVariantProperties.getComponentType()));
        return this.testedVariantProperties.getArtifacts().get(InternalArtifactType.COMPILE_AND_RUNTIME_NOT_NAMESPACED_R_CLASS_JAR.INSTANCE);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.componentIdentity.getName()).toString();
    }

    @Override
    public JarCreatorType getJarCreatorType() {
        if (this.baseServices.getProjectOptions().get(BooleanOption.USE_NEW_JAR_CREATOR)) {
            return JarCreatorType.JAR_FLINGER;
        }
        return JarCreatorType.JAR_MERGER;
    }

    @Override
    public ApkCreatorType getApkCreatorType() {
        if (this.baseServices.getProjectOptions().get(BooleanOption.USE_NEW_APK_CREATOR)) {
            return ApkCreatorType.APK_FLINGER;
        }
        return ApkCreatorType.APK_Z_FILE_CREATOR;
    }
}

