/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.ninja;

import com.android.build.gradle.internal.cxx.ninja.NinjaDepsInfo;
import com.android.build.gradle.internal.cxx.string.StringTable;
import com.google.common.primitives.Longs;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J+\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/cxx/ninja/NinjaDepsEncoder;", "Ljava/lang/AutoCloseable;", "stringTable", "Lcom/android/build/gradle/internal/cxx/string/StringTable;", "schemaVersion", "", "output", "Ljava/io/DataOutputStream;", "(Lcom/android/build/gradle/internal/cxx/string/StringTable;ILjava/io/DataOutputStream;)V", "sizeOfTimestamp", "close", "", "writeLittleEndianLong", "v", "", "writeLittleEndianUInt", "l", "writeLittleEndianUIntComplement", "writeLittleEndianUIntWithHighBitSet", "writePath", "path", "", "writeTarget", "target", "targetTimestamp", "dependencies", "", "(Ljava/lang/String;Ljava/lang/Long;Ljava/util/List;)V", "writeTimestamp", "(Ljava/lang/Long;)V", "Companion", "gradle-core"})
public final class NinjaDepsEncoder
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringTable stringTable;
    private final int schemaVersion;
    @NotNull
    private final DataOutputStream output;
    private final int sizeOfTimestamp;

    private NinjaDepsEncoder(StringTable stringTable, int schemaVersion, DataOutputStream output2) {
        this.stringTable = stringTable;
        this.schemaVersion = schemaVersion;
        this.output = output2;
        this.sizeOfTimestamp = this.schemaVersion == 3 ? 4 : 8;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeTarget(@NotNull String target, @Nullable Long targetTimestamp, @NotNull List<String> dependencies) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        int targetId = this.writePath(target);
        Iterable $this$map$iv = dependencies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = this.writePath((String)it);
            collection.add(n);
        }
        List dependencyIds = (List)destination$iv$iv;
        int size = 4 + this.sizeOfTimestamp + dependencies.size() * 4;
        this.writeLittleEndianUIntWithHighBitSet(size);
        this.writeLittleEndianUInt(targetId);
        this.writeTimestamp(targetTimestamp);
        Iterable $this$forEach$iv = dependencyIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.writeLittleEndianUInt(it);
        }
    }

    private final int writePath(String path) {
        return this.stringTable.getIdCreateIfAbsent(path, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(path, this){
            final /* synthetic */ String $path;
            final /* synthetic */ NinjaDepsEncoder this$0;
            {
                this.$path = $path;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int id) {
                String string = this.$path;
                Charset charset = Charsets.UTF_8;
                int n = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] bytes2 = byArray;
                int n2 = bytes2.length % 4;
                int padding = n2 == 0 ? 0 : 4 - n2;
                NinjaDepsEncoder.access$writeLittleEndianUInt(this.this$0, (long)(bytes2.length + padding) + 4L);
                for (byte element : bytes2) {
                    NinjaDepsEncoder.access$getOutput$p(this.this$0).writeByte(element);
                }
                NinjaDepsEncoder ninjaDepsEncoder = this.this$0;
                n = 0;
                int n3 = 0;
                n3 = 0;
                int n4 = padding;
                while (n3 < n4) {
                    int it = n3++;
                    boolean bl = false;
                    NinjaDepsEncoder.access$getOutput$p(ninjaDepsEncoder).writeByte(0);
                }
                NinjaDepsEncoder.access$writeLittleEndianUIntComplement(this.this$0, id);
            }
        }));
    }

    private final void writeTimestamp(Long targetTimestamp) {
        if (this.schemaVersion == 3) {
            Long l = targetTimestamp;
            if (l == null) {
                this.writeLittleEndianUInt(0L);
            } else {
                long l2 = 0L;
                if (l == l2) {
                    this.writeLittleEndianUInt(1L);
                } else {
                    this.writeLittleEndianUInt(targetTimestamp);
                }
            }
        } else {
            Long l = targetTimestamp;
            if (l == null) {
                this.writeLittleEndianLong(0L);
            } else {
                long l3 = 0L;
                if (l == l3) {
                    this.writeLittleEndianLong(1L);
                } else {
                    this.writeLittleEndianLong(targetTimestamp);
                }
            }
        }
    }

    private final void writeLittleEndianUInt(long l) {
        byte[] bytes2 = Longs.toByteArray((long)Long.reverseBytes(l));
        int n = 0;
        do {
            int i2 = n++;
            this.output.writeByte(bytes2[i2]);
        } while (n < 4);
    }

    private final void writeLittleEndianUIntWithHighBitSet(long l) {
        this.writeLittleEndianUInt(l | 0x80000000L);
    }

    private final void writeLittleEndianUIntComplement(long l) {
        this.writeLittleEndianUInt(l ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private final void writeLittleEndianLong(long v) {
        int n = 0;
        byte[] bytes2 = Longs.toByteArray((long)Long.reverseBytes(v));
        int n2 = 0 + bytes2.length;
        if (n < n2) {
            do {
                int i2 = n++;
                this.output.writeByte(bytes2[i2]);
            } while (n < n2);
        }
    }

    @Override
    public void close() {
        this.output.close();
    }

    public static final /* synthetic */ void access$writeLittleEndianUInt(NinjaDepsEncoder $this, long l) {
        $this.writeLittleEndianUInt(l);
    }

    public static final /* synthetic */ DataOutputStream access$getOutput$p(NinjaDepsEncoder $this) {
        return $this.output;
    }

    public static final /* synthetic */ void access$writeLittleEndianUIntComplement(NinjaDepsEncoder $this, long l) {
        $this.writeLittleEndianUIntComplement(l);
    }

    public /* synthetic */ NinjaDepsEncoder(StringTable stringTable, int schemaVersion, DataOutputStream output2, DefaultConstructorMarker $constructor_marker) {
        this(stringTable, schemaVersion, output2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/cxx/ninja/NinjaDepsEncoder$Companion;", "", "()V", "open", "Lcom/android/build/gradle/internal/cxx/ninja/NinjaDepsEncoder;", "ninjaDepsFile", "Ljava/io/File;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NinjaDepsEncoder open(@NotNull File ninjaDepsFile) {
            Intrinsics.checkNotNullParameter((Object)ninjaDepsFile, (String)"ninjaDepsFile");
            NinjaDepsInfo deps = NinjaDepsInfo.Companion.readFile(ninjaDepsFile);
            return new NinjaDepsEncoder(deps.getPathTable$gradle_core(), deps.getSchemaVersion$gradle_core(), new DataOutputStream(new BufferedOutputStream(new FileOutputStream(ninjaDepsFile, true))), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

