/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.dsl.DeviceGroup;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.InstrumentedTestCreationConfig;
import com.android.build.gradle.internal.dsl.ManagedVirtualDevice;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.prefs.AndroidLocationsProvider;
import com.android.utils.ComputerArchUtilsKt;
import com.android.utils.CpuArchitecture;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a(\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a&\u0010\f\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u000e\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0016\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010\"\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u0010#\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"GRADLE_AVD_DIRECTORY_PATH", "", "computeAbiFromArchitecture", "device", "Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;", "require64Bit", "", "apiLevel", "", "vendor", "cpuArch", "Lcom/android/utils/CpuArchitecture;", "computeAvdName", "imageSource", "abi", "hardwareProfile", "computeManagedDeviceEmulatorMode", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "getManagedDeviceAvdFolder", "Lorg/gradle/api/file/DirectoryProperty;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "androidLocationsProvider", "Lcom/android/prefs/AndroidLocationsProvider;", "managedDeviceAllVariantsTaskName", "managedDeviceGroupAllVariantsTaskName", "deviceGroup", "Lcom/android/build/api/dsl/DeviceGroup;", "managedDeviceGroupSingleVariantTaskName", "creationConfig", "Lcom/android/build/gradle/internal/component/InstrumentedTestCreationConfig;", "sanitizeProfileName", "setupTaskName", "gradle-core"})
public final class ManagedDeviceUtilsKt {
    @NotNull
    private static final String GRADLE_AVD_DIRECTORY_PATH = "gradle/avd";

    @NotNull
    public static final DirectoryProperty getManagedDeviceAvdFolder(@NotNull ObjectFactory objectFactory, @NotNull ProviderFactory providerFactory, @NotNull AndroidLocationsProvider androidLocationsProvider) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)androidLocationsProvider, (String)"androidLocationsProvider");
        DirectoryProperty directoryProperty = objectFactory.directoryProperty().fileProvider(providerFactory.provider(new Callable(androidLocationsProvider){
            final /* synthetic */ AndroidLocationsProvider $androidLocationsProvider;
            {
                this.$androidLocationsProvider = $androidLocationsProvider;
            }

            public final File call() {
                return this.$androidLocationsProvider.getGradleAvdLocation().toFile();
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"androidLocationsProvider\u2026dLocation.toFile()\n    })");
        return directoryProperty;
    }

    @NotNull
    public static final String computeAvdName(@NotNull ManagedVirtualDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        return ManagedDeviceUtilsKt.computeAvdName(device.getApiLevel(), device.getSystemImageSource(), ManagedDeviceUtilsKt.computeAbiFromArchitecture(device), device.getDevice());
    }

    @NotNull
    public static final String computeAvdName(int apiLevel, @NotNull String imageSource, @NotNull String abi, @NotNull String hardwareProfile) {
        Intrinsics.checkNotNullParameter((Object)imageSource, (String)"imageSource");
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        Intrinsics.checkNotNullParameter((Object)hardwareProfile, (String)"hardwareProfile");
        String sanitizedProfile = ManagedDeviceUtilsKt.sanitizeProfileName(hardwareProfile);
        String vendor = com.android.testing.utils.ManagedDeviceUtilsKt.computeVendorString((String)imageSource);
        return "dev" + apiLevel + '_' + vendor + '_' + abi + '_' + sanitizedProfile;
    }

    @NotNull
    public static final String sanitizeProfileName(@NotNull String hardwareProfile) {
        Intrinsics.checkNotNullParameter((Object)hardwareProfile, (String)"hardwareProfile");
        CharSequence charSequence = hardwareProfile;
        Regex regex = new Regex("[() ]");
        String string = "_";
        boolean bl = false;
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final String setupTaskName(@NotNull ManagedVirtualDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        return Intrinsics.stringPlus((String)device.getName(), (Object)"Setup");
    }

    @NotNull
    public static final String managedDeviceAllVariantsTaskName(@NotNull ManagedVirtualDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        return Intrinsics.stringPlus((String)device.getName(), (Object)"Check");
    }

    @NotNull
    public static final String managedDeviceGroupAllVariantsTaskName(@NotNull DeviceGroup deviceGroup) {
        Intrinsics.checkNotNullParameter((Object)deviceGroup, (String)"deviceGroup");
        return Intrinsics.stringPlus((String)deviceGroup.getName(), (Object)"GroupCheck");
    }

    @NotNull
    public static final String managedDeviceGroupSingleVariantTaskName(@NotNull InstrumentedTestCreationConfig creationConfig, @NotNull DeviceGroup deviceGroup) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)deviceGroup, (String)"deviceGroup");
        return ComponentCreationConfig.DefaultImpls.computeTaskName$default(creationConfig, Intrinsics.stringPlus((String)deviceGroup.getName(), (Object)"Group"), null, 2, null);
    }

    @NotNull
    public static final String computeAbiFromArchitecture(@NotNull ManagedVirtualDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        return ManagedDeviceUtilsKt.computeAbiFromArchitecture$default(device.getRequire64Bit(), device.getApiLevel(), device.getSystemImageSource(), null, 8, null);
    }

    @NotNull
    public static final String computeAbiFromArchitecture(boolean require64Bit, int apiLevel, @NotNull String vendor, @NotNull CpuArchitecture cpuArch) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)vendor, (String)"vendor");
        Intrinsics.checkNotNullParameter((Object)cpuArch, (String)"cpuArch");
        return cpuArch == CpuArchitecture.ARM || cpuArch == CpuArchitecture.X86_ON_ARM ? "arm64-v8a" : (require64Bit ? "x86_64" : (Intrinsics.areEqual((Object)vendor, (Object)"aosp") && CollectionsKt.listOf((Object[])(objectArray = new Integer[]{26, 30})).contains(apiLevel) ? "x86_64" : (apiLevel <= 30 ? "x86" : "x86_64")));
    }

    public static /* synthetic */ String computeAbiFromArchitecture$default(boolean bl, int n, String string, CpuArchitecture cpuArchitecture, int n2, Object object) {
        if ((n2 & 8) != 0) {
            cpuArchitecture = ComputerArchUtilsKt.getOsArchitecture();
        }
        return ManagedDeviceUtilsKt.computeAbiFromArchitecture(bl, n, string, cpuArchitecture);
    }

    @NotNull
    public static final String computeManagedDeviceEmulatorMode(@NotNull ProjectOptions projectOptions) {
        Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
        String string = projectOptions.get(StringOption.GRADLE_MANAGED_DEVICE_EMULATOR_GPU_MODE);
        String string2 = string == null ? "auto-no-window" : string;
        return string2;
    }
}

