/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.variant.ComponentIdentity;
import com.android.build.api.variant.impl.VariantBuilderImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.api.ApplicationVariantImpl;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.plugins.DslContainerProvider;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.services.VariantServices;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantFactory;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.builder.errors.IssueReporter;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u000e\u001a\u00020\u000f2\u001e\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0011H\u0016JH\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016JH\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*2\u0016\u0010+\u001a\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030,2\u001e\u0010-\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150.H\u0016J(\u0010/\u001a\u00020\u000f2\u001e\u0010-\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150.H\u0002R\u001e\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u00060"}, d2={"Lcom/android/build/gradle/internal/variant/AbstractAppVariantFactory;", "VariantBuilderT", "Lcom/android/build/api/variant/impl/VariantBuilderImpl;", "VariantT", "Lcom/android/build/api/variant/impl/VariantImpl;", "Lcom/android/build/gradle/internal/variant/BaseVariantFactory;", "projectServices", "Lcom/android/build/gradle/internal/services/ProjectServices;", "(Lcom/android/build/gradle/internal/services/ProjectServices;)V", "variantImplementationClass", "Ljava/lang/Class;", "Lcom/android/build/gradle/internal/api/BaseVariantImpl;", "getVariantImplementationClass", "()Ljava/lang/Class;", "createDefaultComponents", "", "dslContainers", "Lcom/android/build/gradle/internal/plugins/DslContainerProvider;", "Lcom/android/build/gradle/internal/dsl/DefaultConfig;", "Lcom/android/build/gradle/internal/dsl/BuildType;", "Lcom/android/build/gradle/internal/dsl/ProductFlavor;", "Lcom/android/build/gradle/internal/dsl/SigningConfig;", "createVariantData", "Lcom/android/build/gradle/internal/variant/BaseVariantData;", "componentIdentity", "Lcom/android/build/api/variant/ComponentIdentity;", "variantDslInfo", "Lcom/android/build/gradle/internal/core/VariantDslInfo;", "variantDependencies", "Lcom/android/build/gradle/internal/dependency/VariantDependencies;", "variantSources", "Lcom/android/build/gradle/internal/core/VariantSources;", "paths", "Lcom/android/build/gradle/internal/variant/VariantPathHelper;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "services", "Lcom/android/build/gradle/internal/services/VariantServices;", "taskContainer", "Lcom/android/build/gradle/internal/scope/MutableTaskContainer;", "preVariantCallback", "project", "Lorg/gradle/api/Project;", "dslExtension", "Lcom/android/build/api/dsl/CommonExtension;", "model", "Lcom/android/build/gradle/internal/variant/VariantInputModel;", "validateVersionCodes", "gradle-core"})
public abstract class AbstractAppVariantFactory<VariantBuilderT extends VariantBuilderImpl, VariantT extends VariantImpl>
extends BaseVariantFactory<VariantBuilderT, VariantT> {
    public AbstractAppVariantFactory(@NotNull ProjectServices projectServices2) {
        Intrinsics.checkNotNullParameter((Object)projectServices2, (String)"projectServices");
        super(projectServices2);
    }

    @Override
    @NotNull
    public BaseVariantData createVariantData(@NotNull ComponentIdentity componentIdentity, @NotNull VariantDslInfo variantDslInfo, @NotNull VariantDependencies variantDependencies, @NotNull VariantSources variantSources, @NotNull VariantPathHelper paths, @NotNull ArtifactsImpl artifacts, @NotNull VariantServices services, @NotNull MutableTaskContainer taskContainer) {
        Intrinsics.checkNotNullParameter((Object)componentIdentity, (String)"componentIdentity");
        Intrinsics.checkNotNullParameter((Object)variantDslInfo, (String)"variantDslInfo");
        Intrinsics.checkNotNullParameter((Object)variantDependencies, (String)"variantDependencies");
        Intrinsics.checkNotNullParameter((Object)variantSources, (String)"variantSources");
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        Intrinsics.checkNotNullParameter((Object)artifacts, (String)"artifacts");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)taskContainer, (String)"taskContainer");
        return new ApplicationVariantData(componentIdentity, variantDslInfo, variantDependencies, variantSources, paths, artifacts, services, taskContainer);
    }

    @Override
    @NotNull
    public Class<? extends BaseVariantImpl> getVariantImplementationClass() {
        return ApplicationVariantImpl.class;
    }

    @Override
    public void preVariantCallback(@NotNull Project project2, @NotNull CommonExtension<?, ?, ?, ?> dslExtension, @NotNull VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model) {
        boolean bl;
        Collection<String> collection;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(dslExtension, (String)"dslExtension");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        super.preVariantCallback(project2, dslExtension, model);
        this.validateVersionCodes(model);
        if (!this.getComponentType().isDynamicFeature()) {
            return;
        }
        IssueReporter issueReporter2 = this.projectServices.getIssueReporter();
        for (BuildTypeData<BuildType> buildType : model.getBuildTypes().values()) {
            if (!buildType.getBuildType().isMinifyEnabled()) continue;
            IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)StringsKt.trimIndent((String)("\n                            Dynamic feature modules cannot set minifyEnabled to true. minifyEnabled is set to true in build type '" + buildType.getBuildType().getName() + "'.\n                            To enable minification for a dynamic feature module, set minifyEnabled to true in the base module.\n                            ")), null, null, (int)12, null);
        }
        String message2 = "Signing configuration should not be declared in build types of dynamic-feature. Dynamic-features use the signing configuration declared in the application module.";
        for (BuildTypeData<BuildType> buildTypeData : model.getBuildTypes().values()) {
            if (buildTypeData.getBuildType().getSigningConfig() == null) continue;
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.SIGNING_CONFIG_DECLARED_IN_DYNAMIC_FEATURE, (String)message2, null, null, (int)12, null);
        }
        message2 = "Signing configuration should not be declared in product flavors of dynamic-feature. Dynamic-features use the signing configuration declared in the application module.";
        for (ProductFlavorData productFlavorData : model.getProductFlavors().values()) {
            if (((ProductFlavor)productFlavorData.getProductFlavor()).getSigningConfig() == null) continue;
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.SIGNING_CONFIG_DECLARED_IN_DYNAMIC_FEATURE, (String)message2, null, null, (int)12, null);
        }
        message2 = "abiFilters should not be declared in dynamic-features. Dynamic-features use the abiFilters declared in the application module.";
        if (!model.getDefaultConfigData().getDefaultConfig().getNdkConfig().getAbiFilters().isEmpty()) {
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)message2, null, null, (int)12, null);
        }
        for (BuildTypeData buildTypeData : model.getBuildTypes().values()) {
            collection = ((BuildType)buildTypeData.getBuildType()).getNdkConfig().getAbiFilters();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"buildType.buildType.ndkConfig.abiFilters");
            collection = collection;
            bl = false;
            if (!(!collection.isEmpty())) continue;
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)message2, null, null, (int)12, null);
        }
        for (ProductFlavorData productFlavorData : model.getProductFlavors().values()) {
            collection = ((ProductFlavor)productFlavorData.getProductFlavor()).getNdkConfig().getAbiFilters();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"productFlavor.productFlavor.ndkConfig.abiFilters");
            bl = false;
            if (!(!collection.isEmpty())) continue;
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)message2, null, null, (int)12, null);
        }
    }

    @Override
    public void createDefaultComponents(@NotNull DslContainerProvider<DefaultConfig, BuildType, ProductFlavor, SigningConfig> dslContainers) {
        Intrinsics.checkNotNullParameter(dslContainers, (String)"dslContainers");
        dslContainers.getSigningConfigContainer().create("debug");
        dslContainers.getBuildTypeContainer().create("debug");
        dslContainers.getBuildTypeContainer().create("release");
    }

    private final void validateVersionCodes(VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model) {
        IssueReporter issueReporter2 = this.projectServices.getIssueReporter();
        Integer versionCode2 = model.getDefaultConfigData().getDefaultConfig().getVersionCode();
        if (versionCode2 != null && versionCode2 < 1) {
            IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)StringsKt.trimIndent((String)("\n                        android.defaultConfig.versionCode is set to " + versionCode2 + ", but it should be a positive integer.\n                        See https://developer.android.com/studio/publish/versioning#appversioning for more information.\n                        ")), null, null, (int)12, null);
            return;
        }
        for (ProductFlavorData<ProductFlavor> flavorData : model.getProductFlavors().values()) {
            Integer flavorVersionCode = flavorData.getProductFlavor().getVersionCode();
            if (flavorVersionCode == null || flavorVersionCode > 0) {
                return;
            }
            IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)("versionCode is set to " + flavorVersionCode + " in product flavor " + flavorData.getProductFlavor().getName() + ", but it should be a positive integer. See https://developer.android.com/studio/publish/versioning#appversioning for more information."), null, null, (int)12, null);
        }
    }
}

