/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.AllTestResults;
import com.android.build.gradle.internal.test.report.ClassPageRenderer;
import com.android.build.gradle.internal.test.report.ClassTestResults;
import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.HtmlReportRenderer;
import com.android.build.gradle.internal.test.report.OverviewPageRenderer;
import com.android.build.gradle.internal.test.report.PackagePageRenderer;
import com.android.build.gradle.internal.test.report.PackageTestResults;
import com.android.build.gradle.internal.test.report.PageRenderer;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestResult;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestReport {
    private final HtmlReportRenderer htmlRenderer = new HtmlReportRenderer();
    private final ReportType reportType;
    private final File resultDir;
    private final File reportDir;

    public TestReport(ReportType reportType, File resultDir, File reportDir) {
        this.reportType = reportType;
        this.resultDir = resultDir;
        this.reportDir = reportDir;
        this.htmlRenderer.requireResource(this.getClass().getResource("report.js"));
        this.htmlRenderer.requireResource(this.getClass().getResource("base-style.css"));
        this.htmlRenderer.requireResource(this.getClass().getResource("style.css"));
    }

    public CompositeTestResults generateReport() {
        AllTestResults model = this.loadModel();
        this.generateFiles(model);
        return model;
    }

    private AllTestResults loadModel() {
        File[] files2;
        AllTestResults model = new AllTestResults();
        if (this.resultDir.exists() && (files2 = this.resultDir.listFiles()) != null) {
            for (File file : files2) {
                if (!file.getName().startsWith("TEST-") || !file.getName().endsWith(".xml")) continue;
                this.mergeFromFile(file, model);
            }
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeFromFile(File file, AllTestResults model) {
        FileInputStream inputStream = null;
        try {
            Document document;
            inputStream = new FileInputStream(file);
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(inputStream));
            }
            finally {
                ((InputStream)inputStream).close();
            }
            String deviceName = null;
            String projectName = null;
            String flavorName2 = null;
            NodeList propertiesList = document.getElementsByTagName("properties");
            for (int i2 = 0; i2 < propertiesList.getLength(); ++i2) {
                Element properties = (Element)propertiesList.item(i2);
                XPath xPath = XPathFactory.newInstance().newXPath();
                deviceName = xPath.evaluate("property[@name='device']/@value", properties);
                projectName = xPath.evaluate("property[@name='project']/@value", properties);
                flavorName2 = xPath.evaluate("property[@name='flavor']/@value", properties);
            }
            NodeList testCases = document.getElementsByTagName("testcase");
            for (int i3 = 0; i3 < testCases.getLength(); ++i3) {
                Element testCase = (Element)testCases.item(i3);
                String className = testCase.getAttribute("classname");
                String testName = testCase.getAttribute("name");
                BigDecimal duration = this.parse(testCase.getAttribute("time"));
                duration = duration.multiply(BigDecimal.valueOf(1000L));
                NodeList failures = testCase.getElementsByTagName("failure");
                TestResult testResult = model.addTest(className, testName, duration.longValue(), deviceName, projectName, flavorName2);
                for (int j = 0; j < failures.getLength(); ++j) {
                    Element failure = (Element)failures.item(j);
                    testResult.addFailure(failure.getAttribute("message"), failure.getTextContent(), deviceName, projectName, flavorName2);
                }
                if (testCase.getElementsByTagName("skipped").getLength() <= 0) continue;
                testResult.ignored();
            }
            NodeList ignoredTestCases = document.getElementsByTagName("ignored-testcase");
            for (int i4 = 0; i4 < ignoredTestCases.getLength(); ++i4) {
                Element testCase = (Element)ignoredTestCases.item(i4);
                String className = testCase.getAttribute("classname");
                String testName = testCase.getAttribute("name");
                model.addTest(className, testName, 0L, deviceName, projectName, flavorName2).ignored();
            }
            String suiteClassName = document.getDocumentElement().getAttribute("name");
            if (!StringsKt.isBlank((CharSequence)suiteClassName)) {
                ClassTestResults suiteResults = model.addTestClass(suiteClassName);
                NodeList stdOutElements = document.getElementsByTagName("system-out");
                for (int i5 = 0; i5 < stdOutElements.getLength(); ++i5) {
                    suiteResults.addStandardOutput(stdOutElements.item(i5).getTextContent());
                }
                NodeList stdErrElements = document.getElementsByTagName("system-err");
                for (int i6 = 0; i6 < stdErrElements.getLength(); ++i6) {
                    suiteResults.addStandardError(stdErrElements.item(i6).getTextContent());
                }
            } else {
                NodeList stdOutElements = document.getElementsByTagName("system-out");
                for (int i7 = 0; i7 < stdOutElements.getLength(); ++i7) {
                    model.addStandardOutput(stdOutElements.item(i7).getTextContent());
                }
                NodeList stdErrElements = document.getElementsByTagName("system-err");
                for (int i8 = 0; i8 < stdErrElements.getLength(); ++i8) {
                    model.addStandardError(stdErrElements.item(i8).getTextContent());
                }
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not load test results from '%s'.", file), (Throwable)e);
        }
        finally {
            try {
                Closeables.close((Closeable)inputStream, (boolean)true);
            }
            catch (IOException iOException) {}
        }
    }

    private void generateFiles(AllTestResults model) {
        try {
            this.generatePage(model, new OverviewPageRenderer(this.reportType), new File(this.reportDir, "index.html"));
            for (PackageTestResults packageResults : model.getPackages()) {
                this.generatePage(packageResults, new PackagePageRenderer(this.reportType), new File(this.reportDir, packageResults.getFilename(this.reportType) + ".html"));
                for (ClassTestResults classResults : packageResults.getClasses()) {
                    this.generatePage(classResults, new ClassPageRenderer(this.reportType), new File(this.reportDir, classResults.getFilename(this.reportType) + ".html"));
                }
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not generate test report to '%s'.", this.reportDir), (Throwable)e);
        }
    }

    private <T extends CompositeTestResults> void generatePage(T model, PageRenderer<T> renderer, File outputFile) throws Exception {
        this.htmlRenderer.renderer(renderer).writeTo(model, outputFile);
    }

    public BigDecimal parse(String source) throws ParseException {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("#.#", symbols);
        format.setParseBigDecimal(true);
        return (BigDecimal)format.parse(source);
    }
}

