/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.internal.cxx.configure.CMakeVersion;
import com.android.build.gradle.internal.cxx.configure.CmakeLocatorKt;
import com.android.build.gradle.internal.cxx.configure.CmakeVersionRequirements;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment;
import com.android.build.gradle.internal.cxx.os.OsBehaviorKt;
import com.android.prefs.AndroidLocationsProvider;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.cxx.CxxDiagnosticCode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a~\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\n2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00120\u00112\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00120\u00112\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00120\u0011\u001a\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0019\u001a\u00020\nH\u0002\u001a\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u0012\u001a\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\n\u001a \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\nH\u0002\u001a\n\u0010!\u001a\u00020\"*\u00020\u0001\"\u0019\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001c\u0010\u0005\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\"\u001c\u0010\u0007\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0004\u00a8\u0006#"}, d2={"defaultCmakeVersion", "Lcom/android/repository/Revision;", "kotlin.jvm.PlatformType", "getDefaultCmakeVersion", "()Lcom/android/repository/Revision;", "forkCmakeReportedVersion", "getForkCmakeReportedVersion", "forkCmakeSdkVersionRevision", "getForkCmakeSdkVersionRevision", "findCmakePathLogic", "Ljava/io/File;", "cmakeVersionFromDsl", "", "cmakePathFromLocalProperties", "downloader", "Ljava/util/function/Consumer;", "environmentPaths", "Lkotlin/Function0;", "", "sdkFolders", "cmakeVersionGetter", "Lkotlin/Function1;", "repositoryPackages", "Lcom/android/repository/api/LocalPackage;", "getCmakeRevisionFromExecutable", "cmakeFolder", "getEnvironmentPaths", "getSdkCmakeFolders", "sdkRoot", "getSdkCmakePackages", "androidLocationsProvider", "Lcom/android/prefs/AndroidLocationsProvider;", "sdkFolder", "isCmakeForkVersion", "", "gradle-core"})
public final class CmakeLocatorKt {
    private static final Revision forkCmakeSdkVersionRevision = Revision.parseRevision((String)CMakeVersion.FORK.getSdkFolderName());
    private static final Revision forkCmakeReportedVersion = Revision.parseRevision((String)CMakeVersion.FORK.getVersion());
    private static final Revision defaultCmakeVersion = Revision.parseRevision((String)CMakeVersion.DEFAULT.getVersion());

    public static final Revision getForkCmakeSdkVersionRevision() {
        return forkCmakeSdkVersionRevision;
    }

    public static final Revision getForkCmakeReportedVersion() {
        return forkCmakeReportedVersion;
    }

    public static final Revision getDefaultCmakeVersion() {
        return defaultCmakeVersion;
    }

    @NotNull
    public static final List<File> getEnvironmentPaths() {
        String string = System.getenv("PATH");
        String envPath = string == null ? "" : string;
        CharSequence charSequence = System.getProperty("path.separator");
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getProperty(\"path.separator\")");
        int n = 0;
        Regex pathSeparator = new Regex(charSequence);
        charSequence = envPath;
        n = 0;
        boolean bl = false;
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)pathSeparator.split(charSequence, n)), (Function1)getEnvironmentPaths.1.INSTANCE), (Function1)getEnvironmentPaths.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> getSdkCmakeFolders(@Nullable File sdkRoot) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        File[] fileArray;
        File file = sdkRoot;
        File[] fileArray2 = file == null ? null : ((fileArray = FilesKt.resolve((File)file, (String)"cmake")) == null ? null : fileArray.listFiles());
        File[] $this$map$iv = fileArray2 == null ? new File[]{} : fileArray2;
        boolean $i$f$map = false;
        fileArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv;
        int n = ((void)iterator2).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_14 = item$iv$iv = iterator2[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            File file2 = FilesKt.resolve((File)it, (String)"bin");
            collection.add(file2);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private static final List<LocalPackage> getSdkCmakePackages(AndroidLocationsProvider androidLocationsProvider, File sdkFolder) {
        File file = sdkFolder;
        AndroidSdkHandler androidSdkHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)androidLocationsProvider, (Path)(file == null ? null : file.toPath()));
        RepoManager sdkManager = androidSdkHandler.getSdkManager((ProgressIndicator)new LoggerProgressIndicatorWrapper(ThreadLoggingEnvironment.Companion.getILogger(CxxDiagnosticCode.CMAKE_PACKAGES_SDK, CxxDiagnosticCode.CMAKE_PACKAGES_SDK)));
        RepositoryPackages packages = sdkManager.getPackages();
        Collection collection = packages.getLocalPackagesForPrefix("cmake");
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"packages.getLocalPackagesForPrefix(FD_CMAKE)");
        return CollectionsKt.toList((Iterable)collection);
    }

    private static final Revision getCmakeRevisionFromExecutable(File cmakeFolder2) {
        if (!cmakeFolder2.exists()) {
            return null;
        }
        File cmakeExecutable = new File(cmakeFolder2, Intrinsics.stringPlus((String)"cmake", (Object)OsBehaviorKt.getExe()));
        if (!cmakeExecutable.exists()) {
            return null;
        }
        return CmakeUtils.getVersion(cmakeFolder2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final File findCmakePathLogic(@Nullable String cmakeVersionFromDsl, @Nullable File cmakePathFromLocalProperties, @Nullable Consumer<String> downloader, @NotNull Function0<? extends List<? extends File>> environmentPaths, @NotNull Function0<? extends List<? extends File>> sdkFolders, @NotNull Function1<? super File, ? extends Revision> cmakeVersionGetter, @NotNull Function0<? extends List<? extends LocalPackage>> repositoryPackages) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(environmentPaths, (String)"environmentPaths");
        Intrinsics.checkNotNullParameter(sdkFolders, (String)"sdkFolders");
        Intrinsics.checkNotNullParameter(cmakeVersionGetter, (String)"cmakeVersionGetter");
        Intrinsics.checkNotNullParameter(repositoryPackages, (String)"repositoryPackages");
        CmakeVersionRequirements dsl = new CmakeVersionRequirements(cmakeVersionFromDsl);
        boolean bl = false;
        List nonsatisfiers = new ArrayList();
        if (cmakePathFromLocalProperties != null) {
            Revision version = CmakeLocatorKt.findCmakePathLogic$versionGetter(cmakeVersionGetter, FilesKt.resolve((File)cmakePathFromLocalProperties, (String)"bin"));
            if (version == null) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.CMAKE_VERSION_IS_INVALID, "Could not get version from cmake.dir path '" + cmakePathFromLocalProperties + "'.", new Object[0]);
            } else {
                if (cmakeVersionFromDsl == null) {
                    return cmakePathFromLocalProperties;
                }
                if (!dsl.isSatisfiedBy(version)) {
                    Collection collection = nonsatisfiers;
                    String string = "" + '\'' + version + "' found from cmake.dir";
                    boolean bl2 = false;
                    collection.add(string);
                } else {
                    return cmakePathFromLocalProperties;
                }
            }
        }
        boolean bl3 = false;
        Set cmakePaths = new LinkedHashSet();
        for (File environmentPath : (List)environmentPaths.invoke()) {
            if (cmakePaths.contains(environmentPath.getPath()) || (object2 = CmakeLocatorKt.findCmakePathLogic$versionGetter(cmakeVersionGetter, environmentPath)) == null) continue;
            Object version = object2;
            if (!dsl.isSatisfiedBy((Revision)version)) {
                object2 = nonsatisfiers;
                object = "" + '\'' + version + "' found in PATH";
                boolean bl4 = false;
                object2.add(object);
                continue;
            }
            object2 = environmentPath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"environmentPath.path");
            cmakePaths.add(object2);
        }
        if (cmakePaths.isEmpty()) {
            for (File sdkFolder : (List)sdkFolders.invoke()) {
                Object version;
                Object object3;
                if (cmakePaths.contains(sdkFolder.getPath())) continue;
                try {
                    object = Revision.parseRevision((String)CmakeUtils.keepWhileNumbersAndDots(sdkFolder.getParentFile().getName()));
                }
                catch (Throwable e) {
                    object = null;
                }
                object2 = object;
                if (object2 == null) {
                    object = CmakeLocatorKt.findCmakePathLogic$versionGetter(cmakeVersionGetter, sdkFolder);
                    if (object == null) continue;
                    object3 = object;
                } else {
                    object3 = version = object2;
                }
                if (!dsl.isSatisfiedBy((Revision)version)) continue;
                object2 = sdkFolder.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"sdkFolder.path");
                cmakePaths.add(object2);
            }
        }
        if (cmakePaths.isEmpty()) {
            for (LocalPackage localPackage : (List)repositoryPackages.invoke()) {
                Path packagePath = localPackage.getLocation().resolve("bin");
                if (cmakePaths.contains(((Object)packagePath).toString())) continue;
                Revision version = Intrinsics.areEqual((Object)localPackage.getVersion(), (Object)forkCmakeSdkVersionRevision) ? forkCmakeReportedVersion : localPackage.getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
                if (!dsl.isSatisfiedBy(version)) {
                    object = nonsatisfiers;
                    String e = "" + '\'' + version + "' found in SDK";
                    boolean bl5 = false;
                    object.add(e);
                    continue;
                }
                cmakePaths.add(((Object)packagePath).toString());
            }
        }
        if (cmakePaths.isEmpty()) {
            void $this$onEach$iv;
            if (downloader != null && dsl.getDownloadVersion() != null) {
                downloader.accept(dsl.getDownloadVersion());
                return CmakeLocatorKt.findCmakePathLogic(cmakeVersionFromDsl, cmakePathFromLocalProperties, null, environmentPaths, sdkFolders, cmakeVersionGetter, repositoryPackages);
            }
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.CMAKE_IS_MISSING, "CMake " + dsl.getHumanReadableVersionLanguage() + " was not found in SDK, PATH, or by cmake.dir property.", new Object[0]);
            Iterable iterable = CollectionsKt.distinct((Iterable)nonsatisfiers);
            boolean $i$f$onEach = false;
            void var12_21 = $this$onEach$iv;
            boolean bl6 = false;
            boolean bl7 = false;
            void $this$apply$iv = var12_21;
            boolean bl8 = false;
            for (Object element$iv : $this$apply$iv) {
                String it = (String)element$iv;
                boolean bl9 = false;
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.CMAKE_VERSION_IS_INVALID, "- CMake " + it + " did not satisfy requested version.", new Object[0]);
            }
            return null;
        }
        return new File((String)CollectionsKt.first((Iterable)cmakePaths)).getParentFile();
    }

    public static final boolean isCmakeForkVersion(@NotNull Revision $this$isCmakeForkVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$isCmakeForkVersion, (String)"<this>");
        return $this$isCmakeForkVersion.getMajor() == 3 && $this$isCmakeForkVersion.getMinor() == 6 && $this$isCmakeForkVersion.getMicro() == 0;
    }

    private static final Revision findCmakePathLogic$versionGetter(Function1<? super File, ? extends Revision> $cmakeVersionGetter, File cmakePath) {
        Revision revision;
        try {
            revision = (Revision)$cmakeVersionGetter.invoke((Object)cmakePath);
        }
        catch (IOException e) {
            LoggingEnvironmentKt.warnln("Could not execute cmake at '" + cmakePath + "' to get version. Skipping.", new Object[0]);
            revision = null;
        }
        return revision;
    }

    public static final /* synthetic */ Revision access$getCmakeRevisionFromExecutable(File cmakeFolder2) {
        return CmakeLocatorKt.getCmakeRevisionFromExecutable(cmakeFolder2);
    }

    public static final /* synthetic */ List access$getSdkCmakePackages(AndroidLocationsProvider androidLocationsProvider, File sdkFolder) {
        return CmakeLocatorKt.getSdkCmakePackages(androidLocationsProvider, sdkFolder);
    }
}

