/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ8\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\tJ(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\tH\u0002J6\u0010 \u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014J4\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00102\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00170\u0007H\u0002J\u0014\u0010%\u001a\u00020\u00102\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'J \u0010)\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010*\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J\u0018\u0010+\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\tH\u0002J:\u0010-\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00102\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00170\u0007H\u0002J\"\u0010/\u001a\u00020\u0017*\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001701H\u0002R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR \u0010\u0006\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/build/gradle/internal/AvdSnapshotHandler;", "", "showEmulatorKernelLogging", "", "deviceBootAndSnapshotCheckTimeoutSec", "", "processFactory", "Lkotlin/Function1;", "", "", "Ljava/lang/ProcessBuilder;", "(ZLjava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "Ljava/lang/Integer;", "checkSnapshotLoadable", "avdName", "emulatorExecutable", "Ljava/io/File;", "avdLocation", "emulatorGpuFlag", "logger", "Lcom/android/utils/ILogger;", "snapshotName", "closeEmulatorWithId", "", "adbExecutable", "emulatorProcess", "Ljava/lang/Process;", "idValue", "ensureEmulatorVersionRequirement", "emulatorDir", "findDeviceSerialWithId", "adb", "generateSnapshot", "getDeviceProperty", "propertyName", "emulatorSerial", "stdoutTextProcessor", "getEmulatorExecutable", "emulatorDirectoryProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "isBootCompleted", "isPackageManagerStarted", "killDevice", "serial", "runAdbShell", "shellCommandArgs", "waitUntilTimeout", "onTimeout", "Lkotlin/Function0;", "gradle-core"})
public final class AvdSnapshotHandler {
    private final boolean showEmulatorKernelLogging;
    @Nullable
    private final Integer deviceBootAndSnapshotCheckTimeoutSec;
    @NotNull
    private final Function1<List<String>, ProcessBuilder> processFactory;

    public AvdSnapshotHandler(boolean showEmulatorKernelLogging, @Nullable Integer deviceBootAndSnapshotCheckTimeoutSec, @NotNull Function1<? super List<String>, ProcessBuilder> processFactory) {
        Intrinsics.checkNotNullParameter(processFactory, (String)"processFactory");
        this.showEmulatorKernelLogging = showEmulatorKernelLogging;
        this.deviceBootAndSnapshotCheckTimeoutSec = deviceBootAndSnapshotCheckTimeoutSec;
        this.processFactory = processFactory;
    }

    public /* synthetic */ AvdSnapshotHandler(boolean bl, Integer n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(bl, n, (Function1<? super List<String>, ProcessBuilder>)function1);
    }

    @NotNull
    public final File getEmulatorExecutable(@NotNull Provider<Directory> emulatorDirectoryProvider2) {
        File file;
        Intrinsics.checkNotNullParameter(emulatorDirectoryProvider2, (String)"emulatorDirectoryProvider");
        Object object = (Directory)emulatorDirectoryProvider2.getOrNull();
        File file2 = file = object == null ? null : object.getAsFile();
        if (file == null) {
            object = "Emulator dir does not exist";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        File emulatorDir = file;
        this.ensureEmulatorVersionRequirement(emulatorDir);
        return FilesKt.resolve((File)emulatorDir, (String)"emulator");
    }

    public final boolean checkSnapshotLoadable(@NotNull String avdName, @NotNull File emulatorExecutable, @NotNull File avdLocation, @NotNull String emulatorGpuFlag, @NotNull ILogger logger, @NotNull String snapshotName) {
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)emulatorExecutable, (String)"emulatorExecutable");
        Intrinsics.checkNotNullParameter((Object)avdLocation, (String)"avdLocation");
        Intrinsics.checkNotNullParameter((Object)emulatorGpuFlag, (String)"emulatorGpuFlag");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)snapshotName, (String)"snapshotName");
        logger.info("Checking " + snapshotName + " on device " + avdName + " is loadable.", new Object[0]);
        Object object = new String[11];
        object[0] = emulatorExecutable.getAbsolutePath();
        object[1] = Intrinsics.stringPlus((String)"@", (Object)avdName);
        object[2] = "-no-window";
        object[3] = "-no-boot-anim";
        object[4] = "-no-audio";
        String string = "-verbose";
        boolean bl = false;
        boolean bl2 = false;
        String string2 = string;
        int n = 5;
        Object[] objectArray = object;
        Function1<List<String>, ProcessBuilder> function1 = this.processFactory;
        boolean bl3 = false;
        boolean bl4 = this.showEmulatorKernelLogging;
        objectArray[n] = bl4 ? string : null;
        string = "-show-kernel";
        bl = false;
        bl2 = false;
        String it = string;
        n = 6;
        objectArray = object;
        boolean bl5 = false;
        bl4 = this.showEmulatorKernelLogging;
        objectArray[n] = bl4 ? string : null;
        object[7] = "-gpu";
        object[8] = emulatorGpuFlag;
        object[9] = "-check-snapshot-loadable";
        object[10] = snapshotName;
        ProcessBuilder processBuilder = (ProcessBuilder)function1.invoke((Object)CollectionsKt.listOfNotNull((Object[])object));
        object = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"processBuilder.environment()");
        string = "ANDROID_AVD_HOME";
        String string3 = avdLocation.getAbsolutePath();
        bl2 = false;
        object.put(string, string3);
        Process process2 = processBuilder.start();
        Ref.BooleanRef success = new Ref.BooleanRef();
        try {
            GrabProcessOutput.grabProcessOutput((Process)process2, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_PROCESS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(logger, success){
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ Ref.BooleanRef $success;
                {
                    this.$logger = $logger;
                    this.$success = $success;
                }

                public void out(@Nullable String line) {
                    String string = line;
                    if (string == null) {
                        return;
                    }
                    this.$logger.verbose(line, new Object[0]);
                    if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Loadable", (boolean)false, (int)2, null)) {
                        this.$success.element = true;
                    }
                }

                public void err(@Nullable String line) {
                }
            });
        }
        catch (Exception e) {
            process2.destroy();
            throw new RuntimeException(e);
        }
        return success.element;
    }

    public static /* synthetic */ boolean checkSnapshotLoadable$default(AvdSnapshotHandler avdSnapshotHandler, String string, File file, File file2, String string2, ILogger iLogger, String string3, int n, Object object) {
        if ((n & 0x20) != 0) {
            string3 = "default_boot";
        }
        return avdSnapshotHandler.checkSnapshotLoadable(string, file, file2, string2, iLogger, string3);
    }

    private final void waitUntilTimeout(Process $this$waitUntilTimeout, ILogger logger, Function0<Unit> onTimeout) {
        long l;
        long timeoutSec;
        Integer n = this.deviceBootAndSnapshotCheckTimeoutSec;
        long l2 = timeoutSec = n == null ? 600L : (l = (long)n.intValue());
        if (timeoutSec > 0L) {
            logger.verbose("Waiting for a process to complete (timeout " + timeoutSec + " seconds)", new Object[0]);
            if (!$this$waitUntilTimeout.waitFor(timeoutSec, TimeUnit.SECONDS)) {
                onTimeout.invoke();
            }
        } else {
            logger.verbose("Waiting for a process to complete (no timeout)", new Object[0]);
            $this$waitUntilTimeout.waitFor();
        }
    }

    public final void generateSnapshot(@NotNull String avdName, @NotNull File emulatorExecutable, @NotNull File adbExecutable2, @NotNull File avdLocation, @NotNull String emulatorGpuFlag, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)emulatorExecutable, (String)"emulatorExecutable");
        Intrinsics.checkNotNullParameter((Object)adbExecutable2, (String)"adbExecutable");
        Intrinsics.checkNotNullParameter((Object)avdLocation, (String)"avdLocation");
        Intrinsics.checkNotNullParameter((Object)emulatorGpuFlag, (String)"emulatorGpuFlag");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        logger.verbose(Intrinsics.stringPlus((String)"Creating snapshot for ", (Object)avdName), new Object[0]);
        String deviceId = Intrinsics.stringPlus((String)avdName, (Object)"_snapshot");
        Object object = new String[11];
        object[0] = emulatorExecutable.getAbsolutePath();
        object[1] = Intrinsics.stringPlus((String)"@", (Object)avdName);
        object[2] = "-no-window";
        object[3] = "-no-boot-anim";
        object[4] = "-no-audio";
        String string = "-verbose";
        boolean bl = false;
        boolean bl2 = false;
        String string2 = string;
        int n = 5;
        Object[] objectArray = object;
        Function1<List<String>, ProcessBuilder> function1 = this.processFactory;
        boolean bl3 = false;
        boolean bl4 = this.showEmulatorKernelLogging;
        objectArray[n] = bl4 ? string : null;
        string = "-show-kernel";
        bl = false;
        bl2 = false;
        String it = string;
        n = 6;
        objectArray = object;
        boolean bl5 = false;
        bl4 = this.showEmulatorKernelLogging;
        objectArray[n] = bl4 ? string : null;
        object[7] = "-id";
        object[8] = deviceId;
        object[9] = "-gpu";
        object[10] = emulatorGpuFlag;
        ProcessBuilder processBuilder = (ProcessBuilder)function1.invoke((Object)CollectionsKt.listOfNotNull((Object[])object));
        object = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"processBuilder.environment()");
        string = "ANDROID_AVD_HOME";
        String string3 = avdLocation.getAbsolutePath();
        bl2 = false;
        object.put(string, string3);
        Process process2 = processBuilder.start();
        AtomicBoolean bootCompleted = new AtomicBoolean(false);
        try {
            new Thread(new Runnable(process2, this, adbExecutable2, deviceId, logger, avdName, bootCompleted){
                final /* synthetic */ Process $process;
                final /* synthetic */ AvdSnapshotHandler this$0;
                final /* synthetic */ File $adbExecutable;
                final /* synthetic */ String $deviceId;
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ String $avdName;
                final /* synthetic */ AtomicBoolean $bootCompleted;
                {
                    this.$process = $process;
                    this.this$0 = $receiver;
                    this.$adbExecutable = $adbExecutable;
                    this.$deviceId = $deviceId;
                    this.$logger = $logger;
                    this.$avdName = $avdName;
                    this.$bootCompleted = $bootCompleted;
                }

                public final void run() {
                    String string;
                    String emulatorSerial = null;
                    while (this.$process.isAlive()) {
                        try {
                            emulatorSerial = AvdSnapshotHandler.access$findDeviceSerialWithId(this.this$0, this.$adbExecutable, this.$deviceId);
                            break;
                        }
                        catch (Exception e) {
                            this.$logger.verbose("Waiting for " + this.$avdName + " to be attached to adb.", new Object[0]);
                            Thread.sleep(5000L);
                        }
                    }
                    StringBuilder stringBuilder = new StringBuilder().append(this.$avdName).append(" is attached to adb (");
                    if (emulatorSerial == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"emulatorSerial");
                        string = null;
                    } else {
                        string = emulatorSerial;
                    }
                    this.$logger.verbose(stringBuilder.append(string).append(").").toString(), new Object[0]);
                    while (this.$process.isAlive() && !AvdSnapshotHandler.access$isBootCompleted(this.this$0, emulatorSerial, this.$adbExecutable, this.$logger)) {
                        this.$logger.verbose("Waiting for " + this.$avdName + " to boot up.", new Object[0]);
                        Thread.sleep(5000L);
                    }
                    this.$logger.verbose("Booting " + this.$avdName + " is completed.", new Object[0]);
                    while (this.$process.isAlive() && !AvdSnapshotHandler.access$isPackageManagerStarted(this.this$0, emulatorSerial, this.$adbExecutable)) {
                        this.$logger.verbose("Waiting for PackageManager to be ready on " + this.$avdName + '.', new Object[0]);
                        Thread.sleep(5000L);
                    }
                    this.$logger.verbose("PackageManager is ready on " + this.$avdName + '.', new Object[0]);
                    if (this.$process.isAlive()) {
                        this.$bootCompleted.set(true);
                        Thread.sleep(5000L);
                        AvdSnapshotHandler.access$killDevice(this.this$0, this.$adbExecutable, emulatorSerial);
                    }
                }
            }).start();
            GrabProcessOutput.grabProcessOutput((Process)process2, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(logger){
                final /* synthetic */ ILogger $logger;
                {
                    this.$logger = $logger;
                }

                public void out(@Nullable String line) {
                    String string = line;
                    if (string == null) {
                        return;
                    }
                    this.$logger.verbose(line, new Object[0]);
                }

                public void err(@Nullable String line) {
                    String string = line;
                    if (string == null) {
                        return;
                    }
                    this.$logger.verbose(line, new Object[0]);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
            this.waitUntilTimeout(process2, logger, (Function0<Unit>)((Function0)new Function0<Unit>(logger, this, adbExecutable2, process2, deviceId, avdName){
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ AvdSnapshotHandler this$0;
                final /* synthetic */ File $adbExecutable;
                final /* synthetic */ Process $process;
                final /* synthetic */ String $deviceId;
                final /* synthetic */ String $avdName;
                {
                    this.$logger = $logger;
                    this.this$0 = $receiver;
                    this.$adbExecutable = $adbExecutable;
                    this.$process = $process;
                    this.$deviceId = $deviceId;
                    this.$avdName = $avdName;
                    super(0);
                }

                public final void invoke() {
                    this.$logger.verbose("Snapshot creation timed out. Closing emulator.", new Object[0]);
                    Object object = this.$process;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"process");
                    AvdSnapshotHandler.access$closeEmulatorWithId(this.this$0, this.$adbExecutable, (Process)object, this.$deviceId, this.$logger);
                    this.$process.waitFor();
                    object = StringsKt.trimIndent((String)("\n                    Gradle was not able to complete device setup for: " + this.$avdName + "\n                    This could be due to having insufficient resources to provision the number of\n                    devices requested. Try running the test again and request fewer devices or\n                    fewer shards.\n                "));
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
            }));
            if (!bootCompleted.get()) {
                string3 = StringsKt.trimIndent((String)("\n                    Gradle was not able to complete device setup for: " + avdName + "\n                    The emulator failed to open the managed device to generate the snapshot.\n                    This is because the emulator closed unexpectedly, try updating the emulator and\n                    ensure a device can be run from Android Studio.\n                "));
                bl2 = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            logger.info(Intrinsics.stringPlus((String)"Successfully created snapshot for: ", (Object)avdName), new Object[0]);
        }
        catch (Exception e) {
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
            this.closeEmulatorWithId(adbExecutable2, process2, deviceId, logger);
            process2.waitFor();
            throw e;
        }
    }

    private final boolean isBootCompleted(String emulatorSerial, File adbExecutable2, ILogger logger) {
        AtomicBoolean bootCompleted = new AtomicBoolean(false);
        this.getDeviceProperty("sys.boot_completed", emulatorSerial, adbExecutable2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(logger, bootCompleted){
            final /* synthetic */ ILogger $logger;
            final /* synthetic */ AtomicBoolean $bootCompleted;
            {
                this.$logger = $logger;
                this.$bootCompleted = $bootCompleted;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Integer n = StringsKt.toIntOrNull((String)it);
                int n2 = 1;
                if (n != null && n == n2) {
                    this.$logger.info("sys.boot_completed=1", new Object[0]);
                    this.$bootCompleted.set(true);
                }
            }
        }));
        if (bootCompleted.get()) {
            return true;
        }
        this.getDeviceProperty("dev.bootcomplete", emulatorSerial, adbExecutable2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(logger, bootCompleted){
            final /* synthetic */ ILogger $logger;
            final /* synthetic */ AtomicBoolean $bootCompleted;
            {
                this.$logger = $logger;
                this.$bootCompleted = $bootCompleted;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Integer n = StringsKt.toIntOrNull((String)it);
                int n2 = 1;
                if (n != null && n == n2) {
                    this.$logger.info("dev.bootcomplete=1", new Object[0]);
                    this.$bootCompleted.set(true);
                }
            }
        }));
        return bootCompleted.get();
    }

    private final boolean isPackageManagerStarted(String emulatorSerial, File adbExecutable2) {
        AtomicBoolean result2 = new AtomicBoolean(false);
        Object[] objectArray = new String[]{"/system/bin/pm", "path", "android"};
        this.runAdbShell(emulatorSerial, adbExecutable2, CollectionsKt.listOf((Object[])objectArray), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(result2){
            final /* synthetic */ AtomicBoolean $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (StringsKt.contains$default((CharSequence)it, (CharSequence)"package:", (boolean)false, (int)2, null)) {
                    this.$result.set(true);
                }
            }
        }));
        return result2.get();
    }

    private final void getDeviceProperty(String propertyName, String emulatorSerial, File adbExecutable2, Function1<? super String, Unit> stdoutTextProcessor) {
        Object[] objectArray = new String[]{"getprop", propertyName};
        this.runAdbShell(emulatorSerial, adbExecutable2, CollectionsKt.listOf((Object[])objectArray), stdoutTextProcessor);
    }

    private final void runAdbShell(String emulatorSerial, File adbExecutable2, List<String> shellCommandArgs, Function1<? super String, Unit> stdoutTextProcessor) {
        Object[] objectArray = new String[]{adbExecutable2.getAbsolutePath(), "-s", emulatorSerial, "shell"};
        Process getPropProcess = ((ProcessBuilder)this.processFactory.invoke((Object)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)shellCommandArgs))).start();
        GrabProcessOutput.grabProcessOutput((Process)getPropProcess, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_PROCESS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(stdoutTextProcessor){
            final /* synthetic */ Function1<String, Unit> $stdoutTextProcessor;
            {
                this.$stdoutTextProcessor = $stdoutTextProcessor;
            }

            public void out(@Nullable String line) {
                String string = line;
                if (string == null) {
                    return;
                }
                string = line;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                this.$stdoutTextProcessor.invoke((Object)((Object)StringsKt.trim((CharSequence)string2)).toString());
            }

            public void err(@Nullable String line) {
            }
        });
    }

    private final void closeEmulatorWithId(File adbExecutable2, Process emulatorProcess, String idValue, ILogger logger) {
        try {
            String emulatorSerial = this.findDeviceSerialWithId(adbExecutable2, idValue);
            this.killDevice(adbExecutable2, emulatorSerial);
        }
        catch (Exception e) {
            logger.info(Intrinsics.stringPlus((String)"Failed to close emulator properly from adb. Reason: ", (Object)e), new Object[0]);
            emulatorProcess.destroy();
        }
    }

    private final void killDevice(File adb2, String serial) {
        Object[] objectArray = new String[]{adb2.getAbsolutePath(), "-s", serial, "emu", "kill"};
        Process killProcess = ((ProcessBuilder)this.processFactory.invoke((Object)CollectionsKt.listOf((Object[])objectArray))).start();
        killProcess.waitFor();
    }

    private final String findDeviceSerialWithId(File adb2, String idValue) {
        boolean bl = false;
        List serials = new ArrayList();
        Object object = new String[]{adb2.getAbsolutePath(), "devices"};
        Process allSerialsProcess = ((ProcessBuilder)this.processFactory.invoke((Object)CollectionsKt.listOf((Object[])object))).start();
        GrabProcessOutput.grabProcessOutput((Process)allSerialsProcess, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(serials){
            final /* synthetic */ List<String> $serials;
            {
                this.$serials = $serials;
            }

            public void out(@Nullable String line) {
                String string = line;
                if (string == null) {
                    return;
                }
                String string2 = line;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String trimmed = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                CharSequence charSequence = trimmed;
                String string4 = "\\s+";
                int n = 0;
                string4 = new Regex(string4);
                n = 0;
                boolean bl2 = false;
                List values = string4.split(charSequence, n);
                if (values.size() == 2 && Intrinsics.areEqual(values.get(1), (Object)"device")) {
                    this.$serials.add((String)values.get(0));
                }
            }

            public void err(@Nullable String line) {
            }
        });
        if (!allSerialsProcess.waitFor(60L, TimeUnit.SECONDS)) {
            allSerialsProcess.destroy();
            allSerialsProcess.waitFor();
            object = "Adb device retrieval timed out. Failed to destroy emulator properly";
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        for (String serial : serials) {
            Ref.ObjectRef id = new Ref.ObjectRef();
            Object[] objectArray = new String[]{adb2.getAbsolutePath(), "-s", serial, "emu", "avd", "id"};
            Process idDetectionProcess = ((ProcessBuilder)this.processFactory.invoke((Object)CollectionsKt.listOf((Object[])objectArray))).start();
            GrabProcessOutput.grabProcessOutput((Process)idDetectionProcess, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput((Ref.ObjectRef<String>)id){
                final /* synthetic */ Ref.ObjectRef<String> $id;
                {
                    this.$id = $id;
                }

                public void out(@Nullable String line) {
                    String string = line;
                    if (string == null) {
                        return;
                    }
                    CharSequence charSequence = line;
                    boolean bl = false;
                    String string2 = charSequence;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String trimmed = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                    charSequence = trimmed;
                    bl = false;
                    if (charSequence.length() > 0 && !Intrinsics.areEqual((Object)trimmed, (Object)"OK")) {
                        this.$id.element = trimmed;
                    }
                }

                public void err(@Nullable String line) {
                }
            });
            if (!idDetectionProcess.waitFor(60L, TimeUnit.SECONDS)) {
                idDetectionProcess.destroy();
                idDetectionProcess.waitFor();
            }
            if (!Intrinsics.areEqual((Object)id.element, (Object)idValue)) continue;
            return serial;
        }
        object = Intrinsics.stringPlus((String)"Failed to find serial for device id: ", (Object)idValue);
        boolean bl3 = false;
        throw (Throwable)new IllegalStateException(object.toString());
    }

    private final void ensureEmulatorVersionRequirement(File emulatorDir) {
        File packageFile = FilesKt.resolve((File)emulatorDir, (String)"package.xml");
        Pattern versionPattern = Pattern.compile("<major>(\\d+)</major><minor>(\\d+)</minor><micro>(\\d+)</micro>");
        for (String line : Files.readAllLines(packageFile.toPath())) {
            Matcher matcher = versionPattern.matcher(line);
            if (!matcher.find()) continue;
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(1)");
            boolean bl = false;
            int majorVersion = Integer.parseInt(string);
            String string2 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(2)");
            boolean bl2 = false;
            int minorVersion = Integer.parseInt(string2);
            String string3 = matcher.group(3);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"matcher.group(3)");
            boolean bl3 = false;
            int microVersion = Integer.parseInt(string3);
            if (majorVersion > 30) {
                return;
            }
            if (majorVersion == 30 && minorVersion > 6) {
                return;
            }
            if (majorVersion == 30 && minorVersion == 6 && microVersion >= 4) {
                return;
            }
            string3 = "Emulator needs to be updated in order to use managed devices. Minimum version required: 30.6.4. Version found: " + majorVersion + '.' + minorVersion + '.' + microVersion + '.';
            bl3 = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        String string = "Could not determine version of Emulator in " + emulatorDir.getAbsolutePath() + ". Update emulator in order to use Managed Devices.";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    public static final /* synthetic */ String access$findDeviceSerialWithId(AvdSnapshotHandler $this, File adb2, String idValue) {
        return $this.findDeviceSerialWithId(adb2, idValue);
    }

    public static final /* synthetic */ boolean access$isBootCompleted(AvdSnapshotHandler $this, String emulatorSerial, File adbExecutable2, ILogger logger) {
        return $this.isBootCompleted(emulatorSerial, adbExecutable2, logger);
    }

    public static final /* synthetic */ boolean access$isPackageManagerStarted(AvdSnapshotHandler $this, String emulatorSerial, File adbExecutable2) {
        return $this.isPackageManagerStarted(emulatorSerial, adbExecutable2);
    }

    public static final /* synthetic */ void access$killDevice(AvdSnapshotHandler $this, File adb2, String serial) {
        $this.killDevice(adb2, serial);
    }

    public static final /* synthetic */ void access$closeEmulatorWithId(AvdSnapshotHandler $this, File adbExecutable2, Process emulatorProcess, String idValue, ILogger logger) {
        $this.closeEmulatorWithId(adbExecutable2, emulatorProcess, idValue, logger);
    }
}

