/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.instrumentation.ClassesHierarchyResolver;
import com.android.build.gradle.internal.instrumentation.FixFramesClassWriter;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.services.ClassesHierarchyBuildService;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.FixStackFramesDelegate;
import com.android.builder.utils.ZipEntryUtils;
import com.android.utils.FileUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 -2\u00020\u0001:\u0005,-./0B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010 \u001a\u00020!J\"\u0010\"\u001a\u00020!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$J\u001c\u0010'\u001a\u00020!2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020*0)H\u0002J\u001c\u0010+\u001a\u00020!2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020*0)H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00061"}, d2={"Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate;", "", "classesDir", "Ljava/io/File;", "jarsDir", "bootClasspath", "", "referencedClasses", "classesOutDir", "jarsOutDir", "workers", "Lorg/gradle/workers/WorkerExecutor;", "task", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "classesHierarchyBuildServiceProvider", "Lorg/gradle/api/provider/Provider;", "Lcom/android/build/gradle/internal/services/ClassesHierarchyBuildService;", "(Ljava/io/File;Ljava/io/File;Ljava/util/Set;Ljava/util/Set;Ljava/io/File;Ljava/io/File;Lorg/gradle/workers/WorkerExecutor;Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;Lorg/gradle/api/provider/Provider;)V", "getBootClasspath", "()Ljava/util/Set;", "getClassesDir", "()Ljava/io/File;", "getClassesHierarchyBuildServiceProvider", "()Lorg/gradle/api/provider/Provider;", "getClassesOutDir", "getJarsDir", "getJarsOutDir", "getReferencedClasses", "getTask", "()Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "getWorkers", "()Lorg/gradle/workers/WorkerExecutor;", "doFullRun", "", "doIncrementalRun", "jarChanges", "", "Lorg/gradle/work/FileChange;", "classesChanges", "processClasses", "changedInput", "", "Lorg/gradle/work/ChangeType;", "processJars", "ClassesParams", "Companion", "FixClassesStackFramesRunnable", "FixJarStackFramesRunnable", "JarParams", "gradle-core"})
public final class FixStackFramesDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File classesDir;
    @NotNull
    private final File jarsDir;
    @NotNull
    private final Set<File> bootClasspath;
    @NotNull
    private final Set<File> referencedClasses;
    @NotNull
    private final File classesOutDir;
    @NotNull
    private final File jarsOutDir;
    @NotNull
    private final WorkerExecutor workers;
    @NotNull
    private final AndroidVariantTask task;
    @NotNull
    private final Provider<ClassesHierarchyBuildService> classesHierarchyBuildServiceProvider;
    @NotNull
    private static final LoggerWrapper logger;
    @NotNull
    private static final FileTime zeroFileTime;

    public FixStackFramesDelegate(@NotNull File classesDir, @NotNull File jarsDir, @NotNull Set<? extends File> bootClasspath2, @NotNull Set<? extends File> referencedClasses, @NotNull File classesOutDir, @NotNull File jarsOutDir, @NotNull WorkerExecutor workers, @NotNull AndroidVariantTask task, @NotNull Provider<ClassesHierarchyBuildService> classesHierarchyBuildServiceProvider) {
        Intrinsics.checkNotNullParameter((Object)classesDir, (String)"classesDir");
        Intrinsics.checkNotNullParameter((Object)jarsDir, (String)"jarsDir");
        Intrinsics.checkNotNullParameter(bootClasspath2, (String)"bootClasspath");
        Intrinsics.checkNotNullParameter(referencedClasses, (String)"referencedClasses");
        Intrinsics.checkNotNullParameter((Object)classesOutDir, (String)"classesOutDir");
        Intrinsics.checkNotNullParameter((Object)jarsOutDir, (String)"jarsOutDir");
        Intrinsics.checkNotNullParameter((Object)workers, (String)"workers");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(classesHierarchyBuildServiceProvider, (String)"classesHierarchyBuildServiceProvider");
        this.classesDir = classesDir;
        this.jarsDir = jarsDir;
        this.bootClasspath = bootClasspath2;
        this.referencedClasses = referencedClasses;
        this.classesOutDir = classesOutDir;
        this.jarsOutDir = jarsOutDir;
        this.workers = workers;
        this.task = task;
        this.classesHierarchyBuildServiceProvider = classesHierarchyBuildServiceProvider;
    }

    @NotNull
    public final File getClassesDir() {
        return this.classesDir;
    }

    @NotNull
    public final File getJarsDir() {
        return this.jarsDir;
    }

    @NotNull
    public final Set<File> getBootClasspath() {
        return this.bootClasspath;
    }

    @NotNull
    public final Set<File> getReferencedClasses() {
        return this.referencedClasses;
    }

    @NotNull
    public final File getClassesOutDir() {
        return this.classesOutDir;
    }

    @NotNull
    public final File getJarsOutDir() {
        return this.jarsOutDir;
    }

    @NotNull
    public final WorkerExecutor getWorkers() {
        return this.workers;
    }

    @NotNull
    public final AndroidVariantTask getTask() {
        return this.task;
    }

    @NotNull
    public final Provider<ClassesHierarchyBuildService> getClassesHierarchyBuildServiceProvider() {
        return this.classesHierarchyBuildServiceProvider;
    }

    private final void processJars(Map<File, ? extends ChangeType> changedInput) {
        Map<File, ? extends ChangeType> $this$forEach$iv = changedInput;
        boolean $i$f$forEach = false;
        Map<File, ? extends ChangeType> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<File, ? extends ChangeType>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<File, ? extends ChangeType> element$iv;
            Map.Entry<File, ? extends ChangeType> $dstr$inputJar$changeType = element$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry<File, ? extends ChangeType> entry = $dstr$inputJar$changeType;
            boolean bl3 = false;
            File inputJar = entry.getKey();
            Map.Entry<File, ? extends ChangeType> entry2 = $dstr$inputJar$changeType;
            boolean bl4 = false;
            ChangeType changeType = entry2.getValue();
            File outputJar = new File(this.getJarsOutDir(), inputJar.getName());
            FileUtils.deleteIfExists((File)outputJar);
            if (changeType != ChangeType.ADDED && changeType != ChangeType.MODIFIED) continue;
            this.getWorkers().noIsolation().submit(FixJarStackFramesRunnable.class, new Action(this, inputJar, outputJar){
                final /* synthetic */ FixStackFramesDelegate this$0;
                final /* synthetic */ File $inputJar;
                final /* synthetic */ File $outputJar;
                {
                    this.this$0 = $receiver;
                    this.$inputJar = $inputJar;
                    this.$outputJar = $outputJar;
                }

                public final void execute(JarParams params) {
                    params.initializeFromAndroidVariantTask(this.this$0.getTask());
                    params.getInputJar().set((Object)this.$inputJar);
                    params.getOutputJar().set((Object)this.$outputJar);
                    params.getClassesHierarchyBuildService().set(this.this$0.getClassesHierarchyBuildServiceProvider());
                    ListProperty<File> listProperty = params.getClasspath();
                    Object[] objectArray = new Set[3];
                    objectArray[0] = this.this$0.getBootClasspath();
                    Object[] objectArray2 = this.this$0.getJarsDir().listFiles();
                    Intrinsics.checkNotNull((Object)objectArray2);
                    objectArray[1] = ArraysKt.toSet((Object[])objectArray2);
                    objectArray[2] = this.this$0.getReferencedClasses();
                    listProperty.set((Iterable)CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray)));
                }
            });
        }
    }

    private final void processClasses(Map<File, ? extends ChangeType> changedInput) {
        Map<File, ? extends ChangeType> $this$filterValues$iv = changedInput;
        boolean $i$f$filterValues = false;
        Map<File, ChangeType> result$iv = new LinkedHashMap();
        Map<File, ? extends ChangeType> map = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry<File, ? extends ChangeType> entry$iv : map.entrySet()) {
            ChangeType it = entry$iv.getValue();
            boolean bl2 = false;
            if (!(it == ChangeType.REMOVED)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$forEach$iv = result$iv;
        boolean $i$f$forEach = false;
        result$iv = $this$forEach$iv;
        boolean bl3 = false;
        Object object = result$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$inputFile$_u24__u24 = element$iv = object.next();
            boolean bl4 = false;
            Map.Entry bl2 = $dstr$inputFile$_u24__u24;
            boolean bl5 = false;
            File inputFile = (File)bl2.getKey();
            FileUtils.deleteIfExists((File)FilesKt.resolve((File)this.getClassesOutDir(), (File)FilesKt.relativeTo((File)inputFile, (File)this.getClassesDir())));
        }
        Map<File, ? extends ChangeType> $this$filterValues$iv2 = changedInput;
        boolean $i$f$filterValues2 = false;
        LinkedHashMap result$iv2 = new LinkedHashMap();
        object = $this$filterValues$iv2;
        boolean bl6 = false;
        for (Map.Entry entry$iv : object.entrySet()) {
            ChangeType it = (ChangeType)entry$iv.getValue();
            boolean bl7 = false;
            if (!(it == ChangeType.ADDED || it == ChangeType.MODIFIED)) continue;
            result$iv2.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set filesToProcess = ((Map)result$iv2).keySet();
        Collection collection = filesToProcess;
        boolean bl8 = false;
        if (!collection.isEmpty()) {
            this.workers.noIsolation().submit(FixClassesStackFramesRunnable.class, new Action(this, filesToProcess){
                final /* synthetic */ FixStackFramesDelegate this$0;
                final /* synthetic */ Set<File> $filesToProcess;
                {
                    this.this$0 = $receiver;
                    this.$filesToProcess = $filesToProcess;
                }

                public final void execute(ClassesParams params) {
                    params.initializeFromAndroidVariantTask(this.this$0.getTask());
                    params.getInputDir().set((Object)this.this$0.getClassesDir());
                    params.getInputFiles().set((Iterable)this.$filesToProcess);
                    params.getOutputDir().set((Object)this.this$0.getClassesOutDir());
                    params.getClassesHierarchyBuildService().set(this.this$0.getClassesHierarchyBuildServiceProvider());
                    Object[] objectArray = new Collection[]{this.this$0.getBootClasspath(), CollectionsKt.listOf((Object)this.this$0.getClassesDir()), this.this$0.getReferencedClasses()};
                    params.getClasspath().set((Iterable)CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray)));
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void doFullRun() {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FileUtils.cleanOutputDir((File)this.classesOutDir);
        FileUtils.cleanOutputDir((File)this.jarsOutDir);
        ImmutableMap immutableMap = this.jarsDir.listFiles();
        Intrinsics.checkNotNull((Object)immutableMap);
        ImmutableMap immutableMap2 = immutableMap;
        FixStackFramesDelegate fixStackFramesDelegate = this;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var6_7 = $this$mapTo$iv$iv;
        int n = ((void)var6_7).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = var6_7[j];
            collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)ChangeType.ADDED);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        fixStackFramesDelegate.processJars(MapsKt.toMap((Iterable)collection));
        immutableMap2 = FileUtils.getAllFiles((File)this.classesDir).toMap((Function)doFullRun.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap2, (String)"getAllFiles(classesDir).toMap { ChangeType.ADDED }");
        this.processClasses((Map)immutableMap2);
    }

    public final void doIncrementalRun(@NotNull Iterable<? extends FileChange> jarChanges, @NotNull Iterable<? extends FileChange> classesChanges) {
        boolean bl;
        FileChange it;
        Map map;
        Iterable<? extends FileChange> $this$associateTo$iv$iv;
        Iterable<? extends FileChange> $this$associate$iv;
        Intrinsics.checkNotNullParameter(jarChanges, (String)"jarChanges");
        Intrinsics.checkNotNullParameter(classesChanges, (String)"classesChanges");
        Iterable<? extends FileChange> iterable = jarChanges;
        FixStackFramesDelegate fixStackFramesDelegate = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var6_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object t : $this$associateTo$iv$iv) {
            map = destination$iv$iv;
            it = (FileChange)t;
            bl = false;
            it = TuplesKt.to((Object)it.getFile(), (Object)it.getChangeType());
            bl = false;
            map.put(it.getFirst(), it.getSecond());
        }
        Map map2 = destination$iv$iv;
        fixStackFramesDelegate.processJars(map2);
        $this$associate$iv = classesChanges;
        fixStackFramesDelegate = this;
        $i$f$associate = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
        $this$associateTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateTo = false;
        for (Object object : $this$associateTo$iv$iv) {
            map = destination$iv$iv;
            it = (FileChange)object;
            bl = false;
            Pair pair = TuplesKt.to((Object)it.getFile(), (Object)it.getChangeType());
            boolean bl2 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        map2 = destination$iv$iv;
        fixStackFramesDelegate.processClasses(map2);
    }

    static {
        Object object = LoggerWrapper.getLogger(FixStackFramesDelegate.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLogger(FixStackFramesDelegate::class.java)");
        logger = object;
        object = FileTime.fromMillis(0L);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromMillis(0)");
        zeroFileTime = object;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate$Companion;", "", "()V", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "zeroFileTime", "Ljava/nio/file/attribute/FileTime;", "getFixedClass", "", "originalFile", "Ljava/io/InputStream;", "classesHierarchyResolver", "Lcom/android/build/gradle/internal/instrumentation/ClassesHierarchyResolver;", "transformJar", "", "inputJar", "Ljava/io/File;", "outputJar", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void transformJar(@NotNull File inputJar, @NotNull File outputJar, @NotNull ClassesHierarchyResolver classesHierarchyResolver) {
            Intrinsics.checkNotNullParameter((Object)inputJar, (String)"inputJar");
            Intrinsics.checkNotNullParameter((Object)outputJar, (String)"outputJar");
            Intrinsics.checkNotNullParameter((Object)classesHierarchyResolver, (String)"classesHierarchyResolver");
            Closeable closeable = new ZipFile(inputJar);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ZipFile inputZip = (ZipFile)closeable;
                boolean bl3 = false;
                Object object = outputJar;
                int n = 0;
                object = new FileOutputStream((File)object);
                n = 8192;
                boolean bl4 = false;
                object = new ZipOutputStream(object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n));
                n = 0;
                bl4 = false;
                Throwable throwable2 = null;
                try {
                    ZipOutputStream outputZip = (ZipOutputStream)object;
                    boolean bl5 = false;
                    Enumeration<? extends ZipEntry> inEntries = inputZip.entries();
                    while (inEntries.hasMoreElements()) {
                        byte[] byArray;
                        ZipEntry entry = inEntries.nextElement();
                        Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
                        if (!ZipEntryUtils.isValidZipEntryName((ZipEntry)entry)) {
                            throw new InvalidPathException(entry.getName(), "Entry name contains invalid characters");
                        }
                        ZipEntry outEntry = new ZipEntry(entry.getName());
                        Closeable closeable2 = inputZip.getInputStream(entry);
                        Intrinsics.checkNotNullExpressionValue((Object)closeable2, (String)"inputZip.getInputStream(entry)");
                        int n2 = 8192;
                        boolean bl6 = false;
                        closeable2 = closeable2 instanceof BufferedInputStream ? (BufferedInputStream)closeable2 : new BufferedInputStream((InputStream)closeable2, n2);
                        n2 = 0;
                        bl6 = false;
                        Throwable throwable3 = null;
                        try {
                            BufferedInputStream it = (BufferedInputStream)closeable2;
                            boolean bl7 = false;
                            String string = entry.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                            byArray = StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null) ? Companion.getFixedClass(it, classesHierarchyResolver) : ByteStreams.toByteArray((InputStream)it);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                        }
                        byte[] newEntryContent = byArray;
                        CRC32 crc32 = new CRC32();
                        crc32.update(newEntryContent);
                        outEntry.setCrc(crc32.getValue());
                        outEntry.setMethod(0);
                        outEntry.setSize(newEntryContent.length);
                        outEntry.setCompressedSize(newEntryContent.length);
                        outEntry.setLastAccessTime(zeroFileTime);
                        outEntry.setLastModifiedTime(zeroFileTime);
                        outEntry.setCreationTime(zeroFileTime);
                        outputZip.putNextEntry(outEntry);
                        outputZip.write(newEntryContent);
                        outputZip.closeEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final byte[] getFixedClass(InputStream originalFile, ClassesHierarchyResolver classesHierarchyResolver) {
            byte[] byArray;
            byte[] bytes2 = ByteStreams.toByteArray((InputStream)originalFile);
            try {
                ClassReader classReader = new ClassReader(bytes2);
                FixFramesClassWriter classWriter = new FixFramesClassWriter(2, classesHierarchyResolver);
                classReader.accept((ClassVisitor)classWriter, 4);
                byArray = classWriter.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"{\n                val cl\u2026ByteArray()\n            }");
            }
            catch (Throwable t) {
                LoggerWrapper loggerWrapper = logger;
                String string = t.getMessage();
                Intrinsics.checkNotNull((Object)string);
                loggerWrapper.verbose(string, new Object[0]);
                byte[] byArray2 = bytes2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n                // we \u2026      bytes\n            }");
                byArray = byArray2;
            }
            return byArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate$JarParams;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "classesHierarchyBuildService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/services/ClassesHierarchyBuildService;", "getClassesHierarchyBuildService", "()Lorg/gradle/api/provider/Property;", "classpath", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getClasspath", "()Lorg/gradle/api/provider/ListProperty;", "inputJar", "getInputJar", "outputJar", "getOutputJar", "gradle-core"})
    public static abstract class JarParams
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<File> getInputJar();

        @NotNull
        public abstract Property<File> getOutputJar();

        @NotNull
        public abstract Property<ClassesHierarchyBuildService> getClassesHierarchyBuildService();

        @NotNull
        public abstract ListProperty<File> getClasspath();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate$ClassesParams;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "classesHierarchyBuildService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/services/ClassesHierarchyBuildService;", "getClassesHierarchyBuildService", "()Lorg/gradle/api/provider/Property;", "classpath", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getClasspath", "()Lorg/gradle/api/provider/ListProperty;", "inputDir", "getInputDir", "inputFiles", "getInputFiles", "outputDir", "getOutputDir", "gradle-core"})
    public static abstract class ClassesParams
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract ListProperty<File> getInputFiles();

        @NotNull
        public abstract Property<File> getInputDir();

        @NotNull
        public abstract Property<File> getOutputDir();

        @NotNull
        public abstract Property<ClassesHierarchyBuildService> getClassesHierarchyBuildService();

        @NotNull
        public abstract ListProperty<File> getClasspath();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate$FixJarStackFramesRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate$JarParams;", "()V", "run", "", "gradle-core"})
    public static abstract class FixJarStackFramesRunnable
    extends ProfileAwareWorkAction<JarParams> {
        @Override
        public void run() {
            Object object = ((JarParams)this.getParameters()).getInputJar().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.inputJar.get()");
            File file = (File)object;
            object = ((JarParams)this.getParameters()).getOutputJar().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.outputJar.get()");
            File file2 = (File)object;
            ClassesHierarchyResolver.Builder builder = ((ClassesHierarchyBuildService)((JarParams)this.getParameters()).getClassesHierarchyBuildService().get()).getClassesHierarchyResolverBuilder();
            object = ((JarParams)this.getParameters()).getClasspath().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.classpath.get()");
            Companion.transformJar(file, file2, builder.addDependenciesSources((Iterable)object).build());
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate$FixClassesStackFramesRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate$ClassesParams;", "()V", "run", "", "gradle-core"})
    public static abstract class FixClassesStackFramesRunnable
    extends ProfileAwareWorkAction<ClassesParams> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassesHierarchyResolver.Builder builder = ((ClassesHierarchyBuildService)((ClassesParams)this.getParameters()).getClassesHierarchyBuildService().get()).getClassesHierarchyResolverBuilder();
            Object object = ((ClassesParams)this.getParameters()).getClasspath().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.classpath.get()");
            ClassesHierarchyResolver classesHierarchyResolver = builder.addDependenciesSources((Iterable)object).build();
            object = ((ClassesParams)this.getParameters()).getInputFiles().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.inputFiles.get()");
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File inputFile = (File)element$iv;
                boolean bl = false;
                Object object2 = ((ClassesParams)this.getParameters()).getOutputDir().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.outputDir.get()");
                File file = (File)object2;
                Intrinsics.checkNotNullExpressionValue((Object)inputFile, (String)"inputFile");
                object2 = ((ClassesParams)this.getParameters()).getInputDir().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.inputDir.get()");
                File outputFile = FilesKt.resolve((File)file, (File)FilesKt.relativeTo((File)inputFile, (File)((File)object2)));
                FileUtils.deleteIfExists((File)outputFile);
                outputFile.getParentFile().mkdirs();
                object2 = inputFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"inputFile.name");
                if (StringsKt.endsWith$default((String)object2, (String)".class", (boolean)false, (int)2, null)) {
                    object2 = new FileOutputStream(outputFile);
                    int n = 8192;
                    boolean bl2 = false;
                    object2 = object2 instanceof BufferedOutputStream ? (BufferedOutputStream)object2 : new BufferedOutputStream((OutputStream)object2, n);
                    n = 0;
                    bl2 = false;
                    Throwable throwable = null;
                    try {
                        BufferedOutputStream outputStream = (BufferedOutputStream)object2;
                        boolean bl3 = false;
                        Object object3 = inputFile;
                        int n2 = 0;
                        object3 = new FileInputStream((File)object3);
                        n2 = 8192;
                        boolean bl4 = false;
                        object3 = object3 instanceof BufferedInputStream ? (BufferedInputStream)object3 : new BufferedInputStream((InputStream)object3, n2);
                        n2 = 0;
                        bl4 = false;
                        Throwable throwable2 = null;
                        try {
                            BufferedInputStream inputStream = (BufferedInputStream)object3;
                            boolean bl5 = false;
                            outputStream.write(Companion.getFixedClass(inputStream, classesHierarchyResolver));
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                        continue;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                        continue;
                    }
                }
                FileUtils.copyFile((File)inputFile, (File)outputFile);
            }
        }
    }
}

