/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.io;

import com.android.build.gradle.internal.cxx.io.IoStructuredLogCodecKt;
import com.android.build.gradle.internal.cxx.io.IoUtilsKt;
import com.android.build.gradle.internal.cxx.io.SynchronizeFile;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.GeneratedMessageV3;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\u0016\u0010\r\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u000fH\u0002\u001a2\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u001a\b\u0003\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u0012\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0013"}, d2={"areSameFileOrContent", "", "Lcom/android/build/gradle/internal/cxx/io/SynchronizeFile$Comparison;", "getAreSameFileOrContent", "(Lcom/android/build/gradle/internal/cxx/io/SynchronizeFile$Comparison;)Z", "compareFileContents", "source", "Ljava/io/File;", "destination", "compareBufferSize", "", "hardLinkOrCopyFile", "", "isSameFileOrContent", "realCreateLink", "Ljava/nio/file/Path;", "synchronizeFile", "createLink", "Lkotlin/Function2;", "gradle-core"})
public final class IoUtilsKt {
    public static final void hardLinkOrCopyFile(@NotNull File source, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (!source.isFile()) {
            String string = "Could not hard link or copy '" + source + "' because it did not exist.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        IoUtilsKt.synchronizeFile$default(source, destination, null, 4, null);
    }

    public static final void synchronizeFile(@NotNull File source, @NotNull File destination, @VisibleForTesting @NotNull Function2<? super Path, ? super Path, Unit> createLink) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter(createLink, (String)"createLink");
        SynchronizeFile.Comparison comparison = IoUtilsKt.compareFileContents$default(source, destination, 0, 4, null);
        if (IoUtilsKt.getAreSameFileOrContent(comparison)) {
            object = SynchronizeFile.Outcome.SAME_FILE;
        } else {
            if (destination.isFile()) {
                Files.deleteIfExists(destination.toPath());
            }
            if (!source.isFile()) {
                object = SynchronizeFile.Outcome.DELETED_DESTINATION_BECAUSE_SOURCE_DID_NOT_EXIST;
            } else {
                Object object2;
                if (!destination.getParentFile().isDirectory()) {
                    destination.getParentFile().mkdirs();
                }
                try {
                    object2 = destination.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"destination.toPath()");
                    Path path = object2;
                    object2 = source.toPath().toRealPath(new LinkOption[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"source.toPath().toRealPath()");
                    createLink.invoke((Object)path, object2);
                    LoggingEnvironmentKt.infoln("hard linked " + source + " to " + destination, new Object[0]);
                    object2 = SynchronizeFile.Outcome.CREATED_HARD_LINK_FROM_SOURCE_TO_DESTINATION;
                }
                catch (IOException e) {
                    LoggingEnvironmentKt.warnln("Hard link from '" + source + "' to '" + destination + "' failed. Doing a slower copy instead.", new Object[0]);
                    FilesKt.copyTo$default((File)source, (File)destination, (boolean)true, (int)0, (int)4, null);
                    object2 = SynchronizeFile.Outcome.COPIED_FROM_SOURCE_TO_DESTINATION;
                }
                object = object2;
            }
        }
        SynchronizeFile.Outcome operationOutcome = object;
        LoggingEnvironmentKt.logStructured((Function1<? super StringEncoder, ? extends GeneratedMessageV3>)((Function1)new Function1<StringEncoder, GeneratedMessageV3>(source, destination, comparison, operationOutcome){
            final /* synthetic */ File $source;
            final /* synthetic */ File $destination;
            final /* synthetic */ SynchronizeFile.Comparison $comparison;
            final /* synthetic */ SynchronizeFile.Outcome $operationOutcome;
            {
                this.$source = $source;
                this.$destination = $destination;
                this.$comparison = $comparison;
                this.$operationOutcome = $operationOutcome;
                super(1);
            }

            @NotNull
            public final GeneratedMessageV3 invoke(@NotNull StringEncoder encoder) {
                Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
                SynchronizeFile.Builder result2 = SynchronizeFile.newBuilder();
                result2.setWorkingDirectory(new File(".").getAbsolutePath());
                result2.setSourceFile(this.$source.getPath());
                result2.setDestinationFile(this.$destination.getPath());
                result2.setInitialFileComparison(this.$comparison);
                result2.setOutcome(this.$operationOutcome);
                SynchronizeFile synchronizeFile2 = result2.build();
                Intrinsics.checkNotNullExpressionValue((Object)synchronizeFile2, (String)"result.build()");
                return IoStructuredLogCodecKt.encode(synchronizeFile2, encoder);
            }
        }));
    }

    public static /* synthetic */ void synchronizeFile$default(File file, File file2, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = synchronizeFile.1.INSTANCE;
        }
        IoUtilsKt.synchronizeFile(file, file2, (Function2<? super Path, ? super Path, Unit>)function2);
    }

    private static final void realCreateLink(Path destination, Path source) {
        Files.createLink(destination, source);
    }

    public static final boolean isSameFileOrContent(@NotNull File source, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return IoUtilsKt.getAreSameFileOrContent(IoUtilsKt.compareFileContents$default(source, destination, 0, 4, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    @NotNull
    public static final SynchronizeFile.Comparison compareFileContents(@NotNull File source, @NotNull File destination, int compareBufferSize) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (source == destination) {
            return SynchronizeFile.Comparison.SAME_PATH_BY_FILE_OBJECT_IDENTITY;
        }
        if (Intrinsics.areEqual((Object)source.getPath(), (Object)destination.getPath())) {
            return SynchronizeFile.Comparison.SAME_PATH_ACCORDING_TO_LEXICAL_PATH;
        }
        if (Intrinsics.areEqual((Object)source.getCanonicalPath(), (Object)destination.getCanonicalPath())) {
            return SynchronizeFile.Comparison.SAME_PATH_ACCORDING_TO_CANONICAL_PATH;
        }
        if (!source.isFile() && !destination.isFile()) {
            return SynchronizeFile.Comparison.SAME_SOURCE_AND_DESTINATION_DID_NOT_EXIST;
        }
        if (!source.isFile()) {
            return SynchronizeFile.Comparison.NOT_SAME_SOURCE_DID_NOT_EXIST;
        }
        if (!destination.isFile()) {
            return SynchronizeFile.Comparison.NOT_SAME_DESTINATION_DID_NOT_EXIST;
        }
        if (Files.isSameFile(source.toPath(), destination.toPath())) {
            return SynchronizeFile.Comparison.SAME_PATH_ACCORDING_TO_FILE_SYSTEM_PROVIDER;
        }
        if (source.length() != destination.length()) {
            return SynchronizeFile.Comparison.NOT_SAME_LENGTH;
        }
        buffer1 = new byte[compareBufferSize];
        buffer2 = new byte[compareBufferSize];
        var5_5 = new FileInputStream(source);
        var6_6 = false;
        var7_7 = false;
        var7_8 = null;
        try {
            input1 = (FileInputStream)var5_5;
            $i$a$-use-IoUtilsKt$compareFileContents$1 = false;
            var10_13 = new FileInputStream(destination);
            var11_14 = false;
            var12_15 = false;
            var12_16 = null;
            input2 = (FileInputStream)var10_13;
            $i$a$-use-IoUtilsKt$compareFileContents$1$1 = false;
lbl38:
            // 2 sources

            while (true) {
                size1 = input1.read(buffer1);
                if (size1 == -1) {
                    var16_27 = SynchronizeFile.Comparison.SAME_CONTENT;
                }
                ** GOTO lbl-1000
                break;
            }
            {
                block24: {
                    catch (Throwable var13_18) {
                        var12_16 = var13_18;
                        throw var13_18;
                    }
                    catch (Throwable var13_19) {
                        CloseableKt.closeFinally((Closeable)var10_13, (Throwable)var12_16);
                        throw var13_19;
                    }
                    CloseableKt.closeFinally((Closeable)var10_13, (Throwable)var12_16);
                    var24_28 = var16_27;
                    return var24_28;
lbl-1000:
                    // 1 sources

                    {
                        size2 = input2.read(buffer2);
                        var18_24 = size1 == size2;
                        var19_25 = false;
                        var20_26 = false;
                        if (_Assertions.ENABLED && !var18_24) {
                            var21_29 = false;
                            var21_30 = "Assertion failed";
                            throw (Throwable)new AssertionError((Object)var21_30);
                        }
                        var18_23 = buffer1;
                        var19_25 = false;
                        if (Arrays.equals(var18_23, buffer2)) break block24;
                        var22_31 = SynchronizeFile.Comparison.NOT_SAME_CONTENT;
                    }
                    CloseableKt.closeFinally((Closeable)var10_13, (Throwable)var12_16);
                    var23_32 = var22_31;
                    return var23_32;
                }
                ** try [egrp 5[TRYBLOCK] [10 : 356->381)] { 
lbl-1000:
                // 1 sources

                {
                    ** continue;
                }
            }
        }
lbl72:
        // 2 sources

        catch (Throwable var8_10) {
            var7_8 = var8_10;
            throw var8_10;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var5_5, (Throwable)var7_8);
        }
    }

    public static /* synthetic */ SynchronizeFile.Comparison compareFileContents$default(File file, File file2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 8192;
        }
        return IoUtilsKt.compareFileContents(file, file2, n);
    }

    private static final boolean getAreSameFileOrContent(SynchronizeFile.Comparison $this$areSameFileOrContent) {
        boolean bl;
        SynchronizeFile.Comparison comparison = $this$areSameFileOrContent;
        int n = WhenMappings.$EnumSwitchMapping$0[comparison.ordinal()];
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                bl = false;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                bl = true;
                break;
            }
            default: {
                String string = Intrinsics.stringPlus((String)"Unrecognized comparison code: ", (Object)((Object)$this$areSameFileOrContent));
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return bl;
    }

    public static final /* synthetic */ void access$realCreateLink(Path destination, Path source) {
        IoUtilsKt.realCreateLink(destination, source);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SynchronizeFile.Comparison.values().length];
            nArray[SynchronizeFile.Comparison.NOT_SAME_SOURCE_DID_NOT_EXIST.ordinal()] = 1;
            nArray[SynchronizeFile.Comparison.NOT_SAME_DESTINATION_DID_NOT_EXIST.ordinal()] = 2;
            nArray[SynchronizeFile.Comparison.NOT_SAME_LENGTH.ordinal()] = 3;
            nArray[SynchronizeFile.Comparison.NOT_SAME_CONTENT.ordinal()] = 4;
            nArray[SynchronizeFile.Comparison.SAME_SOURCE_AND_DESTINATION_DID_NOT_EXIST.ordinal()] = 5;
            nArray[SynchronizeFile.Comparison.SAME_PATH_BY_FILE_OBJECT_IDENTITY.ordinal()] = 6;
            nArray[SynchronizeFile.Comparison.SAME_PATH_ACCORDING_TO_LEXICAL_PATH.ordinal()] = 7;
            nArray[SynchronizeFile.Comparison.SAME_PATH_ACCORDING_TO_FILE_SYSTEM_PROVIDER.ordinal()] = 8;
            nArray[SynchronizeFile.Comparison.SAME_PATH_ACCORDING_TO_CANONICAL_PATH.ordinal()] = 9;
            nArray[SynchronizeFile.Comparison.SAME_CONTENT.ordinal()] = 10;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

