/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.AvdManager;
import com.android.build.gradle.internal.AvdManagerKt;
import com.android.build.gradle.internal.AvdSnapshotHandler;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.io.IAbstractFile;
import com.android.prefs.AndroidLocationsProvider;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.PathFileWrapper;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdCamera;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.EmulatedProperties;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"J5\u0010#\u001a\u0004\u0018\u00010$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00052\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b*J,\u0010+\u001a\u00020\u00032\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00052\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u0016J\u0014\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160-H\u0002J\u0014\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00160\"J\u000e\u00101\u001a\u00020/2\u0006\u0010(\u001a\u00020\u0016J\u001a\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00104\u001a\u000205H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0013\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/android/build/gradle/internal/AvdManager;", "", "avdFolder", "Ljava/io/File;", "versionedSdkLoader", "Lorg/gradle/api/provider/Provider;", "Lcom/android/build/gradle/internal/SdkComponentsBuildService$VersionedSdkLoader;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "androidLocationsProvider", "Lcom/android/prefs/AndroidLocationsProvider;", "snapshotHandler", "Lcom/android/build/gradle/internal/AvdSnapshotHandler;", "(Ljava/io/File;Lorg/gradle/api/provider/Provider;Lcom/android/sdklib/repository/AndroidSdkHandler;Lcom/android/prefs/AndroidLocationsProvider;Lcom/android/build/gradle/internal/AvdSnapshotHandler;)V", "avdManager", "Lcom/android/sdklib/internal/avd/AvdManager;", "getAvdManager", "()Lcom/android/sdklib/internal/avd/AvdManager;", "avdManager$delegate", "Lkotlin/Lazy;", "defaultEmulatorPropertiesMap", "", "", "deviceManager", "Lcom/android/sdklib/devices/DeviceManager;", "getDeviceManager", "()Lcom/android/sdklib/devices/DeviceManager;", "deviceManager$delegate", "logger", "Lcom/android/utils/ILogger;", "sdkDirectory", "getSdkDirectory", "()Ljava/io/File;", "allAvds", "", "createAvd", "Lcom/android/sdklib/internal/avd/AvdInfo;", "imageProvider", "Lorg/gradle/api/file/Directory;", "imageHash", "deviceName", "hardwareProfile", "createAvd$gradle_core", "createOrRetrieveAvd", "defaultHardwareConfig", "", "deleteAvds", "", "avds", "loadSnapshotIfNeeded", "retrieveSystemImage", "Lcom/android/sdklib/ISystemImage;", "imageLocation", "Ljava/nio/file/Path;", "gradle-core"})
public final class AvdManager {
    @NotNull
    private final File avdFolder;
    @NotNull
    private final Provider<SdkComponentsBuildService.VersionedSdkLoader> versionedSdkLoader;
    @NotNull
    private final AndroidSdkHandler sdkHandler;
    @NotNull
    private final AndroidLocationsProvider androidLocationsProvider;
    @NotNull
    private final AvdSnapshotHandler snapshotHandler;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Lazy avdManager$delegate;
    @NotNull
    private final Lazy deviceManager$delegate;
    @NotNull
    private final Map<String, String> defaultEmulatorPropertiesMap;

    public AvdManager(@NotNull File avdFolder, @NotNull Provider<SdkComponentsBuildService.VersionedSdkLoader> versionedSdkLoader2, @NotNull AndroidSdkHandler sdkHandler, @NotNull AndroidLocationsProvider androidLocationsProvider, @NotNull AvdSnapshotHandler snapshotHandler) {
        Intrinsics.checkNotNullParameter((Object)avdFolder, (String)"avdFolder");
        Intrinsics.checkNotNullParameter(versionedSdkLoader2, (String)"versionedSdkLoader");
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        Intrinsics.checkNotNullParameter((Object)androidLocationsProvider, (String)"androidLocationsProvider");
        Intrinsics.checkNotNullParameter((Object)snapshotHandler, (String)"snapshotHandler");
        this.avdFolder = avdFolder;
        this.versionedSdkLoader = versionedSdkLoader2;
        this.sdkHandler = sdkHandler;
        this.androidLocationsProvider = androidLocationsProvider;
        this.snapshotHandler = snapshotHandler;
        Pair[] pairArray = LoggerWrapper.getLogger(AvdManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"getLogger(AvdManager::class.java)");
        this.logger = (ILogger)pairArray;
        this.avdManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<com.android.sdklib.internal.avd.AvdManager>(this){
            final /* synthetic */ AvdManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final com.android.sdklib.internal.avd.AvdManager invoke() {
                com.android.sdklib.internal.avd.AvdManager avdManager2 = com.android.sdklib.internal.avd.AvdManager.getInstance((AndroidSdkHandler)AvdManager.access$getSdkHandler$p(this.this$0), (Path)AvdManager.access$getSdkHandler$p(this.this$0).toCompatiblePath(AvdManager.access$getAvdFolder$p(this.this$0)), (ILogger)AvdManager.access$getLogger$p(this.this$0));
                if (avdManager2 == null) {
                    throw new RuntimeException("Failed to initialize AvdManager.");
                }
                return avdManager2;
            }
        }));
        this.deviceManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DeviceManager>(this){
            final /* synthetic */ AvdManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final DeviceManager invoke() {
                return DeviceManager.createInstance((AndroidLocationsProvider)AvdManager.access$getAndroidLocationsProvider$p(this.this$0), (Path)AvdManager.access$getSdkDirectory(this.this$0).toPath(), (ILogger)AvdManager.access$getLogger$p(this.this$0));
            }
        }));
        pairArray = new Pair[]{TuplesKt.to((Object)"hw.camera.back", (Object)AvdCamera.EMULATED.getAsParameter()), TuplesKt.to((Object)"hw.cpu.ncore", (Object)String.valueOf(EmulatedProperties.RECOMMENDED_NUMBER_OF_CORES)), TuplesKt.to((Object)"skin.path", (Object)"_no_skin"), TuplesKt.to((Object)"showDeviceFrame", (Object)"yes"), TuplesKt.to((Object)"hw.camera.front", (Object)AvdCamera.EMULATED.getAsParameter()), TuplesKt.to((Object)"hw.keyboard", (Object)"yes"), TuplesKt.to((Object)"hw.gpu.mode", (Object)GpuMode.AUTO.getGpuSetting()), TuplesKt.to((Object)"hw.initialOrientation", (Object)"Portrait"), TuplesKt.to((Object)"disk.dataPartition.size", (Object)EmulatedProperties.DEFAULT_INTERNAL_STORAGE.toString()), TuplesKt.to((Object)"runtime.network.latency", (Object)"None"), TuplesKt.to((Object)"runtime.network.speed", (Object)"Full"), TuplesKt.to((Object)"sdcard.size", (Object)EmulatedProperties.DEFAULT_SDCARD_SIZE.toString()), TuplesKt.to((Object)"fastboot.forceChosenSnapshotBoot", (Object)"no"), TuplesKt.to((Object)"fastboot.forceColdBoot", (Object)"no"), TuplesKt.to((Object)"fastboot.forceFastBoot", (Object)"yes"), TuplesKt.to((Object)"hw.gpu.enabled", (Object)"yes"), TuplesKt.to((Object)"vm.heapSize", (Object)EmulatedProperties.DEFAULT_HEAP.toString())};
        this.defaultEmulatorPropertiesMap = MapsKt.mapOf((Pair[])pairArray);
    }

    private final File getSdkDirectory() {
        File file = ((Directory)((SdkComponentsBuildService.VersionedSdkLoader)this.versionedSdkLoader.get()).getSdkDirectoryProvider().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"versionedSdkLoader.get()\u2026toryProvider.get().asFile");
        return file;
    }

    private final com.android.sdklib.internal.avd.AvdManager getAvdManager() {
        Lazy lazy = this.avdManager$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (com.android.sdklib.internal.avd.AvdManager)lazy.getValue();
    }

    private final DeviceManager getDeviceManager() {
        Lazy lazy = this.deviceManager$delegate;
        Object var3_2 = null;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-deviceManager>(...)");
        return (DeviceManager)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File createOrRetrieveAvd(@NotNull Provider<Directory> imageProvider, @NotNull String imageHash, @NotNull String deviceName, @NotNull String hardwareProfile) {
        Intrinsics.checkNotNullParameter(imageProvider, (String)"imageProvider");
        Intrinsics.checkNotNullParameter((Object)imageHash, (String)"imageHash");
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter((Object)hardwareProfile, (String)"hardwareProfile");
        Object v = AvdManagerKt.access$getAvdLocks$p().computeIfAbsent(deviceName, createOrRetrieveAvd.lock.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(v, (String)"avdLocks.computeIfAbsent\u2026          Any()\n        }");
        Object lock2 = v;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock2) {
            Path path;
            File file;
            block5: {
                AvdInfo info2;
                boolean bl3 = false;
                this.getAvdManager().reloadAvds(this.logger);
                AvdInfo avdInfo = info2 = this.getAvdManager().getAvd(deviceName, false);
                if (avdInfo == null) break block5;
                AvdInfo avdInfo2 = avdInfo;
                boolean bl4 = false;
                boolean bl5 = false;
                AvdInfo it = avdInfo2;
                boolean bl6 = false;
                this.logger.info("Device: " + deviceName + " already exists. AVD creation skipped.", new Object[0]);
                File file2 = info2.getConfigFile().toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"info.configFile.toFile()");
                File file3 = file2;
                return file3;
            }
            AvdInfo newInfo = this.createAvd$gradle_core(imageProvider, imageHash, deviceName, hardwareProfile);
            Object object = newInfo;
            File file4 = object == null ? null : (file = (path = object.getConfigFile()) == null ? null : path.toFile());
            if (file == null) {
                object = "AVD could not be created.";
                boolean bl7 = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            File file5 = file;
            return file5;
        }
    }

    @Nullable
    public final AvdInfo createAvd$gradle_core(@NotNull Provider<Directory> imageProvider, @NotNull String imageHash, @NotNull String deviceName, @NotNull String hardwareProfile) {
        Object v0;
        boolean bl;
        Object object;
        ISystemImage systemImage;
        block4: {
            Intrinsics.checkNotNullParameter(imageProvider, (String)"imageProvider");
            Intrinsics.checkNotNullParameter((Object)imageHash, (String)"imageHash");
            Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
            Intrinsics.checkNotNullParameter((Object)hardwareProfile, (String)"hardwareProfile");
            if (!imageProvider.isPresent()) {
                throw new RuntimeException(Intrinsics.stringPlus((String)"Failed to find system image for hash: ", (Object)imageHash));
            }
            Path imageLocation = this.sdkHandler.toCompatiblePath(((Directory)imageProvider.get()).getAsFile());
            Intrinsics.checkNotNullExpressionValue((Object)imageLocation, (String)"imageLocation");
            ISystemImage iSystemImage = systemImage = this.retrieveSystemImage(this.sdkHandler, imageLocation);
            if (iSystemImage == null) {
                String string = Intrinsics.stringPlus((String)"System image does not exist at ", (Object)imageLocation);
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            object = this.getDeviceManager().getDevices(DeviceManager.ALL_DEVICES);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"deviceManager.getDevices\u2026eviceManager.ALL_DEVICES)");
            object = (Iterable)object;
            bl = false;
            Iterable iterable = object;
            boolean bl3 = false;
            for (Object e : iterable) {
                Device it = (Device)e;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)hardwareProfile)) continue;
                v0 = e;
                break block4;
            }
            v0 = null;
        }
        Device device = v0;
        if (device == null) {
            object = Intrinsics.stringPlus((String)"Failed to find hardware profile for name: ", (Object)hardwareProfile);
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        Device device2 = device;
        Map<String, String> hardwareConfig = this.defaultHardwareConfig();
        object = DeviceManager.getHardwareProperties((Device)device2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getHardwareProperties(device)");
        hardwareConfig.putAll((Map<String, String>)object);
        EmulatedProperties.restrictDefaultRamSize(hardwareConfig);
        Path deviceFolder = AvdInfo.getDefaultAvdFolder((com.android.sdklib.internal.avd.AvdManager)this.getAvdManager(), (String)deviceName, (boolean)false);
        return this.getAvdManager().createAvd(deviceFolder, deviceName, systemImage, null, null, null, hardwareConfig, device2.getBootProps(), device2.hasPlayStore(), false, false, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadSnapshotIfNeeded(@NotNull String deviceName) {
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Object v = AvdManagerKt.access$getAvdLocks$p().computeIfAbsent(deviceName, loadSnapshotIfNeeded.lock.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(v, (String)"avdLocks.computeIfAbsent\u2026          Any()\n        }");
        Object lock2 = v;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock2) {
            boolean bl3 = false;
            Provider<Directory> emulatorProvider = ((SdkComponentsBuildService.VersionedSdkLoader)this.versionedSdkLoader.get()).getEmulatorDirectoryProvider();
            File emulatorExecutable = this.snapshotHandler.getEmulatorExecutable(emulatorProvider);
            if (AvdSnapshotHandler.checkSnapshotLoadable$default(this.snapshotHandler, deviceName, emulatorExecutable, this.avdFolder, this.logger, null, 16, null)) {
                this.logger.verbose(Intrinsics.stringPlus((String)"Snapshot already exists for device ", (Object)deviceName), new Object[0]);
                return;
            }
            File adbExecutable2 = ((RegularFile)((SdkComponentsBuildService.VersionedSdkLoader)this.versionedSdkLoader.get()).getAdbExecutableProvider().get()).getAsFile();
            this.logger.verbose(Intrinsics.stringPlus((String)"Creating snapshot for ", (Object)deviceName), new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)adbExecutable2, (String)"adbExecutable");
            this.snapshotHandler.generateSnapshot(deviceName, emulatorExecutable, adbExecutable2, this.avdFolder, this.logger);
            if (!AvdSnapshotHandler.checkSnapshotLoadable$default(this.snapshotHandler, deviceName, emulatorExecutable, this.avdFolder, this.logger, null, 16, null)) {
                String string = "Snapshot setup ran successfully, but the snapshot failed to be created. This is\nlikely to a lack of disk space for the snapshot. Try the cleanManagedDevices\ntask with the --unused-only flag to remove any unused devices for this project.";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.logger.verbose("Verified snapshot created for: " + deviceName + '.', new Object[0]);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> allAvds() {
        void $this$mapTo$iv$iv;
        this.getAvdManager().reloadAvds(this.logger);
        AvdInfo[] avdInfoArray = this.getAvdManager().getAllAvds();
        Intrinsics.checkNotNullExpressionValue((Object)avdInfoArray, (String)"avdManager.allAvds");
        Object[] $this$map$iv = avdInfoArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AvdInfo avdInfo = (AvdInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    public final void deleteAvds(@NotNull List<String> avds) {
        Intrinsics.checkNotNullParameter(avds, (String)"avds");
        this.getAvdManager().reloadAvds(this.logger);
        for (String avdName : avds) {
            AvdInfo avdInfo = this.getAvdManager().getAvd(avdName, false);
            if (avdInfo != null) {
                this.getAvdManager().deleteAvd(avdInfo, this.logger);
                continue;
            }
            this.logger.warning("Failed to delete avd: " + avdName + '.', new Object[0]);
        }
    }

    private final Map<String, String> defaultHardwareConfig() {
        Provider<Directory> emulatorProvider = ((SdkComponentsBuildService.VersionedSdkLoader)this.versionedSdkLoader.get()).getEmulatorDirectoryProvider();
        if (!emulatorProvider.isPresent()) {
            String string = "AVD Emulator package is not downloaded. Failed to retrieve hardware defaults for virtual device.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        File emulatorLib = ((Directory)emulatorProvider.get()).getAsFile();
        File libDirectory = new File(emulatorLib, "lib");
        File hardwareDefs = new File(libDirectory, "hardware-properties.ini");
        Map map = HardwareProperties.parseHardwareDefinitions((IAbstractFile)((IAbstractFile)new PathFileWrapper(this.sdkHandler.toCompatiblePath(hardwareDefs))), (ILogger)this.logger);
        if (map == null) {
            String string = "Failed to find hardware definitions for emulator.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map hwMap = map;
        Map hwConfigMap = MapsKt.toMutableMap(this.defaultEmulatorPropertiesMap);
        Iterable $this$forEach$iv = hwMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HardwareProperties.HardwareProperty it = (HardwareProperties.HardwareProperty)element$iv;
            boolean bl = false;
            String string = it.getDefault();
            Object object = string;
            boolean bl2 = false;
            boolean bl3 = false;
            if (object == null || object.length() == 0) continue;
            object = hwConfigMap;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"default");
            String string3 = string;
            boolean bl4 = false;
            object.put(string2, string3);
        }
        return hwConfigMap;
    }

    private final ISystemImage retrieveSystemImage(AndroidSdkHandler sdkHandler, Path imageLocation) {
        long delay = 2L;
        int n = 0;
        do {
            int retry = n++;
            ISystemImage systemImage = sdkHandler.getSystemImageManager((ProgressIndicator)new LoggerProgressIndicatorWrapper((ILogger)new StdLogger(StdLogger.Level.VERBOSE))).getImageAt(imageLocation);
            if (systemImage != null) {
                return systemImage;
            }
            if (retry == 4) continue;
            this.logger.warning("Failed to to retrieve system image at: " + imageLocation + " Retrying in " + delay + " seconds", new Object[0]);
            Thread.sleep(delay * (long)1000);
            long l = delay * 2L;
            long l2 = 10L;
            boolean bl = false;
            delay = Math.min(l, l2);
        } while (n <= 4);
        return null;
    }

    public static final /* synthetic */ AndroidSdkHandler access$getSdkHandler$p(AvdManager $this) {
        return $this.sdkHandler;
    }

    public static final /* synthetic */ File access$getAvdFolder$p(AvdManager $this) {
        return $this.avdFolder;
    }

    public static final /* synthetic */ ILogger access$getLogger$p(AvdManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ AndroidLocationsProvider access$getAndroidLocationsProvider$p(AvdManager $this) {
        return $this.androidLocationsProvider;
    }

    public static final /* synthetic */ File access$getSdkDirectory(AvdManager $this) {
        return $this.getSdkDirectory();
    }
}

