/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import java.math.BigDecimal;

public class DurationFormatter {
    public static final int MILLIS_PER_SECOND = 1000;
    public static final int MILLIS_PER_MINUTE = 60000;
    public static final int MILLIS_PER_HOUR = 3600000;
    public static final int MILLIS_PER_DAY = 86400000;

    public String format(long duration) {
        if (duration == 0L) {
            return "0s";
        }
        StringBuilder result2 = new StringBuilder();
        long days = duration / 86400000L;
        duration %= 86400000L;
        if (days > 0L) {
            result2.append(days);
            result2.append("d");
        }
        long hours = duration / 3600000L;
        duration %= 3600000L;
        if (hours > 0L || result2.length() > 0) {
            result2.append(hours);
            result2.append("h");
        }
        long minutes = duration / 60000L;
        duration %= 60000L;
        if (minutes > 0L || result2.length() > 0) {
            result2.append(minutes);
            result2.append("m");
        }
        int secondsScale = result2.length() > 0 ? 2 : 3;
        result2.append(BigDecimal.valueOf(duration).divide(BigDecimal.valueOf(1000L)).setScale(secondsScale, 4));
        result2.append("s");
        return result2.toString();
    }
}

