/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.dsl.AssetPackBundleExtension;
import com.android.build.api.variant.impl.ApplicationVariantImpl;
import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.tasks.MergeNativeDebugMetadataTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.PackageBundleTask;
import com.android.build.gradle.internal.tasks.PackageBundleTaskKt;
import com.android.build.gradle.internal.tasks.VariantAwareTaskKt;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.packaging.PackagingUtils;
import com.android.bundle.Config;
import com.android.tools.build.bundletool.commands.BuildBundleCommand;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\b'\u0018\u0000 F2\u00020\u0001:\u0007CDEFGHIB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010A\u001a\u00020BH\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000fR\u0014\u0010\u001d\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000fR\u0014\u0010\u001f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000fR\u0014\u0010!\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000fR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0014R \u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020'8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0014R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020$0\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0014R \u00101\u001a\u0002002\u0006\u0010&\u001a\u0002008G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u000fR\u0014\u00109\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u000fR\u0014\u0010;\u001a\u00020<8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0014\u0010?\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u000f\u00a8\u0006J"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "aaptOptionsNoCompress", "Lorg/gradle/api/provider/ListProperty;", "", "getAaptOptionsNoCompress", "()Lorg/gradle/api/provider/ListProperty;", "abiFilters", "Lorg/gradle/api/provider/SetProperty;", "getAbiFilters", "()Lorg/gradle/api/provider/SetProperty;", "appMetadata", "Lorg/gradle/api/file/RegularFileProperty;", "getAppMetadata", "()Lorg/gradle/api/file/RegularFileProperty;", "assetPackOptionsForAssetPackBundle", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$AssetPackOptionsForAssetPackBundle;", "getAssetPackOptionsForAssetPackBundle", "()Lorg/gradle/api/provider/Property;", "assetPackZips", "Lorg/gradle/api/file/DirectoryProperty;", "getAssetPackZips", "()Lorg/gradle/api/file/DirectoryProperty;", "baseModuleZip", "getBaseModuleZip", "binaryArtProfile", "getBinaryArtProfile", "binaryArtProfileMetadata", "getBinaryArtProfileMetadata", "bundleDeps", "getBundleDeps", "bundleFile", "getBundleFile", "bundleNeedsFusedStandaloneConfig", "", "getBundleNeedsFusedStandaloneConfig", "<set-?>", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "bundleOptions", "getBundleOptions", "()Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "bundleType", "Lcom/android/bundle/Config$BundleConfig$BundleType;", "getBundleType", "compressNativeLibs", "getCompressNativeLibs", "Lorg/gradle/api/file/FileCollection;", "featureZips", "getFeatureZips", "()Lorg/gradle/api/file/FileCollection;", "fileName", "getFileName", "()Ljava/lang/String;", "integrityConfigFile", "getIntegrityConfigFile", "mainDexList", "getMainDexList", "nativeDebugMetadataFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getNativeDebugMetadataFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "obsfuscationMappingFile", "getObsfuscationMappingFile", "doTaskAction", "", "AssetPackOptionsForAssetPackBundle", "BundleOptions", "BundleToolWorkAction", "Companion", "CreationAction", "CreationForAssetPackBundleAction", "Params", "gradle-core"})
public abstract class PackageBundleTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private FileCollection featureZips;
    private BundleOptions bundleOptions;
    public static final int MIN_SDK_FOR_SPLITS = 21;

    @Input
    @NotNull
    public abstract Property<Config.BundleConfig.BundleType> getBundleType();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract DirectoryProperty getBaseModuleZip();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public final FileCollection getFeatureZips() {
        FileCollection fileCollection2 = this.featureZips;
        if (fileCollection2 != null) {
            return fileCollection2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
        return null;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract DirectoryProperty getAssetPackZips();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getBundleDeps();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getMainDexList();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getObsfuscationMappingFile();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getIntegrityConfigFile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getNativeDebugMetadataFiles();

    @Input
    @NotNull
    public abstract SetProperty<String> getAbiFilters();

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getAppMetadata();

    @Input
    @NotNull
    public abstract ListProperty<String> getAaptOptionsNoCompress();

    @Nested
    @NotNull
    public final BundleOptions getBundleOptions() {
        BundleOptions bundleOptions = this.bundleOptions;
        if (bundleOptions != null) {
            return bundleOptions;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bundleOptions");
        return null;
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getCompressNativeLibs();

    @Nested
    @Optional
    @NotNull
    public abstract Property<AssetPackOptionsForAssetPackBundle> getAssetPackOptionsForAssetPackBundle();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getBundleFile();

    @Input
    @NotNull
    public final String getFileName() {
        String string = ((RegularFile)this.getBundleFile().get()).getAsFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bundleFile.get().asFile.name");
        return string;
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getBundleNeedsFusedStandaloneConfig();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    @NotNull
    public abstract RegularFileProperty getBinaryArtProfile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    @NotNull
    public abstract RegularFileProperty getBinaryArtProfileMetadata();

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(BundleToolWorkAction.class, new Action(this){
            final /* synthetic */ PackageBundleTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(Params it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                it.getBundleType().set((Provider)this.this$0.getBundleType());
                if (this.this$0.getBaseModuleZip().isPresent()) {
                    it.getBaseModuleFile().set(((Directory)this.this$0.getBaseModuleZip().get()).getAsFileTree().getSingleFile());
                }
                Object[] objectArray = new Object[]{this.this$0.getFeatureZips()};
                it.getFeatureFiles().from(objectArray);
                if (this.this$0.getAssetPackZips().isPresent()) {
                    objectArray = new Object[]{((Directory)this.this$0.getAssetPackZips().get()).getAsFileTree().getFiles()};
                    it.getAssetPackFiles().from(objectArray);
                }
                it.getMainDexList().set((Provider)this.this$0.getMainDexList());
                it.getObfuscationMappingFile().set((Provider)this.this$0.getObsfuscationMappingFile());
                it.getIntegrityConfigFile().set((Provider)this.this$0.getIntegrityConfigFile());
                objectArray = new Object[]{this.this$0.getNativeDebugMetadataFiles()};
                it.getNativeDebugMetadataFiles().from(objectArray);
                it.getAaptOptionsNoCompress().set((Provider)this.this$0.getAaptOptionsNoCompress());
                it.getBundleOptions().set((Object)this.this$0.getBundleOptions());
                it.getCompressNativeLibs().set((Provider)this.this$0.getCompressNativeLibs());
                it.getAssetPackOptionsForAssetPackBundle().set((Provider)this.this$0.getAssetPackOptionsForAssetPackBundle());
                it.getBundleFile().set((Provider)this.this$0.getBundleFile());
                it.getBundleDeps().set((Provider)this.this$0.getBundleDeps());
                it.getBundleNeedsFusedStandaloneConfig().set((Provider)this.this$0.getBundleNeedsFusedStandaloneConfig());
                it.getAppMetadata().set((Provider)this.this$0.getAppMetadata());
                it.getAbiFilters().set((Provider)this.this$0.getAbiFilters());
                it.getBinaryArtProfiler().set((Provider)this.this$0.getBinaryArtProfile());
                it.getBinaryArtProfilerMetadata().set((Provider)this.this$0.getBinaryArtProfileMetadata());
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$Companion;", "", "()V", "MIN_SDK_FOR_SPLITS", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000fR\u0012\u0010\u001b\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000fR\u0012\u0010\u001d\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000fR\u0012\u0010\u001f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000fR\u0012\u0010!\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000fR\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0018R\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0018R\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0018R\u0018\u0010,\u001a\b\u0012\u0004\u0012\u00020$0\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0018R\u0012\u0010.\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0013R\u0012\u00100\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u000fR\u0012\u00102\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u000fR\u0012\u00104\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0013R\u0012\u00106\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u000f\u00a8\u00068"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "aaptOptionsNoCompress", "Lorg/gradle/api/provider/ListProperty;", "", "getAaptOptionsNoCompress", "()Lorg/gradle/api/provider/ListProperty;", "abiFilters", "Lorg/gradle/api/provider/SetProperty;", "getAbiFilters", "()Lorg/gradle/api/provider/SetProperty;", "appMetadata", "Lorg/gradle/api/file/RegularFileProperty;", "getAppMetadata", "()Lorg/gradle/api/file/RegularFileProperty;", "assetPackFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getAssetPackFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "assetPackOptionsForAssetPackBundle", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$AssetPackOptionsForAssetPackBundle;", "getAssetPackOptionsForAssetPackBundle", "()Lorg/gradle/api/provider/Property;", "baseModuleFile", "getBaseModuleFile", "binaryArtProfiler", "getBinaryArtProfiler", "binaryArtProfilerMetadata", "getBinaryArtProfilerMetadata", "bundleDeps", "getBundleDeps", "bundleFile", "getBundleFile", "bundleNeedsFusedStandaloneConfig", "", "getBundleNeedsFusedStandaloneConfig", "bundleOptions", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "getBundleOptions", "bundleType", "Lcom/android/bundle/Config$BundleConfig$BundleType;", "getBundleType", "compressNativeLibs", "getCompressNativeLibs", "featureFiles", "getFeatureFiles", "integrityConfigFile", "getIntegrityConfigFile", "mainDexList", "getMainDexList", "nativeDebugMetadataFiles", "getNativeDebugMetadataFiles", "obfuscationMappingFile", "getObfuscationMappingFile", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<Config.BundleConfig.BundleType> getBundleType();

        @NotNull
        public abstract RegularFileProperty getBaseModuleFile();

        @NotNull
        public abstract ConfigurableFileCollection getFeatureFiles();

        @NotNull
        public abstract ConfigurableFileCollection getAssetPackFiles();

        @NotNull
        public abstract RegularFileProperty getMainDexList();

        @NotNull
        public abstract RegularFileProperty getObfuscationMappingFile();

        @NotNull
        public abstract RegularFileProperty getIntegrityConfigFile();

        @NotNull
        public abstract ConfigurableFileCollection getNativeDebugMetadataFiles();

        @NotNull
        public abstract ListProperty<String> getAaptOptionsNoCompress();

        @NotNull
        public abstract Property<BundleOptions> getBundleOptions();

        @NotNull
        public abstract Property<Boolean> getCompressNativeLibs();

        @NotNull
        public abstract Property<AssetPackOptionsForAssetPackBundle> getAssetPackOptionsForAssetPackBundle();

        @NotNull
        public abstract RegularFileProperty getBundleFile();

        @NotNull
        public abstract RegularFileProperty getBundleDeps();

        @NotNull
        public abstract Property<Boolean> getBundleNeedsFusedStandaloneConfig();

        @NotNull
        public abstract RegularFileProperty getAppMetadata();

        @NotNull
        public abstract SetProperty<String> getAbiFilters();

        @NotNull
        public abstract RegularFileProperty getBinaryArtProfiler();

        @NotNull
        public abstract RegularFileProperty getBinaryArtProfilerMetadata();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleToolWorkAction;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$Params;", "()V", "getBundlePath", "Ljava/nio/file/Path;", "folder", "Ljava/io/File;", "run", "", "gradle-core"})
    public static abstract class BundleToolWorkAction
    extends ProfileAwareWorkAction<Params> {
        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            File it;
            boolean bl;
            File $i$f$map2;
            boolean bl22;
            String string;
            boolean bl32;
            File it2;
            Object element$iv2;
            File bundleFile = (File)((Params)this.getParameters()).getBundleFile().getAsFile().get();
            FileUtils.cleanOutputDir((File)bundleFile.getParentFile());
            ImmutableList.Builder builder = ImmutableList.builder();
            if (((Params)this.getParameters()).getBaseModuleFile().isPresent()) {
                builder.add((Object)((File)((Params)this.getParameters()).getBaseModuleFile().getAsFile().get()).toPath());
            }
            Iterable $this$forEach$iv = (Iterable)((Params)this.getParameters()).getFeatureFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it2 = (File)element$iv2;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                builder.add((Object)this.getBundlePath(it2));
            }
            $this$forEach$iv = ((Params)this.getParameters()).getAssetPackFiles().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"parameters.assetPackFiles.files");
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it2 = (File)element$iv2;
                bl32 = false;
                File file = it2.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.parentFile");
                builder.add((Object)this.getBundlePath(file));
            }
            List noCompressGlobsForBundle = PackagingUtils.getNoCompressGlobsForBundle((Collection)((Collection)((Params)this.getParameters()).getAaptOptionsNoCompress().get()));
            Object object = Config.SplitsConfig.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newBuilder()");
            Config.SplitsConfig.Builder splitsConfig = PackageBundleTaskKt.access$splitBy(PackageBundleTaskKt.access$splitBy(PackageBundleTaskKt.access$splitBy(object, Config.SplitDimension.Value.ABI, ((BundleOptions)((Params)this.getParameters()).getBundleOptions().get()).getEnableAbi()), Config.SplitDimension.Value.SCREEN_DENSITY, ((BundleOptions)((Params)this.getParameters()).getBundleOptions().get()).getEnableDensity()), Config.SplitDimension.Value.LANGUAGE, ((BundleOptions)((Params)this.getParameters()).getBundleOptions().get()).getEnableLanguage());
            object = ((BundleOptions)((Params)this.getParameters()).getBundleOptions().get()).getEnableTexture();
            if (object != null) {
                element$iv2 = object;
                boolean it3 = false;
                bl32 = false;
                boolean it4 = (Boolean)element$iv2;
                boolean bl5 = false;
                splitsConfig.addSplitDimension(Config.SplitDimension.newBuilder().setValue(Config.SplitDimension.Value.TEXTURE_COMPRESSION_FORMAT).setSuffixStripping(Config.SuffixStripping.newBuilder().setEnabled(true).setDefaultSuffix((string = ((BundleOptions)((Params)this.getParameters()).getBundleOptions().get()).getTextureDefaultFormat()) == null ? "" : string)).setNegate(!it4));
            }
            object = ((BundleOptions)((Params)this.getParameters()).getBundleOptions().get()).getEnableDeviceTier();
            if (object != null) {
                element$iv2 = object;
                boolean it3 = false;
                bl32 = false;
                boolean it5 = (Boolean)element$iv2;
                bl22 = false;
                splitsConfig.addSplitDimension(Config.SplitDimension.newBuilder().setValue(Config.SplitDimension.Value.DEVICE_TIER).setSuffixStripping(Config.SuffixStripping.newBuilder().setEnabled(true).setDefaultSuffix((string = ((BundleOptions)((Params)this.getParameters()).getBundleOptions().get()).getDefaultDeviceTier()) == null ? "" : string)).setNegate(!it5));
            }
            Config.UncompressNativeLibraries.Builder uncompressNativeLibrariesConfig = Config.UncompressNativeLibraries.newBuilder().setEnabled((Boolean)((Params)this.getParameters()).getCompressNativeLibs().get() == false);
            Config.Optimizations.Builder bundleOptimizations = Config.Optimizations.newBuilder().setSplitsConfig(splitsConfig).setUncompressNativeLibraries(uncompressNativeLibrariesConfig);
            Object it3 = ((BundleOptions)((Params)this.getParameters()).getBundleOptions().get()).getEnableStoreArchive();
            if (it3 != null) {
                Boolean bl32 = it3;
                boolean it5 = false;
                bl22 = false;
                boolean it6 = bl32;
                boolean bl6 = false;
                bundleOptimizations.setStoreArchive(Config.StoreArchive.newBuilder().setEnabled(it6));
            }
            it3 = ((Params)this.getParameters()).getBundleNeedsFusedStandaloneConfig().get();
            Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"parameters.bundleNeedsFusedStandaloneConfig.get()");
            if (((Boolean)it3).booleanValue()) {
                bundleOptimizations.setStandaloneConfig(Config.StandaloneConfig.newBuilder().addSplitDimension(Config.SplitDimension.newBuilder().setValue(Config.SplitDimension.Value.ABI).setNegate(true)).addSplitDimension(Config.SplitDimension.newBuilder().setValue(Config.SplitDimension.Value.SCREEN_DENSITY).setNegate(true)).addSplitDimension(Config.SplitDimension.newBuilder().setValue(Config.SplitDimension.Value.LANGUAGE).setNegate(true)).addSplitDimension(Config.SplitDimension.newBuilder().setValue(Config.SplitDimension.Value.TEXTURE_COMPRESSION_FORMAT).setNegate(true)).setStrip64BitLibraries(true));
            }
            Config.BundleConfig.Builder bundleConfig = Config.BundleConfig.newBuilder().setType((Config.BundleConfig.BundleType)((Params)this.getParameters()).getBundleType().get()).setCompression(Config.Compression.newBuilder().addAllUncompressedGlob((Iterable)noCompressGlobsForBundle)).setOptimizations(bundleOptimizations);
            if (((Params)this.getParameters()).getAssetPackOptionsForAssetPackBundle().isPresent()) {
                Collection<Long> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable bl32 = ((AssetPackOptionsForAssetPackBundle)((Params)this.getParameters()).getAssetPackOptionsForAssetPackBundle().get()).getVersionCodes();
                Config.AssetModulesConfig.Builder builder2 = bundleConfig.getAssetModulesConfigBuilder().setAssetVersionTag(((AssetPackOptionsForAssetPackBundle)((Params)this.getParameters()).getAssetPackOptionsForAssetPackBundle().get()).getVersionTag());
                boolean $i$f$map2 = false;
                void bl22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it7;
                    int n = ((Number)item$iv$iv).intValue();
                    collection = destination$iv$iv;
                    boolean bl7 = false;
                    Long l = (long)it7;
                    collection.add(l);
                }
                collection = (List)destination$iv$iv;
                builder2.addAllAppVersion((Iterable)collection);
            }
            BuildBundleCommand.Builder command = BuildBundleCommand.builder().setUncompressedBundle(true).setBundleConfig(bundleConfig.build()).setOutputPath(bundleFile.toPath()).setModulesPaths(builder.build());
            if (((Params)this.getParameters()).getBinaryArtProfiler().isPresent() && ((RegularFile)((Params)this.getParameters()).getBinaryArtProfiler().get()).getAsFile().exists()) {
                command.addMetadataFile(StringsKt.replace$default((String)"assets/dexopt", (char)'/', (char)'.', (boolean)false, (int)4, null), "baseline.prof", ((RegularFile)((Params)this.getParameters()).getBinaryArtProfiler().get()).getAsFile().toPath());
            }
            if (((Params)this.getParameters()).getBinaryArtProfilerMetadata().isPresent() && ((RegularFile)((Params)this.getParameters()).getBinaryArtProfilerMetadata().get()).getAsFile().exists()) {
                command.addMetadataFile(StringsKt.replace$default((String)"assets/dexopt", (char)'/', (char)'.', (boolean)false, (int)4, null), "baseline.profm", ((RegularFile)((Params)this.getParameters()).getBinaryArtProfilerMetadata().get()).getAsFile().toPath());
            }
            if (($i$f$map2 = (File)((Params)this.getParameters()).getBundleDeps().getAsFile().getOrNull()) != null) {
                File $this$mapTo$iv$iv = $i$f$map2;
                boolean destination$iv$iv = false;
                bl = false;
                it = $this$mapTo$iv$iv;
                boolean bl8 = false;
                command.addMetadataFile("com.android.tools.build.libraries", "dependencies.pb", it.toPath());
            }
            $i$f$map2 = (File)((Params)this.getParameters()).getMainDexList().getAsFile().getOrNull();
            if ($i$f$map2 != null) {
                File $this$mapTo$iv$iv = $i$f$map2;
                boolean destination$iv$iv = false;
                bl = false;
                it = $this$mapTo$iv$iv;
                boolean bl9 = false;
                command.setMainDexListFile(it.toPath());
            }
            $i$f$map2 = (File)((Params)this.getParameters()).getObfuscationMappingFile().getAsFile().getOrNull();
            if ($i$f$map2 != null) {
                File $this$mapTo$iv$iv = $i$f$map2;
                boolean destination$iv$iv = false;
                bl = false;
                it = $this$mapTo$iv$iv;
                boolean bl10 = false;
                command.addMetadataFile("com.android.tools.build.obfuscation", "proguard.map", it.toPath());
            }
            $i$f$map2 = (File)((Params)this.getParameters()).getIntegrityConfigFile().getAsFile().getOrNull();
            if ($i$f$map2 != null) {
                File $this$mapTo$iv$iv = $i$f$map2;
                boolean destination$iv$iv = false;
                bl = false;
                it = $this$mapTo$iv$iv;
                boolean bl11 = false;
                if (it.isFile()) {
                    command.addMetadataFile("com.google.play.apps.integrity", "AppIntegrityConfig.pb", it.toPath());
                }
            }
            Set abiFilters = (Set)((Params)this.getParameters()).getAbiFilters().get();
            Iterable $this$forEach$iv2 = (Iterable)((Params)this.getParameters()).getNativeDebugMetadataFiles();
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                File file = (File)element$iv3;
                boolean bl12 = false;
                String abi = file.getParentFile().getName();
                if (!abiFilters.isEmpty() && !abiFilters.contains(abi)) continue;
                command.addMetadataFile("com.android.tools.build.debugsymbols", abi + '/' + file.getName(), file.toPath());
            }
            command.addMetadataFile("com.android.tools.build.gradle", "app-metadata.properties", ((File)((Params)this.getParameters()).getAppMetadata().getAsFile().get()).toPath());
            command.build().execute();
        }

        private final Path getBundlePath(File folder) {
            File[] children2 = folder.listFiles();
            Preconditions.checkNotNull((Object)children2);
            Preconditions.checkState((children2.length == 1 ? 1 : 0) != 0);
            Path path = children2[0].toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"children[0].toPath()");
            return path;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u001b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BU\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010Jn\u0010 \u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010!J\u0013\u0010\"\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\bH\u00d6\u0001R\u0015\u0010\n\u001a\u0004\u0018\u00010\b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\t\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0013\u0010\u0010R\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0014\u0010\u0010R\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0015\u0010\u0010R\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0016\u0010\u0010R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000e\u00a8\u0006("}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "Ljava/io/Serializable;", "enableAbi", "", "enableDensity", "enableLanguage", "enableTexture", "textureDefaultFormat", "", "enableDeviceTier", "defaultDeviceTier", "enableStoreArchive", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/Boolean;)V", "getDefaultDeviceTier", "()Ljava/lang/String;", "getEnableAbi", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getEnableDensity", "getEnableDeviceTier", "getEnableLanguage", "getEnableStoreArchive", "getEnableTexture", "getTextureDefaultFormat", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/Boolean;)Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "equals", "other", "", "hashCode", "", "toString", "gradle-core"})
    public static final class BundleOptions
    implements Serializable {
        @Nullable
        private final Boolean enableAbi;
        @Nullable
        private final Boolean enableDensity;
        @Nullable
        private final Boolean enableLanguage;
        @Nullable
        private final Boolean enableTexture;
        @Nullable
        private final String textureDefaultFormat;
        @Nullable
        private final Boolean enableDeviceTier;
        @Nullable
        private final String defaultDeviceTier;
        @Nullable
        private final Boolean enableStoreArchive;

        public BundleOptions(@Nullable Boolean enableAbi, @Nullable Boolean enableDensity, @Nullable Boolean enableLanguage, @Nullable Boolean enableTexture, @Nullable String textureDefaultFormat, @Nullable Boolean enableDeviceTier, @Nullable String defaultDeviceTier, @Nullable Boolean enableStoreArchive) {
            this.enableAbi = enableAbi;
            this.enableDensity = enableDensity;
            this.enableLanguage = enableLanguage;
            this.enableTexture = enableTexture;
            this.textureDefaultFormat = textureDefaultFormat;
            this.enableDeviceTier = enableDeviceTier;
            this.defaultDeviceTier = defaultDeviceTier;
            this.enableStoreArchive = enableStoreArchive;
        }

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableAbi() {
            return this.enableAbi;
        }

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableDensity() {
            return this.enableDensity;
        }

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableLanguage() {
            return this.enableLanguage;
        }

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableTexture() {
            return this.enableTexture;
        }

        @Input
        @Optional
        @Nullable
        public final String getTextureDefaultFormat() {
            return this.textureDefaultFormat;
        }

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableDeviceTier() {
            return this.enableDeviceTier;
        }

        @Input
        @Optional
        @Nullable
        public final String getDefaultDeviceTier() {
            return this.defaultDeviceTier;
        }

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableStoreArchive() {
            return this.enableStoreArchive;
        }

        @Nullable
        public final Boolean component1() {
            return this.enableAbi;
        }

        @Nullable
        public final Boolean component2() {
            return this.enableDensity;
        }

        @Nullable
        public final Boolean component3() {
            return this.enableLanguage;
        }

        @Nullable
        public final Boolean component4() {
            return this.enableTexture;
        }

        @Nullable
        public final String component5() {
            return this.textureDefaultFormat;
        }

        @Nullable
        public final Boolean component6() {
            return this.enableDeviceTier;
        }

        @Nullable
        public final String component7() {
            return this.defaultDeviceTier;
        }

        @Nullable
        public final Boolean component8() {
            return this.enableStoreArchive;
        }

        @NotNull
        public final BundleOptions copy(@Nullable Boolean enableAbi, @Nullable Boolean enableDensity, @Nullable Boolean enableLanguage, @Nullable Boolean enableTexture, @Nullable String textureDefaultFormat, @Nullable Boolean enableDeviceTier, @Nullable String defaultDeviceTier, @Nullable Boolean enableStoreArchive) {
            return new BundleOptions(enableAbi, enableDensity, enableLanguage, enableTexture, textureDefaultFormat, enableDeviceTier, defaultDeviceTier, enableStoreArchive);
        }

        public static /* synthetic */ BundleOptions copy$default(BundleOptions bundleOptions, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, String string, Boolean bl5, String string2, Boolean bl6, int n, Object object) {
            if ((n & 1) != 0) {
                bl = bundleOptions.enableAbi;
            }
            if ((n & 2) != 0) {
                bl2 = bundleOptions.enableDensity;
            }
            if ((n & 4) != 0) {
                bl3 = bundleOptions.enableLanguage;
            }
            if ((n & 8) != 0) {
                bl4 = bundleOptions.enableTexture;
            }
            if ((n & 0x10) != 0) {
                string = bundleOptions.textureDefaultFormat;
            }
            if ((n & 0x20) != 0) {
                bl5 = bundleOptions.enableDeviceTier;
            }
            if ((n & 0x40) != 0) {
                string2 = bundleOptions.defaultDeviceTier;
            }
            if ((n & 0x80) != 0) {
                bl6 = bundleOptions.enableStoreArchive;
            }
            return bundleOptions.copy(bl, bl2, bl3, bl4, string, bl5, string2, bl6);
        }

        @NotNull
        public String toString() {
            return "BundleOptions(enableAbi=" + this.enableAbi + ", enableDensity=" + this.enableDensity + ", enableLanguage=" + this.enableLanguage + ", enableTexture=" + this.enableTexture + ", textureDefaultFormat=" + this.textureDefaultFormat + ", enableDeviceTier=" + this.enableDeviceTier + ", defaultDeviceTier=" + this.defaultDeviceTier + ", enableStoreArchive=" + this.enableStoreArchive + ')';
        }

        public int hashCode() {
            int result2 = this.enableAbi == null ? 0 : ((Object)this.enableAbi).hashCode();
            result2 = result2 * 31 + (this.enableDensity == null ? 0 : ((Object)this.enableDensity).hashCode());
            result2 = result2 * 31 + (this.enableLanguage == null ? 0 : ((Object)this.enableLanguage).hashCode());
            result2 = result2 * 31 + (this.enableTexture == null ? 0 : ((Object)this.enableTexture).hashCode());
            result2 = result2 * 31 + (this.textureDefaultFormat == null ? 0 : this.textureDefaultFormat.hashCode());
            result2 = result2 * 31 + (this.enableDeviceTier == null ? 0 : ((Object)this.enableDeviceTier).hashCode());
            result2 = result2 * 31 + (this.defaultDeviceTier == null ? 0 : this.defaultDeviceTier.hashCode());
            result2 = result2 * 31 + (this.enableStoreArchive == null ? 0 : ((Object)this.enableStoreArchive).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BundleOptions)) {
                return false;
            }
            BundleOptions bundleOptions = (BundleOptions)other;
            if (!Intrinsics.areEqual((Object)this.enableAbi, (Object)bundleOptions.enableAbi)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.enableDensity, (Object)bundleOptions.enableDensity)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.enableLanguage, (Object)bundleOptions.enableLanguage)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.enableTexture, (Object)bundleOptions.enableTexture)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.textureDefaultFormat, (Object)bundleOptions.textureDefaultFormat)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.enableDeviceTier, (Object)bundleOptions.enableDeviceTier)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.defaultDeviceTier, (Object)bundleOptions.defaultDeviceTier)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.enableStoreArchive, (Object)bundleOptions.enableStoreArchive);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J%\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$AssetPackOptionsForAssetPackBundle;", "Ljava/io/Serializable;", "versionCodes", "", "", "versionTag", "", "(Ljava/util/List;Ljava/lang/String;)V", "getVersionCodes", "()Ljava/util/List;", "getVersionTag", "()Ljava/lang/String;", "setVersionTag", "(Ljava/lang/String;)V", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "gradle-core"})
    public static final class AssetPackOptionsForAssetPackBundle
    implements Serializable {
        @NotNull
        private final List<Integer> versionCodes;
        @Nullable
        private String versionTag;

        public AssetPackOptionsForAssetPackBundle(@NotNull List<Integer> versionCodes, @Nullable String versionTag) {
            Intrinsics.checkNotNullParameter(versionCodes, (String)"versionCodes");
            this.versionCodes = versionCodes;
            this.versionTag = versionTag;
        }

        @Input
        @NotNull
        public final List<Integer> getVersionCodes() {
            return this.versionCodes;
        }

        @Input
        @Nullable
        public final String getVersionTag() {
            return this.versionTag;
        }

        public final void setVersionTag(@Nullable String string) {
            this.versionTag = string;
        }

        @NotNull
        public final List<Integer> component1() {
            return this.versionCodes;
        }

        @Nullable
        public final String component2() {
            return this.versionTag;
        }

        @NotNull
        public final AssetPackOptionsForAssetPackBundle copy(@NotNull List<Integer> versionCodes, @Nullable String versionTag) {
            Intrinsics.checkNotNullParameter(versionCodes, (String)"versionCodes");
            return new AssetPackOptionsForAssetPackBundle(versionCodes, versionTag);
        }

        public static /* synthetic */ AssetPackOptionsForAssetPackBundle copy$default(AssetPackOptionsForAssetPackBundle assetPackOptionsForAssetPackBundle, List list, String string, int n, Object object) {
            if ((n & 1) != 0) {
                list = assetPackOptionsForAssetPackBundle.versionCodes;
            }
            if ((n & 2) != 0) {
                string = assetPackOptionsForAssetPackBundle.versionTag;
            }
            return assetPackOptionsForAssetPackBundle.copy(list, string);
        }

        @NotNull
        public String toString() {
            return "AssetPackOptionsForAssetPackBundle(versionCodes=" + this.versionCodes + ", versionTag=" + this.versionTag + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.versionCodes).hashCode();
            result2 = result2 * 31 + (this.versionTag == null ? 0 : this.versionTag.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AssetPackOptionsForAssetPackBundle)) {
                return false;
            }
            AssetPackOptionsForAssetPackBundle assetPackOptionsForAssetPackBundle = (AssetPackOptionsForAssetPackBundle)other;
            if (!Intrinsics.areEqual(this.versionCodes, assetPackOptionsForAssetPackBundle.versionCodes)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.versionTag, (Object)assetPackOptionsForAssetPackBundle.versionTag);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0016\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$CreationForAssetPackBundleAction;", "Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask;", "projectServices", "Lcom/android/build/gradle/internal/services/ProjectServices;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "assetPackBundle", "Lcom/android/build/api/dsl/AssetPackBundleExtension;", "(Lcom/android/build/gradle/internal/services/ProjectServices;Lcom/android/build/api/artifact/impl/ArtifactsImpl;Lcom/android/build/api/dsl/AssetPackBundleExtension;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationForAssetPackBundleAction
    extends TaskCreationAction<PackageBundleTask> {
        @NotNull
        private final ProjectServices projectServices;
        @NotNull
        private final ArtifactsImpl artifacts;
        @NotNull
        private final AssetPackBundleExtension assetPackBundle;
        @NotNull
        private final Class<PackageBundleTask> type;
        @NotNull
        private final String name;

        public CreationForAssetPackBundleAction(@NotNull ProjectServices projectServices2, @NotNull ArtifactsImpl artifacts2, @NotNull AssetPackBundleExtension assetPackBundle) {
            Intrinsics.checkNotNullParameter((Object)projectServices2, (String)"projectServices");
            Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
            Intrinsics.checkNotNullParameter((Object)assetPackBundle, (String)"assetPackBundle");
            this.projectServices = projectServices2;
            this.artifacts = artifacts2;
            this.assetPackBundle = assetPackBundle;
            this.type = PackageBundleTask.class;
            this.name = "packageBundle";
        }

        @Override
        @NotNull
        public Class<PackageBundleTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<PackageBundleTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.artifacts.setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.INTERMEDIARY_BUNDLE.INSTANCE);
        }

        @Override
        public void configure(@NotNull PackageBundleTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            VariantAwareTaskKt.configureVariantProperties(task, "", this.projectServices.getBuildServiceRegistry());
            task.getBundleType().set((Object)Config.BundleConfig.BundleType.ASSET_ONLY);
            ConfigurableFileCollection configurableFileCollection = this.projectServices.getObjectFactory().fileCollection();
            Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"projectServices.objectFactory.fileCollection()");
            task.featureZips = (FileCollection)configurableFileCollection;
            this.artifacts.setTaskInputToFinalProduct(InternalArtifactType.ASSET_PACK_BUNDLE.INSTANCE, (Property)task.getAssetPackZips());
            task.getAppMetadata();
            task.bundleOptions = PackageBundleTaskKt.access$convert(this.assetPackBundle);
            HasConfigurableValuesKt.setDisallowChanges(task.getCompressNativeLibs(), true);
            task.getAssetPackOptionsForAssetPackBundle().set((Object)new AssetPackOptionsForAssetPackBundle(CollectionsKt.toList((Iterable)this.assetPackBundle.getVersionCodes()), this.assetPackBundle.getVersionTag()));
            task.getBundleNeedsFusedStandaloneConfig().set((Object)false);
            this.artifacts.setTaskInputToFinalProduct(InternalArtifactType.APP_METADATA.INSTANCE, (Property)task.getAppMetadata());
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask;", "Lcom/android/build/api/variant/impl/ApplicationVariantImpl;", "componentProperties", "(Lcom/android/build/api/variant/impl/ApplicationVariantImpl;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PackageBundleTask, ApplicationVariantImpl> {
        @NotNull
        private final ApplicationVariantImpl componentProperties;

        public CreationAction(@NotNull ApplicationVariantImpl componentProperties) {
            Intrinsics.checkNotNullParameter((Object)componentProperties, (String)"componentProperties");
            super((ComponentCreationConfig)componentProperties);
            this.componentProperties = componentProperties;
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("package", "Bundle");
        }

        @Override
        @NotNull
        public Class<PackageBundleTask> getType() {
            return PackageBundleTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<PackageBundleTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApplicationVariantImpl)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.INTERMEDIARY_BUNDLE.INSTANCE);
        }

        @Override
        public void configure(@NotNull PackageBundleTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.getBundleType().set((Object)Config.BundleConfig.BundleType.REGULAR);
            ((ApplicationVariantImpl)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.MODULE_BUNDLE.INSTANCE, (Property)task.getBaseModuleZip());
            task.featureZips = VariantDependencies.getArtifactFileCollection$default(((ApplicationVariantImpl)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MODULE_BUNDLE, null, 8, null);
            if (((ApplicationVariantImpl)this.creationConfig).getNeedAssetPackTasks()) {
                ((ApplicationVariantImpl)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.ASSET_PACK_BUNDLE.INSTANCE, (Property)task.getAssetPackZips());
            }
            ((ApplicationVariantImpl)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.BUNDLE_DEPENDENCY_REPORT.INSTANCE, (Property)task.getBundleDeps());
            ((ApplicationVariantImpl)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.APP_INTEGRITY_CONFIG.INSTANCE, (Property)task.getIntegrityConfigFile());
            Object[] objectArray = new Object[]{MergeNativeDebugMetadataTask.Companion.getNativeDebugMetadataFiles((ApplicationVariantImpl)this.creationConfig)};
            HasConfigurableValuesKt.fromDisallowChanges(task.getNativeDebugMetadataFiles(), objectArray);
            HasConfigurableValuesKt.setDisallowChanges(task.getAbiFilters(), (Iterable)((ApplicationVariantImpl)this.creationConfig).getVariantDslInfo().getSupportedAbis());
            HasConfigurableValuesKt.setDisallowChanges(task.getAaptOptionsNoCompress(), (Provider)((ApplicationVariantImpl)this.creationConfig).getAndroidResources().getNoCompress());
            task.bundleOptions = PackageBundleTaskKt.access$convert(((ApplicationVariantImpl)this.creationConfig).getGlobal().getBundleOptions());
            task.getCompressNativeLibs().set(this.componentProperties.getPackaging().getJniLibs().getUseLegacyPackagingFromBundle());
            if (!((ApplicationVariantImpl)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_UNCOMPRESSED_NATIVE_LIBS_IN_BUNDLE)) {
                task.getCompressNativeLibs().set((Object)true);
            }
            task.getCompressNativeLibs().disallowChanges();
            if (((ApplicationVariantImpl)this.creationConfig).getNeedsMainDexListForBundle()) {
                ((ApplicationVariantImpl)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.MAIN_DEX_LIST_FOR_BUNDLE.INSTANCE, (Property)task.getMainDexList());
            }
            ((ApplicationVariantImpl)this.creationConfig).getArtifacts().setTaskInputToFinalProduct((Artifact.Single)SingleArtifact.OBFUSCATION_MAPPING_FILE.INSTANCE, (Property)task.getObsfuscationMappingFile());
            task.getBundleNeedsFusedStandaloneConfig().set(task.getProject().getProviders().provider(new Callable(this){
                final /* synthetic */ CreationAction this$0;
                {
                    this.this$0 = $receiver;
                }

                public final Boolean call() {
                    return VariantApiExtensionsKt.getFeatureLevel(((ApplicationVariantImpl)CreationAction.access$getCreationConfig$p(this.this$0)).getMinSdkVersion()) < 21 && ((ApplicationVariantImpl)CreationAction.access$getCreationConfig$p(this.this$0)).getArtifacts().get(InternalArtifactType.ASSET_PACK_BUNDLE.INSTANCE).isPresent();
                }
            }));
            ((ApplicationVariantImpl)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.APP_METADATA.INSTANCE, (Property)task.getAppMetadata());
            if (((ApplicationVariantImpl)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_ART_PROFILES) && !((ApplicationVariantImpl)this.creationConfig).getDebuggable()) {
                ((ApplicationVariantImpl)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.BINARY_ART_PROFILE.INSTANCE, (Property)task.getBinaryArtProfile());
                ((ApplicationVariantImpl)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.BINARY_ART_PROFILE_METADATA.INSTANCE, (Property)task.getBinaryArtProfileMetadata());
            }
            task.getBinaryArtProfile().disallowChanges();
            task.getBinaryArtProfileMetadata().disallowChanges();
        }

        public static final /* synthetic */ ComponentCreationConfig access$getCreationConfig$p(CreationAction $this) {
            return $this.creationConfig;
        }
    }
}

