/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.variant.DimensionCombination;
import com.android.build.gradle.internal.variant.DimensionCombinationImpl;
import com.android.build.gradle.internal.variant.DimensionCombinator;
import com.android.build.gradle.internal.variant.DimensionCombinatorKt;
import com.android.build.gradle.internal.variant.FlavorCombinationBuilder;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.builder.errors.IssueReporter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B3\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007H\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007H\u0002J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/variant/DimensionCombinator;", "", "variantInputModel", "Lcom/android/build/gradle/internal/variant/VariantInputModel;", "errorReporter", "Lcom/android/builder/errors/IssueReporter;", "flavorDimensionList", "", "", "(Lcom/android/build/gradle/internal/variant/VariantInputModel;Lcom/android/builder/errors/IssueReporter;Ljava/util/List;)V", "combineFlavorsAndBuildTypes", "Lcom/android/build/gradle/internal/variant/DimensionCombination;", "flavorCombos", "Lcom/android/build/gradle/internal/variant/FlavorCombinationBuilder;", "computeFlavorlessVariants", "computeVariants", "computeVariantsWithFlavors", "validateFlavorDimensions", "Companion", "gradle-core"})
public final class DimensionCombinator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VariantInputModel<?, ?, ?, ?> variantInputModel;
    @NotNull
    private final IssueReporter errorReporter;
    @NotNull
    private final List<String> flavorDimensionList;
    @NotNull
    public static final String FAKE_DIMENSION = "agp-missing-dimension-for-sync-only";

    public DimensionCombinator(@NotNull VariantInputModel<?, ?, ?, ?> variantInputModel, @NotNull IssueReporter errorReporter, @NotNull List<String> flavorDimensionList) {
        Intrinsics.checkNotNullParameter(variantInputModel, (String)"variantInputModel");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter(flavorDimensionList, (String)"flavorDimensionList");
        this.variantInputModel = variantInputModel;
        this.errorReporter = errorReporter;
        this.flavorDimensionList = flavorDimensionList;
    }

    @NotNull
    public final List<DimensionCombination> computeVariants() {
        if (this.variantInputModel.getProductFlavors().isEmpty()) {
            return this.computeFlavorlessVariants();
        }
        return this.computeVariantsWithFlavors();
    }

    private final List<DimensionCombination> computeFlavorlessVariants() {
        List list;
        if (this.variantInputModel.getBuildTypes().isEmpty()) {
            ImmutableList immutableList = ImmutableList.of((Object)new DimensionCombinationImpl(null, null, 3, null));
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"{\n            ImmutableL\u2026binationImpl())\n        }");
            list = (List)immutableList;
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String buildType : this.variantInputModel.getBuildTypes().keySet()) {
                builder.add((Object)new DimensionCombinationImpl(buildType, null, 2, null));
            }
            ImmutableList immutableList = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"{\n            val builde\u2026builder.build()\n        }");
            list = (List)immutableList;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DimensionCombination> computeVariantsWithFlavors() {
        void $this$groupByTo$iv$iv;
        List<String> flavorDimensionList = this.validateFlavorDimensions();
        Sequence $this$groupBy$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.variantInputModel.getProductFlavors().values()), (Function1)computeVariantsWithFlavors.flavorMap.1.INSTANCE);
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            String key$iv$iv;
            com.android.build.api.dsl.ProductFlavor it2 = (com.android.build.api.dsl.ProductFlavor)element$iv$iv;
            boolean $i$a$-groupBy-DimensionCombinator$computeVariantsWithFlavors$flavorMap$42 = false;
            Intrinsics.checkNotNull((Object)it2.getDimension());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            com.android.build.api.dsl.ProductFlavor $i$a$-groupBy-DimensionCombinator$computeVariantsWithFlavors$flavorMap$42 = (com.android.build.api.dsl.ProductFlavor)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            String string = it.getName();
            list.add(string);
        }
        Map flavorMap2 = destination$iv$iv;
        ImmutableList.Builder builder = ImmutableList.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        DimensionCombinatorKt.createProductFlavorCombinations$default(flavorDimensionList, flavorMap2, builder, this.errorReporter, null, 0, 48, null);
        ImmutableList immutableList = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"builder.build()");
        return this.combineFlavorsAndBuildTypes((List)immutableList);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DimensionCombination> combineFlavorsAndBuildTypes(List<FlavorCombinationBuilder> flavorCombos) {
        if (this.variantInputModel.getBuildTypes().isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = flavorCombos;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FlavorCombinationBuilder flavorCombinationBuilder = (FlavorCombinationBuilder)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DimensionCombinationImpl dimensionCombinationImpl = new DimensionCombinationImpl(null, (List)it.getFlavorPairs(), 1, null);
                collection.add(dimensionCombinationImpl);
            }
            return (List)destination$iv$iv;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String buildType : this.variantInputModel.getBuildTypes().keySet()) {
            Collection<DimensionCombinationImpl> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable destination$iv$iv = flavorCombos;
            ImmutableList.Builder builder2 = builder;
            boolean $i$f$map = false;
            void var7_13 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FlavorCombinationBuilder flavorCombinationBuilder = (FlavorCombinationBuilder)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                DimensionCombinationImpl dimensionCombinationImpl = new DimensionCombinationImpl(buildType, (List)it.getFlavorPairs());
                collection.add(dimensionCombinationImpl);
            }
            collection = (List)destination$iv$iv2;
            builder2.addAll((Iterable)collection);
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"builder.build()");
        return (List)immutableList;
    }

    private final List<String> validateFlavorDimensions() {
        if (this.flavorDimensionList.isEmpty()) {
            IssueReporter.reportError$default((IssueReporter)this.errorReporter, (IssueReporter.Type)IssueReporter.Type.UNNAMED_FLAVOR_DIMENSION, (String)"All flavors must now belong to a named flavor dimension. Learn more at https://d.android.com/r/tools/flavorDimensions-missing-error-message.html", null, null, (int)12, null);
            boolean bl = false;
            Set dimensions = new LinkedHashSet();
            for (ProductFlavorData<?> flavor : this.variantInputModel.getProductFlavors().values()) {
                Object productFlavor = flavor.getProductFlavor();
                String dim = productFlavor.getDimension();
                if (dim == null) {
                    ((ProductFlavor)productFlavor).setInternalDimensionDefault$gradle_core(FAKE_DIMENSION);
                    continue;
                }
                dimensions.add(dim);
            }
            if (dimensions.isEmpty()) {
                dimensions.add(FAKE_DIMENSION);
            }
            return CollectionsKt.toList((Iterable)dimensions);
        }
        if (this.flavorDimensionList.size() == 1) {
            String dimensionName = this.flavorDimensionList.get(0);
            for (ProductFlavorData<?> flavorData : this.variantInputModel.getProductFlavors().values()) {
                Object flavor = flavorData.getProductFlavor();
                if (flavor.getDimension() != null) continue;
                ((ProductFlavor)flavor).setInternalDimensionDefault$gradle_core(dimensionName);
            }
        }
        return this.flavorDimensionList;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/variant/DimensionCombinator$Companion;", "", "()V", "FAKE_DIMENSION", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

