/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.utils.DesugarConfigJson;
import com.android.build.gradle.internal.utils.DesugarLibConfigExtractor;
import com.android.build.gradle.internal.utils.DesugarLibLintExtractor;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ValueSourceSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f\u001a \u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u001a.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a \u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"ATTR_LINT_COMPILE_SDK", "Lorg/gradle/api/attributes/Attribute;", "", "ATTR_LINT_MIN_SDK", "DESUGAR_LIB_CONFIG", "DESUGAR_LIB_CONFIG_FILE", "DESUGAR_LIB_DEX", "DESUGAR_LIB_LINT", "getArtifactCollection", "Lorg/gradle/api/file/FileCollection;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "getDesugarLibConfig", "Lorg/gradle/api/provider/Provider;", "project", "Lorg/gradle/api/Project;", "getDesugarLibConfigFromTransform", "getDesugarLibConfiguration", "getDesugarLibJarFromMaven", "getDesugarLibLintFromTransform", "minSdkVersion", "", "compileSdkVersion", "getDesugaredMethods", "", "coreLibraryDesugaringEnabled", "", "Lcom/android/build/api/variant/AndroidVersion;", "registerDesugarLibConfigTransform", "", "registerDesugarLibLintTransform", "gradle-core"})
@JvmName(name="DesugarLibUtils")
public final class DesugarLibUtils {
    @NotNull
    private static final String DESUGAR_LIB_CONFIG_FILE = "desugar.json";
    @NotNull
    public static final String DESUGAR_LIB_DEX = "_internal-desugar-lib-dex";
    @NotNull
    public static final String DESUGAR_LIB_CONFIG = "_internal-desugar-lib-config";
    @NotNull
    private static final String DESUGAR_LIB_LINT = "_internal-desugar-lib-lint";
    @NotNull
    private static final Attribute<String> ATTR_LINT_MIN_SDK;
    @NotNull
    private static final Attribute<String> ATTR_LINT_COMPILE_SDK;

    @NotNull
    public static final FileCollection getDesugarLibJarFromMaven(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Configuration configuration = DesugarLibUtils.getDesugarLibConfiguration(project2);
        return DesugarLibUtils.getArtifactCollection(configuration);
    }

    @NotNull
    public static final Provider<String> getDesugarLibConfig(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object object = project2.getConfigurations().findByName("coreLibraryDesugaring");
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.configurations.f\u2026ORE_LIBRARY_DESUGARING)!!");
        Configuration configuration = (Configuration)object2;
        DesugarLibUtils.registerDesugarLibConfigTransform(project2);
        object2 = project2.getProviders().of(DesugarConfigJson.class, arg_0 -> DesugarLibUtils.getDesugarLibConfig$lambda-0(configuration, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.providers.of(Des\u2026orm(configuration))\n    }");
        return object2;
    }

    @NotNull
    public static final List<String> getDesugaredMethods(@NotNull Project project2, boolean coreLibraryDesugaringEnabled, @NotNull com.android.build.api.variant.AndroidVersion minSdkVersion2, @Nullable String compileSdkVersion) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)minSdkVersion2, (String)"minSdkVersion");
        List<String> list = project2.getConfigurations().findByName("coreLibraryDesugaring");
        Intrinsics.checkNotNull((Object)list);
        List<String> list2 = list;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"project.configurations.f\u2026ORE_LIBRARY_DESUGARING)!!");
        Configuration configuration = (Configuration)list2;
        if (compileSdkVersion == null || !coreLibraryDesugaringEnabled || configuration.getDependencies().isEmpty()) {
            list2 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"emptyList()");
            return list2;
        }
        int minSdk = VariantApiExtensionsKt.getFeatureLevel(minSdkVersion2);
        AndroidVersion androidVersion = AndroidTargetHash.getPlatformVersion((String)compileSdkVersion);
        Intrinsics.checkNotNull((Object)androidVersion);
        int compileSdk = androidVersion.getFeatureLevel();
        DesugarLibUtils.registerDesugarLibLintTransform(project2, minSdk, compileSdk);
        Set files = DesugarLibUtils.getDesugarLibLintFromTransform(configuration, minSdk, compileSdk).getFiles();
        boolean bl = false;
        List methods = new ArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)files, (String)"files");
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            methods.addAll(FilesKt.readLines$default((File)it, null, (int)1, null));
        }
        return methods;
    }

    private static final Configuration getDesugarLibConfiguration(Project project2) {
        Object object = project2.getConfigurations().findByName("coreLibraryDesugaring");
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.configurations.f\u2026ORE_LIBRARY_DESUGARING)!!");
        Configuration configuration = (Configuration)object2;
        if (configuration.getDependencies().isEmpty()) {
            throw new RuntimeException("coreLibraryDesugaring configuration contains no dependencies. If you intend to enable core library desugaring, please add dependencies to coreLibraryDesugaring configuration.");
        }
        return configuration;
    }

    private static final FileCollection getDesugarLibConfigFromTransform(Configuration configuration) {
        FileCollection fileCollection2 = configuration.getIncoming().artifactView(DesugarLibUtils::getDesugarLibConfigFromTransform$lambda-3).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final FileCollection getArtifactCollection(Configuration configuration) {
        FileCollection fileCollection2 = configuration.getIncoming().artifactView(DesugarLibUtils::getArtifactCollection$lambda-5).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final void registerDesugarLibConfigTransform(Project project2) {
        project2.getDependencies().registerTransform(DesugarLibConfigExtractor.class, DesugarLibUtils::registerDesugarLibConfigTransform$lambda-6);
    }

    private static final void registerDesugarLibLintTransform(Project project2, int minSdkVersion2, int compileSdkVersion) {
        project2.getDependencies().registerTransform(DesugarLibLintExtractor.class, arg_0 -> DesugarLibUtils.registerDesugarLibLintTransform$lambda-8(minSdkVersion2, compileSdkVersion, arg_0));
    }

    private static final FileCollection getDesugarLibLintFromTransform(Configuration configuration, int minSdkVersion2, int compileSdkVersion) {
        FileCollection fileCollection2 = configuration.getIncoming().artifactView(arg_0 -> DesugarLibUtils.getDesugarLibLintFromTransform$lambda-10(minSdkVersion2, compileSdkVersion, arg_0)).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final void getDesugarLibConfig$lambda-0(Configuration $configuration, ValueSourceSpec it) {
        Intrinsics.checkNotNullParameter((Object)$configuration, (String)"$configuration");
        ((DesugarConfigJson.Parameters)it.getParameters()).getDesugarJson().setFrom((Iterable)DesugarLibUtils.getDesugarLibConfigFromTransform($configuration));
    }

    private static final void getDesugarLibConfigFromTransform$lambda-3$lambda-2(AttributeContainer it) {
        it.attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)DESUGAR_LIB_CONFIG);
    }

    private static final void getDesugarLibConfigFromTransform$lambda-3(ArtifactView.ViewConfiguration configuration) {
        configuration.attributes(DesugarLibUtils::getDesugarLibConfigFromTransform$lambda-3$lambda-2);
    }

    private static final void getArtifactCollection$lambda-5$lambda-4(AttributeContainer it) {
        it.attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"jar");
    }

    private static final void getArtifactCollection$lambda-5(ArtifactView.ViewConfiguration config2) {
        config2.attributes(DesugarLibUtils::getArtifactCollection$lambda-5$lambda-4);
    }

    private static final void registerDesugarLibConfigTransform$lambda-6(TransformSpec spec) {
        spec.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"jar");
        spec.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)DESUGAR_LIB_CONFIG);
    }

    private static final void registerDesugarLibLintTransform$lambda-8$lambda-7(int $minSdkVersion, int $compileSdkVersion, DesugarLibLintExtractor.Parameters parameters) {
        parameters.getMinSdkVersion().set((Object)$minSdkVersion);
        parameters.getCompileSdkVersion().set((Object)$compileSdkVersion);
    }

    private static final void registerDesugarLibLintTransform$lambda-8(int $minSdkVersion, int $compileSdkVersion, TransformSpec spec) {
        spec.parameters(arg_0 -> DesugarLibUtils.registerDesugarLibLintTransform$lambda-8$lambda-7($minSdkVersion, $compileSdkVersion, arg_0));
        spec.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"jar");
        spec.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)DESUGAR_LIB_LINT);
        spec.getFrom().attribute(ATTR_LINT_MIN_SDK, (Object)String.valueOf($minSdkVersion));
        spec.getTo().attribute(ATTR_LINT_MIN_SDK, (Object)String.valueOf($minSdkVersion));
        spec.getFrom().attribute(ATTR_LINT_COMPILE_SDK, (Object)String.valueOf($compileSdkVersion));
        spec.getTo().attribute(ATTR_LINT_COMPILE_SDK, (Object)String.valueOf($compileSdkVersion));
    }

    private static final void getDesugarLibLintFromTransform$lambda-10$lambda-9(int $minSdkVersion, int $compileSdkVersion, AttributeContainer it) {
        it.attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)DESUGAR_LIB_LINT);
        it.attribute(ATTR_LINT_MIN_SDK, (Object)String.valueOf($minSdkVersion));
        it.attribute(ATTR_LINT_COMPILE_SDK, (Object)String.valueOf($compileSdkVersion));
    }

    private static final void getDesugarLibLintFromTransform$lambda-10(int $minSdkVersion, int $compileSdkVersion, ArtifactView.ViewConfiguration configuration) {
        configuration.attributes(arg_0 -> DesugarLibUtils.getDesugarLibLintFromTransform$lambda-10$lambda-9($minSdkVersion, $compileSdkVersion, arg_0));
    }

    static {
        Attribute attribute = Attribute.of((String)"lint-min-sdk", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"of(\"lint-min-sdk\", String::class.java)");
        ATTR_LINT_MIN_SDK = attribute;
        attribute = Attribute.of((String)"lint-compile-sdk", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"of(\"lint-compile-sdk\", String::class.java)");
        ATTR_LINT_COMPILE_SDK = attribute;
    }
}

