/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.api.variant.VariantOutputConfiguration;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.BuiltArtifactsSplitOutputMatcher;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00118G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/test/TestDataImpl;", "Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;", "namespace", "Lorg/gradle/api/provider/Provider;", "", "testConfig", "Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;", "testApkDir", "Lorg/gradle/api/file/Directory;", "testedApksDir", "Lorg/gradle/api/file/FileCollection;", "(Lorg/gradle/api/provider/Provider;Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/file/FileCollection;)V", "libraryType", "", "getLibraryType", "()Lorg/gradle/api/provider/Provider;", "supportedAbis", "", "getSupportedAbis", "()Ljava/util/Set;", "findTestedApks", "", "Ljava/io/File;", "deviceConfigProvider", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "logger", "Lcom/android/utils/ILogger;", "gradle-core"})
public final class TestDataImpl
extends AbstractTestDataImpl {
    @NotNull
    private final Provider<Boolean> libraryType;
    @NotNull
    private final Set<String> supportedAbis;

    public TestDataImpl(@NotNull Provider<String> namespace2, @NotNull AndroidTestCreationConfig testConfig, @NotNull Provider<Directory> testApkDir, @Nullable FileCollection testedApksDir) {
        Intrinsics.checkNotNullParameter(namespace2, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)testConfig, (String)"testConfig");
        Intrinsics.checkNotNullParameter(testApkDir, (String)"testApkDir");
        super(namespace2, testConfig, testConfig, testConfig.getVariantSources(), testApkDir, testedApksDir);
        Collection collection = testConfig.getOutputs().getSplitsByType(VariantOutputConfiguration.OutputType.ONE_OF_MANY);
        boolean bl = false;
        if (!collection.isEmpty()) {
            throw new RuntimeException("Multi-output in test variant not yet supported");
        }
        this.libraryType = testConfig.getServices().provider((Function0)new Function0<Boolean>(testConfig){
            final /* synthetic */ AndroidTestCreationConfig $testConfig;
            {
                this.$testConfig = $testConfig;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$testConfig.getTestedConfig().getVariantType().isAar();
            }
        });
        this.supportedAbis = testConfig.getTestedConfig().getVariantDslInfo().getSupportedAbis();
    }

    @Override
    @NotNull
    public Provider<Boolean> getLibraryType() {
        return this.libraryType;
    }

    @Input
    @NotNull
    public final Set<String> getSupportedAbis() {
        return this.supportedAbis;
    }

    @Override
    @NotNull
    public List<File> findTestedApks(@NotNull DeviceConfigProvider deviceConfigProvider, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)deviceConfigProvider, (String)"deviceConfigProvider");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        FileCollection fileCollection2 = this.getTestedApksDir();
        if (fileCollection2 == null) {
            return CollectionsKt.emptyList();
        }
        ImmutableList.Builder apks = ImmutableList.builder();
        BuiltArtifactsImpl builtArtifactsImpl = new BuiltArtifactsLoaderImpl().load(this.getTestedApksDir());
        if (builtArtifactsImpl == null) {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of()");
            return (List)immutableList;
        }
        BuiltArtifactsImpl builtArtifacts = builtArtifactsImpl;
        apks.addAll((Iterable)BuiltArtifactsSplitOutputMatcher.INSTANCE.computeBestOutput(deviceConfigProvider, builtArtifacts, (Collection<String>)this.supportedAbis));
        builtArtifactsImpl = apks.build();
        Intrinsics.checkNotNullExpressionValue((Object)builtArtifactsImpl, (String)"apks.build()");
        return (List)((Object)builtArtifactsImpl);
    }
}

