/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.AvdComponentsBuildService;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.ManagedDeviceUtilsKt;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.EmulatorSnapshots;
import com.android.build.gradle.internal.dsl.ManagedVirtualDevice;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.AndroidTestTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.TestsAnalytics;
import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.build.gradle.internal.testing.StaticTestData;
import com.android.build.gradle.internal.testing.TestData;
import com.android.build.gradle.internal.testing.utp.ManagedDeviceTestRunner;
import com.android.build.gradle.internal.testing.utp.RetentionConfig;
import com.android.build.gradle.internal.testing.utp.RetentionConfigKt;
import com.android.build.gradle.internal.testing.utp.UtpDependencies;
import com.android.build.gradle.internal.testing.utp.UtpDependencyUtilsKt;
import com.android.build.gradle.internal.testing.utp.UtpManagedDevice;
import com.android.build.gradle.internal.testing.utp.UtpTestUtilsKt;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.model.TestOptions;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@DisableCachingByDefault
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b'\u0018\u00002\u00020\u00012\u00020\u0002:\u000267B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010)\u001a\u00020*H\u0014J\b\u0010+\u001a\u00020,H'J\b\u0010-\u001a\u00020\u001aH\u0016J\b\u0010.\u001a\u00020,H'J\b\u0010/\u001a\u00020,H'J\b\u00100\u001a\u00020\u001aH\u0017J\u0010\u00101\u001a\u00020*2\u0006\u00102\u001a\u00020\u001aH\u0007J\u0010\u00103\u001a\u00020*2\u0006\u00104\u001a\u00020\u001aH\u0016J\b\u00105\u001a\u00020\u001aH\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\bR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\bR\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\bR\u0014\u0010%\u001a\u00020&8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u00068"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "Lcom/android/build/gradle/internal/tasks/AndroidTestTask;", "()V", "abi", "Lorg/gradle/api/provider/Property;", "", "getAbi", "()Lorg/gradle/api/provider/Property;", "apiLevel", "", "getApiLevel", "avdComponents", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "getAvdComponents", "avdName", "getAvdName", "buddyApks", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBuddyApks", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "dependencies", "Lorg/gradle/api/artifacts/ArtifactCollection;", "deviceName", "getDeviceName", "enableEmulatorDisplay", "", "getEnableEmulatorDisplay", "hasFailures", "installOptions", "Lorg/gradle/api/provider/ListProperty;", "getInstallOptions", "()Lorg/gradle/api/provider/ListProperty;", "shouldIgnore", "testData", "Lcom/android/build/gradle/internal/testing/TestData;", "getTestData", "testRunnerFactory", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$TestRunnerFactory;", "getTestRunnerFactory", "()Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$TestRunnerFactory;", "doTaskAction", "", "getCoverageDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getIgnoreFailures", "getReportsDir", "getResultsDir", "getTestFailed", "setDisplayEmulatorOption", "value", "setIgnoreFailures", "ignore", "testsFound", "CreationAction", "TestRunnerFactory", "gradle-core"})
public abstract class ManagedDeviceInstrumentationTestTask
extends NonIncrementalTask
implements AndroidTestTask {
    private boolean hasFailures;
    private boolean shouldIgnore;
    private ArtifactCollection dependencies;

    @Nested
    @NotNull
    public abstract TestRunnerFactory getTestRunnerFactory();

    @Nested
    @NotNull
    public abstract Property<TestData> getTestData();

    @Optional
    @Input
    @NotNull
    public abstract ListProperty<String> getInstallOptions();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getBuddyApks();

    @Input
    @NotNull
    public abstract Property<String> getDeviceName();

    @Input
    @NotNull
    public abstract Property<String> getAvdName();

    @Input
    @NotNull
    public abstract Property<Integer> getApiLevel();

    @Input
    @NotNull
    public abstract Property<String> getAbi();

    @Internal
    @NotNull
    public abstract Property<AvdComponentsBuildService> getAvdComponents();

    @Override
    @Internal
    public boolean getTestFailed() {
        return this.hasFailures;
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getEnableEmulatorDisplay();

    @Option(option="enable-display", description="Adding this option will display the emulator while testing, insteadof running the tests on a headless emulator.")
    public final void setDisplayEmulatorOption(boolean value) {
        this.getEnableEmulatorDisplay().set((Object)value);
    }

    public boolean getIgnoreFailures() {
        return this.shouldIgnore;
    }

    public void setIgnoreFailures(boolean ignore) {
        this.shouldIgnore = ignore;
    }

    @Override
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getResultsDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getReportsDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getCoverageDirectory();

    @Override
    protected void doTaskAction() {
        ArtifactCollection artifactCollection;
        boolean bl;
        Provider<Directory> emulatorProvider = ((AvdComponentsBuildService)this.getAvdComponents().get()).getEmulatorDirectory();
        Preconditions.checkArgument((boolean)emulatorProvider.isPresent(), (String)"The emulator is missing. Download the emulator in order to use managed devices.", (Object[])new Object[0]);
        Object object = this.getDeviceName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"deviceName.get()");
        String string = (String)object;
        object = this.getAvdName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"avdName.get()");
        String string2 = (String)object;
        object = this.getApiLevel().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apiLevel.get()");
        int n = ((Number)object).intValue();
        object = this.getAbi().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"abi.get()");
        String string3 = (String)object;
        object = ((Directory)((AvdComponentsBuildService)this.getAvdComponents().get()).getAvdFolder().get()).getAsFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"avdComponents.get().avdF\u2026get().asFile.absolutePath");
        Object object2 = object;
        object = this.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"path");
        Object object3 = object;
        Object object4 = ((Directory)emulatorProvider.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"emulatorProvider.get().asFile");
        File file = object4;
        object4 = SdkConstants.FN_EMULATOR;
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"FN_EMULATOR");
        object = FilesKt.resolve((File)file, (String)object4).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"emulatorProvider.get().a\u2026FN_EMULATOR).absolutePath");
        Object object5 = object;
        object = this.getEnableEmulatorDisplay().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"enableEmulatorDisplay.get()");
        UtpManagedDevice managedDevice = new UtpManagedDevice(string, string2, n, string3, (String)object2, (String)object3, (String)object5, (Boolean)object);
        DeviceProviderInstrumentTestTask.checkForNonApks(this.getBuddyApks().getFiles(), ManagedDeviceInstrumentationTestTask::doTaskAction$lambda-0);
        File resultsOutDir = ((Directory)this.getResultsDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)resultsOutDir);
        File codeCoverageOutDir = ((Directory)this.getCoverageDirectory().get()).getAsFile();
        FileUtils.cleanOutputDir((File)codeCoverageOutDir);
        if (!this.testsFound()) {
            this.getLogger().info("No tests found, nothing to do.");
            bl = true;
        } else {
            boolean runner22;
            try {
                ManagedDeviceTestRunner runner22 = this.getTestRunnerFactory().createTestRunner(this.getWorkerExecutor());
                Intrinsics.checkNotNullExpressionValue((Object)resultsOutDir, (String)"resultsOutDir");
                Intrinsics.checkNotNullExpressionValue((Object)codeCoverageOutDir, (String)"codeCoverageOutDir");
                Object object6 = this.getProjectPath().get();
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"projectPath.get()");
                String string4 = (String)object6;
                object6 = ((TestData)this.getTestData().get()).getFlavorName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"testData.get().flavorName.get()");
                String string5 = (String)object6;
                StaticTestData staticTestData = ((TestData)this.getTestData().get()).getAsStaticData();
                boolean bl2 = false;
                object6 = this.getInstallOptions().getOrElse((Object)CollectionsKt.emptyList());
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"installOptions.getOrElse(listOf())");
                List list = (List)object6;
                object6 = this.getBuddyApks().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"buddyApks.files");
                runner22 = runner22.runTests(managedDevice, resultsOutDir, codeCoverageOutDir, string4, string5, staticTestData, list, (Set<? extends File>)object6, new LoggerWrapper(this.getLogger()));
            }
            catch (Exception e) {
                ArtifactCollection artifactCollection2;
                Object object7 = this.dependencies;
                if (object7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dependencies");
                    artifactCollection2 = null;
                } else {
                    artifactCollection2 = object7;
                }
                object7 = this.getTestRunnerFactory().getExecutionEnum().get();
                Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"testRunnerFactory.executionEnum.get()");
                TestOptions.Execution execution = (TestOptions.Execution)object7;
                object7 = this.getAnalyticsService().get();
                Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"analyticsService.get()");
                TestsAnalytics.recordCrashedInstrumentedTestRun(artifactCollection2, execution, false, (AnalyticsService)object7);
                throw e;
            }
            bl = runner22;
        }
        boolean success = bl;
        File reportOutDir = ((Directory)this.getReportsDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)reportOutDir);
        TestReport report = new TestReport(ReportType.SINGLE_FLAVOR, resultsOutDir, reportOutDir);
        CompositeTestResults results = report.generateReport();
        Object object8 = this.dependencies;
        if (object8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dependencies");
            artifactCollection = null;
        } else {
            artifactCollection = object8;
        }
        object8 = this.getTestRunnerFactory().getExecutionEnum().get();
        Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"testRunnerFactory.executionEnum.get()");
        TestOptions.Execution execution = (TestOptions.Execution)object8;
        int n2 = results.getTestCount();
        object8 = this.getAnalyticsService().get();
        Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"analyticsService.get()");
        TestsAnalytics.recordOkInstrumentedTestRun(artifactCollection, execution, false, n2, (AnalyticsService)object8);
        if (!success) {
            this.hasFailures = true;
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(new File(reportOutDir, "index.html"));
            String message = Intrinsics.stringPlus((String)"There were failing tests. See the report at: ", (Object)reportUrl);
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message);
                return;
            }
            throw new GradleException(message);
        }
        this.hasFailures = false;
    }

    private final boolean testsFound() {
        return !((TestData)this.getTestData().get()).getTestDirectories().getAsFileTree().isEmpty();
    }

    private static final void doTaskAction$lambda-0(String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        throw new InvalidUserDataException(message);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0007R\u0014\u0010\u001a\u001a\u00020\u001b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$TestRunnerFactory;", "", "()V", "buildToolsRevision", "Lorg/gradle/api/provider/Property;", "Lcom/android/repository/Revision;", "getBuildToolsRevision", "()Lorg/gradle/api/provider/Property;", "compileSdkVersion", "", "getCompileSdkVersion", "executionEnum", "Lcom/android/builder/model/TestOptions$Execution;", "getExecutionEnum", "retentionConfig", "Lcom/android/build/gradle/internal/testing/utp/RetentionConfig;", "getRetentionConfig", "sdkBuildService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkBuildService", "testShardsSize", "", "getTestShardsSize", "unifiedTestPlatform", "", "getUnifiedTestPlatform", "utpDependencies", "Lcom/android/build/gradle/internal/testing/utp/UtpDependencies;", "getUtpDependencies", "()Lcom/android/build/gradle/internal/testing/utp/UtpDependencies;", "createTestRunner", "Lcom/android/build/gradle/internal/testing/utp/ManagedDeviceTestRunner;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "gradle-core"})
    public static abstract class TestRunnerFactory {
        @Input
        @NotNull
        public abstract Property<Boolean> getUnifiedTestPlatform();

        @Input
        @NotNull
        public abstract Property<TestOptions.Execution> getExecutionEnum();

        @Input
        @NotNull
        public abstract Property<RetentionConfig> getRetentionConfig();

        @Input
        @NotNull
        public abstract Property<String> getCompileSdkVersion();

        @Input
        @NotNull
        public abstract Property<Revision> getBuildToolsRevision();

        @Input
        @Optional
        @NotNull
        public abstract Property<Integer> getTestShardsSize();

        @Internal
        @NotNull
        public abstract Property<SdkComponentsBuildService> getSdkBuildService();

        @Nested
        @NotNull
        public abstract UtpDependencies getUtpDependencies();

        @NotNull
        public final ManagedDeviceTestRunner createTestRunner(@NotNull WorkerExecutor workerExecutor) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
            Object object = this.getUnifiedTestPlatform().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"unifiedTestPlatform.get()");
            Preconditions.checkArgument((boolean)((Boolean)object), (String)"android.experimental.androidTest.useUnifiedTestPlatform must be enabled.", (Object[])new Object[0]);
            Object object2 = (TestOptions.Execution)this.getExecutionEnum().get();
            int n = object2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object2.ordinal()];
            switch (n) {
                case 1: 
                case 2: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            boolean useOrchestrator = bl;
            UtpDependencies utpDependencies = this.getUtpDependencies();
            SdkComponentsBuildService.VersionedSdkLoader versionedSdkLoader = ((SdkComponentsBuildService)this.getSdkBuildService().get()).sdkLoader((Provider<String>)((Provider)this.getCompileSdkVersion()), (Provider<Revision>)((Provider)this.getBuildToolsRevision()));
            object2 = this.getRetentionConfig().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"retentionConfig.get()");
            return new ManagedDeviceTestRunner(workerExecutor, utpDependencies, versionedSdkLoader, (RetentionConfig)object2, useOrchestrator, (Integer)this.getTestShardsSize().getOrNull(), null, null, 192, null);
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TestOptions.Execution.values().length];
                nArray[TestOptions.Execution.ANDROIDX_TEST_ORCHESTRATOR.ordinal()] = 1;
                nArray[TestOptions.Execution.ANDROID_TEST_ORCHESTRATOR.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B+\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0016\u0010\u0018\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "creationConfig", "avdComponents", "Lorg/gradle/api/provider/Provider;", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "device", "Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;", "testData", "Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;Lorg/gradle/api/provider/Provider;Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ManagedDeviceInstrumentationTestTask, VariantCreationConfig> {
        @NotNull
        private final Provider<AvdComponentsBuildService> avdComponents;
        @NotNull
        private final ManagedVirtualDevice device;
        @NotNull
        private final AbstractTestDataImpl testData;
        @NotNull
        private final String name;
        @NotNull
        private final Class<ManagedDeviceInstrumentationTestTask> type;

        public CreationAction(@NotNull VariantCreationConfig creationConfig, @NotNull Provider<AvdComponentsBuildService> avdComponents, @NotNull ManagedVirtualDevice device, @NotNull AbstractTestDataImpl testData) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter(avdComponents, (String)"avdComponents");
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            Intrinsics.checkNotNullParameter((Object)testData, (String)"testData");
            super((ComponentCreationConfig)creationConfig);
            this.avdComponents = avdComponents;
            this.device = device;
            this.testData = testData;
            this.name = VariantTaskCreationAction.computeTaskName$default(this, this.device.getName(), null, 2, null);
            this.type = ManagedDeviceInstrumentationTestTask.class;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<ManagedDeviceInstrumentationTestTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ManagedDeviceInstrumentationTestTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, handleProvider.1.INSTANCE).withName("managedDevice").on(InternalArtifactType.MANAGED_DEVICE_CODE_COVERAGE.INSTANCE);
        }

        @Override
        public void configure(@NotNull ManagedDeviceInstrumentationTestTask task) {
            VariantCreationConfig testedConfig;
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.getEnableEmulatorDisplay().convention((Object)false);
            BaseExtension baseExtension = ((VariantCreationConfig)this.creationConfig).getGlobalScope().getExtension();
            Intrinsics.checkNotNullExpressionValue((Object)baseExtension, (String)"creationConfig.globalScope.extension");
            BaseExtension extension = baseExtension;
            ProjectOptions projectOptions = ((VariantCreationConfig)this.creationConfig).getServices().getProjectOptions();
            VariantCreationConfig variantCreationConfig = testedConfig = ((VariantCreationConfig)this.creationConfig).getTestedConfig();
            String string = variantCreationConfig == null ? null : variantCreationConfig.getName();
            String variantName = string == null ? ((VariantCreationConfig)this.creationConfig).getName() : string;
            task.setDescription("Installs and runs the test for " + variantName + "  on the managed device " + this.device.getName());
            HasConfigurableValuesKt.setDisallowChanges(task.getDeviceName(), this.device.getName());
            HasConfigurableValuesKt.setDisallowChanges(task.getAvdName(), ManagedDeviceUtilsKt.computeAvdName(this.device));
            HasConfigurableValuesKt.setDisallowChanges(task.getApiLevel(), this.device.getApiLevel());
            HasConfigurableValuesKt.setDisallowChanges(task.getAbi(), this.device.getAbi());
            HasConfigurableValuesKt.setDisallowChanges(task.getAvdComponents(), this.avdComponents);
            task.setGroup("verification");
            HasConfigurableValuesKt.setDisallowChanges(task.getTestData(), this.testData);
            task.getInstallOptions().set((Iterable)extension.getAdbOptions().getInstallOptions());
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getCompileSdkVersion(), extension.getCompileSdkVersion());
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getBuildToolsRevision(), extension.getBuildToolsRevision());
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getSdkBuildService(), BuildServicesKt.getBuildService(((VariantCreationConfig)this.creationConfig).getServices().getBuildServiceRegistry(), SdkComponentsBuildService.class));
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getTestShardsSize(), projectOptions.get(IntegerOption.MANAGED_DEVICE_SHARD_POOL_SIZE));
            TestOptions.Execution executionEnum = extension.getTestOptions().getExecutionEnum();
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getExecutionEnum(), executionEnum);
            VariantCreationConfig variantCreationConfig2 = testedConfig;
            boolean useUtp = UtpTestUtilsKt.shouldEnableUtp(projectOptions, extension.getTestOptions(), variantCreationConfig2 == null ? null : variantCreationConfig2.getVariantType());
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getUnifiedTestPlatform(), useUtp);
            if (useUtp) {
                if (!projectOptions.get(BooleanOption.ANDROID_TEST_USES_UNIFIED_TEST_PLATFORM)) {
                    LoggerWrapper.getLogger(CreationAction.class).warning("Implicitly enabling Unified Test Platform because related features are specified in gradle test options. Please add -Pandroid.experimental.androidTest.useUnifiedTestPlatform=true to your gradle command to suppress this warning.", new Object[0]);
                }
                variantCreationConfig2 = task.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)variantCreationConfig2, (String)"task.project");
                UtpDependencyUtilsKt.maybeCreateUtpConfigurations((Project)variantCreationConfig2);
                UtpDependencies utpDependencies = task.getTestRunnerFactory().getUtpDependencies();
                variantCreationConfig2 = task.getProject().getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)variantCreationConfig2, (String)"task.project.configurations");
                UtpDependencyUtilsKt.resolveDependencies(utpDependencies, (ConfigurationContainer)variantCreationConfig2);
            }
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getRetentionConfig(), RetentionConfigKt.createRetentionConfig(projectOptions, (EmulatorSnapshots)extension.getTestOptions().getEmulatorSnapshots()));
            task.dependencies = VariantDependencies.getArtifactCollection$default(((VariantCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES_JAR, null, 8, null);
            String flavor = (String)this.testData.getFlavorName().get();
            CharSequence charSequence = flavor;
            boolean bl = false;
            boolean bl2 = false;
            String flavorFolder = charSequence == null || charSequence.length() == 0 ? "" : Intrinsics.stringPlus((String)"flavors/", (Object)flavor);
            String deviceFolder = Intrinsics.stringPlus((String)"managedDevice/", (Object)this.device.getName());
            String subFolder = '/' + deviceFolder + '/' + flavorFolder;
            String string2 = extension.getTestOptions().getResultsDir();
            String resultsLocation = string2 == null ? task.getProject().getBuildDir() + "/outputs/androidTest-results" : string2;
            task.getResultsDir().set(new File(Intrinsics.stringPlus((String)resultsLocation, (Object)subFolder)));
            String string3 = extension.getTestOptions().getReportDir();
            String reportsLocation = string3 == null ? task.getProject().getBuildDir() + "/reports/androidTests" : string3;
            task.getReportsDir().set(new File(Intrinsics.stringPlus((String)reportsLocation, (Object)subFolder)));
            string3 = (Configuration)task.getProject().getConfigurations().findByName("androidTestUtil");
            if (string3 != null) {
                String string4 = string3;
                boolean bl3 = false;
                boolean bl4 = false;
                String it = string4;
                boolean bl5 = false;
                Object[] objectArray = new Object[]{it};
                task.getBuddyApks().from(objectArray);
            }
        }
    }
}

