/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.bundle.AppIntegrityConfigOuterClass;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\u00020\u0001:\u0002\u0007\bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/tasks/IntegrityConfigParser;", "", "config", "Lorg/w3c/dom/Document;", "(Lorg/w3c/dom/Document;)V", "parseConfig", "Lcom/android/bundle/AppIntegrityConfigOuterClass$AppIntegrityConfig;", "Companion", "InvalidIntegrityConfigException", "gradle-core"})
public final class IntegrityConfigParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document config;
    @NotNull
    private static final Map<String, AppIntegrityConfigOuterClass.Policy.Action> POLICY_ACTION_MAP;
    @NotNull
    private static final AppIntegrityConfigOuterClass.AppIntegrityConfig DEFAULT_CONFIG;

    public IntegrityConfigParser(@NotNull Document config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        this.config = config2;
    }

    @NotNull
    public final AppIntegrityConfigOuterClass.AppIntegrityConfig parseConfig() {
        try {
            IntegrityConfigParser.Companion.validate(this.config);
        }
        catch (SAXParseException e) {
            throw new InvalidIntegrityConfigException("The IntegrityConfig xml provided is invalid.", e);
        }
        Element configElement = this.config.getDocumentElement();
        AppIntegrityConfigOuterClass.AppIntegrityConfig.Builder builder = AppIntegrityConfigOuterClass.AppIntegrityConfig.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)configElement, (String)"configElement");
        AppIntegrityConfigOuterClass.AppIntegrityConfig appIntegrityConfig = builder.setEnabled(IntegrityConfigParser.Companion.isEnabled(configElement)).setLicenseCheck(IntegrityConfigParser.Companion.parseLicenseCheckConfig(configElement)).setInstallerCheck(IntegrityConfigParser.Companion.parseInstallerCheckConfig(configElement)).setEmulatorCheck(IntegrityConfigParser.Companion.parseEmulatorCheckConfig(configElement)).build();
        Intrinsics.checkNotNullExpressionValue((Object)appIntegrityConfig, (String)"newBuilder()\n           \u2026nt))\n            .build()");
        return appIntegrityConfig;
    }

    static {
        AppIntegrityConfigOuterClass.AppIntegrityConfig appIntegrityConfig = new AppIntegrityConfigOuterClass.AppIntegrityConfig[]{TuplesKt.to((Object)"DISABLE", (Object)AppIntegrityConfigOuterClass.Policy.Action.DISABLE), TuplesKt.to((Object)"WARN", (Object)AppIntegrityConfigOuterClass.Policy.Action.WARN), TuplesKt.to((Object)"WARN_THEN_DISABLE", (Object)AppIntegrityConfigOuterClass.Policy.Action.WARN_THEN_DISABLE)};
        POLICY_ACTION_MAP = MapsKt.mapOf((Pair[])appIntegrityConfig);
        appIntegrityConfig = AppIntegrityConfigOuterClass.AppIntegrityConfig.newBuilder().setEnabled(true).setLicenseCheck(AppIntegrityConfigOuterClass.LicenseCheck.newBuilder().setEnabled(false).setPolicy(AppIntegrityConfigOuterClass.Policy.newBuilder().setAction(AppIntegrityConfigOuterClass.Policy.Action.WARN))).setInstallerCheck(AppIntegrityConfigOuterClass.InstallerCheck.newBuilder().setEnabled(true).setPolicy(AppIntegrityConfigOuterClass.Policy.newBuilder().setAction(AppIntegrityConfigOuterClass.Policy.Action.WARN))).setEmulatorCheck(AppIntegrityConfigOuterClass.EmulatorCheck.newBuilder().setEnabled(true)).build();
        Intrinsics.checkNotNullExpressionValue((Object)appIntegrityConfig, (String)"newBuilder()\n           \u2026ue))\n            .build()");
        DEFAULT_CONFIG = appIntegrityConfig;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/tasks/IntegrityConfigParser$InvalidIntegrityConfigException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "t", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "gradle-core"})
    public static final class InvalidIntegrityConfigException
    extends Exception {
        public InvalidIntegrityConfigException(@NotNull String message, @NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            super(message, t);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\f*\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/tasks/IntegrityConfigParser$Companion;", "", "()V", "DEFAULT_CONFIG", "Lcom/android/bundle/AppIntegrityConfigOuterClass$AppIntegrityConfig;", "POLICY_ACTION_MAP", "", "", "Lcom/android/bundle/AppIntegrityConfigOuterClass$Policy$Action;", "isEnabled", "", "element", "Lorg/w3c/dom/Element;", "parseEmulatorCheckConfig", "Lcom/android/bundle/AppIntegrityConfigOuterClass$EmulatorCheck$Builder;", "parent", "parseInstallerCheckConfig", "Lcom/android/bundle/AppIntegrityConfigOuterClass$InstallerCheck$Builder;", "parseLicenseCheckConfig", "Lcom/android/bundle/AppIntegrityConfigOuterClass$LicenseCheck$Builder;", "parsePolicy", "Lcom/android/bundle/AppIntegrityConfigOuterClass$Policy;", "validate", "", "document", "Lorg/w3c/dom/Document;", "getChildByTagName", "tagName", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Element getChildByTagName(Element $this$getChildByTagName, String tagName) {
            void $this$forEach$iv;
            NodeList nodeList = $this$getChildByTagName.getChildNodes();
            Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"childNodes");
            boolean $i$f$forEach = false;
            ArrayList<Node> copy$iv = new ArrayList<Node>($this$forEach$iv.getLength());
            int n = 0;
            int n2 = $this$forEach$iv.getLength();
            if (n < n2) {
                do {
                    int i$iv = n++;
                    copy$iv.add($this$forEach$iv.item(i$iv));
                } while (n < n2);
            }
            Iterable $this$forEach$iv$iv = copy$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Node it$iv = (Node)element$iv$iv;
                boolean bl = false;
                Node it = it$iv;
                boolean bl2 = false;
                if (!(it instanceof Element) || !Intrinsics.areEqual((Object)((Element)it).getTagName(), (Object)tagName)) continue;
                return (Element)it;
            }
            return null;
        }

        private final AppIntegrityConfigOuterClass.LicenseCheck.Builder parseLicenseCheckConfig(Element parent) {
            AppIntegrityConfigOuterClass.LicenseCheck.Builder builder = AppIntegrityConfigOuterClass.LicenseCheck.newBuilder((AppIntegrityConfigOuterClass.LicenseCheck)DEFAULT_CONFIG.getLicenseCheck());
            Element element = this.getChildByTagName(parent, "LicenseCheck");
            if (element != null) {
                Element element2 = element;
                boolean bl = false;
                boolean bl2 = false;
                Element licenseCheckElement = element2;
                boolean bl3 = false;
                builder.setEnabled(Companion.isEnabled(licenseCheckElement));
                AppIntegrityConfigOuterClass.Policy policy = Companion.parsePolicy(licenseCheckElement);
                if (policy != null) {
                    AppIntegrityConfigOuterClass.Policy policy2 = policy;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    AppIntegrityConfigOuterClass.Policy policy3 = policy2;
                    boolean bl6 = false;
                    builder.setPolicy(policy3);
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
            return builder;
        }

        private final AppIntegrityConfigOuterClass.InstallerCheck.Builder parseInstallerCheckConfig(Element parent) {
            AppIntegrityConfigOuterClass.InstallerCheck.Builder builder = AppIntegrityConfigOuterClass.InstallerCheck.newBuilder((AppIntegrityConfigOuterClass.InstallerCheck)DEFAULT_CONFIG.getInstallerCheck());
            Element element = this.getChildByTagName(parent, "InstallerCheck");
            if (element != null) {
                int n;
                Element element2 = element;
                boolean bl = false;
                boolean bl2 = false;
                Element installerCheckElement = element2;
                boolean bl3 = false;
                builder.setEnabled(Companion.isEnabled(installerCheckElement));
                Object object = Companion.parsePolicy(installerCheckElement);
                if (object != null) {
                    AppIntegrityConfigOuterClass.Policy policy = object;
                    boolean bl4 = false;
                    n = 0;
                    AppIntegrityConfigOuterClass.Policy policy2 = policy;
                    boolean bl5 = false;
                    builder.setPolicy(policy2);
                }
                object = installerCheckElement.getElementsByTagName("AdditionalInstallSource");
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"installerCheckElement.ge\u2026AdditionalInstallSource\")");
                Object $this$forEach$iv = object;
                boolean $i$f$forEach = false;
                ArrayList<Node> copy$iv = new ArrayList<Node>($this$forEach$iv.getLength());
                n = 0;
                int policy2 = $this$forEach$iv.getLength();
                if (n < policy2) {
                    do {
                        int i$iv = n++;
                        copy$iv.add($this$forEach$iv.item(i$iv));
                    } while (n < policy2);
                }
                Iterable $this$forEach$iv$iv = copy$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    Node it$iv = (Node)element$iv$iv;
                    boolean bl6 = false;
                    Node it = it$iv;
                    boolean bl7 = false;
                    builder.addAdditionalInstallSource(it.getTextContent());
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
            return builder;
        }

        private final AppIntegrityConfigOuterClass.EmulatorCheck.Builder parseEmulatorCheckConfig(Element parent) {
            AppIntegrityConfigOuterClass.EmulatorCheck.Builder builder = AppIntegrityConfigOuterClass.EmulatorCheck.newBuilder((AppIntegrityConfigOuterClass.EmulatorCheck)DEFAULT_CONFIG.getEmulatorCheck());
            Element element = this.getChildByTagName(parent, "EmulatorCheck");
            if (element != null) {
                Element element2 = element;
                boolean bl = false;
                boolean bl2 = false;
                Element emulatorCheckElement = element2;
                boolean bl3 = false;
                builder.setEnabled(Companion.isEnabled(emulatorCheckElement));
            }
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
            return builder;
        }

        private final AppIntegrityConfigOuterClass.Policy parsePolicy(Element parent) {
            Element element = this.getChildByTagName(parent, "Policy");
            if (element != null) {
                Element element2 = element;
                boolean bl = false;
                boolean bl2 = false;
                Element policyElement = element2;
                boolean bl3 = false;
                AppIntegrityConfigOuterClass.Policy.Action action = (AppIntegrityConfigOuterClass.Policy.Action)POLICY_ACTION_MAP.get(policyElement.getAttribute("action"));
                return AppIntegrityConfigOuterClass.Policy.newBuilder().setAction(action).build();
            }
            return null;
        }

        private final boolean isEnabled(Element element) {
            return !element.hasAttribute("enabled") || Intrinsics.areEqual((Object)element.getAttribute("enabled"), (Object)"true");
        }

        private final void validate(Document document) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(IntegrityConfigParser.class.getResource("integrity_config_schema.xsd"));
            schema.newValidator().validate(new DOMSource(document));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

