/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.BuildToolsExecutableInput;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.SdkComponentsKt;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.dsl.EmulatorSnapshots;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.AndroidTestTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.TestsAnalytics;
import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.build.gradle.internal.testing.ConnectedDeviceProvider;
import com.android.build.gradle.internal.testing.OnDeviceOrchestratorTestRunner;
import com.android.build.gradle.internal.testing.ShardedTestRunner;
import com.android.build.gradle.internal.testing.SimpleTestRunner;
import com.android.build.gradle.internal.testing.TestData;
import com.android.build.gradle.internal.testing.TestRunner;
import com.android.build.gradle.internal.testing.utp.RetentionConfig;
import com.android.build.gradle.internal.testing.utp.RetentionConfigKt;
import com.android.build.gradle.internal.testing.utp.UtpDependencies;
import com.android.build.gradle.internal.testing.utp.UtpDependencyUtilsKt;
import com.android.build.gradle.internal.testing.utp.UtpTestResultListener;
import com.android.build.gradle.internal.testing.utp.UtpTestRunner;
import com.android.build.gradle.internal.testing.utp.UtpTestUtilsKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.VariantType;
import com.android.builder.model.TestOptions;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.ide.common.workers.ExecutorServiceAdapter;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.process.ExecOperations;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkerExecutor;

@DisableCachingByDefault
public abstract class DeviceProviderInstrumentTestTask
extends NonIncrementalTask
implements AndroidTestTask {
    private static final Predicate<File> IS_APK = file -> "apk".equals(Files.getFileExtension((String)file.getName()));
    private boolean ignoreFailures;
    private boolean testFailed;
    private ArtifactCollection dependencies;
    private UtpTestResultListener utpTestResultListener;

    public void setUtpTestResultListener(UtpTestResultListener utpTestResultListener) {
        this.utpTestResultListener = utpTestResultListener;
    }

    @Internal
    public ExecutorServiceAdapter getExecutorServiceAdapter() {
        return Workers.INSTANCE.withThreads(this.getPath(), (AnalyticsService)this.getAnalyticsService().get());
    }

    @Override
    protected void doTaskAction() throws DeviceException, IOException, ExecutionException {
        boolean success;
        File additionalTestOutputDir;
        String environmentSerials = this.getTargetSerials().isEmpty() ? System.getenv("ANDROID_SERIAL") : null;
        DeviceProvider deviceProvider = this.getDeviceProviderFactory().getDeviceProvider(this.getTestRunnerFactory().getBuildTools().adbExecutable(), environmentSerials);
        if (!deviceProvider.isConfigured()) {
            this.setDidWork(false);
            return;
        }
        DeviceProviderInstrumentTestTask.checkForNonApks(this.getBuddyApks().getFiles(), message -> {
            throw new InvalidUserDataException(message);
        });
        File resultsOutDir = ((Directory)this.getResultsDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)resultsOutDir);
        if (((Boolean)this.getAdditionalTestOutputEnabled().get()).booleanValue()) {
            additionalTestOutputDir = ((Directory)this.getAdditionalTestOutputDir().get()).getAsFile();
            FileUtils.cleanOutputDir((File)additionalTestOutputDir);
        } else {
            additionalTestOutputDir = null;
        }
        File coverageOutDir = ((Directory)this.getCoverageDirectory().get()).getAsFile();
        FileUtils.cleanOutputDir((File)coverageOutDir);
        if (!this.testsFound()) {
            this.getLogger().info("No tests found, nothing to do.");
            File emptyCoverageFile = new File(coverageOutDir, "coverage.ec");
            emptyCoverageFile.createNewFile();
            success = true;
        } else {
            success = (Boolean)deviceProvider.use(() -> {
                TestRunner testRunner = this.getTestRunnerFactory().createTestRunner(this.getWorkerExecutor(), this.getExecutorServiceAdapter(), this.utpTestResultListener);
                Collection extraArgs = (Collection)this.getInstallOptions().getOrElse((Object)ImmutableList.of());
                try {
                    return testRunner.runTests((String)this.getProjectPath().get(), (String)((TestData)this.getTestData().get()).getFlavorName().get(), ((TestData)this.getTestData().get()).getAsStaticData(), this.getBuddyApks().getFiles(), this.getFilteredDevices(deviceProvider), deviceProvider.getTimeoutInMs(), extraArgs, resultsOutDir, (Boolean)this.getAdditionalTestOutputEnabled().get(), additionalTestOutputDir, coverageOutDir, new LoggerWrapper(this.getLogger()));
                }
                catch (Exception e) {
                    TestsAnalytics.recordCrashedInstrumentedTestRun(this.dependencies, (TestOptions.Execution)this.getTestRunnerFactory().getExecutionEnum().get(), (Boolean)this.getCodeCoverageEnabled().get(), (AnalyticsService)this.getAnalyticsService().get());
                    throw e;
                }
            });
        }
        File reportOutDir = (File)this.getReportsDir().getAsFile().get();
        FileUtils.cleanOutputDir((File)reportOutDir);
        TestReport report = new TestReport(ReportType.SINGLE_FLAVOR, resultsOutDir, reportOutDir);
        CompositeTestResults results = report.generateReport();
        TestsAnalytics.recordOkInstrumentedTestRun(this.dependencies, (TestOptions.Execution)this.getTestRunnerFactory().getExecutionEnum().get(), (Boolean)this.getCodeCoverageEnabled().get(), results.getTestCount(), (AnalyticsService)this.getAnalyticsService().get());
        if (!success) {
            this.testFailed = true;
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(new File(reportOutDir, "index.html"));
            String message2 = "There were failing tests. See the report at: " + reportUrl;
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message2);
                return;
            }
            throw new GradleException(message2);
        }
        this.testFailed = false;
    }

    public static void checkForNonApks(Collection<File> buddyApksFiles, Consumer<String> errorHandler2) {
        List nonApks = buddyApksFiles.stream().filter(IS_APK.negate()).collect(Collectors.toList());
        if (!nonApks.isEmpty()) {
            Collections.sort(nonApks);
            String message = String.format("Not all files in %s configuration are APKs: %s", "androidTestUtil", Joiner.on((char)' ').join(nonApks));
            errorHandler2.accept(message);
        }
    }

    private List<? extends DeviceConnector> getFilteredDevices(DeviceProvider deviceProvider) {
        if (!(deviceProvider instanceof ConnectedDeviceProvider)) {
            boolean validEnvironment;
            String environmentSerials = System.getenv("ANDROID_SERIAL");
            boolean bl = validEnvironment = environmentSerials != null && !environmentSerials.isEmpty();
            if (validEnvironment && !this.getTargetSerials().isEmpty()) {
                throw new GradleException("Cannot determine devices to target. For custom device providers either unset the ANDROID_SERIAL environment variable or do remove the --serial command line argumetnts when running this task");
            }
        }
        List allDevices = deviceProvider.getDevices();
        ArrayList targetSerials = Lists.newArrayList(this.getTargetSerials());
        if (targetSerials.isEmpty()) {
            return allDevices;
        }
        ArrayList targetDevices = Lists.newArrayList();
        for (DeviceConnector device : allDevices) {
            if (!targetSerials.contains(device.getSerialNumber())) continue;
            targetDevices.add(device);
            targetSerials.remove(device.getSerialNumber());
        }
        if (!targetSerials.isEmpty()) {
            throw new GradleException("Serials specified via command line are not present. Devices have no match for the following serials: " + ((Object)targetSerials).toString());
        }
        return targetDevices;
    }

    private List<String> getTargetSerials() {
        if (this.getTestRunnerFactory().getDeviceSerialValues().isPresent()) {
            return (List)this.getTestRunnerFactory().getDeviceSerialValues().get();
        }
        return (List)this.getTestRunnerFactory().getConnectedCheckDeviceSerials().getOrElse(Collections.emptyList());
    }

    private boolean testsFound() {
        return (Boolean)((TestData)this.getTestData().get()).hasTests((FileCollection)this.getClasses(), (FileCollection)this.getRClasses(), (FileCollection)this.getBuildConfigClasses()).get();
    }

    @OutputDirectory
    public abstract DirectoryProperty getReportsDir();

    @Override
    @OutputDirectory
    public abstract DirectoryProperty getResultsDir();

    @Optional
    @OutputDirectory
    public abstract DirectoryProperty getAdditionalTestOutputDir();

    @OutputDirectory
    public abstract DirectoryProperty getCoverageDirectory();

    @Input
    public abstract Property<Boolean> getCodeCoverageEnabled();

    @Input
    public abstract Property<Boolean> getAdditionalTestOutputEnabled();

    @Optional
    @Input
    public abstract ListProperty<String> getInstallOptions();

    @Nested
    public abstract Property<TestData> getTestData();

    @Nested
    public abstract TestRunnerFactory getTestRunnerFactory();

    @Nested
    public abstract DeviceProviderFactory getDeviceProviderFactory();

    @Classpath
    @Optional
    public abstract ConfigurableFileCollection getClasses();

    @Classpath
    @Optional
    public abstract ConfigurableFileCollection getBuildConfigClasses();

    @Classpath
    @Optional
    public abstract ConfigurableFileCollection getRClasses();

    @Option(option="serial", description="The serial of the device to test against. This will take precedence over the serials specified in the ANDROID_SERIAL environment variable. In addition, when this argument is specified the test task will fail if it cannot connect to the device. \n\nMultiple devices can be specified by specifying the command multiple times. i.e. myAndroidTestTask --serial deviceSerial1 --serial deviceSerial2")
    public void setSerialOption(List<String> serials) {
        this.getTestRunnerFactory().getDeviceSerialValues().addAll(serials);
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Override
    @Internal
    public boolean getTestFailed() {
        return this.testFailed;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getBuddyApks();

    public static class CreationAction
    extends VariantTaskCreationAction<DeviceProviderInstrumentTestTask, VariantCreationConfig> {
        private static final String CONNECTED_DEVICE_PROVIDER = "connected";
        private final String deviceProviderName;
        private final DeviceProvider deviceProvider;
        private final Type type;
        private final AbstractTestDataImpl testData;
        private final Provider<List<String>> connectedCheckTargetSerials;

        public CreationAction(VariantCreationConfig creationConfig, AbstractTestDataImpl testData) {
            this(creationConfig, testData, null);
        }

        public CreationAction(VariantCreationConfig creationConfig, AbstractTestDataImpl testData, Provider<List<String>> connectedCheckTargetSerials) {
            this(creationConfig, null, CONNECTED_DEVICE_PROVIDER, Type.INTERNAL_CONNECTED_DEVICE_PROVIDER, testData, connectedCheckTargetSerials);
        }

        public CreationAction(VariantCreationConfig creationConfig, DeviceProvider deviceProvider, AbstractTestDataImpl testData, Provider<List<String>> connectedCheckTargetSerials) {
            this(creationConfig, deviceProvider, deviceProvider.getName(), Type.CUSTOM_DEVICE_PROVIDER, testData, connectedCheckTargetSerials);
        }

        private CreationAction(VariantCreationConfig creationConfig, DeviceProvider deviceProvider, String deviceProviderName, Type type, AbstractTestDataImpl testData, Provider<List<String>> connectedCheckTargetSerials) {
            super(creationConfig);
            this.deviceProvider = deviceProvider;
            this.deviceProviderName = deviceProviderName;
            this.type = type;
            this.testData = testData;
            this.connectedCheckTargetSerials = connectedCheckTargetSerials;
        }

        @Override
        public String getName() {
            return this.computeTaskName(this.deviceProviderName);
        }

        @Override
        public Class<DeviceProviderInstrumentTestTask> getType() {
            return DeviceProviderInstrumentTestTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<DeviceProviderInstrumentTestTask> taskProvider) {
            super.handleProvider(taskProvider);
            boolean isAdditionalAndroidTestOutputEnabled = ((VariantCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT);
            if (this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER) {
                if (isAdditionalAndroidTestOutputEnabled) {
                    ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, DeviceProviderInstrumentTestTask::getAdditionalTestOutputDir).withName(this.deviceProviderName).on(InternalArtifactType.CONNECTED_ANDROID_TEST_ADDITIONAL_OUTPUT.INSTANCE);
                }
                ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, DeviceProviderInstrumentTestTask::getCoverageDirectory).withName(this.deviceProviderName).on(InternalArtifactType.CODE_COVERAGE.INSTANCE);
            } else {
                if (isAdditionalAndroidTestOutputEnabled) {
                    ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, DeviceProviderInstrumentTestTask::getAdditionalTestOutputDir).withName(this.deviceProviderName).on(InternalArtifactType.DEVICE_PROVIDER_ANDROID_TEST_ADDITIONAL_OUTPUT.INSTANCE);
                }
                ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, DeviceProviderInstrumentTestTask::getCoverageDirectory).withName(this.deviceProviderName).on(InternalArtifactType.DEVICE_PROVIDER_CODE_COVERAGE.INSTANCE);
            }
            if (((VariantCreationConfig)this.creationConfig).getVariantType().isForTesting()) {
                if (this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER) {
                    ((VariantCreationConfig)this.creationConfig).getTaskContainer().setConnectedTestTask(taskProvider);
                } else {
                    ((VariantCreationConfig)this.creationConfig).getTaskContainer().getProviderTestTaskList().add(taskProvider);
                }
            }
        }

        @Override
        public void configure(DeviceProviderInstrumentTestTask task) {
            String variantName;
            super.configure(task);
            BaseExtension extension = ((VariantCreationConfig)this.creationConfig).getGlobalScope().getExtension();
            Project project2 = task.getProject();
            ProjectOptions projectOptions = ((VariantCreationConfig)this.creationConfig).getServices().getProjectOptions();
            VariantCreationConfig testedConfig = ((VariantCreationConfig)this.creationConfig).getTestedConfig();
            VariantType variantType = testedConfig != null ? testedConfig.getVariantType() : ((VariantCreationConfig)this.creationConfig).getVariantType();
            String string = variantName = testedConfig != null ? testedConfig.getName() : ((VariantCreationConfig)this.creationConfig).getName();
            if (this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER) {
                task.setDescription("Installs and runs the tests for " + variantName + " on connected devices.");
            } else {
                task.setDescription(StringHelper.appendCapitalized((String)("Installs and runs the tests for " + variantName + " using provider: "), (String)this.deviceProviderName));
            }
            task.getAdditionalTestOutputEnabled().set((Object)projectOptions.get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT));
            task.setGroup("verification");
            task.getTestData().set((Object)this.testData);
            task.getDeviceProviderFactory().getTimeOutInMs().set((Object)extension.getAdbOptions().getTimeOutInMs());
            if (this.deviceProvider != null) {
                Preconditions.checkState((this.type != Type.INTERNAL_CONNECTED_DEVICE_PROVIDER ? 1 : 0) != 0, (Object)"If using AGP device provider, no device provider should be specified in order to make task compatible with configuration caching (DeviceProvider is not serializable currently).");
                task.getDeviceProviderFactory().deviceProvider = this.deviceProvider;
            }
            task.getInstallOptions().set(extension.getAdbOptions().getInstallOptions());
            task.getTestRunnerFactory().getShardBetweenDevices().set(projectOptions.getProvider(BooleanOption.ENABLE_TEST_SHARDING));
            task.getTestRunnerFactory().getNumShards().set(projectOptions.getProvider(IntegerOption.ANDROID_TEST_SHARD_COUNT));
            task.getTestRunnerFactory().getSdkBuildService().set(BuildServicesKt.getBuildService(((VariantCreationConfig)this.creationConfig).getServices().getBuildServiceRegistry(), SdkComponentsBuildService.class));
            SdkComponentsKt.initialize(task.getTestRunnerFactory().getBuildTools(), this.creationConfig);
            TestOptions.Execution executionEnum = extension.getTestOptions().getExecutionEnum();
            task.getTestRunnerFactory().getExecutionEnum().set((Object)executionEnum);
            if (this.connectedCheckTargetSerials != null) {
                task.getTestRunnerFactory().getConnectedCheckDeviceSerials().set(this.connectedCheckTargetSerials);
            }
            boolean useUtp = UtpTestUtilsKt.shouldEnableUtp(projectOptions, extension.getTestOptions(), variantType);
            task.getTestRunnerFactory().getUnifiedTestPlatform().set((Object)useUtp);
            if (useUtp) {
                if (!projectOptions.get(BooleanOption.ANDROID_TEST_USES_UNIFIED_TEST_PLATFORM)) {
                    LoggerWrapper.getLogger(DeviceProviderInstrumentTestTask.class).warning("Implicitly enabling Unified Test Platform because related features are specified in gradle test options. Please add -Pandroid.experimental.androidTest.useUnifiedTestPlatform=true to your gradle command to suppress this warning.", new Object[0]);
                }
                UtpDependencyUtilsKt.maybeCreateUtpConfigurations(project2);
                UtpDependencyUtilsKt.resolveDependencies(task.getTestRunnerFactory().getUtpDependencies(), task.getProject().getConfigurations());
            }
            task.getTestRunnerFactory().getUninstallIncompatibleApks().set((Object)projectOptions.get(BooleanOption.UNINSTALL_INCOMPATIBLE_APKS));
            task.getTestRunnerFactory().getRetentionConfig().set((Object)RetentionConfigKt.createRetentionConfig(projectOptions, (EmulatorSnapshots)extension.getTestOptions().getEmulatorSnapshots()));
            task.getCodeCoverageEnabled().set((Object)((VariantCreationConfig)this.creationConfig).getVariantDslInfo().isTestCoverageEnabled());
            boolean useJacocoTransformOutputs = ((VariantCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_JACOCO_TRANSFORM_INSTRUMENTATION) && ((VariantCreationConfig)this.creationConfig).getVariantDslInfo().isTestCoverageEnabled();
            task.dependencies = ((VariantCreationConfig)this.creationConfig).getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, useJacocoTransformOutputs ? AndroidArtifacts.ArtifactType.JACOCO_CLASSES_JAR : AndroidArtifacts.ArtifactType.CLASSES_JAR);
            String flavorFolder = (String)this.testData.getFlavorName().get();
            if (!flavorFolder.isEmpty()) {
                flavorFolder = "flavors/" + flavorFolder;
            }
            String providerFolder = this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER ? CONNECTED_DEVICE_PROVIDER : "device/" + this.deviceProviderName;
            String subFolder = "/" + providerFolder + "/" + flavorFolder;
            String rootLocation = extension.getTestOptions().getResultsDir();
            if (rootLocation == null) {
                rootLocation = project2.getBuildDir() + "/" + "outputs" + "/" + "androidTest-results";
            }
            task.getResultsDir().set(new File(rootLocation + subFolder));
            rootLocation = extension.getTestOptions().getReportDir();
            if (rootLocation == null) {
                rootLocation = project2.getBuildDir() + "/" + "reports" + "/" + "androidTests";
            }
            task.getReportsDir().set(project2.file((Object)(rootLocation + subFolder)));
            Configuration androidTestUtil = (Configuration)project2.getConfigurations().findByName("androidTestUtil");
            if (androidTestUtil != null) {
                task.getBuddyApks().from(new Object[]{androidTestUtil});
            }
            task.getOutputs().upToDateWhen(it -> false);
            task.getClasses().from(new Object[]{((VariantCreationConfig)this.creationConfig).getArtifacts().getAllClasses()});
            task.getClasses().disallowChanges();
            task.getBuildConfigClasses().from(new Object[]{((ComponentImpl)this.creationConfig).getCompiledBuildConfig()});
            task.getBuildConfigClasses().disallowChanges();
            task.getRClasses().from(new Object[]{((ComponentImpl)this.creationConfig).getCompiledRClasses(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH)});
            task.getRClasses().disallowChanges();
        }

        public static enum Type {
            INTERNAL_CONNECTED_DEVICE_PROVIDER,
            CUSTOM_DEVICE_PROVIDER;

        }
    }

    public static abstract class DeviceProviderFactory {
        private DeviceProvider deviceProvider;

        @Input
        public abstract Property<Integer> getTimeOutInMs();

        public DeviceProvider getDeviceProvider(Provider<RegularFile> adbExecutableProvider, String environmentSerials) {
            if (this.deviceProvider != null) {
                return this.deviceProvider;
            }
            return new ConnectedDeviceProvider(adbExecutableProvider, (int)((Integer)this.getTimeOutInMs().get()), (ILogger)LoggerWrapper.getLogger(DeviceProviderInstrumentTestTask.class), environmentSerials);
        }
    }

    public static abstract class TestRunnerFactory {
        @Input
        public abstract Property<Boolean> getUnifiedTestPlatform();

        @Input
        public abstract Property<Boolean> getShardBetweenDevices();

        @Input
        @Optional
        public abstract Property<Integer> getNumShards();

        @Input
        public abstract Property<Boolean> getUninstallIncompatibleApks();

        @Input
        public abstract Property<TestOptions.Execution> getExecutionEnum();

        @Input
        public abstract Property<RetentionConfig> getRetentionConfig();

        @Internal
        public abstract Property<SdkComponentsBuildService> getSdkBuildService();

        @Nested
        public abstract UtpDependencies getUtpDependencies();

        @Input
        public abstract ListProperty<String> getConnectedCheckDeviceSerials();

        @Input
        public abstract ListProperty<String> getDeviceSerialValues();

        @Inject
        public ExecOperations getExecOperations() {
            throw new UnsupportedOperationException("Injected by Gradle.");
        }

        @Nested
        public abstract BuildToolsExecutableInput getBuildTools();

        TestRunner createTestRunner(WorkerExecutor workerExecutor, ExecutorServiceAdapter executorServiceAdapter, UtpTestResultListener utpTestResultListener) {
            GradleProcessExecutor gradleProcessExecutor = new GradleProcessExecutor(arg_0 -> ((ExecOperations)this.getExecOperations()).exec(arg_0));
            if (((Boolean)this.getUnifiedTestPlatform().get()).booleanValue()) {
                boolean useOrchestrator = this.getExecutionEnum().get() == TestOptions.Execution.ANDROID_TEST_ORCHESTRATOR || this.getExecutionEnum().get() == TestOptions.Execution.ANDROIDX_TEST_ORCHESTRATOR;
                return new UtpTestRunner((File)this.getBuildTools().splitSelectExecutable().getOrNull(), gradleProcessExecutor, workerExecutor, executorServiceAdapter, this.getUtpDependencies(), ((SdkComponentsBuildService)this.getSdkBuildService().get()).sdkLoader((Provider<String>)this.getBuildTools().getCompileSdkVersion(), (Provider<Revision>)this.getBuildTools().getBuildToolsRevision()), (RetentionConfig)this.getRetentionConfig().get(), useOrchestrator, (Boolean)this.getUninstallIncompatibleApks().get(), utpTestResultListener);
            }
            switch ((TestOptions.Execution)this.getExecutionEnum().get()) {
                case ANDROID_TEST_ORCHESTRATOR: 
                case ANDROIDX_TEST_ORCHESTRATOR: {
                    Preconditions.checkArgument(((Boolean)this.getShardBetweenDevices().get() == false ? 1 : 0) != 0, (Object)"Sharding is not supported with Android Test Orchestrator.");
                    return new OnDeviceOrchestratorTestRunner((File)this.getBuildTools().splitSelectExecutable().getOrNull(), gradleProcessExecutor, (TestOptions.Execution)this.getExecutionEnum().get(), executorServiceAdapter);
                }
                case HOST: {
                    if (((Boolean)this.getShardBetweenDevices().get()).booleanValue()) {
                        return new ShardedTestRunner((File)this.getBuildTools().splitSelectExecutable().getOrNull(), gradleProcessExecutor, (Integer)this.getNumShards().getOrNull(), executorServiceAdapter);
                    }
                    return new SimpleTestRunner((File)this.getBuildTools().splitSelectExecutable().getOrNull(), gradleProcessExecutor, executorServiceAdapter);
                }
            }
            throw new AssertionError((Object)("Unknown value " + this.getExecutionEnum().get()));
        }
    }
}

