/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
public abstract class CheckProguardFiles
extends NonIncrementalTask {
    @Override
    protected void doTaskAction() {
        HashMap<File, ProguardFiles.ProguardFile> oldFiles = new HashMap<File, ProguardFiles.ProguardFile>();
        oldFiles.put(ProguardFiles.getDefaultProguardFile(ProguardFiles.ProguardFile.OPTIMIZE.fileName, this.getBuildDirectory()).getAbsoluteFile(), ProguardFiles.ProguardFile.OPTIMIZE);
        oldFiles.put(ProguardFiles.getDefaultProguardFile(ProguardFiles.ProguardFile.DONT_OPTIMIZE.fileName, this.getBuildDirectory()).getAbsoluteFile(), ProguardFiles.ProguardFile.DONT_OPTIMIZE);
        for (RegularFile regularFile : (List)this.getProguardFiles().get()) {
            File file = regularFile.getAsFile();
            if (!oldFiles.containsKey(file.getAbsoluteFile())) continue;
            String name = ((ProguardFiles.ProguardFile)((Object)oldFiles.get((Object)file.getAbsoluteFile()))).fileName;
            throw new InvalidUserDataException(name + " should not be used together with the new postprocessing DSL. The new DSL includes sensible settings by default, you can override this using `postprocessing { proguardFiles = []}`");
        }
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public abstract ListProperty<RegularFile> getProguardFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public abstract DirectoryProperty getExtractedProguardFile();

    @Internal(value="only for task execution")
    public abstract DirectoryProperty getBuildDirectory();

    public static class CreationAction
    extends VariantTaskCreationAction<CheckProguardFiles, VariantCreationConfig> {
        public CreationAction(VariantCreationConfig creationConfig) {
            super(creationConfig);
        }

        @Override
        public String getName() {
            return this.computeTaskName("check", "ProguardFiles");
        }

        @Override
        public Class<CheckProguardFiles> getType() {
            return CheckProguardFiles.class;
        }

        @Override
        public void configure(CheckProguardFiles task) {
            super.configure(task);
            task.getProguardFiles().set(((VariantCreationConfig)this.creationConfig).getProguardFiles());
            task.getExtractedProguardFile().set(((VariantCreationConfig)this.creationConfig).getGlobalScope().getGlobalArtifacts().get(InternalArtifactType.DEFAULT_PROGUARD_FILES.INSTANCE));
            task.getProguardFiles().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getBuildDirectory(), task.getProject().getLayout().getBuildDirectory());
        }
    }
}

