/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.plugins;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.dsl.AssetPackBundleExtension;
import com.android.build.api.dsl.SigningConfig;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.errors.DeprecationReporterImpl;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.errors.SyncIssueReporterImpl;
import com.android.build.gradle.internal.lint.LintFromMaven;
import com.android.build.gradle.internal.plugins.AssetPackBundlePluginKt;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.NoOpAnalyticsService;
import com.android.build.gradle.internal.res.Aapt2FromMaven;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.services.Aapt2DaemonBuildService;
import com.android.build.gradle.internal.services.Aapt2ThreadPoolBuildService;
import com.android.build.gradle.internal.services.AndroidLocationsBuildService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.DslServicesImpl;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.tasks.AppMetadataTask;
import com.android.build.gradle.internal.tasks.AssetPackPreBundleTask;
import com.android.build.gradle.internal.tasks.AssetPackUtilKt;
import com.android.build.gradle.internal.tasks.FinalizeBundleTask;
import com.android.build.gradle.internal.tasks.LinkManifestForAssetPackTask;
import com.android.build.gradle.internal.tasks.PackageBundleTask;
import com.android.build.gradle.internal.tasks.ProcessAssetPackManifestTask;
import com.android.build.gradle.internal.tasks.ValidateSigningTask;
import com.android.build.gradle.internal.tasks.factory.TaskConfigAction;
import com.android.build.gradle.internal.tasks.factory.TaskFactory;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryImpl;
import com.android.build.gradle.options.ProjectOptionService;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.errors.IssueReporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J \u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/plugins/AssetPackBundlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "createTasks", "projectServices", "Lcom/android/build/gradle/internal/services/ProjectServices;", "extension", "Lcom/android/build/api/dsl/AssetPackBundleExtension;", "registerServices", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "validateInput", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "gradle-core"})
public final class AssetPackBundlePlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ProjectOptions projectOptions = ((ProjectOptionService)new ProjectOptionService.RegistrationAction(project2).execute().get()).getProjectOptions();
        Enum enum_ = SyncOptions.getModelQueryMode(projectOptions);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"getModelQueryMode(projectOptions)");
        SyncOptions.EvaluationMode evaluationMode = enum_;
        enum_ = SyncOptions.getErrorFormatMode(projectOptions);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"getErrorFormatMode(projectOptions)");
        Enum enum_2 = enum_;
        enum_ = project2.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"project.logger");
        SyncIssueReporterImpl syncIssueHandler = new SyncIssueReporterImpl(evaluationMode, (SyncOptions.ErrorFormatMode)enum_2, (Logger)enum_);
        IssueReporter issueReporter2 = syncIssueHandler;
        String string = project2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
        DeprecationReporterImpl deprecationReporter = new DeprecationReporterImpl(issueReporter2, projectOptions, string);
        SyncIssueReporter syncIssueReporter = syncIssueHandler;
        DeprecationReporter deprecationReporter2 = deprecationReporter;
        ObjectFactory objectFactory = project2.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        ObjectFactory objectFactory2 = objectFactory;
        objectFactory = project2.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.logger");
        ObjectFactory objectFactory3 = objectFactory;
        objectFactory = project2.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.providers");
        ObjectFactory objectFactory4 = objectFactory;
        objectFactory = project2.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.layout");
        ObjectFactory objectFactory5 = objectFactory;
        objectFactory = project2.getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.gradle.sharedServices");
        ProjectServices projectServices2 = new ProjectServices(syncIssueReporter, deprecationReporter2, objectFactory2, (Logger)objectFactory3, (ProviderFactory)objectFactory4, (ProjectLayout)objectFactory5, projectOptions, (BuildServiceRegistry)objectFactory, LintFromMaven.Companion.from(project2, projectOptions, syncIssueHandler), Aapt2FromMaven.Companion.create(project2, projectOptions), project2.getGradle().getStartParameter().getMaxWorkerCount(), new ProjectInfo(project2), (Function1<Object, ? extends File>)((Function1)new Function1<Object, File>((Object)project2){

            public final File invoke(Object p0) {
                return ((Project)this.receiver).file(p0);
            }
        }));
        this.registerServices(project2, projectOptions);
        Provider provider = projectServices2.getProviderFactory().provider(AssetPackBundlePlugin::apply$lambda-0);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"projectServices.providerFactory.provider { null }");
        DslServicesImpl dslServices = new DslServicesImpl(projectServices2, (Provider<SdkComponentsBuildService>)provider);
        Object[] objectArray = new Object[]{dslServices};
        AssetPackBundleExtension extension = dslServices.newDecoratedInstance(AssetPackBundleExtension.class, objectArray);
        project2.getExtensions().add(AssetPackBundleExtension.class, "bundle", (Object)extension);
        project2.afterEvaluate(arg_0 -> AssetPackBundlePlugin.apply$lambda-1(this, projectServices2, extension, project2, arg_0));
    }

    private final void registerServices(Project project2, ProjectOptions projectOptions) {
        if (projectOptions.isAnalyticsEnabled()) {
            new AnalyticsService.RegistrationAction(project2).execute();
        } else {
            project2.getGradle().getSharedServices().registerIfAbsent(BuildServicesKt.getBuildServiceName(AnalyticsService.class), NoOpAnalyticsService.class, AssetPackBundlePlugin::registerServices$lambda-2);
        }
        new Aapt2ThreadPoolBuildService.RegistrationAction(project2, projectOptions).execute();
        new Aapt2DaemonBuildService.RegistrationAction(project2, projectOptions).execute();
        Enum enum_ = SyncOptions.getModelQueryMode(projectOptions);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"getModelQueryMode(projectOptions)");
        SyncOptions.EvaluationMode evaluationMode = enum_;
        enum_ = SyncOptions.getErrorFormatMode(projectOptions);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"getErrorFormatMode(projectOptions)");
        new SyncIssueReporterImpl.GlobalSyncIssueService.RegistrationAction(project2, evaluationMode, (SyncOptions.ErrorFormatMode)enum_).execute();
        new AndroidLocationsBuildService.RegistrationAction(project2).execute();
        new SdkComponentsBuildService.RegistrationAction(project2, projectOptions).execute();
    }

    private final void validateInput(IssueReporter issueReporter2, AssetPackBundleExtension extension) {
        SigningConfig signingConfig2;
        boolean bl = false;
        ArrayList<String> errors = new ArrayList<String>();
        CharSequence charSequence = extension.getApplicationId();
        boolean bl2 = false;
        if (charSequence.length() == 0) {
            errors.add("'applicationId' must be specified for asset pack bundle.");
        }
        charSequence = extension.getVersionTag();
        bl2 = false;
        if (charSequence.length() == 0) {
            errors.add("'versionTag' must be specified for asset pack bundle.");
        }
        if (extension.getVersionCodes().isEmpty()) {
            errors.add("Asset pack bundle must target at least one version code.");
        }
        if (extension.getAssetPacks().isEmpty()) {
            errors.add("Asset pack bundle must contain at least one asset pack.");
        }
        if (AssetPackBundlePluginKt.access$isPresent(signingConfig2 = extension.getSigningConfig()) && (signingConfig2.getStoreFile() == null || signingConfig2.getStorePassword() == null || signingConfig2.getKeyAlias() == null || signingConfig2.getKeyPassword() == null)) {
            errors.add("Signing config is specified but incomplete. To make it complete 'storeFile', 'storePassword', 'keyAlias', 'keyPassword' must be specified.");
        }
        Collection collection = errors;
        boolean bl3 = false;
        if (!collection.isEmpty()) {
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (List)errors, (int)4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createTasks(Project project2, ProjectServices projectServices2, AssetPackBundleExtension extension) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Configuration assetPackFilesConfiguration = (Configuration)project2.getConfigurations().maybeCreate("assetPackFiles");
        Configuration assetPackManifestConfiguration = (Configuration)project2.getConfigurations().maybeCreate("assetPackManifest");
        IssueReporter issueReporter2 = projectServices2.getIssueReporter();
        Set set = extension.getAssetPacks();
        Intrinsics.checkNotNullExpressionValue((Object)assetPackFilesConfiguration, (String)"assetPackFilesConfiguration");
        Intrinsics.checkNotNullExpressionValue((Object)assetPackManifestConfiguration, (String)"assetPackManifestConfiguration");
        AssetPackUtilKt.populateAssetPacksConfigurations(project2, issueReporter2, set, assetPackFilesConfiguration, assetPackManifestConfiguration);
        TaskContainer taskContainer = project2.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskFactoryImpl tasks = new TaskFactoryImpl(taskContainer);
        ArtifactsImpl artifacts = new ArtifactsImpl(project2, "global");
        tasks.register(new AppMetadataTask.CreationForAssetPackBundleAction(artifacts, projectServices2.getProjectOptions()));
        Iterable iterable = extension.getAssetPacks();
        FileCollection fileCollection2 = (FileCollection)assetPackManifestConfiguration;
        String string = extension.getApplicationId();
        ArtifactsImpl artifactsImpl = artifacts;
        TaskFactoryImpl taskFactoryImpl = tasks;
        boolean $i$f$map = false;
        void var10_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = StringsKt.replace$default((String)it, (char)':', (char)File.separatorChar, (boolean)false, (int)4, null);
            collection.add(string3);
        }
        collection = (List)destination$iv$iv;
        Set set2 = CollectionsKt.toSet((Iterable)collection);
        FileCollection fileCollection3 = fileCollection2;
        String string4 = string;
        ArtifactsImpl artifactsImpl2 = artifactsImpl;
        taskFactoryImpl.register(new ProcessAssetPackManifestTask.CreationForAssetPackBundleAction(artifactsImpl2, string4, fileCollection3, set2));
        tasks.register(new LinkManifestForAssetPackTask.CreationForAssetPackBundleAction(artifacts, projectServices2, extension.getCompileSdk()));
        tasks.register(new AssetPackPreBundleTask.CreationForAssetPackBundleAction(artifacts, (FileCollection)assetPackFilesConfiguration));
        tasks.register(new PackageBundleTask.CreationForAssetPackBundleAction(projectServices2, artifacts, extension));
        if (AssetPackBundlePluginKt.access$isPresent(extension.getSigningConfig())) {
            tasks.register(new ValidateSigningTask.CreationForAssetPackBundleAction(artifacts, extension.getSigningConfig()));
        }
        tasks.register(new FinalizeBundleTask.CreationForAssetPackBundleAction(projectServices2, artifacts, extension.getSigningConfig(), AssetPackBundlePluginKt.access$isPresent(extension.getSigningConfig())));
        TaskFactory.DefaultImpls.register$default((TaskFactory)tasks, "bundle", null, (TaskConfigAction)new TaskConfigAction<Task>(artifacts){
            final /* synthetic */ ArtifactsImpl $artifacts;
            {
                this.$artifacts = $artifacts;
            }

            public void configure(@NotNull Task task) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                task.setDescription("Assembles asset pack bundle for asset only updates");
                Object[] objectArray = new Object[]{this.$artifacts.get((SingleArtifact)SingleArtifact.BUNDLE.INSTANCE)};
                task.dependsOn(objectArray);
            }
        }, null, 8, null);
    }

    private static final SdkComponentsBuildService apply$lambda-0() {
        return null;
    }

    private static final void apply$lambda-1(AssetPackBundlePlugin this$0, ProjectServices $projectServices, AssetPackBundleExtension $extension, Project $project, Project it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$projectServices, (String)"$projectServices");
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        this$0.validateInput($projectServices.getIssueReporter(), $extension);
        this$0.createTasks($project, $projectServices, $extension);
    }

    private static final void registerServices$lambda-2(BuildServiceSpec it) {
    }
}

