/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.NdkAbiFile;
import com.android.build.gradle.internal.cxx.configure.NdkAbiFileKt;
import com.android.build.gradle.internal.cxx.configure.PlatformConfigurator;
import com.android.build.gradle.internal.ndk.AbiInfo;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserDataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00112\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0010\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\tH\u0002J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\tH\u0016J\u0018\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020 2\u0006\u0010$\u001a\u00020\tH\u0016J\u0010\u0010.\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\tH\u0016J\u0010\u0010/\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0014J\u0010\u00100\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\tH\u0002J\u0010\u00101\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\tH\u0002J\n\u00102\u001a\u0004\u0018\u00010\u0011H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fRN\u0010\u000f\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00110\u0011 \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00118DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\"\u0010\u001b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\fR\"\u0010\u001d\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\fR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\f\u00a8\u00063"}, d2={"Lcom/android/build/gradle/internal/ndk/DefaultNdkInfo;", "Lcom/android/build/gradle/internal/ndk/NdkInfo;", "rootDirectory", "Ljava/io/File;", "(Ljava/io/File;)V", "abiInfoList", "", "Lcom/android/build/gradle/internal/ndk/AbiInfo;", "default32BitsAbis", "Lcom/android/build/gradle/internal/core/Abi;", "kotlin.jvm.PlatformType", "getDefault32BitsAbis", "()Ljava/util/List;", "defaultAbis", "getDefaultAbis", "defaultToolchainVersions", "Ljava/util/HashMap;", "", "hostTag", "getHostTag", "()Ljava/lang/String;", "hostTag$delegate", "Lkotlin/Lazy;", "platformConfigurator", "Lcom/android/build/gradle/internal/cxx/configure/PlatformConfigurator;", "getRootDirectory", "()Ljava/io/File;", "supported32BitsAbis", "getSupported32BitsAbis", "supportedAbis", "getSupportedAbis", "supportedStls", "Lcom/android/build/gradle/internal/ndk/Stl;", "getSupportedStls", "findSuitablePlatformVersion", "", "abi", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "getDefaultStl", "buildSystem", "Lcom/android/build/gradle/tasks/NativeBuildSystem;", "getDefaultToolchainVersion", "getObjcopyExecutable", "getStlSharedObjectFile", "stl", "getStripExecutable", "getToolchainAbi", "getToolchainPath", "getToolchainPrefix", "validate", "gradle-core"})
public class DefaultNdkInfo
implements NdkInfo {
    @NotNull
    private final File rootDirectory;
    @NotNull
    private final PlatformConfigurator platformConfigurator;
    @NotNull
    private final List<AbiInfo> abiInfoList;
    private final HashMap<Abi, String> defaultToolchainVersions;
    @NotNull
    private final Lazy hostTag$delegate;
    @NotNull
    private final List<Stl> supportedStls;

    public DefaultNdkInfo(@NotNull File rootDirectory) {
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        this.rootDirectory = rootDirectory;
        this.platformConfigurator = new PlatformConfigurator(this.rootDirectory);
        this.abiInfoList = new NdkAbiFile(NdkAbiFileKt.ndkMetaAbisFile(this.rootDirectory)).getAbiInfoList();
        this.defaultToolchainVersions = Maps.newHashMap();
        this.hostTag$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DefaultNdkInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                Object v1;
                List checkDirs;
                block4: {
                    String it;
                    void $this$mapTo$iv$iv;
                    String string = System.getProperty("os.name");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
                    Locale locale = Locale.ENGLISH;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                    boolean bl = false;
                    String string2 = string;
                    boolean bl2 = false;
                    String string3 = string2.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
                    String osName = string3;
                    String osType = StringsKt.contains$default((CharSequence)osName, (CharSequence)"windows", (boolean)false, (int)2, null) ? "windows" : (StringsKt.contains$default((CharSequence)osName, (CharSequence)"mac", (boolean)false, (int)2, null) ? "darwin" : "linux");
                    Object[] objectArray = new String[]{Intrinsics.stringPlus((String)osType, (Object)"-x86_64")};
                    List checkTags = CollectionsKt.mutableListOf((Object[])objectArray);
                    if (Intrinsics.areEqual((Object)osType, (Object)"windows")) {
                        checkTags.add("windows");
                    }
                    File prebuiltBase = FilesKt.resolve((File)this.this$0.getRootDirectory(), (String)"prebuilt");
                    Iterable $this$map$iv = checkTags;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        String string4 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        File file = FilesKt.resolve((File)prebuiltBase, (String)it);
                        collection.add(file);
                    }
                    checkDirs = (List)destination$iv$iv;
                    Iterable iterable2 = checkTags;
                    boolean bl4 = false;
                    Iterable iterable3 = iterable2;
                    boolean bl5 = false;
                    for (T t : iterable3) {
                        it = (String)t;
                        boolean bl6 = false;
                        if (!FilesKt.resolve((File)prebuiltBase, (String)it).isDirectory()) continue;
                        v1 = t;
                        break block4;
                    }
                    v1 = null;
                }
                String string = v1;
                if (string == null) {
                    throw new InvalidUserDataException(Intrinsics.stringPlus((String)"Could not determine NDK host architecture. None of the following directories exist: ", (Object)CollectionsKt.joinToString$default((Iterable)checkDirs, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
                }
                return string;
            }
        }));
        this.supportedStls = ArraysKt.toList((Object[])Stl.values());
    }

    @NotNull
    protected final File getRootDirectory() {
        return this.rootDirectory;
    }

    @Override
    public int findSuitablePlatformVersion(@NotNull String abi, @Nullable AndroidVersion androidVersion) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        return this.platformConfigurator.findSuitablePlatformVersion(abi, androidVersion);
    }

    private final String getToolchainPrefix(Abi abi) {
        String string = abi.getGccToolchainPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"abi.gccToolchainPrefix");
        return string;
    }

    @NotNull
    protected final String getHostTag() {
        Lazy lazy = this.hostTag$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final File getToolchainPath(Abi abi) {
        Abi toolchainAbi = this.getToolchainAbi(abi);
        String string = this.getDefaultToolchainVersion(toolchainAbi);
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        String version = charSequence.length() == 0 ? "" : Intrinsics.stringPlus((String)"-", (Object)it);
        File prebuiltFolder = FilesKt.resolve((File)this.rootDirectory, (String)("toolchains/" + this.getToolchainPrefix(toolchainAbi) + version + "/prebuilt/" + this.getHostTag()));
        if (!prebuiltFolder.isDirectory()) {
            throw new InvalidUserDataException(Intrinsics.stringPlus((String)"Toolchain directory does not exist: ", (Object)prebuiltFolder));
        }
        return prebuiltFolder;
    }

    @NotNull
    protected Abi getToolchainAbi(@NotNull Abi abi) {
        Intrinsics.checkNotNullParameter((Object)((Object)abi), (String)"abi");
        return abi;
    }

    @Override
    @NotNull
    public File getStripExecutable(@NotNull Abi abi) {
        Intrinsics.checkNotNullParameter((Object)((Object)abi), (String)"abi");
        Abi toolchainAbi = this.getToolchainAbi(abi);
        String[] stringArray = new String[]{"bin", Intrinsics.stringPlus((String)toolchainAbi.getGccExecutablePrefix(), (Object)"-strip")};
        File file = FileUtils.join((File)this.getToolchainPath(toolchainAbi), (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"join(\n            getToo\u2026efix + \"-strip\"\n        )");
        return file;
    }

    @Override
    @NotNull
    public File getObjcopyExecutable(@NotNull Abi abi) {
        Intrinsics.checkNotNullParameter((Object)((Object)abi), (String)"abi");
        Abi toolchainAbi = this.getToolchainAbi(abi);
        String[] stringArray = new String[]{"bin", Intrinsics.stringPlus((String)toolchainAbi.getGccExecutablePrefix(), (Object)"-objcopy")};
        File file = FileUtils.join((File)this.getToolchainPath(toolchainAbi), (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"join(\n            getToo\u2026ix + \"-objcopy\"\n        )");
        return file;
    }

    private final String getDefaultToolchainVersion(Abi abi) {
        File[] toolchainsForAbi;
        String toolchainPrefix;
        Abi toolchainAbi;
        block9: {
            block8: {
                toolchainAbi = this.getToolchainAbi(abi);
                String defaultVersion = this.defaultToolchainVersions.get((Object)toolchainAbi);
                if (defaultVersion != null) {
                    return defaultVersion;
                }
                File toolchains = new File(this.rootDirectory, "toolchains");
                toolchainPrefix = this.getToolchainPrefix(toolchainAbi);
                toolchainsForAbi = toolchains.listFiles((arg_0, arg_1) -> DefaultNdkInfo.getDefaultToolchainVersion$lambda-1(toolchainPrefix, arg_0, arg_1));
                if (toolchainsForAbi == null) break block8;
                File[] fileArray = toolchainsForAbi;
                boolean bl = false;
                if (!(fileArray.length == 0)) break block9;
            }
            throw new RuntimeException(Intrinsics.stringPlus((String)"No toolchains found in the NDK toolchains folder for ABI with prefix: ", (Object)toolchainPrefix));
        }
        Revision bestRevision = null;
        String bestVersionString = "";
        Object object = toolchainsForAbi;
        int n = 0;
        int n2 = ((File[])object).length;
        while (n < n2) {
            File toolchainFolder = object[n];
            ++n;
            String folderName = toolchainFolder.getName();
            Object revision = new Revision(0);
            String versionString = "";
            if (folderName.length() > toolchainPrefix.length() + 1) {
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)folderName, (String)"folderName");
                    String string = folderName;
                    int n3 = toolchainPrefix.length() + 1;
                    boolean bl = false;
                    String string2 = string.substring(n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    versionString = string2;
                    string = Revision.parseRevision((String)versionString);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parseRevision(versionString)");
                    revision = string;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (bestRevision != null && revision.compareTo(bestRevision) <= 0) continue;
            bestRevision = revision;
            bestVersionString = versionString;
        }
        object = this.defaultToolchainVersions;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"defaultToolchainVersions");
        object = (Map)object;
        n = 0;
        object.put(toolchainAbi, bestVersionString);
        return bestVersionString;
    }

    @NotNull
    public List<Abi> getDefault32BitsAbis() {
        Stream<Abi> stream2 = this.abiInfoList.stream().filter(DefaultNdkInfo::_get_default32BitsAbis_$lambda-2).map(DefaultNdkInfo::_get_default32BitsAbis_$lambda-3).filter(DefaultNdkInfo::_get_default32BitsAbis_$lambda-4);
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"abiInfoList\n            \u2026> !abi.supports64Bits() }");
        return StreamsKt.toList(stream2);
    }

    @NotNull
    public List<Abi> getDefaultAbis() {
        Stream<Abi> stream2 = this.abiInfoList.stream().filter(DefaultNdkInfo::_get_defaultAbis_$lambda-5).map(DefaultNdkInfo::_get_defaultAbis_$lambda-6);
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"abiInfoList\n            \u2026      .map<Abi>{ it.abi }");
        return StreamsKt.toList(stream2);
    }

    @NotNull
    public List<Abi> getSupported32BitsAbis() {
        Stream<Abi> stream2 = this.abiInfoList.stream().map(DefaultNdkInfo::_get_supported32BitsAbis_$lambda-7).filter(DefaultNdkInfo::_get_supported32BitsAbis_$lambda-8);
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"abiInfoList\n            \u2026> !abi.supports64Bits() }");
        return StreamsKt.toList(stream2);
    }

    @NotNull
    public List<Abi> getSupportedAbis() {
        Stream<Abi> stream2 = this.abiInfoList.stream().map(DefaultNdkInfo::_get_supportedAbis_$lambda-9);
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"abiInfoList\n            \u2026           .map{ it.abi }");
        return StreamsKt.toList(stream2);
    }

    @NotNull
    public List<Stl> getSupportedStls() {
        return this.supportedStls;
    }

    @Override
    @NotNull
    public Stl getDefaultStl(@NotNull NativeBuildSystem buildSystem2) {
        Stl stl2;
        Intrinsics.checkNotNullParameter((Object)((Object)buildSystem2), (String)"buildSystem");
        NativeBuildSystem nativeBuildSystem = buildSystem2;
        int n = WhenMappings.$EnumSwitchMapping$0[nativeBuildSystem.ordinal()];
        switch (n) {
            case 1: {
                stl2 = Stl.GNUSTL_STATIC;
                break;
            }
            case 2: {
                stl2 = Stl.SYSTEM;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return stl2;
    }

    @Override
    @NotNull
    public File getStlSharedObjectFile(@NotNull Stl stl2, @NotNull Abi abi) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)stl2), (String)"stl");
        Intrinsics.checkNotNullParameter((Object)((Object)abi), (String)"abi");
        Stl stl3 = stl2;
        int n = WhenMappings.$EnumSwitchMapping$1[stl3.ordinal()];
        switch (n) {
            case 1: {
                string = "sources/cxx-stl/llvm-libc++";
                break;
            }
            case 2: {
                string = "sources/cxx-stl/gnu-libstdc++/4.9";
                break;
            }
            case 3: {
                string = "sources/cxx-stl/stlport";
                break;
            }
            default: {
                throw new RuntimeException(Intrinsics.stringPlus((String)"Unexpected STL for packaging: ", (Object)((Object)stl2)));
            }
        }
        File stlBasePath = FilesKt.resolve((File)this.rootDirectory, (String)string);
        File file = FilesKt.resolve((File)stlBasePath, (String)("libs/" + abi.getTag() + '/' + stl2.getLibraryName()));
        Preconditions.checkState((boolean)file.isFile(), (String)Intrinsics.stringPlus((String)"Expected NDK STL shared object file at ", (Object)file), (Object[])new Object[0]);
        return file;
    }

    @Override
    @Nullable
    public String validate() {
        File platformsDir = FilesKt.resolve((File)this.rootDirectory, (String)"platforms");
        if (!platformsDir.isDirectory()) {
            return platformsDir + " is not a directory.";
        }
        File toolchainsDir = FilesKt.resolve((File)this.rootDirectory, (String)"toolchains");
        if (!toolchainsDir.isDirectory()) {
            return toolchainsDir + " is not a directory.";
        }
        return null;
    }

    @Override
    @NotNull
    public Map<Abi, File> getStlSharedObjectFiles(@NotNull Stl stl2, @NotNull Collection<? extends Abi> abis2) {
        return NdkInfo.DefaultImpls.getStlSharedObjectFiles(this, stl2, abis2);
    }

    private static final boolean getDefaultToolchainVersion$lambda-1(String $toolchainPrefix, File $noName_0, String filename) {
        Intrinsics.checkNotNullParameter((Object)$toolchainPrefix, (String)"$toolchainPrefix");
        Intrinsics.checkNotNullExpressionValue((Object)filename, (String)"filename");
        return StringsKt.startsWith$default((String)filename, (String)$toolchainPrefix, (boolean)false, (int)2, null);
    }

    private static final boolean _get_default32BitsAbis_$lambda-2(AbiInfo abiInfo) {
        return abiInfo.isDefault() && !abiInfo.isDeprecated();
    }

    private static final Abi _get_default32BitsAbis_$lambda-3(AbiInfo it) {
        return it.getAbi();
    }

    private static final boolean _get_default32BitsAbis_$lambda-4(Abi abi) {
        return !abi.supports64Bits();
    }

    private static final boolean _get_defaultAbis_$lambda-5(AbiInfo abiInfo) {
        return abiInfo.isDefault() && !abiInfo.isDeprecated();
    }

    private static final Abi _get_defaultAbis_$lambda-6(AbiInfo it) {
        return it.getAbi();
    }

    private static final Abi _get_supported32BitsAbis_$lambda-7(AbiInfo it) {
        return it.getAbi();
    }

    private static final boolean _get_supported32BitsAbis_$lambda-8(Abi abi) {
        return !abi.supports64Bits();
    }

    private static final Abi _get_supportedAbis_$lambda-9(AbiInfo it) {
        return it.getAbi();
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[NativeBuildSystem.values().length];
            nArray[NativeBuildSystem.CMAKE.ordinal()] = 1;
            nArray[NativeBuildSystem.NDK_BUILD.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Stl.values().length];
            nArray[Stl.LIBCXX_SHARED.ordinal()] = 1;
            nArray[Stl.GNUSTL_SHARED.ordinal()] = 2;
            nArray[Stl.STLPORT_SHARED.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

