/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.component.UnitTestCreationConfig;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.lint.AndroidLintAnalysisTask;
import com.android.build.gradle.internal.lint.AndroidLintCopyReportTask;
import com.android.build.gradle.internal.lint.AndroidLintGlobalTask;
import com.android.build.gradle.internal.lint.AndroidLintTask;
import com.android.build.gradle.internal.lint.AndroidLintTextOutputTask;
import com.android.build.gradle.internal.lint.LintModelWriterTask;
import com.android.build.gradle.internal.lint.VariantWithTests;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.tasks.LintModelMetadataTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactory;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.builder.core.VariantType;
import com.android.utils.StringHelper;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ@\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J2\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fJ\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0016\u0010\u001a\u001a\u00020\u000b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/lint/LintTaskManager;", "", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "taskFactory", "Lcom/android/build/gradle/internal/tasks/factory/TaskFactory;", "projectInfo", "Lcom/android/build/gradle/internal/scope/ProjectInfo;", "(Lcom/android/build/gradle/internal/scope/GlobalScope;Lcom/android/build/gradle/internal/tasks/factory/TaskFactory;Lcom/android/build/gradle/internal/scope/ProjectInfo;)V", "attachTestsToVariants", "Ljava/util/LinkedHashMap;", "", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "Lkotlin/collections/LinkedHashMap;", "variantPropertiesList", "", "Lcom/android/build/api/variant/impl/VariantImpl;", "testComponentPropertiesList", "Lcom/android/build/api/component/impl/TestComponentImpl;", "createBeforeEvaluateLintTasks", "", "createLintTasks", "variantType", "Lcom/android/builder/core/VariantType;", "variantModel", "Lcom/android/build/gradle/internal/variant/VariantModel;", "getTaskPath", "taskName", "task", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask;", "Companion", "gradle-core"})
public final class LintTaskManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GlobalScope globalScope;
    @NotNull
    private final TaskFactory taskFactory;
    @NotNull
    private final ProjectInfo projectInfo;

    public LintTaskManager(@NotNull GlobalScope globalScope, @NotNull TaskFactory taskFactory, @NotNull ProjectInfo projectInfo) {
        Intrinsics.checkNotNullParameter((Object)globalScope, (String)"globalScope");
        Intrinsics.checkNotNullParameter((Object)taskFactory, (String)"taskFactory");
        Intrinsics.checkNotNullParameter((Object)projectInfo, (String)"projectInfo");
        this.globalScope = globalScope;
        this.taskFactory = taskFactory;
        this.projectInfo = projectInfo;
    }

    public final void createBeforeEvaluateLintTasks() {
        this.taskFactory.register(new AndroidLintGlobalTask.LintFixCreationAction(this.globalScope));
        TaskProvider globalTask = this.taskFactory.register(new AndroidLintGlobalTask.GlobalCreationAction(this.globalScope));
        this.taskFactory.configure("check", (Action<? super Task>)((Action)arg_0 -> LintTaskManager.createBeforeEvaluateLintTasks$lambda-0(globalTask, arg_0)));
    }

    public final void createLintTasks(@NotNull VariantType variantType, @NotNull VariantModel variantModel, @NotNull List<? extends VariantImpl> variantPropertiesList, @NotNull List<? extends TestComponentImpl> testComponentPropertiesList) {
        List list;
        Intrinsics.checkNotNullParameter((Object)variantType, (String)"variantType");
        Intrinsics.checkNotNullParameter((Object)variantModel, (String)"variantModel");
        Intrinsics.checkNotNullParameter(variantPropertiesList, (String)"variantPropertiesList");
        Intrinsics.checkNotNullParameter(testComponentPropertiesList, (String)"testComponentPropertiesList");
        if (variantType.isForTesting()) {
            return;
        }
        if (this.globalScope.getExtension().getLintOptions().isIgnoreTestSources()) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        } else {
            list = testComponentPropertiesList;
        }
        LinkedHashMap<String, VariantWithTests> variantsWithTests = this.attachTestsToVariants(variantPropertiesList, list);
        boolean bl = false;
        Map variantLintTaskToLintVitalTask = new LinkedHashMap();
        boolean needsCopyReportTask = Companion.needsCopyReportTask$gradle_core(this.globalScope.getExtension().getLintOptions());
        for (VariantWithTests variantWithTests : variantsWithTests.values()) {
            ConsumableCreationConfig mainVariant;
            if (variantType.isAar()) {
                Intrinsics.checkNotNullExpressionValue((Object)variantWithTests, (String)"variantWithTests");
                this.taskFactory.register(new LintModelWriterTask.LintCreationAction(variantWithTests, false, 2, null));
                this.taskFactory.register(new LintModelMetadataTask.CreationAction(variantWithTests.getMain()));
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)variantWithTests, (String)"variantWithTests");
                this.taskFactory.register(new LintModelWriterTask.LintCreationAction(variantWithTests, false));
            }
            this.taskFactory.register(new AndroidLintAnalysisTask.SingleVariantCreationAction(variantWithTests));
            if (variantType.isDynamicFeature()) {
                this.taskFactory.register(new AndroidLintAnalysisTask.LintVitalCreationAction(variantWithTests.getMain()));
                this.taskFactory.register(new LintModelWriterTask.LintVitalCreationAction(variantWithTests.getMain(), false, 2, null));
                continue;
            }
            this.taskFactory.register(new AndroidLintTask.SingleVariantCreationAction(variantWithTests));
            TaskProvider variantLintTask = this.taskFactory.register(new AndroidLintTextOutputTask.SingleVariantCreationAction(variantWithTests.getMain()));
            if (needsCopyReportTask) {
                TaskProvider copyLintReportTask = this.taskFactory.register(new AndroidLintCopyReportTask.CreationAction(variantWithTests.getMain()));
                variantLintTask.configure(arg_0 -> LintTaskManager.createLintTasks$lambda-1(copyLintReportTask, arg_0));
            }
            if ((mainVariant = variantWithTests.getMain()).getVariantType().isBaseModule() && !mainVariant.getVariantDslInfo().isDebuggable() && this.globalScope.getExtension().getLintOptions().isCheckReleaseBuilds()) {
                this.taskFactory.register(new AndroidLintAnalysisTask.LintVitalCreationAction(mainVariant));
                this.taskFactory.register(new AndroidLintTask.LintVitalCreationAction(mainVariant));
                TaskProvider lintVitalTask = this.taskFactory.register(new AndroidLintTextOutputTask.LintVitalCreationAction(mainVariant));
                Map map = variantLintTaskToLintVitalTask;
                String string = this.getTaskPath(variantLintTask);
                boolean bl2 = false;
                map.put(string, lintVitalTask);
            }
            this.taskFactory.register(new AndroidLintTask.FixSingleVariantCreationAction(variantWithTests));
        }
        if (variantType.isDynamicFeature()) {
            return;
        }
        String defaultVariant = variantModel.getDefaultVariant();
        if (defaultVariant != null) {
            this.taskFactory.configure("lint", AndroidLintGlobalTask.class, arg_0 -> LintTaskManager.createLintTasks$lambda-2(defaultVariant, arg_0));
            this.taskFactory.configure("lintFix", AndroidLintGlobalTask.class, arg_0 -> LintTaskManager.createLintTasks$lambda-3(defaultVariant, arg_0));
        }
        String lintTaskPath = this.getTaskPath("lint");
        this.projectInfo.getProject().getGradle().getTaskGraph().whenReady(arg_0 -> LintTaskManager.createLintTasks$lambda-8(variantLintTaskToLintVitalTask, lintTaskPath, arg_0));
    }

    private final LinkedHashMap<String, VariantWithTests> attachTestsToVariants(List<? extends VariantImpl> variantPropertiesList, List<? extends TestComponentImpl> testComponentPropertiesList) {
        Object object;
        LinkedHashMap<String, VariantWithTests> variantsWithTests = new LinkedHashMap<String, VariantWithTests>();
        for (VariantImpl variantImpl : variantPropertiesList) {
            Map map = variantsWithTests;
            String string = variantImpl.getName();
            object = new VariantWithTests(variantImpl, null, null, 6, null);
            boolean map2 = false;
            map.put(string, object);
        }
        for (TestComponentImpl testComponentImpl : testComponentPropertiesList) {
            VariantWithTests bl6;
            boolean string;
            String key = testComponentImpl.getTestedConfig().getName();
            VariantWithTests variantWithTests = variantsWithTests.get(key);
            Intrinsics.checkNotNull((Object)variantWithTests);
            object = variantWithTests;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variantsWithTests[key]!!");
            VariantWithTests current = object;
            object = testComponentImpl;
            if (object instanceof AndroidTestCreationConfig) {
                boolean bl5 = current.getAndroidTest() == null;
                boolean bl = false;
                string = false;
                if (!bl5) {
                    boolean bl4 = false;
                    String string2 = "Component " + current.getMain() + " appears to have two conflicting android test components " + current.getAndroidTest() + " and " + testComponentImpl;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                Map map = variantsWithTests;
                bl6 = new VariantWithTests(current.getMain(), (AndroidTestCreationConfig)((Object)testComponentImpl), current.getUnitTest());
                string = false;
                map.put(key, bl6);
                continue;
            }
            if (object instanceof UnitTestCreationConfig) {
                boolean bl = current.getUnitTest() == null;
                boolean bl2 = false;
                string = false;
                if (!bl) {
                    boolean bl7 = false;
                    String string3 = "Component " + current.getMain() + " appears to have two conflicting unit test components " + current.getUnitTest() + " and " + testComponentImpl;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                Map map = variantsWithTests;
                bl6 = new VariantWithTests(current.getMain(), current.getAndroidTest(), (UnitTestCreationConfig)((Object)testComponentImpl));
                string = false;
                map.put(key, bl6);
                continue;
            }
            throw new IllegalStateException("Unexpected test component type");
        }
        return variantsWithTests;
    }

    private final String getTaskPath(TaskProvider<AndroidLintTextOutputTask> task) {
        String string = task.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
        return this.getTaskPath(string);
    }

    private final String getTaskPath(String taskName) {
        return this.projectInfo.getProject().getRootProject() == this.projectInfo.getProject() ? Intrinsics.stringPlus((String)":", (Object)taskName) : this.projectInfo.getProject().getPath() + ':' + taskName;
    }

    private static final void createBeforeEvaluateLintTasks$lambda-0(TaskProvider $globalTask, Task it) {
        Intrinsics.checkNotNullParameter((Object)$globalTask, (String)"$globalTask");
        Object[] objectArray = new Object[]{$globalTask};
        it.dependsOn(objectArray);
    }

    private static final void createLintTasks$lambda-1(TaskProvider $copyLintReportTask, AndroidLintTextOutputTask it) {
        Intrinsics.checkNotNullParameter((Object)$copyLintReportTask, (String)"$copyLintReportTask");
        Object[] objectArray = new Object[]{$copyLintReportTask};
        it.finalizedBy(objectArray);
    }

    private static final void createLintTasks$lambda-2(String $defaultVariant, AndroidLintGlobalTask globalTask) {
        Object[] objectArray = new Object[]{StringHelper.appendCapitalized((String)"lint", (String)$defaultVariant)};
        globalTask.dependsOn(objectArray);
    }

    private static final void createLintTasks$lambda-3(String $defaultVariant, AndroidLintGlobalTask globalFixTask) {
        Object[] objectArray = new Object[]{StringHelper.appendCapitalized((String)"lintFix", (String)$defaultVariant)};
        globalFixTask.dependsOn(objectArray);
    }

    private static final void createLintTasks$lambda-8$lambda-5$lambda-4(AndroidLintTextOutputTask it) {
        it.setEnabled(false);
    }

    private static final void createLintTasks$lambda-8$lambda-7$lambda-6(AndroidLintTextOutputTask it) {
        it.setEnabled(false);
    }

    private static final void createLintTasks$lambda-8(Map $variantLintTaskToLintVitalTask, String $lintTaskPath, TaskExecutionGraph it) {
        Map.Entry entry;
        Map.Entry element$iv;
        Intrinsics.checkNotNullParameter((Object)$variantLintTaskToLintVitalTask, (String)"$variantLintTaskToLintVitalTask");
        Intrinsics.checkNotNullParameter((Object)$lintTaskPath, (String)"$lintTaskPath");
        Map $this$forEach$iv = $variantLintTaskToLintVitalTask;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry $dstr$taskPath$taskToDisable = element$iv = iterator2.next();
            boolean bl2 = false;
            entry = $dstr$taskPath$taskToDisable;
            boolean bl3 = false;
            String taskPath = (String)entry.getKey();
            Map.Entry entry2 = $dstr$taskPath$taskToDisable;
            boolean bl4 = false;
            TaskProvider taskToDisable = (TaskProvider)entry2.getValue();
            if (!it.hasTask(taskPath)) continue;
            taskToDisable.configure(LintTaskManager::createLintTasks$lambda-8$lambda-5$lambda-4);
        }
        if (it.hasTask($lintTaskPath)) {
            $this$forEach$iv = $variantLintTaskToLintVitalTask;
            $i$f$forEach = false;
            map = $this$forEach$iv;
            bl = false;
            iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry $dstr$_u24__u24$lintVitalTask = element$iv = iterator2.next();
                boolean bl5 = false;
                entry = $dstr$_u24__u24$lintVitalTask;
                boolean bl6 = false;
                TaskProvider lintVitalTask = (TaskProvider)entry.getValue();
                lintVitalTask.configure(LintTaskManager::createLintTasks$lambda-8$lambda-7$lambda-6);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u0011\u0010\b\u001a\u00020\u0004*\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0011\u0010\u000b\u001a\u00020\u0004*\u00020\tH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/lint/LintTaskManager$Companion;", "", "()V", "needsCopyReportTask", "", "lintOptions", "Lcom/android/build/gradle/internal/dsl/LintOptions;", "needsCopyReportTask$gradle_core", "isLintStderr", "Ljava/io/File;", "isLintStderr$gradle_core", "isLintStdout", "isLintStdout$gradle_core", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isLintStdout$gradle_core(@NotNull File $this$isLintStdout) {
            Intrinsics.checkNotNullParameter((Object)$this$isLintStdout, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isLintStdout.getPath(), (Object)new File("stdout").getPath());
        }

        public final boolean isLintStderr$gradle_core(@NotNull File $this$isLintStderr) {
            Intrinsics.checkNotNullParameter((Object)$this$isLintStderr, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isLintStderr.getPath(), (Object)new File("stderr").getPath());
        }

        public final boolean needsCopyReportTask$gradle_core(@NotNull LintOptions lintOptions2) {
            Intrinsics.checkNotNullParameter((Object)lintOptions2, (String)"lintOptions");
            File textOutput = lintOptions2.getTextOutput();
            return lintOptions2.getTextReport() && textOutput != null && !this.isLintStdout$gradle_core(textOutput) && !this.isLintStderr$gradle_core(textOutput) || lintOptions2.getHtmlReport() && lintOptions2.getHtmlOutput() != null || lintOptions2.getXmlReport() && lintOptions2.getXmlOutput() != null || lintOptions2.getSarifReport() && lintOptions2.getSarifOutput() != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

