/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.builder.errors.IssueReporter;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"getLocalCustomLintChecks", "Lorg/gradle/api/file/FileCollection;", "lintChecks", "Lorg/gradle/api/artifacts/Configuration;", "Lorg/gradle/api/artifacts/ArtifactCollection;", "lenientMode", "", "getLocalCustomLintChecksForModel", "Lcom/google/common/collect/ImmutableList;", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "gradle-core"})
@JvmName(name="CustomLintCheckUtils")
public final class CustomLintCheckUtils {
    @NotNull
    public static final ImmutableList<File> getLocalCustomLintChecksForModel(@NotNull Project project2, @NotNull IssueReporter issueReporter2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        Configuration lintChecks = project2.getConfigurations().getByName("lintChecks");
        Intrinsics.checkNotNullExpressionValue((Object)lintChecks, (String)"lintChecks");
        ArtifactCollection artifactCollection = CustomLintCheckUtils.getLocalCustomLintChecks(lintChecks, true);
        Collection failures = artifactCollection.getFailures();
        if (!failures.isEmpty()) {
            DependencyFailureHandler failureHandler = new DependencyFailureHandler();
            String string = project2.getPath() + '/' + lintChecks.getName();
            Intrinsics.checkNotNullExpressionValue((Object)failures, (String)"failures");
            failureHandler.addErrors(string, failures);
            failureHandler.registerIssues(issueReporter2);
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)artifactCollection.getArtifactFiles().getFiles());
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(artifactCollection.artifactFiles.files)");
        return immutableList;
    }

    @NotNull
    public static final FileCollection getLocalCustomLintChecks(@NotNull Configuration lintChecks) {
        Intrinsics.checkNotNullParameter((Object)lintChecks, (String)"lintChecks");
        FileCollection fileCollection2 = CustomLintCheckUtils.getLocalCustomLintChecks(lintChecks, false).getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"getLocalCustomLintChecks\u2026de = false).artifactFiles");
        return fileCollection2;
    }

    private static final ArtifactCollection getLocalCustomLintChecks(Configuration lintChecks, boolean lenientMode) {
        ArtifactCollection artifactCollection = lintChecks.getIncoming().artifactView(arg_0 -> CustomLintCheckUtils.getLocalCustomLintChecks$lambda-1(lenientMode, arg_0)).getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"lintChecks.incoming.arti\u2026ientMode)\n    }.artifacts");
        return artifactCollection;
    }

    private static final void getLocalCustomLintChecks$lambda-1$lambda-0(AttributeContainer attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        attributes.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
    }

    private static final void getLocalCustomLintChecks$lambda-1(boolean $lenientMode, ArtifactView.ViewConfiguration config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        config2.attributes(CustomLintCheckUtils::getLocalCustomLintChecks$lambda-1$lambda-0);
        config2.lenient($lenientMode);
    }
}

