/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.Version;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.IssueReporter;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.lint.model.LintModelModuleType;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0000\u00a8\u0006\n"}, d2={"getLintMavenArtifactVersion", "", "versionOverride", "reporter", "Lcom/android/builder/errors/IssueReporter;", "defaultVersion", "agpVersion", "toLintModelModuleType", "Lcom/android/tools/lint/model/LintModelModuleType;", "Lcom/android/builder/core/VariantType;", "gradle-core"})
@JvmName(name="AndroidLintInputs")
public final class AndroidLintInputs {
    @NotNull
    public static final LintModelModuleType toLintModelModuleType(@NotNull VariantType $this$toLintModelModuleType) {
        LintModelModuleType lintModelModuleType;
        Intrinsics.checkNotNullParameter((Object)$this$toLintModelModuleType, (String)"<this>");
        VariantType variantType = $this$toLintModelModuleType;
        if (variantType == VariantTypeImpl.BASE_APK) {
            lintModelModuleType = LintModelModuleType.APP;
        } else if (variantType == VariantTypeImpl.LIBRARY) {
            lintModelModuleType = LintModelModuleType.LIBRARY;
        } else if (variantType == VariantTypeImpl.OPTIONAL_APK) {
            lintModelModuleType = LintModelModuleType.DYNAMIC_FEATURE;
        } else if (variantType == VariantTypeImpl.TEST_APK) {
            lintModelModuleType = LintModelModuleType.TEST;
        } else {
            throw new RuntimeException("Unsupported VariantTypeImpl value");
        }
        return lintModelModuleType;
    }

    @NotNull
    public static final String getLintMavenArtifactVersion(@Nullable String versionOverride, @Nullable IssueReporter reporter, @NotNull String defaultVersion, @NotNull String agpVersion) {
        Intrinsics.checkNotNullParameter((Object)defaultVersion, (String)"defaultVersion");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        if (versionOverride == null) {
            return defaultVersion;
        }
        GradleVersion parsed = GradleVersion.tryParseAndroidGradlePluginVersion((String)versionOverride);
        if (parsed == null) {
            IssueReporter issueReporter2 = reporter;
            if (issueReporter2 != null) {
                IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)StringsKt.trimIndent((String)("\n                    Could not parse lint version override '" + versionOverride + "'\n                    Recommendation: Remove or update the gradle property " + StringOption.LINT_VERSION_OVERRIDE.getPropertyName() + " to be at least " + agpVersion + "\n                    ")), null, null, (int)12, null);
            }
            return defaultVersion;
        }
        GradleVersion gradleVersion = GradleVersion.parseAndroidGradlePluginVersion((String)defaultVersion);
        String normalizedOverride = parsed.getMajor() + 23 + StringsKt.removePrefix((String)versionOverride, (CharSequence)String.valueOf(parsed.getMajor()));
        GradleVersion gradleVersion2 = GradleVersion.tryParseAndroidGradlePluginVersion((String)normalizedOverride);
        if (gradleVersion2 == null) {
            String string = "Unexpected parse error";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        GradleVersion normalizedParsed = gradleVersion2;
        if (normalizedParsed.getMajor() < gradleVersion.getMajor()) {
            gradleVersion2 = reporter;
            if (gradleVersion2 != null) {
                IssueReporter.reportError$default((IssueReporter)gradleVersion2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)StringsKt.trimIndent((String)("\n                    Lint must be at least version " + StringsKt.substringBefore$default((String)agpVersion, (String)".", null, (int)2, null) + ".0.0, and is recommended to be at least " + agpVersion + "\n                    Recommendation: Remove or update the gradle property " + StringOption.LINT_VERSION_OVERRIDE.getPropertyName() + " to be at least " + agpVersion + "\n                    ")), null, null, (int)12, null);
            }
            return defaultVersion;
        }
        if (normalizedParsed.compareTo(gradleVersion) < 0 && (gradleVersion2 = reporter) != null) {
            IssueReporter.reportWarning$default((IssueReporter)gradleVersion2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)StringsKt.trimIndent((String)("\n                    The build will use lint version " + versionOverride + " which is older than the default.\n                    Recommendation: Remove or update the gradle property " + StringOption.LINT_VERSION_OVERRIDE.getPropertyName() + " to be at least " + agpVersion + "\n                    ")), null, null, (int)12, null);
        }
        return normalizedOverride;
    }

    public static /* synthetic */ String getLintMavenArtifactVersion$default(String string, IssueReporter issueReporter2, String string2, String string3, int n, Object object) {
        String string4;
        if ((n & 4) != 0) {
            string4 = Version.ANDROID_TOOLS_BASE_VERSION;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"ANDROID_TOOLS_BASE_VERSION");
            string2 = string4;
        }
        if ((n & 8) != 0) {
            string4 = Version.ANDROID_GRADLE_PLUGIN_VERSION;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
            string3 = string4;
        }
        return AndroidLintInputs.getLintMavenArtifactVersion(string, issueReporter2, string2, string3);
    }
}

