/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.attributes.VariantAttr;
import com.android.build.gradle.internal.ide.DependenciesImpl;
import com.android.builder.model.Dependencies;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0007\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\b\u00a8\u0006\u000b"}, d2={"clone", "Lcom/android/builder/model/Dependencies;", "dependencies", "modelLevel", "", "getVariantName", "", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "Lorg/gradle/api/artifacts/result/ResolvedVariantResult;", "isTestFixturesVariant", "", "gradle-core"})
@JvmName(name="LibraryUtils")
public final class LibraryUtils {
    @NotNull
    public static final Dependencies clone(@NotNull Dependencies dependencies, int modelLevel) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        if (modelLevel >= 4) {
            Dependencies dependencies2 = DependenciesImpl.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)dependencies2, (String)"EMPTY");
            return dependencies2;
        }
        List libraries = CollectionsKt.emptyList();
        ArrayList javaLibraries = Lists.newArrayList((Iterable)dependencies.getJavaLibraries());
        List projects = CollectionsKt.emptyList();
        return new DependenciesImpl(libraries, javaLibraries, projects, Lists.newArrayList((Iterable)dependencies.getRuntimeOnlyClasses()));
    }

    @Nullable
    public static final String getVariantName(@NotNull ResolvedArtifactResult $this$getVariantName) {
        Intrinsics.checkNotNullParameter((Object)$this$getVariantName, (String)"<this>");
        ResolvedVariantResult resolvedVariantResult = $this$getVariantName.getVariant();
        Intrinsics.checkNotNullExpressionValue((Object)resolvedVariantResult, (String)"variant");
        return LibraryUtils.getVariantName(resolvedVariantResult);
    }

    public static final boolean isTestFixturesVariant(@NotNull ResolvedVariantResult $this$isTestFixturesVariant) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isTestFixturesVariant, (String)"<this>");
            List list = $this$isTestFixturesVariant.getCapabilities();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"capabilities");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Capability capability = (Capability)element$iv;
                    boolean bl2 = false;
                    String string = capability.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"capability.name");
                    if (!StringsKt.endsWith$default((String)string, (String)"-test-fixtures", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final String getVariantName(@NotNull ResolvedVariantResult $this$getVariantName) {
        Intrinsics.checkNotNullParameter((Object)$this$getVariantName, (String)"<this>");
        if (LibraryUtils.isTestFixturesVariant($this$getVariantName)) {
            String string;
            VariantAttr variantAttr = (VariantAttr)$this$getVariantName.getAttributes().getAttribute(VariantAttr.ATTRIBUTE);
            if (variantAttr == null) {
                string = null;
            } else {
                String string2 = variantAttr.getName();
                if (string2 == null) {
                    string = null;
                } else {
                    String string3 = string2;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string3;
                    boolean bl3 = false;
                    string = Intrinsics.stringPlus((String)it, (Object)"TestFixtures");
                }
            }
            return string;
        }
        VariantAttr variantAttr = (VariantAttr)$this$getVariantName.getAttributes().getAttribute(VariantAttr.ATTRIBUTE);
        return variantAttr == null ? null : variantAttr.getName();
    }
}

