/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.dsl.PostProcessing;
import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.ProguardFileType;
import com.android.build.gradle.internal.ProguardFilesProvider;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.services.DslServices;
import com.android.builder.model.CodeShrinker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.jetbrains.annotations.NotNull;

@Incubating
public class PostProcessingBlock
implements ProguardFilesProvider,
PostProcessing {
    private final DslServices dslServices;
    private boolean removeUnusedCode = true;
    private boolean removeUnusedResources;
    private boolean obfuscate;
    private boolean optimizeCode;
    private List<File> proguardFiles;
    private List<File> testProguardFiles;
    private List<File> consumerProguardFiles;

    @Inject
    public PostProcessingBlock(DslServices dslServices) {
        this(dslServices, (List<File>)ImmutableList.of((Object)ProguardFiles.getDefaultProguardFile(ProguardFiles.ProguardFile.NO_ACTIONS.fileName, dslServices.getBuildDirectory())));
    }

    @VisibleForTesting
    PostProcessingBlock(DslServices dslServices, List<File> proguardFiles2) {
        this.dslServices = dslServices;
        this.proguardFiles = Lists.newArrayList(proguardFiles2);
        this.testProguardFiles = new ArrayList<File>();
        this.consumerProguardFiles = new ArrayList<File>();
    }

    public void initWith(PostProcessingBlock that) {
        this.removeUnusedCode = that.isRemoveUnusedCode();
        this.removeUnusedResources = that.isRemoveUnusedResources();
        this.obfuscate = that.isObfuscate();
        this.optimizeCode = that.isOptimizeCode();
        this.proguardFiles = Lists.newArrayList(that.getProguardFiles(ProguardFileType.EXPLICIT));
        this.testProguardFiles = Lists.newArrayList(that.getProguardFiles(ProguardFileType.TEST));
        this.consumerProguardFiles = Lists.newArrayList(that.getProguardFiles(ProguardFileType.CONSUMER));
    }

    public void initWith(@NotNull PostProcessing that) {
        this.initWith((PostProcessingBlock)that);
    }

    public boolean isRemoveUnusedCode() {
        return this.removeUnusedCode;
    }

    public void setRemoveUnusedCode(boolean removeUnusedCode) {
        this.removeUnusedCode = removeUnusedCode;
    }

    public boolean isRemoveUnusedResources() {
        return this.removeUnusedResources;
    }

    public void setRemoveUnusedResources(boolean removeUnusedResources) {
        this.removeUnusedResources = removeUnusedResources;
    }

    public boolean isObfuscate() {
        return this.obfuscate;
    }

    public void setObfuscate(boolean obfuscate) {
        this.obfuscate = obfuscate;
    }

    public boolean isOptimizeCode() {
        return this.optimizeCode;
    }

    public void setOptimizeCode(boolean optimizeCode) {
        this.optimizeCode = optimizeCode;
    }

    public void setProguardFiles(List<?> proguardFiles2) {
        this.proguardFiles = new ArrayList<File>();
        for (Object file : proguardFiles2) {
            this.proguardFiles.add(this.dslServices.file(file));
        }
    }

    public void proguardFile(Object file) {
        this.proguardFiles.add(this.dslServices.file(file));
    }

    public void proguardFiles(Object ... files) {
        for (Object file : files) {
            this.proguardFile(file);
        }
    }

    public void setTestProguardFiles(List<?> testProguardFiles) {
        this.testProguardFiles = new ArrayList<File>();
        for (Object file : testProguardFiles) {
            this.testProguardFiles.add(this.dslServices.file(file));
        }
    }

    public void testProguardFile(Object file) {
        this.testProguardFiles.add(this.dslServices.file(file));
    }

    public void testProguardFiles(Object ... files) {
        for (Object file : files) {
            this.testProguardFile(file);
        }
    }

    public void setConsumerProguardFiles(List<?> consumerProguardFiles) {
        this.consumerProguardFiles = new ArrayList<File>();
        for (Object file : consumerProguardFiles) {
            this.consumerProguardFiles.add(this.dslServices.file(file));
        }
    }

    public void consumerProguardFile(Object file) {
        this.consumerProguardFiles.add(this.dslServices.file(file));
    }

    public void consumerProguardFiles(Object ... files) {
        for (Object file : files) {
            this.consumerProguardFile(file);
        }
    }

    public String getCodeShrinker() {
        this.dslServices.getDeprecationReporter().reportObsoleteUsage("codeShrinker", DeprecationReporter.DeprecationTarget.VERSION_8_0);
        return CodeShrinker.R8.name();
    }

    public void setCodeShrinker(String name) {
        this.dslServices.getDeprecationReporter().reportObsoleteUsage("codeShrinker", DeprecationReporter.DeprecationTarget.VERSION_8_0);
    }

    public CodeShrinker getCodeShrinkerEnum() {
        return CodeShrinker.R8;
    }

    @Override
    public Collection<File> getProguardFiles(ProguardFileType type) {
        switch (type) {
            case EXPLICIT: {
                return this.proguardFiles;
            }
            case TEST: {
                return this.testProguardFiles;
            }
            case CONSUMER: {
                return this.consumerProguardFiles;
            }
        }
        throw new AssertionError((Object)("Invalid ProguardFileType: " + (Object)((Object)type)));
    }
}

