/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0005J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J.\u0010\u001b\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u001c\u001a\u00020\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0018\u0010 \u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0005H\u0002R \u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/AvdSnapshotHandler;", "", "processFactory", "Lkotlin/Function1;", "", "", "Ljava/lang/ProcessBuilder;", "(Lkotlin/jvm/functions/Function1;)V", "checkSnapshotLoadable", "", "avdName", "emulatorExecutable", "Ljava/io/File;", "avdLocation", "logger", "Lcom/android/utils/ILogger;", "snapshotName", "closeEmulatorWithId", "", "adbExecutable", "emulatorProcess", "Ljava/lang/Process;", "idValue", "ensureEmulatorVersionRequirement", "emulatorDir", "findDeviceSerialWithId", "adb", "generateSnapshot", "getEmulatorExecutable", "emulatorDirectoryProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "killDevice", "serial", "gradle-core"})
public final class AvdSnapshotHandler {
    @NotNull
    private final Function1<List<String>, ProcessBuilder> processFactory;

    public AvdSnapshotHandler(@NotNull Function1<? super List<String>, ProcessBuilder> processFactory) {
        Intrinsics.checkNotNullParameter(processFactory, (String)"processFactory");
        this.processFactory = processFactory;
    }

    public /* synthetic */ AvdSnapshotHandler(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        this((Function1<? super List<String>, ProcessBuilder>)function1);
    }

    @NotNull
    public final File getEmulatorExecutable(@NotNull Provider<Directory> emulatorDirectoryProvider) {
        File file;
        Intrinsics.checkNotNullParameter(emulatorDirectoryProvider, (String)"emulatorDirectoryProvider");
        Object object = (Directory)emulatorDirectoryProvider.getOrNull();
        File file2 = file = object == null ? null : object.getAsFile();
        if (file == null) {
            object = "Emulator dir does not exist";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        File emulatorDir = file;
        this.ensureEmulatorVersionRequirement(emulatorDir);
        return FilesKt.resolve((File)emulatorDir, (String)"emulator");
    }

    public final boolean checkSnapshotLoadable(@NotNull String avdName, @NotNull File emulatorExecutable, @NotNull File avdLocation, @NotNull ILogger logger, @NotNull String snapshotName) {
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)emulatorExecutable, (String)"emulatorExecutable");
        Intrinsics.checkNotNullParameter((Object)avdLocation, (String)"avdLocation");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)snapshotName, (String)"snapshotName");
        logger.info("Checking " + snapshotName + " on device " + avdName + " is loadable.", new Object[0]);
        Object object = new String[]{emulatorExecutable.getAbsolutePath(), Intrinsics.stringPlus((String)"@", (Object)avdName), "-no-window", "-no-boot-anim", "-check-snapshot-loadable", snapshotName};
        ProcessBuilder processBuilder = (ProcessBuilder)this.processFactory.invoke((Object)CollectionsKt.listOf((Object[])object));
        object = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"processBuilder.environment()");
        String string = "ANDROID_AVD_HOME";
        String string2 = avdLocation.getAbsolutePath();
        boolean bl = false;
        object.put(string, string2);
        Process process2 = processBuilder.start();
        Ref.BooleanRef success = new Ref.BooleanRef();
        try {
            GrabProcessOutput.grabProcessOutput((Process)process2, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_PROCESS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(logger, success){
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ Ref.BooleanRef $success;
                {
                    this.$logger = $logger;
                    this.$success = $success;
                }

                public void out(@Nullable String line) {
                    String string = line;
                    if (string == null) {
                        return;
                    }
                    this.$logger.verbose(line, new Object[0]);
                    if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Loadable", (boolean)false, (int)2, null)) {
                        this.$success.element = true;
                    }
                }

                public void err(@Nullable String line) {
                }
            });
            if (!process2.waitFor(30L, TimeUnit.SECONDS)) {
                process2.destroy();
            }
        }
        catch (Exception e) {
            process2.destroy();
            throw new RuntimeException(e);
        }
        return success.element;
    }

    public static /* synthetic */ boolean checkSnapshotLoadable$default(AvdSnapshotHandler avdSnapshotHandler, String string, File file, File file2, ILogger iLogger, String string2, int n, Object object) {
        if ((n & 0x10) != 0) {
            string2 = "default_boot";
        }
        return avdSnapshotHandler.checkSnapshotLoadable(string, file, file2, iLogger, string2);
    }

    public final void generateSnapshot(@NotNull String avdName, @NotNull File emulatorExecutable, @NotNull File adbExecutable, @NotNull File avdLocation, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)emulatorExecutable, (String)"emulatorExecutable");
        Intrinsics.checkNotNullParameter((Object)adbExecutable, (String)"adbExecutable");
        Intrinsics.checkNotNullParameter((Object)avdLocation, (String)"avdLocation");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        logger.verbose(Intrinsics.stringPlus((String)"Creating snapshot for ", (Object)avdName), new Object[0]);
        String deviceId = Intrinsics.stringPlus((String)avdName, (Object)"_snapshot");
        Object object = new String[]{emulatorExecutable.getAbsolutePath(), Intrinsics.stringPlus((String)"@", (Object)avdName), "-no-window", "-no-boot-anim", "-no-audio", "-id", deviceId};
        ProcessBuilder processBuilder = (ProcessBuilder)this.processFactory.invoke((Object)CollectionsKt.listOf((Object[])object));
        object = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"processBuilder.environment()");
        String string = "ANDROID_AVD_HOME";
        String string2 = avdLocation.getAbsolutePath();
        boolean bl = false;
        object.put(string, string2);
        Process process2 = processBuilder.start();
        try {
            GrabProcessOutput.grabProcessOutput((Process)process2, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(logger, this, adbExecutable, process2, deviceId){
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ AvdSnapshotHandler this$0;
                final /* synthetic */ File $adbExecutable;
                final /* synthetic */ Process $process;
                final /* synthetic */ String $deviceId;
                {
                    this.$logger = $logger;
                    this.this$0 = $receiver;
                    this.$adbExecutable = $adbExecutable;
                    this.$process = $process;
                    this.$deviceId = $deviceId;
                }

                public void out(@Nullable String line) {
                    Object object = line;
                    if (object == null) {
                        return;
                    }
                    this.$logger.verbose(line, new Object[0]);
                    if (StringsKt.contains$default((CharSequence)line, (CharSequence)"boot completed", (boolean)false, (int)2, null)) {
                        Thread.sleep(5000L);
                        object = this.$process;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"process");
                        AvdSnapshotHandler.access$closeEmulatorWithId(this.this$0, this.$adbExecutable, (Process)object, this.$deviceId, this.$logger);
                    }
                }

                public void err(@Nullable String line) {
                }
            });
            if (!process2.waitFor(80L, TimeUnit.SECONDS)) {
                logger.verbose("Snapshot creation timed out. Closing emulator.", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
                this.closeEmulatorWithId(adbExecutable, process2, deviceId, logger);
                process2.waitFor();
                string = Intrinsics.stringPlus((String)"Failed to generate snapshot for device: ", (Object)avdName);
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            logger.verbose(Intrinsics.stringPlus((String)"Successfully created snapshot for: ", (Object)avdName), new Object[0]);
        }
        catch (Exception e) {
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
            this.closeEmulatorWithId(adbExecutable, process2, deviceId, logger);
            process2.waitFor();
            throw e;
        }
    }

    private final void closeEmulatorWithId(File adbExecutable, Process emulatorProcess, String idValue, ILogger logger) {
        try {
            String emulatorSerial = this.findDeviceSerialWithId(adbExecutable, idValue);
            this.killDevice(adbExecutable, emulatorSerial);
        }
        catch (Exception e) {
            logger.info(Intrinsics.stringPlus((String)"Failed to close emulator properly from adb. Reason: ", (Object)e), new Object[0]);
            emulatorProcess.destroy();
        }
    }

    private final void killDevice(File adb, String serial) {
        Object[] objectArray = new String[]{adb.getAbsolutePath(), "-s", serial, "emu", "kill"};
        Process killProcess = ((ProcessBuilder)this.processFactory.invoke((Object)CollectionsKt.listOf((Object[])objectArray))).start();
        killProcess.waitFor();
    }

    private final String findDeviceSerialWithId(File adb, String idValue) {
        boolean bl = false;
        List serials = new ArrayList();
        Object object = new String[]{adb.getAbsolutePath(), "devices"};
        Process allSerialsProcess = ((ProcessBuilder)this.processFactory.invoke((Object)CollectionsKt.listOf((Object[])object))).start();
        GrabProcessOutput.grabProcessOutput((Process)allSerialsProcess, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(serials){
            final /* synthetic */ List<String> $serials;
            {
                this.$serials = $serials;
            }

            public void out(@Nullable String line) {
                String string = line;
                if (string == null) {
                    return;
                }
                String string2 = line;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String trimmed = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                CharSequence charSequence = trimmed;
                String string4 = "\\s+";
                int n = 0;
                string4 = new Regex(string4);
                n = 0;
                boolean bl2 = false;
                List values = string4.split(charSequence, n);
                if (values.size() == 2 && Intrinsics.areEqual(values.get(1), (Object)"device")) {
                    this.$serials.add((String)values.get(0));
                }
            }

            public void err(@Nullable String line) {
            }
        });
        if (!allSerialsProcess.waitFor(10L, TimeUnit.SECONDS)) {
            allSerialsProcess.destroy();
            allSerialsProcess.waitFor();
            object = "Adb device retrieval timed out. Failed to destroy emulator properly";
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        for (String serial : serials) {
            Ref.ObjectRef id = new Ref.ObjectRef();
            Object[] objectArray = new String[]{adb.getAbsolutePath(), "-s", serial, "emu", "avd", "id"};
            Process idDetectionProcess = ((ProcessBuilder)this.processFactory.invoke((Object)CollectionsKt.listOf((Object[])objectArray))).start();
            GrabProcessOutput.grabProcessOutput((Process)idDetectionProcess, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput((Ref.ObjectRef<String>)id){
                final /* synthetic */ Ref.ObjectRef<String> $id;
                {
                    this.$id = $id;
                }

                public void out(@Nullable String line) {
                    String string = line;
                    if (string == null) {
                        return;
                    }
                    CharSequence charSequence = line;
                    boolean bl = false;
                    String string2 = charSequence;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String trimmed = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                    charSequence = trimmed;
                    bl = false;
                    if (charSequence.length() > 0 && !Intrinsics.areEqual((Object)trimmed, (Object)"OK")) {
                        this.$id.element = trimmed;
                    }
                }

                public void err(@Nullable String line) {
                }
            });
            if (!idDetectionProcess.waitFor(10L, TimeUnit.SECONDS)) {
                idDetectionProcess.destroy();
                idDetectionProcess.waitFor();
            }
            if (!Intrinsics.areEqual((Object)id.element, (Object)idValue)) continue;
            return serial;
        }
        object = Intrinsics.stringPlus((String)"Failed to find serial for device id: ", (Object)idValue);
        boolean bl3 = false;
        throw (Throwable)new IllegalStateException(object.toString());
    }

    private final void ensureEmulatorVersionRequirement(File emulatorDir) {
        File packageFile = FilesKt.resolve((File)emulatorDir, (String)"package.xml");
        Pattern versionPattern = Pattern.compile("<major>(\\d+)</major><minor>(\\d+)</minor><micro>(\\d+)</micro>");
        for (String line : Files.readAllLines(packageFile.toPath())) {
            Matcher matcher = versionPattern.matcher(line);
            if (!matcher.find()) continue;
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(1)");
            boolean bl = false;
            int majorVersion = Integer.parseInt(string);
            String string2 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(2)");
            boolean bl2 = false;
            int minorVersion = Integer.parseInt(string2);
            String string3 = matcher.group(3);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"matcher.group(3)");
            boolean bl3 = false;
            int microVersion = Integer.parseInt(string3);
            if (majorVersion > 30) {
                return;
            }
            if (majorVersion == 30 && minorVersion > 6) {
                return;
            }
            if (majorVersion == 30 && minorVersion == 6 && microVersion >= 4) {
                return;
            }
            string3 = "Emulator needs to be updated in order to use managed devices. Minimum version required: 30.6.4. Version found: " + majorVersion + '.' + minorVersion + '.' + microVersion + '.';
            bl3 = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        String string = "Could not determine version of Emulator in " + emulatorDir.getAbsolutePath() + ". Update emulator in order to use Managed Devices.";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    public AvdSnapshotHandler() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$closeEmulatorWithId(AvdSnapshotHandler $this, File adbExecutable, Process emulatorProcess, String idValue, ILogger logger) {
        $this.closeEmulatorWithId(adbExecutable, emulatorProcess, idValue, logger);
    }
}

