/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.AvdComponentsBuildService;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.lint.CustomLintCheckUtils;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BootClasspathBuilder;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.core.LibraryRequest;
import com.android.builder.model.OptionalCompilationStep;
import com.android.ide.common.blame.MessageReceiver;
import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.OptionalLibrary;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class GlobalScope {
    private final Project project;
    private final DataBindingBuilder dataBindingBuilder;
    private BaseExtension extension;
    private final Provider<SdkComponentsBuildService> sdkComponents;
    private final Provider<AvdComponentsBuildService> avdComponents;
    private final ToolingModelBuilderRegistry toolingRegistry;
    private final Set<OptionalCompilationStep> optionalCompilationSteps;
    private final MessageReceiver messageReceiver;
    private final SoftwareComponentFactory componentFactory;
    private final String createdBy;
    private final DslServices dslServices;
    private Configuration lintChecks;
    private Configuration lintPublish;
    private Configuration androidJarConfig;
    private final ArtifactsImpl globalArtifacts;
    private Provider<List<RegularFile>> bootClasspath = null;
    private ListProperty<RegularFile> filteredBootClasspath = null;
    private Provider<SdkComponentsBuildService.VersionedSdkLoader> versionedSdkLoader = null;

    public GlobalScope(Project project2, String createdBy, DslServices dslServices2, Provider<SdkComponentsBuildService> sdkComponents2, Provider<AvdComponentsBuildService> avdComponents, ToolingModelBuilderRegistry toolingRegistry, MessageReceiver messageReceiver, SoftwareComponentFactory componentFactory) {
        this.project = (Project)Preconditions.checkNotNull((Object)project2);
        this.createdBy = createdBy;
        this.dslServices = (DslServices)Preconditions.checkNotNull((Object)dslServices2);
        this.sdkComponents = sdkComponents2;
        this.avdComponents = avdComponents;
        this.toolingRegistry = (ToolingModelBuilderRegistry)Preconditions.checkNotNull((Object)toolingRegistry);
        this.optionalCompilationSteps = (Set)Preconditions.checkNotNull(dslServices2.getProjectOptions().getOptionalCompilationSteps());
        this.messageReceiver = messageReceiver;
        this.componentFactory = componentFactory;
        this.globalArtifacts = new ArtifactsImpl(project2, "global");
        this.lintChecks = project2.getConfigurations().detachedConfiguration(new Dependency[0]);
        this.dataBindingBuilder = new DataBindingBuilder();
        this.dataBindingBuilder.setPrintMachineReadableOutput(SyncOptions.getErrorFormatMode(dslServices2.getProjectOptions()) == SyncOptions.ErrorFormatMode.MACHINE_PARSABLE);
    }

    public void setExtension(BaseExtension extension) {
        this.extension = (BaseExtension)Preconditions.checkNotNull((Object)extension);
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public BaseExtension getExtension() {
        return this.extension;
    }

    public DataBindingBuilder getDataBindingBuilder() {
        return this.dataBindingBuilder;
    }

    public Provider<SdkComponentsBuildService> getSdkComponents() {
        return this.sdkComponents;
    }

    public Provider<AvdComponentsBuildService> getAvdComponents() {
        return this.avdComponents;
    }

    public ToolingModelBuilderRegistry getToolingRegistry() {
        return this.toolingRegistry;
    }

    public boolean isActive(OptionalCompilationStep step) {
        return this.optionalCompilationSteps.contains(step);
    }

    public void setLintChecks(Configuration lintChecks) {
        this.lintChecks = lintChecks;
    }

    public void setLintPublish(Configuration lintPublish) {
        this.lintPublish = lintPublish;
    }

    public void setAndroidJarConfig(Configuration androidJarConfig) {
        this.androidJarConfig = androidJarConfig;
    }

    public FileCollection getMockableJarArtifact() {
        return this.getMockableJarArtifact(this.getExtension().getTestOptions().getUnitTests().isReturnDefaultValues());
    }

    public FileCollection getMockableJarArtifact(boolean returnDefaultValues) {
        Preconditions.checkNotNull((Object)this.androidJarConfig);
        Action attributes = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)"android-mockable-jar").attribute(AndroidArtifacts.MOCKABLE_JAR_RETURN_DEFAULT_VALUES, (Object)returnDefaultValues);
        return this.androidJarConfig.getIncoming().artifactView(config2 -> config2.attributes(attributes)).getArtifacts().getArtifactFiles();
    }

    public FileCollection getPlatformAttrs() {
        Preconditions.checkNotNull((Object)this.androidJarConfig);
        Action attributes = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)"android-platform-attr");
        return this.androidJarConfig.getIncoming().artifactView(config2 -> config2.attributes(attributes)).getArtifacts().getArtifactFiles();
    }

    @Deprecated
    public DslServices getDslServices() {
        return this.dslServices;
    }

    public MessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    public FileCollection getLocalCustomLintChecks() {
        return CustomLintCheckUtils.getLocalCustomLintChecks(this.lintChecks);
    }

    public FileCollection getPublishedCustomLintChecks() {
        Action attributes = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
        return this.lintPublish.getIncoming().artifactView(config2 -> config2.attributes(attributes)).getArtifacts().getArtifactFiles();
    }

    public ArtifactsImpl getGlobalArtifacts() {
        return this.globalArtifacts;
    }

    public boolean hasDynamicFeatures() {
        BaseExtension extension = this.getExtension();
        if (extension instanceof BaseAppModuleExtension) {
            return !((BaseAppModuleExtension)extension).getDynamicFeatures().isEmpty();
        }
        return false;
    }

    public synchronized Provider<List<RegularFile>> getBootClasspath() {
        if (this.bootClasspath == null) {
            ListProperty classpath = this.project.getObjects().listProperty(RegularFile.class);
            classpath.addAll(this.getFilteredBootClasspath());
            if (this.extension.getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
                classpath.add(this.getVersionedSdkLoader().flatMap(SdkComponentsBuildService.VersionedSdkLoader::getCoreLambdaStubsProvider));
            }
            this.bootClasspath = classpath;
        }
        return this.bootClasspath;
    }

    @VisibleForTesting
    public synchronized void setBootClasspath(Provider<List<RegularFile>> classpath) {
        this.bootClasspath = classpath;
    }

    public synchronized Provider<List<RegularFile>> getFilteredBootClasspath() {
        if (this.filteredBootClasspath == null) {
            Provider<SdkComponentsBuildService.VersionedSdkLoader> versionedSdkLoader = this.getVersionedSdkLoader();
            this.filteredBootClasspath = this.project.getObjects().listProperty(RegularFile.class);
            this.filteredBootClasspath.addAll(BootClasspathBuilder.INSTANCE.computeClasspath(this.project.getLayout(), this.project.getProviders(), this.project.getObjects(), this.getDslServices().getIssueReporter(), (Provider<List<File>>)versionedSdkLoader.flatMap(SdkComponentsBuildService.VersionedSdkLoader::getTargetBootClasspathProvider), (Provider<AndroidVersion>)versionedSdkLoader.flatMap(SdkComponentsBuildService.VersionedSdkLoader::getTargetAndroidVersionProvider), (Provider<List<OptionalLibrary>>)versionedSdkLoader.flatMap(SdkComponentsBuildService.VersionedSdkLoader::getAdditionalLibrariesProvider), (Provider<List<OptionalLibrary>>)versionedSdkLoader.flatMap(SdkComponentsBuildService.VersionedSdkLoader::getOptionalLibrariesProvider), (Provider<File>)versionedSdkLoader.flatMap(SdkComponentsBuildService.VersionedSdkLoader::getAnnotationsJarProvider), false, (List<LibraryRequest>)ImmutableList.copyOf(this.getExtension().getLibraryRequests())));
        }
        return this.filteredBootClasspath;
    }

    public synchronized Provider<SdkComponentsBuildService.VersionedSdkLoader> getVersionedSdkLoader() {
        if (this.versionedSdkLoader == null) {
            this.versionedSdkLoader = this.getSdkComponents().map(sdkComponentsBuildService -> sdkComponentsBuildService.sdkLoader((Provider<String>)this.project.provider(this.extension::getCompileSdkVersion), (Provider<Revision>)this.project.provider(this.extension::getBuildToolsRevision)));
        }
        return this.versionedSdkLoader;
    }

    public FileCollection getFullBootClasspath() {
        return this.project.files(new Object[]{this.getFullBootClasspathProvider().get()});
    }

    public Provider<List<RegularFile>> getFullBootClasspathProvider() {
        return BootClasspathBuilder.INSTANCE.computeClasspath(this.project.getLayout(), this.project.getProviders(), this.project.getObjects(), this.getDslServices().getIssueReporter(), (Provider<List<File>>)this.getVersionedSdkLoader().flatMap(SdkComponentsBuildService.VersionedSdkLoader::getTargetBootClasspathProvider), (Provider<AndroidVersion>)this.getVersionedSdkLoader().flatMap(SdkComponentsBuildService.VersionedSdkLoader::getTargetAndroidVersionProvider), (Provider<List<OptionalLibrary>>)this.getVersionedSdkLoader().flatMap(SdkComponentsBuildService.VersionedSdkLoader::getAdditionalLibrariesProvider), (Provider<List<OptionalLibrary>>)this.getVersionedSdkLoader().flatMap(SdkComponentsBuildService.VersionedSdkLoader::getOptionalLibrariesProvider), (Provider<File>)this.getVersionedSdkLoader().flatMap(SdkComponentsBuildService.VersionedSdkLoader::getAnnotationsJarProvider), true, (List<LibraryRequest>)ImmutableList.of());
    }

    public SoftwareComponentFactory getComponentFactory() {
        return this.componentFactory;
    }
}

