/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.process;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.process.ChunkBytesToLineOutputStream;
import com.android.build.gradle.internal.cxx.process.ClangMessageCategoryKt;
import com.android.build.gradle.internal.cxx.process.DefaultProcessOutput;
import com.android.build.gradle.internal.cxx.process.DefaultProcessOutputHandler;
import com.android.build.gradle.internal.cxx.process.MultiplexingOutputStream;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0016R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/cxx/process/DefaultProcessOutputHandler;", "Lcom/android/ide/common/process/ProcessOutputHandler;", "stderrFile", "Ljava/io/File;", "stdoutFile", "logPrefix", "", "logStderr", "", "logStdout", "logFullStdout", "(Ljava/io/File;Ljava/io/File;Ljava/lang/String;ZZZ)V", "ninjaDirectoryLine", "stderr", "Ljava/io/FileOutputStream;", "getStderr", "()Ljava/io/FileOutputStream;", "setStderr", "(Ljava/io/FileOutputStream;)V", "stdout", "getStdout", "setStdout", "createOutput", "Lcom/android/ide/common/process/ProcessOutput;", "handleOutput", "", "processOutput", "gradle-core"})
public final class DefaultProcessOutputHandler
implements ProcessOutputHandler {
    @NotNull
    private final File stderrFile;
    @NotNull
    private final File stdoutFile;
    @NotNull
    private final String logPrefix;
    private final boolean logStderr;
    private final boolean logStdout;
    private final boolean logFullStdout;
    @Nullable
    private FileOutputStream stderr;
    @Nullable
    private FileOutputStream stdout;
    @Nullable
    private String ninjaDirectoryLine;

    public DefaultProcessOutputHandler(@NotNull File stderrFile, @NotNull File stdoutFile, @NotNull String logPrefix, boolean logStderr, boolean logStdout, boolean logFullStdout) {
        Intrinsics.checkNotNullParameter((Object)stderrFile, (String)"stderrFile");
        Intrinsics.checkNotNullParameter((Object)stdoutFile, (String)"stdoutFile");
        Intrinsics.checkNotNullParameter((Object)logPrefix, (String)"logPrefix");
        this.stderrFile = stderrFile;
        this.stdoutFile = stdoutFile;
        this.logPrefix = logPrefix;
        this.logStderr = logStderr;
        this.logStdout = logStdout;
        this.logFullStdout = logFullStdout;
    }

    @Nullable
    public final FileOutputStream getStderr() {
        return this.stderr;
    }

    public final void setStderr(@Nullable FileOutputStream fileOutputStream) {
        this.stderr = fileOutputStream;
    }

    @Nullable
    public final FileOutputStream getStdout() {
        return this.stdout;
    }

    public final void setStdout(@Nullable FileOutputStream fileOutputStream) {
        this.stdout = fileOutputStream;
    }

    @NotNull
    public ProcessOutput createOutput() {
        FileOutputStream singleStderr = new FileOutputStream(this.stderrFile, true);
        FileOutputStream singleStdout = new FileOutputStream(this.stdoutFile, true);
        Object[] objectArray = new OutputStream[]{singleStderr};
        List stderrReceivers = CollectionsKt.mutableListOf((Object[])objectArray);
        Object[] objectArray2 = new OutputStream[]{singleStdout};
        List stdoutReceivers = CollectionsKt.mutableListOf((Object[])objectArray2);
        if (this.logStderr) {
            stderrReceivers.add(new ChunkBytesToLineOutputStream(this.logPrefix, createOutput.1.INSTANCE, 0, 4, null));
        }
        if (this.logStdout) {
            stdoutReceivers.add(new ChunkBytesToLineOutputStream(this.logPrefix, (Function1)new Function1<String, Unit>(this){
                final /* synthetic */ DefaultProcessOutputHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String line) {
                    Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                    if (ClangMessageCategoryKt.isNinjaWorkingDirectoryLine(line)) {
                        DefaultProcessOutputHandler.access$setNinjaDirectoryLine$p(this.this$0, line);
                    }
                    if (DefaultProcessOutputHandler.access$getLogFullStdout$p(this.this$0)) {
                        LoggingEnvironmentKt.lifecycleln(line, new Object[0]);
                    } else if (ClangMessageCategoryKt.shouldElevateToLifeCycle(line)) {
                        String string = DefaultProcessOutputHandler.access$getNinjaDirectoryLine$p(this.this$0);
                        if (string != null) {
                            String string2 = string;
                            DefaultProcessOutputHandler defaultProcessOutputHandler = this.this$0;
                            boolean bl = false;
                            boolean bl2 = false;
                            String ninjaDirectoryLine = string2;
                            boolean bl3 = false;
                            LoggingEnvironmentKt.lifecycleln(ninjaDirectoryLine, new Object[0]);
                            DefaultProcessOutputHandler.access$setNinjaDirectoryLine$p(defaultProcessOutputHandler, null);
                        }
                        LoggingEnvironmentKt.lifecycleln(line, new Object[0]);
                    }
                }
            }, 0, 4, null));
        }
        return new DefaultProcessOutput(singleStderr, singleStdout, new MultiplexingOutputStream(stdoutReceivers), new MultiplexingOutputStream(stderrReceivers));
    }

    public void handleOutput(@NotNull ProcessOutput processOutput) {
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        if (this.stdout != null) {
            throw new RuntimeException("Multiple calls");
        }
        DefaultProcessOutput output2 = (DefaultProcessOutput)processOutput;
        this.stderr = output2.getStderr();
        this.stdout = output2.getStdout();
    }

    public static final /* synthetic */ void access$setNinjaDirectoryLine$p(DefaultProcessOutputHandler $this, String string) {
        $this.ninjaDirectoryLine = string;
    }

    public static final /* synthetic */ boolean access$getLogFullStdout$p(DefaultProcessOutputHandler $this) {
        return $this.logFullStdout;
    }

    public static final /* synthetic */ String access$getNinjaDirectoryLine$p(DefaultProcessOutputHandler $this) {
        return $this.ninjaDirectoryLine;
    }
}

