/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.build;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.attribution.AttributionStructuredLogCodecKt;
import com.android.build.gradle.internal.cxx.attribution.BuildAttributionUtilsKt;
import com.android.build.gradle.internal.cxx.attribution.BuildTaskAttributions;
import com.android.build.gradle.internal.cxx.build.CxxBuilder;
import com.android.build.gradle.internal.cxx.build.CxxRegularBuilder;
import com.android.build.gradle.internal.cxx.build.CxxRegularBuilderKt;
import com.android.build.gradle.internal.cxx.caching.CxxBuildCache;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.process.ProcessOutputJunctionKt;
import com.android.build.gradle.internal.cxx.settings.BuildSettingsConfiguration;
import com.android.build.gradle.internal.cxx.settings.BuildSettingsFactoryKt;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.utils.FileUtils;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.protobuf.GeneratedMessageV3;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.internal.hash.FileHasher;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u0000 -2\u00020\u0001:\u0002,-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J&\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020)0&2\u0006\u0010*\u001a\u00020\bH\u0002J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006.\u00b2\u0006\u0012\u0010/\u001a\n 1*\u0004\u0018\u00010000X\u008a\u0084\u0002"}, d2={"Lcom/android/build/gradle/internal/cxx/build/CxxRegularBuilder;", "Lcom/android/build/gradle/internal/cxx/build/CxxBuilder;", "abi", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "(Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;)V", "getAbi", "()Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "nativeBuildConfigValueMini", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValueMini;", "getNativeBuildConfigValueMini", "()Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValueMini;", "objFolder", "Ljava/io/File;", "getObjFolder", "()Ljava/io/File;", "soFolder", "getSoFolder", "variant", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "getVariant", "()Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "applyBuildSettings", "", "buildSettings", "Lcom/android/build/gradle/internal/cxx/settings/BuildSettingsConfiguration;", "processBuilder", "Lcom/android/ide/common/process/ProcessInfoBuilder;", "build", "ops", "Lorg/gradle/process/ExecOperations;", "fileHasher", "Lorg/gradle/internal/hash/FileHasher;", "buildCacheController", "Lorg/gradle/caching/internal/controller/BuildCacheController;", "executeProcessBatch", "buildCache", "Lcom/android/build/gradle/internal/cxx/caching/CxxBuildCache;", "buildSteps", "", "Lcom/android/build/gradle/internal/cxx/build/CxxRegularBuilder$BuildStep;", "findLibrariesToBuild", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValueMini;", "config", "verifyTargetExists", "BuildStep", "Companion", "gradle-core", "attributions", "Lcom/android/build/gradle/internal/cxx/attribution/BuildTaskAttributions;", "kotlin.jvm.PlatformType"})
public final class CxxRegularBuilder
implements CxxBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CxxAbiModel abi;
    @NotNull
    public static final String BUILD_TARGETS_PLACEHOLDER = "{LIST_OF_TARGETS_TO_BUILD}";

    public CxxRegularBuilder(@NotNull CxxAbiModel abi) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        this.abi = abi;
    }

    @NotNull
    public final CxxAbiModel getAbi() {
        return this.abi;
    }

    @Override
    @NotNull
    public File getObjFolder() {
        return CxxAbiModelKt.getObjFolder(this.abi);
    }

    @Override
    @NotNull
    public File getSoFolder() {
        return this.abi.getSoFolder();
    }

    private final CxxVariantModel getVariant() {
        return this.abi.getVariant();
    }

    private final NativeBuildConfigValueMini getNativeBuildConfigValueMini() {
        NativeBuildConfigValueMini nativeBuildConfigValueMini = AndroidBuildGradleJsons.getNativeBuildMiniConfig(this.abi, null);
        Intrinsics.checkNotNullExpressionValue((Object)nativeBuildConfigValueMini, (String)"getNativeBuildMiniConfig(abi, null)");
        return nativeBuildConfigValueMini;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void build(@NotNull ExecOperations ops2, @NotNull FileHasher fileHasher, @NotNull BuildCacheController buildCacheController) {
        String[] stringArray;
        String $this$forEach$iv$iv$iv;
        List<String> $this$mapNotNullTo$iv$iv222;
        Object destination$iv$iv;
        Object object;
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)ops2, (String)"ops");
        Intrinsics.checkNotNullParameter((Object)fileHasher, (String)"fileHasher");
        Intrinsics.checkNotNullParameter((Object)buildCacheController, (String)"buildCacheController");
        LoggingEnvironmentKt.infoln("starting build", new Object[0]);
        LoggingEnvironmentKt.infoln("reading expected JSONs", new Object[0]);
        NativeBuildConfigValueMini config2 = this.getNativeBuildConfigValueMini();
        LoggingEnvironmentKt.infoln("done reading expected JSONs", new Object[0]);
        Set<String> targets = this.getVariant().getBuildTargetSet();
        if (targets.isEmpty()) {
            LoggingEnvironmentKt.infoln("executing build commands for targets that produce .so files or executables", new Object[0]);
        } else {
            this.verifyTargetExists(config2);
        }
        CxxBuildCache buildCache = new CxxBuildCache(buildCacheController, fileHasher);
        ArrayList buildSteps = Lists.newArrayList();
        LoggingEnvironmentKt.infoln("evaluate miniconfig", new Object[0]);
        if (config2.libraries.isEmpty()) {
            LoggingEnvironmentKt.infoln("no libraries", new Object[0]);
            return;
        }
        List<NativeLibraryValueMini> librariesToBuild = this.findLibrariesToBuild(config2);
        if (librariesToBuild.isEmpty()) {
            LoggingEnvironmentKt.infoln("no libraries to build", new Object[0]);
            return;
        }
        List<String> list = config2.buildTargetsCommandComponents;
        if (list == null) {
            bl = null;
        } else {
            object = list;
            boolean bl2 = false;
            bl = !object.isEmpty();
        }
        if (Intrinsics.areEqual(bl, (Object)true)) {
            void $this$mapNotNull$iv;
            object = librariesToBuild;
            boolean $i$f$mapNotNull22 = false;
            void var12_15 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv222;
            boolean $i$f$forEach = false;
            stringArray = $this$forEach$iv$iv$iv.iterator();
            while (stringArray.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = stringArray.next();
                boolean bl3 = false;
                NativeLibraryValueMini library = (NativeLibraryValueMini)element$iv$iv;
                boolean bl4 = false;
                if (library.artifactName == null) continue;
                boolean bl5 = false;
                boolean bl6 = false;
                String it$iv$iv = string;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List artifactNames = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
            $this$mapNotNullTo$iv$iv222 = config2.buildTargetsCommandComponents;
            Intrinsics.checkNotNull($this$mapNotNullTo$iv$iv222);
            Object $i$f$mapNotNull22 = $this$mapNotNullTo$iv$iv222;
            List buildTargetsCommand = CxxRegularBuilder.Companion.substituteBuildTargetsCommand($i$f$mapNotNull22, artifactNames);
            Set<String> set = this.getVariant().getBuildTargetSet();
            $i$f$mapNotNull22 = CxxAbiModelKt.getJsonFile(this.abi).getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapNotNull22, (String)"abi.jsonFile.parentFile");
            buildSteps.add(new BuildStep(this.abi, buildTargetsCommand, librariesToBuild, set, (File)$i$f$mapNotNull22));
            LoggingEnvironmentKt.infoln(Intrinsics.stringPlus((String)"about to build targets ", (Object)CollectionsKt.joinToString$default((Iterable)artifactNames, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)), new Object[0]);
        } else {
            for (NativeLibraryValueMini libraryValue : librariesToBuild) {
                List<String> $i$f$mapNotNull22;
                $this$mapNotNullTo$iv$iv222 = libraryValue.buildCommandComponents;
                Intrinsics.checkNotNull($this$mapNotNullTo$iv$iv222);
                List<String> list2 = $i$f$mapNotNull22 = $this$mapNotNullTo$iv$iv222;
                List list3 = CollectionsKt.listOf((Object)libraryValue);
                Set<String> set = this.getVariant().getBuildTargetSet();
                $i$f$mapNotNull22 = CxxAbiModelKt.getJsonFile(this.abi).getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapNotNull22, (String)"abi.jsonFile.parentFile");
                buildSteps.add(new BuildStep(this.abi, list2, list3, set, (File)((Object)$i$f$mapNotNull22)));
                $this$mapNotNullTo$iv$iv222 = libraryValue.buildCommandComponents;
                Intrinsics.checkNotNull($this$mapNotNullTo$iv$iv222);
                $i$f$mapNotNull22 = $this$mapNotNullTo$iv$iv222;
                LoggingEnvironmentKt.infoln(Intrinsics.stringPlus((String)"about to build ", (Object)CollectionsKt.joinToString$default((Iterable)$i$f$mapNotNull22, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)), new Object[0]);
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)buildSteps, (String)"buildSteps");
        this.executeProcessBatch(buildCache, ops2, buildSteps);
        LoggingEnvironmentKt.infoln("check expected build outputs", new Object[0]);
        for (NativeLibraryValueMini library : config2.libraries.values()) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)library.artifactName) ? 1 : 0) != 0);
            Collection $i$f$mapNotNull22 = targets;
            boolean $this$mapNotNullTo$iv$iv222 = false;
            if (!$i$f$mapNotNull22.isEmpty() && !CollectionsKt.contains((Iterable)targets, (Object)library.artifactName) || buildSteps.stream().noneMatch((Predicate)new Predicate<BuildStep>(library){
                final /* synthetic */ NativeLibraryValueMini $library;
                {
                    this.$library = $library;
                }

                public final boolean test(BuildStep step) {
                    return step.getLibraries().contains(this.$library);
                }
            }) || (destination$iv$iv = library.output) == null) continue;
            Object $this$mapNotNullTo$iv$iv222 = destination$iv$iv;
            Object output2 = $this$mapNotNullTo$iv$iv222;
            if (!((File)output2).exists()) {
                throw new GradleException("Expected output file at " + output2 + " for target " + library.artifactName + " but there was none");
            }
            if (library.abi == null) {
                throw new GradleException("Expected NativeLibraryValue to have non-null abi");
            }
            $this$forEach$iv$iv$iv = library.abi;
            Intrinsics.checkNotNull((Object)$this$forEach$iv$iv$iv);
            Object object2 = Abi.getByName($this$forEach$iv$iv$iv);
            if (object2 == null) {
                throw new RuntimeException(Intrinsics.stringPlus((String)"Unknown ABI seen ", (Object)library.abi));
            }
            Object abi = destination$iv$iv = object2;
            object2 = new String[]{((Abi)((Object)abi)).getTag(), ((File)output2).getName()};
            File expectedOutputFile = FileUtils.join((File)this.getVariant().getSoFolder(), (String[])object2);
            if (!FileUtils.isSameFile((File)output2, (File)expectedOutputFile)) {
                LoggingEnvironmentKt.infoln("external build set its own library output location for '" + ((File)output2).getName() + "', hard link or copy to expected location", new Object[0]);
                if (expectedOutputFile.getParentFile().mkdirs()) {
                    LoggingEnvironmentKt.infoln(Intrinsics.stringPlus((String)"created folder ", (Object)expectedOutputFile.getParentFile()), new Object[0]);
                }
                Intrinsics.checkNotNullExpressionValue((Object)expectedOutputFile, (String)"expectedOutputFile");
                CxxRegularBuilderKt.hardLinkOrCopy((File)output2, expectedOutputFile);
            }
            for (File runtimeFile : library.runtimeFiles) {
                stringArray = new String[]{((Abi)((Object)abi)).getTag(), runtimeFile.getName()};
                File dest = FileUtils.join((File)this.getVariant().getSoFolder(), (String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)runtimeFile, (String)"runtimeFile");
                Intrinsics.checkNotNullExpressionValue((Object)dest, (String)"dest");
                CxxRegularBuilderKt.hardLinkOrCopy(runtimeFile, dest);
            }
        }
        if (!this.abi.getSoFolder().isDirectory()) {
            LoggingEnvironmentKt.infoln("didn't copy STL file to " + this.abi.getSoFolder() + " because that folder wasn't created by the build ", new Object[0]);
        } else if (this.abi.getStlLibraryFile() != null && this.abi.getStlLibraryFile().isFile()) {
            File file = this.abi.getSoFolder();
            object = this.abi.getStlLibraryFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"abi.stlLibraryFile.name");
            File objAbi = FilesKt.resolve((File)file, (String)object);
            CxxRegularBuilderKt.hardLinkOrCopy(this.abi.getStlLibraryFile(), objAbi);
        }
        LoggingEnvironmentKt.infoln("build complete", new Object[0]);
    }

    private final void verifyTargetExists(NativeBuildConfigValueMini config2) {
        Set<String> targets = this.getVariant().getBuildTargetSet();
        LoggingEnvironmentKt.infoln("executing build commands for targets: '" + Joiner.on((String)", ").join((Iterable)targets) + '\'', new Object[0]);
        HashSet matchingTargets = Sets.newHashSet();
        HashSet unmatchedTargets = Sets.newHashSet();
        for (NativeLibraryValueMini libraryValue : config2.libraries.values()) {
            if (CollectionsKt.contains((Iterable)targets, (Object)libraryValue.artifactName)) {
                matchingTargets.add(libraryValue.artifactName);
                continue;
            }
            unmatchedTargets.add(libraryValue.artifactName);
        }
        for (String target : targets) {
            if (matchingTargets.contains(target)) continue;
            throw new GradleException("Unexpected native build target " + target + ". Valid values are: " + Joiner.on((String)", ").join((Iterable)unmatchedTargets));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final List<NativeLibraryValueMini> findLibrariesToBuild(NativeBuildConfigValueMini config) {
        librariesToBuild = Lists.newArrayList();
        targets = this.getVariant().getBuildTargetSet();
        implicitTargets = CollectionsKt.toMutableSet((Iterable)this.getVariant().getImplicitBuildTargetSet());
        block10: for (NativeLibraryValueMini libraryValue : config.libraries.values()) {
            block20: {
                block21: {
                    LoggingEnvironmentKt.infoln("evaluate library " + libraryValue.artifactName + " (" + libraryValue.abi + ')', new Object[0]);
                    var7_8 = (List<String>)targets;
                    var8_10 = false;
                    if (var7_8.isEmpty() == false && !CollectionsKt.contains((Iterable)targets, (Object)libraryValue.artifactName)) {
                        v0 = new StringBuilder().append("not building target ");
                        var7_8 = libraryValue.artifactName;
                        Intrinsics.checkNotNull(var7_8);
                        LoggingEnvironmentKt.infoln(v0.append((String)var7_8).append(" because it isn't in targets set").toString(), new Object[0]);
                        continue;
                    }
                    var7_8 = config.buildTargetsCommandComponents;
                    if (!Intrinsics.areEqual((Object)(var7_8 == null ? null : Boolean.valueOf(var7_8.isEmpty())), (Object)false) && !Intrinsics.areEqual((Object)((var7_8 = libraryValue.buildCommandComponents) == null ? null : Boolean.valueOf(var7_8.isEmpty())), (Object)false)) {
                        v1 = new StringBuilder().append("not building target ");
                        var7_8 = libraryValue.artifactName;
                        Intrinsics.checkNotNull((Object)var7_8);
                        LoggingEnvironmentKt.infoln(v1.append((String)var7_8).append(" because there was no buildCommandComponents for the target, nor a buildTargetsCommandComponents for the config").toString(), new Object[0]);
                        continue;
                    }
                    if (!targets.isEmpty()) break block20;
                    output = libraryValue.output;
                    if (output == null) {
                        v2 = new StringBuilder().append("not building target ");
                        var8_11 = libraryValue.artifactName;
                        Intrinsics.checkNotNull((Object)var8_11);
                        LoggingEnvironmentKt.infoln(v2.append(var8_11).append(" because no targets are specified and library build output file is null").toString(), new Object[0]);
                        continue;
                    }
                    if (!CollectionsKt.contains((Iterable)this.getVariant().getImplicitBuildTargetSet(), (Object)libraryValue.artifactName)) break block21;
                    LoggingEnvironmentKt.infoln("building target " + libraryValue.artifactName + " because it is required by the build", new Object[0]);
                    break block20;
                }
                var8_12 = Files.getFileExtension((String)output.getName());
                if (var8_12 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var8_12.hashCode()) {
                    case 0: {
                        if (var8_12.equals("")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 97: {
                        if (var8_12.equals("a")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 3676: {
                        if (var8_12.equals("so")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 2: {
                        v3 = new StringBuilder().append("not building target library ");
                        var9_14 = libraryValue.artifactName;
                        Intrinsics.checkNotNull((Object)var9_14);
                        LoggingEnvironmentKt.infoln(v3.append(var9_14).append(" because static libraries are not build by default.").toString(), new Object[0]);
                        continue block10;
                    }
                    case 3: {
                        v4 = new StringBuilder().append("building target library ");
                        var9_14 = libraryValue.artifactName;
                        Intrinsics.checkNotNull((Object)var9_14);
                        LoggingEnvironmentKt.infoln(v4.append(var9_14).append(" because no targets are specified.").toString(), new Object[0]);
                        break;
                    }
                    case 1: {
                        v5 = new StringBuilder().append("building target executable ");
                        var9_14 = libraryValue.artifactName;
                        Intrinsics.checkNotNull((Object)var9_14);
                        LoggingEnvironmentKt.infoln(v5.append(var9_14).append(" because no targets are specified.").toString(), new Object[0]);
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        v6 = new StringBuilder().append("not building target ");
                        var9_14 = libraryValue.artifactName;
                        Intrinsics.checkNotNull((Object)var9_14);
                        LoggingEnvironmentKt.infoln(v6.append(var9_14).append(" because the type cannot be determined.").toString(), new Object[0]);
                        continue block10;
                    }
                }
            }
            librariesToBuild.add(libraryValue);
        }
        var5_5 = implicitTargets;
        Intrinsics.checkNotNullExpressionValue((Object)librariesToBuild, (String)"librariesToBuild");
        $this$map$iv = librariesToBuild;
        $i$f$map = false;
        var8_13 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var13_18 = (NativeLibraryValueMini)item$iv$iv;
            var15_20 = destination$iv$iv;
            $i$a$-map-CxxRegularBuilder$findLibrariesToBuild$1 = false;
            var16_21 = it.artifactName;
            var15_20.add(var16_21);
        }
        var6_6 = (List)destination$iv$iv;
        var7_9 = false;
        v7 = var5_5;
        if (v7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        TypeIntrinsics.asMutableCollection((Object)v7).removeAll(var6_6);
        var5_5 = implicitTargets;
        var6_7 = false;
        if (var5_5.isEmpty() == false) {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.REQUIRED_BUILD_TARGETS_MISSING, Intrinsics.stringPlus((String)"did not find implicitly required targets: ", (Object)CollectionsKt.joinToString$default((Iterable)implicitTargets, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)), new Object[0]);
        }
        return librariesToBuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeProcessBatch(CxxBuildCache buildCache, ExecOperations ops2, List<BuildStep> buildSteps) {
        for (BuildStep buildStep : buildSteps) {
            int n;
            List<String> tokens = buildStep.getBuildCommandComponents();
            ProcessInfoBuilder processBuilder = new ProcessInfoBuilder();
            processBuilder.setExecutable(tokens.get(0));
            int n2 = 1;
            int n3 = tokens.size();
            if (n2 < n3) {
                do {
                    int i2 = n2++;
                    processBuilder.addArgs(tokens.get(i2));
                } while (n2 < n3);
            }
            LoggingEnvironmentKt.infoln(String.valueOf(processBuilder), new Object[0]);
            String logFileSuffix = null;
            String abiName = buildStep.getLibraries().get((int)0).abi;
            CxxAbiModel abi = buildStep.getAbi();
            if (buildStep.getLibraries().size() > 1) {
                logFileSuffix = "targets";
                Stream stream2 = buildStep.getLibraries().stream().map(executeProcessBatch.targetNames.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(stream2, (String)"buildStep\n                    .libraries\n                    .stream()\n                    .map { library -> library.artifactName + \"_\" + library.abi }");
                List targetNames2 = StreamsKt.toList(stream2);
                LoggingEnvironmentKt.infoln(Intrinsics.stringPlus((String)"Build multiple targets ", (Object)CollectionsKt.joinToString$default((Iterable)targetNames2, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)), new Object[0]);
            } else {
                Preconditions.checkElementIndex((int)0, (int)buildStep.getLibraries().size());
                logFileSuffix = buildStep.getLibraries().get((int)0).artifactName + '_' + abiName;
                LoggingEnvironmentKt.infoln(Intrinsics.stringPlus((String)"Build ", (Object)logFileSuffix), new Object[0]);
            }
            this.applyBuildSettings(abi.getBuildSettings(), processBuilder);
            long buildStartTime = Clock.systemUTC().millis();
            if (CxxAbiModelKt.getNinjaLogFile(abi).isFile()) {
                File $this$useLines$iv = CxxAbiModelKt.getNinjaLogFile(abi);
                Charset charset$iv = Charsets.UTF_8;
                boolean $i$f$useLines = false;
                Object object = $this$useLines$iv;
                int n4 = 8192;
                boolean bl = false;
                Object object2 = object;
                boolean bl2 = false;
                Object object3 = object2;
                boolean bl3 = false;
                object3 = new FileInputStream((File)object3);
                bl3 = false;
                object2 = new InputStreamReader((InputStream)object3, charset$iv);
                bl2 = false;
                object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n4);
                n4 = 0;
                bl = false;
                Throwable throwable = null;
                try {
                    BufferedReader it$iv = (BufferedReader)object;
                    boolean bl4 = false;
                    Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl5 = false;
                    int n5 = SequencesKt.count((Sequence)it);
                    n = n5;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            } else {
                n = 0;
            }
            int linesToSkip = n;
            buildCache.cacheBuild(abi, buildStep.getTargetsFromDsl(), (Function0<Unit>)((Function0)new Function0<Unit>(buildStep, logFileSuffix, processBuilder, abi, ops2){
                final /* synthetic */ BuildStep $buildStep;
                final /* synthetic */ String $logFileSuffix;
                final /* synthetic */ ProcessInfoBuilder $processBuilder;
                final /* synthetic */ CxxAbiModel $abi;
                final /* synthetic */ ExecOperations $ops;
                {
                    this.$buildStep = $buildStep;
                    this.$logFileSuffix = $logFileSuffix;
                    this.$processBuilder = $processBuilder;
                    this.$abi = $abi;
                    this.$ops = $ops;
                    super(0);
                }

                public final void invoke() {
                    Boolean bl;
                    ProcessOutputJunctionKt.createProcessOutputJunction(FilesKt.resolve((File)this.$buildStep.getOutputFolder(), (String)("android_gradle_build_command_" + this.$logFileSuffix + ".txt")), FilesKt.resolve((File)this.$buildStep.getOutputFolder(), (String)("android_gradle_build_stdout_" + this.$logFileSuffix + ".txt")), FilesKt.resolve((File)this.$buildStep.getOutputFolder(), (String)("android_gradle_build_stderr_" + this.$logFileSuffix + ".txt")), this.$processBuilder, "").logStderr().logStdout().logFullStdout((bl = (Boolean)CxxAbiModelKt.ifLogNativeBuildToLifecycle(this.$abi, executeProcessBatch.1.INSTANCE)) == null ? false : bl).execute((Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult>)((Function1)new Function1<Action<? super ExecSpec>, ExecResult>(this.$ops){

                        public final ExecResult invoke(Action<? super ExecSpec> p0) {
                            return ((ExecOperations)this.receiver).exec(p0);
                        }
                    }));
                }
            }));
            CxxAbiModelKt.ifCMake(abi, (Function0)new Function0<Unit>(abi, linesToSkip, buildStartTime, buildStep){
                final /* synthetic */ CxxAbiModel $abi;
                final /* synthetic */ int $linesToSkip;
                final /* synthetic */ long $buildStartTime;
                final /* synthetic */ BuildStep $buildStep;
                {
                    this.$abi = $abi;
                    this.$linesToSkip = $linesToSkip;
                    this.$buildStartTime = $buildStartTime;
                    this.$buildStep = $buildStep;
                    super(0);
                }

                public final void invoke() {
                    Lazy attributions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BuildTaskAttributions>(this.$abi, this.$linesToSkip, this.$buildStartTime, this.$buildStep){
                        final /* synthetic */ CxxAbiModel $abi;
                        final /* synthetic */ int $linesToSkip;
                        final /* synthetic */ long $buildStartTime;
                        final /* synthetic */ BuildStep $buildStep;
                        {
                            this.$abi = $abi;
                            this.$linesToSkip = $linesToSkip;
                            this.$buildStartTime = $buildStartTime;
                            this.$buildStep = $buildStep;
                            super(0);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final BuildTaskAttributions invoke() {
                            Collection<String> collection;
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            Iterable iterable = this.$buildStep.getLibraries();
                            BuildTaskAttributions.Builder builder = BuildAttributionUtilsKt.generateNinjaSourceFileAttribution(this.$abi, this.$linesToSkip, this.$buildStartTime).toBuilder();
                            boolean $i$f$map = false;
                            void var3_4 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                NativeLibraryValueMini nativeLibraryValueMini = (NativeLibraryValueMini)item$iv$iv;
                                collection = destination$iv$iv;
                                boolean bl = false;
                                String string = it.artifactName;
                                collection.add(string);
                            }
                            collection = (List)destination$iv$iv;
                            return builder.addAllLibrary((Iterable<String>)collection).build();
                        }
                    }));
                    File file = this.$abi.getVariant().getModule().getProject().getChromeTraceJsonFolder();
                    if (file != null) {
                        File file2 = file;
                        CxxAbiModel cxxAbiModel = this.$abi;
                        long l = this.$buildStartTime;
                        boolean bl = false;
                        boolean bl2 = false;
                        File traceFolder = file2;
                        boolean bl3 = false;
                        BuildTaskAttributions buildTaskAttributions = executeProcessBatch.2.invoke$lambda-0((Lazy<BuildTaskAttributions>)attributions$delegate);
                        Intrinsics.checkNotNullExpressionValue((Object)buildTaskAttributions, (String)"attributions");
                        BuildAttributionUtilsKt.generateChromeTrace(buildTaskAttributions, cxxAbiModel, l, traceFolder);
                    }
                    LoggingEnvironmentKt.logStructured((Function1<? super StringEncoder, ? extends GeneratedMessageV3>)((Function1)new Function1<StringEncoder, GeneratedMessageV3>((Lazy<BuildTaskAttributions>)attributions$delegate){
                        final /* synthetic */ Lazy<BuildTaskAttributions> $attributions$delegate;
                        {
                            this.$attributions$delegate = $attributions$delegate;
                            super(1);
                        }

                        @NotNull
                        public final GeneratedMessageV3 invoke(@NotNull StringEncoder encoder) {
                            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
                            BuildTaskAttributions buildTaskAttributions = executeProcessBatch.2.access$invoke$lambda-0(this.$attributions$delegate);
                            Intrinsics.checkNotNullExpressionValue((Object)buildTaskAttributions, (String)"attributions");
                            return AttributionStructuredLogCodecKt.encode(buildTaskAttributions, encoder);
                        }
                    }));
                }

                private static final BuildTaskAttributions invoke$lambda-0(Lazy<BuildTaskAttributions> $attributions$delegate) {
                    Lazy<BuildTaskAttributions> lazy = $attributions$delegate;
                    Object var2_2 = null;
                    boolean bl = false;
                    return (BuildTaskAttributions)lazy.getValue();
                }

                public static final /* synthetic */ BuildTaskAttributions access$invoke$lambda-0(Lazy $attributions$delegate) {
                    return executeProcessBatch.2.invoke$lambda-0((Lazy<BuildTaskAttributions>)$attributions$delegate);
                }

                static {
                }
            });
        }
    }

    private final void applyBuildSettings(BuildSettingsConfiguration buildSettings, ProcessInfoBuilder processBuilder) {
        processBuilder.addEnvironments(BuildSettingsFactoryKt.getEnvironmentVariableMap(buildSettings));
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/cxx/build/CxxRegularBuilder$BuildStep;", "", "abi", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "buildCommandComponents", "", "", "libraries", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValueMini;", "targetsFromDsl", "", "outputFolder", "Ljava/io/File;", "(Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;Ljava/util/List;Ljava/util/List;Ljava/util/Set;Ljava/io/File;)V", "getAbi", "()Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "getBuildCommandComponents", "()Ljava/util/List;", "getLibraries", "getOutputFolder", "()Ljava/io/File;", "getTargetsFromDsl", "()Ljava/util/Set;", "gradle-core"})
    private static final class BuildStep {
        @NotNull
        private final CxxAbiModel abi;
        @NotNull
        private final List<String> buildCommandComponents;
        @NotNull
        private final List<NativeLibraryValueMini> libraries;
        @NotNull
        private final Set<String> targetsFromDsl;
        @NotNull
        private final File outputFolder;

        public BuildStep(@NotNull CxxAbiModel abi, @NotNull List<String> buildCommandComponents, @NotNull List<? extends NativeLibraryValueMini> libraries, @NotNull Set<String> targetsFromDsl, @NotNull File outputFolder) {
            Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
            Intrinsics.checkNotNullParameter(buildCommandComponents, (String)"buildCommandComponents");
            Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
            Intrinsics.checkNotNullParameter(targetsFromDsl, (String)"targetsFromDsl");
            Intrinsics.checkNotNullParameter((Object)outputFolder, (String)"outputFolder");
            this.abi = abi;
            this.buildCommandComponents = buildCommandComponents;
            this.libraries = libraries;
            this.targetsFromDsl = targetsFromDsl;
            this.outputFolder = outputFolder;
        }

        @NotNull
        public final CxxAbiModel getAbi() {
            return this.abi;
        }

        @NotNull
        public final List<String> getBuildCommandComponents() {
            return this.buildCommandComponents;
        }

        @NotNull
        public final List<NativeLibraryValueMini> getLibraries() {
            return this.libraries;
        }

        @NotNull
        public final Set<String> getTargetsFromDsl() {
            return this.targetsFromDsl;
        }

        @NotNull
        public final File getOutputFolder() {
            return this.outputFolder;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/cxx/build/CxxRegularBuilder$Companion;", "", "()V", "BUILD_TARGETS_PLACEHOLDER", "", "substituteBuildTargetsCommand", "", "buildTargetsCommandComponents", "artifactNames", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> substituteBuildTargetsCommand(List<String> buildTargetsCommandComponents, List<String> artifactNames) {
            List list;
            Collection collection;
            block8: {
                void $this$takeLastWhile$iv;
                if (!buildTargetsCommandComponents.contains(CxxRegularBuilder.BUILD_TARGETS_PLACEHOLDER)) {
                    return buildTargetsCommandComponents;
                }
                List<String> $this$takeWhile$iv = buildTargetsCommandComponents;
                boolean $i$f$takeWhile = false;
                ArrayList list$iv = new ArrayList();
                for (Object t : $this$takeWhile$iv) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)CxxRegularBuilder.BUILD_TARGETS_PLACEHOLDER))) break;
                    list$iv.add(t);
                }
                $this$takeWhile$iv = buildTargetsCommandComponents;
                collection = CollectionsKt.plus((Collection)list$iv, (Iterable)artifactNames);
                boolean $i$f$takeLastWhile = false;
                if ($this$takeLastWhile$iv.isEmpty()) {
                    list = CollectionsKt.emptyList();
                } else {
                    ListIterator iterator$iv = $this$takeLastWhile$iv.listIterator($this$takeLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)CxxRegularBuilder.BUILD_TARGETS_PLACEHOLDER)) continue;
                        iterator$iv.next();
                        int expectedSize$iv = $this$takeLastWhile$iv.size() - iterator$iv.nextIndex();
                        if (expectedSize$iv == 0) {
                            list = CollectionsKt.emptyList();
                        } else {
                            ArrayList arrayList = new ArrayList(expectedSize$iv);
                            boolean bl2 = false;
                            boolean bl3 = false;
                            ArrayList $this$apply$iv = arrayList;
                            boolean bl4 = false;
                            while (iterator$iv.hasNext()) {
                                $this$apply$iv.add(iterator$iv.next());
                            }
                            list = arrayList;
                        }
                        break block8;
                    }
                    list = CollectionsKt.toList((Iterable)((Iterable)$this$takeLastWhile$iv));
                }
            }
            List list2 = list;
            return CollectionsKt.plus((Collection)collection, (Iterable)list2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

