/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.component.impl.TestFixturesImpl;
import com.android.build.api.variant.impl.TestVariantBuilderImpl;
import com.android.build.api.variant.impl.TestVariantImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.AbstractAppTaskManager;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.component.TestCreationConfig;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.SigningConfigVersionsWriterTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.test.TestApplicationTestData;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.CheckTestedAppObfuscation;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.google.common.base.Preconditions;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public class TestApplicationTaskManager
extends AbstractAppTaskManager<TestVariantBuilderImpl, TestVariantImpl> {
    public TestApplicationTaskManager(List<ComponentInfo<TestVariantBuilderImpl, TestVariantImpl>> variants, List<TestComponentImpl> testComponents, List<TestFixturesImpl> testFixturesComponents, boolean hasFlavors, ProjectOptions projectOptions, GlobalScope globalScope, BaseExtension extension, ProjectInfo projectInfo) {
        super(variants, testComponents, testFixturesComponents, hasFlavors, projectOptions, globalScope, extension, projectInfo);
    }

    @Override
    protected void doCreateTasksForVariant(@NotNull ComponentInfo<TestVariantBuilderImpl, TestVariantImpl> variantInfo) {
        this.createCommonTasks(variantInfo);
        TestVariantImpl testVariantProperties = variantInfo.getVariant();
        Provider testingApk = testVariantProperties.getArtifacts().get(SingleArtifact.APK.INSTANCE);
        FileCollection testedApks = testVariantProperties.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.PROVIDED_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.APK);
        TestApplicationTestData testData = new TestApplicationTestData(testVariantProperties.getNamespace(), testVariantProperties, testingApk, testedApks);
        this.configureTestData(testVariantProperties, testData);
        this.createValidateSigningTask(testVariantProperties);
        this.taskFactory.register(new SigningConfigVersionsWriterTask.CreationAction(testVariantProperties));
        TaskProvider<DeviceProviderInstrumentTestTask> instrumentTestTask = this.taskFactory.register(new DeviceProviderInstrumentTestTask.CreationAction(testVariantProperties, testData){

            @Override
            public String getName() {
                return super.getName() + "AndroidTest";
            }
        });
        this.taskFactory.configure("connectedAndroidTest", (Action<? super Task>)((Action)task -> task.dependsOn(new Object[]{instrumentTestTask})));
    }

    @Override
    protected void maybeCreateJavaCodeShrinkerTask(ConsumableCreationConfig creationConfig) {
        if (creationConfig.getMinifiedEnabled()) {
            this.doCreateJavaCodeShrinkerTask(creationConfig, true);
        } else {
            TaskProvider<CheckTestedAppObfuscation> checkObfuscation = this.taskFactory.register(new CheckTestedAppObfuscation.CreationAction(creationConfig));
            Preconditions.checkNotNull(creationConfig.getTaskContainer().getJavacTask());
            TaskFactoryUtils.dependsOn(creationConfig.getTaskContainer().getJavacTask(), checkObfuscation);
        }
    }

    @Override
    protected TaskProvider<? extends ManifestProcessorTask> createMergeManifestTasks(ApkCreationConfig creationConfig) {
        return this.taskFactory.register(new ProcessTestManifest.CreationAction((TestCreationConfig)((Object)creationConfig)));
    }

    @Override
    protected void createVariantPreBuildTask(ComponentCreationConfig creationConfig) {
        this.createDefaultPreBuildTask(creationConfig);
    }
}

