/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceDirectorySet;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.LibraryCreationConfig;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.builder.model.SourceProvider;
import com.android.utils.StringHelper;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r\u001a\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r\u001a(\u0010\u0018\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0011H\u0002\u001a\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010 \u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0012\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010#\u001a\u00020\u0001H\u0002\u001a,\u0010$\u001a\u00020\t2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0011\u001a\u0018\u0010'\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001c\u0010(\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"KOTLIN_ANDROID_PLUGIN_ID", "", "KOTLIN_KAPT_PLUGIN_ID", "KOTLIN_MPP_PLUGIN_IDS", "", "irBackendByDefault", "Lkotlin/KotlinVersion;", "irBackendIntroduced", "addComposeArgsToKotlinCompile", "", "task", "Lorg/gradle/api/Task;", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "compilerExtension", "Lorg/gradle/api/file/FileCollection;", "useLiveLiterals", "", "findKaptConfigurationsForVariant", "Lorg/gradle/api/artifacts/Configuration;", "project", "Lorg/gradle/api/Project;", "getKotlinCompile", "Lorg/gradle/api/tasks/TaskProvider;", "getKotlinOptionsValueIfSet", "extension", "Lcom/android/build/gradle/BaseExtension;", "methodName", "defaultValue", "getKotlinPluginVersion", "getProjectKotlinPluginKotlinVersion", "isKotlinAndroidPluginApplied", "isKotlinKaptPluginApplied", "isKotlinPluginApplied", "parseKotlinVersion", "currVersion", "recordIrBackendForAnalytics", "allPropertiesList", "composeIsEnabled", "setIrUsedInAnalytics", "syncAgpAndKgpSources", "sourceSets", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lcom/android/build/gradle/api/AndroidSourceSet;", "gradle-core"})
@JvmName(name="KgpUtils")
public final class KgpUtils {
    @NotNull
    public static final String KOTLIN_ANDROID_PLUGIN_ID = "org.jetbrains.kotlin.android";
    @NotNull
    public static final String KOTLIN_KAPT_PLUGIN_ID = "org.jetbrains.kotlin.kapt";
    @NotNull
    private static final List<String> KOTLIN_MPP_PLUGIN_IDS;
    @NotNull
    private static final KotlinVersion irBackendByDefault;
    @NotNull
    private static final KotlinVersion irBackendIntroduced;

    public static final boolean isKotlinPluginApplied(@NotNull Project project2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        try {
            boolean bl2;
            block5: {
                PluginContainer pluginContainer = project2.getPlugins();
                Intrinsics.checkExpressionValueIsNotNull((Object)pluginContainer, (String)"project.plugins");
                Iterable $this$any$iv = (Iterable)pluginContainer;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Plugin it = (Plugin)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof KotlinBasePluginWrapper)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (Throwable ignored) {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final KotlinVersion getProjectKotlinPluginKotlinVersion(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        String currVersion = KgpUtils.getKotlinPluginVersion(project2);
        if (currVersion == null || Intrinsics.areEqual((Object)currVersion, (Object)"unknown")) {
            return null;
        }
        return KgpUtils.parseKotlinVersion(currVersion);
    }

    private static final KotlinVersion parseKotlinVersion(String currVersion) {
        try {
            String[] stringArray = new String[]{"."};
            List parts = StringsKt.split$default((CharSequence)currVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String major = (String)parts.get(0);
            String minor = (String)parts.get(1);
            String patch = StringsKt.substringBefore$default((String)((String)parts.get(2)), (char)'-', null, (int)2, null);
            String string = major;
            boolean bl = false;
            int n = Integer.parseInt(string);
            string = minor;
            bl = false;
            int n2 = Integer.parseInt(string);
            string = patch;
            bl = false;
            return new KotlinVersion(n, n2, Integer.parseInt(string));
        }
        catch (Throwable e) {
            KotlinVersion kotlinVersion = null;
            return kotlinVersion;
        }
    }

    private static final String getKotlinPluginVersion(Project project2) {
        Object object;
        Plugin plugin = project2.getPlugins().findPlugin("kotlin-android");
        if (plugin == null) {
            return null;
        }
        Plugin plugin2 = object = plugin;
        try {
            Method method = plugin2.getClass().getMethod("getKotlinPluginVersion", new Class[0]);
            method.setAccessible(true);
            object = method.invoke((Object)plugin2, new Object[0]).toString();
        }
        catch (Throwable e) {
            object = "unknown";
        }
        return object;
    }

    public static final boolean isKotlinAndroidPluginApplied(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return project2.getPluginManager().hasPlugin(KOTLIN_ANDROID_PLUGIN_ID);
    }

    public static final boolean isKotlinKaptPluginApplied(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return project2.getPluginManager().hasPlugin(KOTLIN_KAPT_PLUGIN_ID);
    }

    @NotNull
    public static final TaskProvider<Task> getKotlinCompile(@NotNull Project project2, @NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
        TaskProvider taskProvider = project2.getTasks().named(creationConfig.computeTaskName("compile", "Kotlin"));
        Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"project.tasks.named(creationConfig.computeTaskName(\"compile\", \"Kotlin\"))");
        return taskProvider;
    }

    public static final void recordIrBackendForAnalytics(@NotNull List<? extends ComponentCreationConfig> allPropertiesList, @NotNull BaseExtension extension, @NotNull Project project2, boolean composeIsEnabled) {
        Intrinsics.checkParameterIsNotNull(allPropertiesList, (String)"allPropertiesList");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        for (ComponentCreationConfig componentCreationConfig : allPropertiesList) {
            try {
                TaskProvider<Task> compileKotlin = KgpUtils.getKotlinCompile(project2, componentCreationConfig);
                compileKotlin.configure((Action)new Action<Task>(composeIsEnabled, componentCreationConfig, project2, extension){
                    final /* synthetic */ boolean $composeIsEnabled;
                    final /* synthetic */ ComponentCreationConfig $creationConfig;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ BaseExtension $extension;
                    {
                        this.$composeIsEnabled = $composeIsEnabled;
                        this.$creationConfig = $creationConfig;
                        this.$project = $project;
                        this.$extension = $extension;
                    }

                    public final void execute(@NotNull Task task) {
                        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
                        try {
                            if (this.$composeIsEnabled) {
                                KgpUtils.access$setIrUsedInAnalytics(this.$creationConfig, this.$project);
                                return;
                            }
                            KotlinVersion kotlinVersion = KgpUtils.getProjectKotlinPluginKotlinVersion(this.$project);
                            if (kotlinVersion == null) {
                                return;
                            }
                            Boolean irBackendEnabled = kotlinVersion.compareTo(KgpUtils.access$getIrBackendByDefault$p()) >= 0 ? Boolean.valueOf(!KgpUtils.access$getKotlinOptionsValueIfSet(task, this.$extension, "getUseOldBackend", false)) : (kotlinVersion.compareTo(KgpUtils.access$getIrBackendIntroduced$p()) >= 0 ? Boolean.valueOf(KgpUtils.access$getKotlinOptionsValueIfSet(task, this.$extension, "getUseIR", false)) : null);
                            Boolean bl = irBackendEnabled;
                            if (bl != null) {
                                Boolean bl2 = bl;
                                ComponentCreationConfig componentCreationConfig = this.$creationConfig;
                                Project project2 = this.$project;
                                boolean bl3 = false;
                                boolean bl4 = false;
                                boolean it = bl2;
                                boolean bl5 = false;
                                KgpUtils.access$setIrUsedInAnalytics(componentCreationConfig, project2);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Throwable throwable) {}
        }
    }

    private static final boolean getKotlinOptionsValueIfSet(Task task, BaseExtension extension, String methodName, boolean defaultValue) {
        Method getKotlinOptions = task.getClass().getMethod("getKotlinOptions", new Class[0]);
        Object taskOptions = getKotlinOptions.invoke((Object)task, new Object[0]);
        Method method = taskOptions.getClass().getMethod(methodName, new Class[0]);
        Object object = method.invoke(taskOptions, new Object[0]);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean taskValue = (Boolean)object;
        if (defaultValue != taskValue) {
            return taskValue;
        }
        Object kotlinDslOptions = ((ExtensionAware)extension).getExtensions().getByName("kotlinOptions");
        Object object2 = method.invoke(kotlinDslOptions, new Object[0]);
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean globalValue = (Boolean)object2;
        if (defaultValue != globalValue) {
            return globalValue;
        }
        return defaultValue;
    }

    private static final void setIrUsedInAnalytics(ComponentCreationConfig creationConfig, Project project2) {
        Object object = BuildServicesKt.getBuildService(creationConfig.getServices().getBuildServiceRegistry(), AnalyticsConfiguratorService.class).get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getBuildService(\n                    creationConfig.services.buildServiceRegistry,\n                    AnalyticsConfiguratorService::class.java)\n                    .get()");
        AnalyticsConfiguratorService buildService = (AnalyticsConfiguratorService)object;
        String string = project2.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.path");
        object = buildService.getVariantBuilder(string, creationConfig.getName());
        if (object != null) {
            object.setKotlinOptions(GradleBuildVariant.KotlinOptions.newBuilder().setUseIr(true));
        }
    }

    public static final void addComposeArgsToKotlinCompile(@NotNull Task task, @NotNull ComponentCreationConfig creationConfig, @NotNull FileCollection compilerExtension, boolean useLiveLiterals) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkParameterIsNotNull((Object)compilerExtension, (String)"compilerExtension");
        KotlinCompile cfr_ignored_0 = (KotlinCompile)task;
        Object[] objectArray = new Object[]{compilerExtension};
        ((KotlinCompile)task).getInputs().files(objectArray).withPropertyName("composeCompilerExtension").withNormalizer(ClasspathNormalizer.class);
        ((KotlinCompile)task).getInputs().property("useLiveLiterals", (Object)useLiveLiterals);
        boolean debuggable = creationConfig instanceof ApkCreationConfig || creationConfig instanceof LibraryCreationConfig ? creationConfig.getDebuggable() : false;
        Project project2 = ((KotlinCompile)task).getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"task.project");
        KotlinVersion kotlinVersion = KgpUtils.getProjectKotlinPluginKotlinVersion(project2);
        task.doFirst((Action)new Action<Task>(kotlinVersion, compilerExtension, debuggable, useLiveLiterals){
            final /* synthetic */ KotlinVersion $kotlinVersion;
            final /* synthetic */ FileCollection $compilerExtension;
            final /* synthetic */ boolean $debuggable;
            final /* synthetic */ boolean $useLiveLiterals;
            {
                this.$kotlinVersion = $kotlinVersion;
                this.$compilerExtension = $compilerExtension;
                this.$debuggable = $debuggable;
                this.$useLiveLiterals = $useLiveLiterals;
            }

            public final void execute(Task it) {
                boolean bl;
                Object object;
                if (it == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.gradle.tasks.KotlinCompile");
                }
                KotlinCompile cfr_ignored_0 = (KotlinCompile)it;
                Object[] objectArray = this.$kotlinVersion;
                if (objectArray != null) {
                    object = objectArray;
                    boolean bl2 = false;
                    bl = false;
                    Object[] version = object;
                    boolean bl3 = false;
                    if (version.compareTo(KgpUtils.access$getIrBackendByDefault$p()) < 0 && version.compareTo(KgpUtils.access$getIrBackendIntroduced$p()) >= 0) {
                        ((KotlinCompile)it).getKotlinOptions().setUseIR(true);
                    }
                }
                object = new String[5];
                Object object2 = this.$compilerExtension.getFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"compilerExtension.files");
                object[0] = Intrinsics.stringPlus((String)"-Xplugin=", (Object)((File)CollectionsKt.first((Iterable)((Iterable)object2))).getAbsolutePath());
                object[1] = "-XXLanguage:+NonParenthesizedAnnotationsOnFunctionalTypes";
                object[2] = "-P";
                object[3] = "plugin:androidx.compose.plugins.idea:enabled=true";
                object[4] = "-Xallow-unstable-dependencies";
                List extraFreeCompilerArgs = CollectionsKt.mutableListOf((Object[])object);
                if (this.$debuggable) {
                    object = extraFreeCompilerArgs;
                    object2 = new String[]{"-P", "plugin:androidx.compose.compiler.plugins.kotlin:sourceInformation=true"};
                    object2 = CollectionsKt.listOf((Object[])object2);
                    bl = false;
                    CollectionsKt.addAll((Collection)object, (Iterable)object2);
                    if (this.$useLiveLiterals) {
                        object = extraFreeCompilerArgs;
                        object2 = new String[]{"-P", "plugin:androidx.compose.compiler.plugins.kotlin:liveLiterals=true"};
                        object2 = CollectionsKt.listOf((Object[])object2);
                        bl = false;
                        CollectionsKt.addAll((Collection)object, (Iterable)object2);
                    }
                }
                object = ((KotlinCompile)it).getKotlinOptions();
                object.setFreeCompilerArgs(CollectionsKt.plus((Collection)object.getFreeCompilerArgs(), (Iterable)extraFreeCompilerArgs));
            }
        });
    }

    public static final void syncAgpAndKgpSources(@NotNull Project project2, @NotNull NamedDomainObjectContainer<AndroidSourceSet> sourceSets) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull(sourceSets, (String)"sourceSets");
            Iterable $this$any$iv = KOTLIN_MPP_PLUGIN_IDS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!project2.getPluginManager().hasPlugin(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean hasMpp = bl;
        sourceSets.all((Action)new Action<AndroidSourceSet>(hasMpp){
            final /* synthetic */ boolean $hasMpp;
            {
                this.$hasMpp = $hasMpp;
            }

            public final void execute(AndroidSourceSet it) {
                if (it == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.internal.HasConvention");
                }
                V kotlinConvention = ((HasConvention)it).getConvention().getPlugins().get("kotlin");
                if (kotlinConvention != null) {
                    Object[] objectArray = kotlinConvention.getClass().getMethod("getKotlin", new Class[0]).invoke(kotlinConvention, new Object[0]);
                    if (objectArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.file.SourceDirectorySet");
                    }
                    SourceDirectorySet sourceDir = (SourceDirectorySet)objectArray;
                    if (!this.$hasMpp) {
                        objectArray = new Object[]{((DefaultAndroidSourceDirectorySet)it.getKotlin()).getSrcDirs()};
                        sourceDir.srcDirs(objectArray);
                    }
                    it.getKotlin().setSrcDirs((Iterable)CollectionsKt.listOf((Object)sourceDir.getSourceDirectories()));
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Configuration> findKaptConfigurationsForVariant(@NotNull Project project2, @NotNull ComponentCreationConfig creationConfig) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
        Iterable $this$mapNotNull$iv = creationConfig.getVariantSources().getSortedSourceProviders();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Configuration configuration;
            String kaptConfigurationName;
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            SourceProvider sourceSet = (SourceProvider)element$iv$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)sourceSet.getName(), (Object)"main")) {
                String string2 = sourceSet.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sourceSet.name");
                string = StringHelper.appendCapitalized((String)"kapt", (String)string2);
            } else {
                string = kaptConfigurationName = "kapt";
            }
            if ((Configuration)project2.getConfigurations().findByName(kaptConfigurationName) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Configuration it$iv$iv = configuration;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ void access$setIrUsedInAnalytics(ComponentCreationConfig creationConfig, Project project2) {
        KgpUtils.setIrUsedInAnalytics(creationConfig, project2);
    }

    public static final /* synthetic */ KotlinVersion access$getIrBackendByDefault$p() {
        return irBackendByDefault;
    }

    public static final /* synthetic */ boolean access$getKotlinOptionsValueIfSet(Task task, BaseExtension extension, String methodName, boolean defaultValue) {
        return KgpUtils.getKotlinOptionsValueIfSet(task, extension, methodName, defaultValue);
    }

    public static final /* synthetic */ KotlinVersion access$getIrBackendIntroduced$p() {
        return irBackendIntroduced;
    }

    static {
        Object[] objectArray = new String[]{"kotlin-multiplatform", "org.jetbrains.kotlin.multiplatform"};
        KOTLIN_MPP_PLUGIN_IDS = CollectionsKt.listOf((Object[])objectArray);
        irBackendByDefault = new KotlinVersion(1, 5);
        irBackendIntroduced = new KotlinVersion(1, 3, 70);
    }
}

