/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res;

import com.android.SdkConstants;
import com.android.Version;
import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.res.Aapt2FromMaven;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/res/Aapt2FromMaven;", "", "aapt2Directory", "Lorg/gradle/api/file/FileCollection;", "version", "", "(Lorg/gradle/api/file/FileCollection;Ljava/lang/String;)V", "getAapt2Directory", "()Lorg/gradle/api/file/FileCollection;", "getVersion", "()Ljava/lang/String;", "Companion", "gradle-core"})
public final class Aapt2FromMaven {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileCollection aapt2Directory;
    @NotNull
    private final String version;
    @NotNull
    private static final String TYPE_EXTRACTED_AAPT2_BINARY = "_internal-android-aapt2-binary";

    public Aapt2FromMaven(@NotNull FileCollection aapt2Directory2, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)aapt2Directory2, (String)"aapt2Directory");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        this.aapt2Directory = aapt2Directory2;
        this.version = version;
    }

    @NotNull
    public final FileCollection getAapt2Directory() {
        return this.aapt2Directory;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @JvmStatic
    @NotNull
    public static final Aapt2FromMaven create(@NotNull Project project2, @NotNull ProjectOptions projectOptions) {
        return Companion.create(project2, projectOptions);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/res/Aapt2FromMaven$Companion;", "", "()V", "TYPE_EXTRACTED_AAPT2_BINARY", "", "create", "Lcom/android/build/gradle/internal/res/Aapt2FromMaven;", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "Aapt2Extractor", "Aapt2Version", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Aapt2FromMaven create(@NotNull Project project2, @NotNull ProjectOptions projectOptions) {
            String string;
            String string2;
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
            String string3 = projectOptions.get(StringOption.AAPT2_FROM_MAVEN_OVERRIDE);
            String customAapt2 = string2 = string3 == null ? "" : string3;
            String string4 = projectOptions.get(StringOption.AAPT2_FROM_MAVEN_VERSION_OVERRIDE);
            String overriddenVersion = string3 = string4 == null ? "" : string4;
            String defaultVersion = Version.ANDROID_GRADLE_PLUGIN_VERSION + '-' + Aapt2Version.INSTANCE.getBUILD_NUMBER();
            if (StringsKt.any((CharSequence)customAapt2) && StringsKt.any((CharSequence)overriddenVersion)) {
                string4 = "You cannot specify both local and remote custom versions of AAPT2.\nPlease use either " + StringOption.AAPT2_FROM_MAVEN_OVERRIDE.getPropertyName() + " for setting a local path to the executable or " + StringOption.AAPT2_FROM_MAVEN_VERSION_OVERRIDE + " for specifying a Maven version (e.g. \"" + defaultVersion + "\").";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string4.toString());
            }
            if (StringsKt.any((CharSequence)customAapt2)) {
                string4 = SdkConstants.FN_AAPT2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"FN_AAPT2");
                if (!StringsKt.endsWith$default((String)customAapt2, (String)string4, (boolean)false, (int)2, null)) {
                    string4 = Intrinsics.stringPlus((String)"Custom AAPT2 location does not point to an AAPT2 executable: ", (Object)customAapt2);
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string4.toString());
                }
                Object[] objectArray = new Object[]{new File(customAapt2).getParentFile()};
                string4 = project2.files(objectArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"project.files(File(customAapt2).parentFile)");
                return new Aapt2FromMaven((FileCollection)string4, customAapt2);
            }
            String version = StringsKt.any((CharSequence)overriddenVersion) ? overriddenVersion : defaultVersion;
            int n = SdkConstants.currentPlatform();
            switch (n) {
                case 2: {
                    string = "windows";
                    break;
                }
                case 3: {
                    string = "osx";
                    break;
                }
                case 1: {
                    string = "linux";
                    break;
                }
                default: {
                    String string5 = "Unknown platform '" + System.getProperty("os.name") + '\'';
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string5.toString());
                }
            }
            String classifier = string;
            Dependency[] dependencyArray = new Dependency[1];
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"group", (Object)"com.android.tools.build"), TuplesKt.to((Object)"name", (Object)"aapt2"), TuplesKt.to((Object)"version", (Object)version), TuplesKt.to((Object)"classifier", (Object)classifier)};
            dependencyArray[0] = project2.getDependencies().module((Object)MapsKt.mapOf((Pair[])pairArray));
            Configuration configuration = project2.getConfigurations().detachedConfiguration(dependencyArray);
            project2.getDependencies().registerTransform(Aapt2Extractor.class, (Action)new Action<TransformSpec<GenericTransformParameters>>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public final void execute(TransformSpec<GenericTransformParameters> it) {
                    ((GenericTransformParameters)it.getParameters()).getProjectName().set((Object)this.$project.getName());
                    it.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"jar");
                    it.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-android-aapt2-binary");
                }
            });
            FileCollection aapt2Directory2 = configuration.getIncoming().artifactView((Action)create.aapt2Directory.1.INSTANCE).getArtifacts().getArtifactFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)aapt2Directory2, (String)"aapt2Directory");
            return new Aapt2FromMaven(aapt2Directory2, version);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/res/Aapt2FromMaven$Companion$Aapt2Version;", "", "()V", "BUILD_NUMBER", "", "getBUILD_NUMBER", "()Ljava/lang/String;", "BUILD_NUMBER$delegate", "Lkotlin/Lazy;", "gradle-core"})
        private static final class Aapt2Version {
            @NotNull
            public static final Aapt2Version INSTANCE = new Aapt2Version();
            @NotNull
            private static final Lazy BUILD_NUMBER$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)BUILD_NUMBER.2.INSTANCE);

            private Aapt2Version() {
            }

            @NotNull
            public final String getBUILD_NUMBER() {
                Lazy lazy = BUILD_NUMBER$delegate;
                boolean bl = false;
                Object object = lazy.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"pyright (C) 2018 The Android Open Source Project\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * Utilities related to AAPT2 Daemon management.\n */\n@file:JvmName(\"Aapt2MavenUtils\")\n\npackage com.android.build.gradle.internal.res\n\nimport com.android.SdkConstants\nimport com.android.Version\nimport com.android.build.gradle.internal.dependency.GenericTransformParameters\nimport com.android.build.gradle.options.ProjectOptions\nimport com.android.build.gradle.options.StringOption\nimport com.google.common.collect.Sets\nimport com.google.common.io.ByteStreams\nimport org.gradle.api.Project\nimport org.gradle.api.artifacts.transform.InputArtifact\nimport org.gradle.api.artifacts.transform.TransformAction\nimport org.gradle.api.artifacts.transform.TransformOutputs\nimport org.gradle.api.artifacts.type.ArtifactTypeDefinition\nimport org.gradle.api.file.FileCollection\nimport org.gradle.api.file.FileSystemLocation\nimport org.gradle.api.internal.artifacts.ArtifactAttributes\nimport org.gradle.api.provider.Provider\nimport org.gradle.api.tasks.Classpath\nimport java.io.File\nimport java.nio.file.Files\nimport java.nio.file.attribute.PosixFilePermission\nimport java.util.Properties\nimport java.util.zip.ZipInputStream\n\n/**\n * The AAPT2 binary as (potentially) fetched from Maven.\n *\n * Contains a file collection, which will contain the directory with AAPT2 to be used,\n * and a String identifying the version of AAPT2 being used.\n */\nclass Aapt2FromMaven(val aapt2Directory: FileCollection, val version: String) {\n    companion object {\n        private const val TYPE_EXTRACTED_AAPT2_BINARY = \"_internal-android-aapt2-binary\"\n\n        private object Aapt2Version {\n            val BUILD_NUMBER: String by lazy(LazyThreadSafetyMode.PUBLICATION) {\n                Aapt2Version::class.java\n                    .getResourceAsStream(\"aapt2_version.properties\")\n                    .buffered()\n                    .use { stream ->\n                        Properties().let { properties ->\n                            properties.load(stream)\n                            properties.getProperty(\"aapt2Version\")\n                        }\n                    }\n            }");
                return (String)object;
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/res/Aapt2FromMaven$Companion$Aapt2Extractor;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "transform", "", "transformOutputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "gradle-core"})
        public static abstract class Aapt2Extractor
        implements TransformAction<GenericTransformParameters> {
            @Classpath
            @InputArtifact
            @NotNull
            public abstract Provider<FileSystemLocation> getInputArtifact();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transform(@NotNull TransformOutputs transformOutputs) {
                Intrinsics.checkParameterIsNotNull((Object)transformOutputs, (String)"transformOutputs");
                File input = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)input, (String)"input");
                Path outDir = transformOutputs.dir((Object)FilesKt.getNameWithoutExtension((File)input)).toPath();
                Files.createDirectories(outDir, new FileAttribute[0]);
                Object object = input;
                int n = 0;
                object = new FileInputStream((File)object);
                n = 8192;
                boolean bl = false;
                object = new ZipInputStream(object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n));
                n = 0;
                bl = false;
                Throwable throwable = null;
                try {
                    ZipEntry zipEntry;
                    ZipInputStream zipInputStream = (ZipInputStream)object;
                    boolean bl2 = false;
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        ZipEntry entry = zipEntry;
                        if (entry.isDirectory()) continue;
                        Path destinationFile = outDir.resolve(entry.getName());
                        Files.createDirectories(destinationFile.getParent(), new FileAttribute[0]);
                        Closeable closeable = Files.newOutputStream(destinationFile, new OpenOption[0]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)closeable, (String)"newOutputStream(destinationFile)");
                        int n2 = 8192;
                        boolean bl3 = false;
                        closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n2);
                        n2 = 0;
                        bl3 = false;
                        Throwable throwable2 = null;
                        try {
                            BufferedOutputStream output2 = (BufferedOutputStream)closeable;
                            boolean bl4 = false;
                            long l = ByteStreams.copy((InputStream)zipInputStream, (OutputStream)output2);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        }
                        if (!Intrinsics.areEqual((Object)entry.getName(), (Object)SdkConstants.FN_AAPT2) || SdkConstants.CURRENT_PLATFORM != 1 && SdkConstants.CURRENT_PLATFORM != 3) continue;
                        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(destinationFile, new LinkOption[0]);
                        Files.setPosixFilePermissions(destinationFile, (Set)Sets.union(permissions, (Set)SetsKt.setOf((Object)((Object)PosixFilePermission.OWNER_EXECUTE))));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
        }
    }
}

