/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.builder.dexing.R8Tool;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/dependency/VersionedCodeShrinker;", "Ljava/io/Serializable;", "version", "", "(Ljava/lang/String;)V", "getVersion", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "gradle-core"})
public final class VersionedCodeShrinker
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String version;
    @NotNull
    private static final Regex versionPattern;

    public VersionedCodeShrinker(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        this.version = version;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String component1() {
        return this.version;
    }

    @NotNull
    public final VersionedCodeShrinker copy(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return new VersionedCodeShrinker(version);
    }

    public static /* synthetic */ VersionedCodeShrinker copy$default(VersionedCodeShrinker versionedCodeShrinker, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = versionedCodeShrinker.version;
        }
        return versionedCodeShrinker.copy(string);
    }

    @NotNull
    public String toString() {
        return "VersionedCodeShrinker(version=" + this.version + ')';
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VersionedCodeShrinker)) {
            return false;
        }
        VersionedCodeShrinker versionedCodeShrinker = (VersionedCodeShrinker)other;
        return Intrinsics.areEqual((Object)this.version, (Object)versionedCodeShrinker.version);
    }

    @JvmStatic
    @NotNull
    public static final VersionedCodeShrinker create() {
        return Companion.create();
    }

    static {
        String string = "[^\\s.]+(?:\\.[^\\s.]+)+";
        boolean bl = false;
        versionPattern = new Regex(string);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/dependency/VersionedCodeShrinker$Companion;", "", "()V", "versionPattern", "Lkotlin/text/Regex;", "create", "Lcom/android/build/gradle/internal/dependency/VersionedCodeShrinker;", "parseVersionString", "", "version", "parseVersionString$gradle_core", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final VersionedCodeShrinker create() {
            return new VersionedCodeShrinker(this.parseVersionString$gradle_core(R8Tool.getR8Version()));
        }

        @VisibleForTesting
        @NotNull
        public final String parseVersionString$gradle_core(@NotNull String version) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            MatchResult matcher = Regex.find$default((Regex)versionPattern, (CharSequence)version, (int)0, (int)2, null);
            if (matcher != null) {
                LoggerWrapper.getLogger(VersionedCodeShrinker.class).verbose(Intrinsics.stringPlus((String)"Parsed shrinker version: ", matcher.getGroupValues().get(0)), new Object[0]);
                string = (String)matcher.getGroupValues().get(0);
            } else {
                LoggerWrapper.getLogger(VersionedCodeShrinker.class).warning("Cannot parse shrinker version, assuming 0.0.0", new Object[0]);
                string = "0.0.0";
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

