/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.manifest;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestProvider;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u00e1\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\b\u0010!\u001a\u0004\u0018\u00010\t2\u0006\u0010\"\u001a\u00020#\u00a2\u0006\u0002\u0010$\u001a\u001a\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u00042\u0006\u0010(\u001a\u00020\tH\u0002\u001aQ\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010,\u00a8\u0006-"}, d2={"findOriginalManifestFilePosition", "Lcom/android/ide/common/blame/SourceFilePosition;", "manifestMergeBlameContents", "", "", "mergedFilePosition", "mergeManifests", "Lcom/android/manifmerger/MergingReport;", "mainManifest", "Ljava/io/File;", "manifestOverlays", "dependencies", "Lcom/android/manifmerger/ManifestProvider;", "navigationJsons", "", "featureName", "packageOverride", "versionCode", "", "versionName", "minSdkVersion", "targetSdkVersion", "maxSdkVersion", "outMergedManifestLocation", "outAaptSafeManifestLocation", "mergeType", "Lcom/android/manifmerger/ManifestMerger2$MergeType;", "placeHolders", "", "", "optionalFeatures", "Lcom/android/manifmerger/ManifestMerger2$Invoker$Feature;", "dependencyFeatureNames", "reportFile", "logger", "Lcom/android/utils/ILogger;", "(Ljava/io/File;Ljava/util/List;Ljava/util/List;Ljava/util/Collection;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Lcom/android/manifmerger/ManifestMerger2$MergeType;Ljava/util/Map;Ljava/util/Collection;Ljava/util/Collection;Ljava/io/File;Lcom/android/utils/ILogger;)Lcom/android/manifmerger/MergingReport;", "save", "", "xmlDocument", "out", "setInjectableValues", "invoker", "Lcom/android/manifmerger/ManifestMerger2$Invoker;", "(Lcom/android/manifmerger/ManifestMerger2$Invoker;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)V", "gradle-core"})
public final class ManifestHelperKt {
    @NotNull
    public static final MergingReport mergeManifests(@NotNull File mainManifest, @NotNull List<? extends File> manifestOverlays2, @NotNull List<? extends ManifestProvider> dependencies, @NotNull Collection<? extends File> navigationJsons, @Nullable String featureName2, @Nullable String packageOverride, @Nullable Integer versionCode2, @Nullable String versionName2, @Nullable String minSdkVersion2, @Nullable String targetSdkVersion, @Nullable Integer maxSdkVersion, @Nullable String outMergedManifestLocation, @Nullable String outAaptSafeManifestLocation, @NotNull ManifestMerger2.MergeType mergeType, @NotNull Map<String, ? extends Object> placeHolders, @NotNull Collection<? extends ManifestMerger2.Invoker.Feature> optionalFeatures, @NotNull Collection<String> dependencyFeatureNames, @Nullable File reportFile2, @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)mainManifest, (String)"mainManifest");
        Intrinsics.checkParameterIsNotNull(manifestOverlays2, (String)"manifestOverlays");
        Intrinsics.checkParameterIsNotNull(dependencies, (String)"dependencies");
        Intrinsics.checkParameterIsNotNull(navigationJsons, (String)"navigationJsons");
        Intrinsics.checkParameterIsNotNull((Object)mergeType, (String)"mergeType");
        Intrinsics.checkParameterIsNotNull(placeHolders, (String)"placeHolders");
        Intrinsics.checkParameterIsNotNull(optionalFeatures, (String)"optionalFeatures");
        Intrinsics.checkParameterIsNotNull(dependencyFeatureNames, (String)"dependencyFeatureNames");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        try {
            String annotatedDocument;
            Collection<? extends ManifestMerger2.Invoker.Feature> $this$toTypedArray$iv = (Collection<? extends ManifestMerger2.Invoker.Feature>)manifestOverlays2;
            boolean $i$f$toTypedArray = false;
            Collection<? extends ManifestMerger2.Invoker.Feature> thisCollection$iv = $this$toTypedArray$iv;
            File[] fileArray = thisCollection$iv.toArray(new File[0]);
            if (fileArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            $this$toTypedArray$iv = optionalFeatures;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            ManifestMerger2.Invoker.Feature[] featureArray = thisCollection$iv.toArray(new ManifestMerger2.Invoker.Feature[0]);
            if (featureArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ManifestMerger2.Invoker manifestMergerInvoker = ManifestMerger2.newMerger((File)mainManifest, (ILogger)logger, (ManifestMerger2.MergeType)mergeType).setPlaceHolderValues(placeHolders).addFlavorAndBuildTypeManifests(Arrays.copyOf(fileArray, fileArray.length)).addManifestProviders((Iterable)dependencies).addNavigationJsons((Iterable)navigationJsons).withFeatures(Arrays.copyOf(featureArray, featureArray.length)).setMergeReportFile(reportFile2).setFeatureName(featureName2).addDependencyFeatureNames((Iterable)dependencyFeatureNames);
            if (mergeType == ManifestMerger2.MergeType.APPLICATION) {
                manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS});
            }
            if (outAaptSafeManifestLocation != null) {
                manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.MAKE_AAPT_SAFE});
            }
            ManifestMerger2.Invoker invoker = manifestMergerInvoker;
            Intrinsics.checkExpressionValueIsNotNull((Object)invoker, (String)"manifestMergerInvoker");
            ManifestHelperKt.setInjectableValues(invoker, packageOverride, versionCode2, versionName2, minSdkVersion2, targetSdkVersion, maxSdkVersion);
            MergingReport mergingReport = manifestMergerInvoker.merge();
            Object[] objectArray = new Object[1];
            MergingReport mergingReport2 = mergingReport;
            Intrinsics.checkExpressionValueIsNotNull((Object)mergingReport2, (String)"mergingReport");
            objectArray[0] = mergingReport2.getResult();
            logger.verbose("Merging result: %1$s", objectArray);
            if (mergingReport.getResult() == MergingReport.Result.ERROR) {
                mergingReport.log(logger);
                throw (Throwable)new RuntimeException(mergingReport.getReportString());
            }
            if (mergingReport.getResult() == MergingReport.Result.WARNING) {
                mergingReport.log(logger);
            }
            if ((annotatedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BLAME)) != null) {
                logger.verbose(annotatedDocument, new Object[0]);
            }
            logger.verbose("Merged manifest saved to " + outMergedManifestLocation, new Object[0]);
            if (outMergedManifestLocation != null) {
                ManifestHelperKt.save(mergingReport.getMergedDocument(MergingReport.MergedManifestKind.MERGED), new File(outMergedManifestLocation));
            }
            if (outAaptSafeManifestLocation != null) {
                ManifestHelperKt.save(mergingReport.getMergedDocument(MergingReport.MergedManifestKind.AAPT_SAFE), new File(outAaptSafeManifestLocation));
            }
            return mergingReport;
        }
        catch (ManifestMerger2.MergeFailureException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @NotNull
    public static final SourceFilePosition findOriginalManifestFilePosition(@NotNull List<String> manifestMergeBlameContents, @NotNull SourceFilePosition mergedFilePosition) {
        block13: {
            block12: {
                Intrinsics.checkParameterIsNotNull(manifestMergeBlameContents, (String)"manifestMergeBlameContents");
                Intrinsics.checkParameterIsNotNull((Object)mergedFilePosition, (String)"mergedFilePosition");
                if (Intrinsics.areEqual((Object)mergedFilePosition.getFile(), (Object)SourceFile.UNKNOWN)) break block12;
                SourceFile sourceFile = mergedFilePosition.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceFile, (String)"mergedFilePosition.file");
                Object object = sourceFile.getSourceFile();
                if (object == null || (object = ((File)object).getAbsolutePath()) == null) break block13;
                if (StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"merged_manifests", (boolean)false, (int)2, null)) break block13;
            }
            return mergedFilePosition;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            SourcePosition sourcePosition = mergedFilePosition.getPosition();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourcePosition, (String)"mergedFilePosition.position");
            String linePrefix = stringBuilder.append(String.valueOf(sourcePosition.getStartLine() + 1)).append("-->").toString();
            Iterable $this$forEach$iv = manifestMergeBlameContents;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SourceFilePosition sourceFilePosition;
                int index;
                int n;
                int closingIndex;
                String position;
                String line = (String)element$iv;
                boolean bl = false;
                String string = line;
                boolean bl2 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String trimmed = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                if (!StringsKt.startsWith$default((String)trimmed, (String)linePrefix, (boolean)false, (int)2, null)) continue;
                String string3 = trimmed;
                int n2 = linePrefix.length();
                int n3 = 0;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
                if (StringsKt.startsWith$default((String)position, (String)"[", (boolean)false, (int)2, null) && (closingIndex = StringsKt.indexOf$default((CharSequence)position, (String)"] ", (int)0, (boolean)false, (int)6, null)) >= 0) {
                    String string5 = position;
                    n3 = closingIndex + 2;
                    n = 0;
                    String string6 = string5;
                    if (string6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(n3);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                    position = string7;
                }
                if ((index = StringsKt.indexOf$default((CharSequence)position, (String)".xml", (int)0, (boolean)false, (int)6, null)) == -1) continue;
                String string8 = position;
                n = 0;
                int n4 = index + ".xml".length();
                boolean bl3 = false;
                String string9 = string8;
                if (string9 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string10 = string9.substring(n, n4);
                Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String file = string10;
                if (Intrinsics.areEqual((Object)file, (Object)position) ^ true) {
                    String string11 = position;
                    n4 = index + ".xml".length() + 1;
                    bl3 = false;
                    String string12 = string11;
                    if (string12 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string13 = string12.substring(n4);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"(this as java.lang.String).substring(startIndex)");
                    String sourcePosition2 = string13;
                    sourceFilePosition = new SourceFilePosition(new File(file), SourcePosition.fromString((String)sourcePosition2));
                } else {
                    sourceFilePosition = new SourceFilePosition(new File(file), SourcePosition.UNKNOWN);
                }
                return sourceFilePosition;
            }
        }
        catch (Exception e) {
            return mergedFilePosition;
        }
        return mergedFilePosition;
    }

    private static final void setInjectableValues(ManifestMerger2.Invoker invoker, String packageOverride, Integer versionCode2, String versionName2, String minSdkVersion2, String targetSdkVersion, Integer maxSdkVersion) {
        boolean bl;
        Object object;
        if (packageOverride != null) {
            object = packageOverride;
            bl = false;
            if (object.length() > 0) {
                invoker.setOverride(ManifestSystemProperty.PACKAGE, packageOverride);
            }
        }
        Integer n = versionCode2;
        if (n != null) {
            object = n;
            bl = false;
            boolean bl2 = false;
            int it = ((Number)object).intValue();
            boolean bl3 = false;
            if (it > 0) {
                invoker.setOverride(ManifestSystemProperty.VERSION_CODE, String.valueOf(it));
            }
        }
        if (versionName2 != null) {
            object = versionName2;
            bl = false;
            if (object.length() > 0) {
                invoker.setOverride(ManifestSystemProperty.VERSION_NAME, versionName2);
            }
        }
        if (minSdkVersion2 != null) {
            object = minSdkVersion2;
            bl = false;
            if (object.length() > 0) {
                invoker.setOverride(ManifestSystemProperty.MIN_SDK_VERSION, minSdkVersion2);
            }
        }
        if (targetSdkVersion != null) {
            object = targetSdkVersion;
            bl = false;
            if (object.length() > 0) {
                invoker.setOverride(ManifestSystemProperty.TARGET_SDK_VERSION, targetSdkVersion);
            }
        }
        if (maxSdkVersion != null) {
            invoker.setOverride(ManifestSystemProperty.MAX_SDK_VERSION, String.valueOf(maxSdkVersion));
        }
    }

    private static final void save(String xmlDocument, File out) {
        try {
            Files.createParentDirs((File)out);
            CharSink charSink = Files.asCharSink((File)out, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]);
            String string = xmlDocument;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            charSink.write((CharSequence)string);
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }
}

