/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.SdkConstants;
import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.internal.cxx.configure.CmakeLocatorKt;
import com.android.build.gradle.internal.cxx.configure.CmakeVersionRequirements;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.cxx.CxxDiagnosticCode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\u001a~\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00122\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00150\u00142\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00150\u00142\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00182\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00150\u0014\u001a\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001c\u001a\u00020\u000eH\u0002\u001a\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0002\u001a\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010\u000eH\u0002\u001a\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u00152\b\u0010!\u001a\u0004\u0018\u00010\u000eH\u0002\u001a\n\u0010\"\u001a\u00020#*\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u0019\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"BAKING_CMAKE_VERSION", "", "DEFAULT_CMAKE_SDK_DOWNLOAD_VERSION", "DEFAULT_CMAKE_VERSION", "FORK_CMAKE_SDK_VERSION", "defaultCmakeVersion", "Lcom/android/repository/Revision;", "kotlin.jvm.PlatformType", "getDefaultCmakeVersion", "()Lcom/android/repository/Revision;", "forkCmakeReportedVersion", "getForkCmakeReportedVersion", "forkCmakeSdkVersionRevision", "findCmakePathLogic", "Ljava/io/File;", "cmakeVersionFromDsl", "cmakePathFromLocalProperties", "downloader", "Ljava/util/function/Consumer;", "environmentPaths", "Lkotlin/Function0;", "", "sdkFolders", "cmakeVersionGetter", "Lkotlin/Function1;", "repositoryPackages", "Lcom/android/repository/api/LocalPackage;", "getCmakeRevisionFromExecutable", "cmakeFolder", "getEnvironmentPaths", "getSdkCmakeFolders", "sdkRoot", "getSdkCmakePackages", "sdkFolder", "isCmakeForkVersion", "", "gradle-core"})
public final class CmakeLocatorKt {
    private static final String FORK_CMAKE_SDK_VERSION = "3.6.4111459";
    private static final Revision forkCmakeSdkVersionRevision = Revision.parseRevision((String)"3.6.4111459");
    private static final Revision forkCmakeReportedVersion = Revision.parseRevision((String)"3.6.0");
    @NotNull
    public static final String DEFAULT_CMAKE_VERSION = "3.10.2";
    private static final Revision defaultCmakeVersion = Revision.parseRevision((String)"3.10.2");
    @NotNull
    public static final String DEFAULT_CMAKE_SDK_DOWNLOAD_VERSION = "3.10.2.4988404";
    @NotNull
    public static final String BAKING_CMAKE_VERSION = "3.18.1";

    public static final Revision getForkCmakeReportedVersion() {
        return forkCmakeReportedVersion;
    }

    public static final Revision getDefaultCmakeVersion() {
        return defaultCmakeVersion;
    }

    private static final List<File> getEnvironmentPaths() {
        String string = System.getenv("PATH");
        if (string == null) {
            string = "";
        }
        String envPath = string;
        String string2 = System.getProperty("path.separator");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"System.getProperty(\"path.separator\")");
        CharSequence charSequence = string2;
        int n = 0;
        Regex pathSeparator = new Regex(charSequence);
        charSequence = envPath;
        n = 0;
        boolean bl = false;
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)pathSeparator.split(charSequence, n)), (Function1)getEnvironmentPaths.1.INSTANCE), (Function1)getEnvironmentPaths.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<File> getSdkCmakeFolders(File sdkRoot) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        File[] fileArray = sdkRoot;
        if (sdkRoot == null || (fileArray = FilesKt.resolve((File)fileArray, (String)"cmake")) == null || (fileArray = fileArray.listFiles()) == null) {
            fileArray = new File[]{};
        }
        File[] $this$map$iv = fileArray;
        boolean $i$f$map = false;
        File[] fileArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv;
        int n = ((void)iterator).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_13 = item$iv$iv = iterator[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            File file = FilesKt.resolve((File)v1, (String)"bin");
            collection.add(file);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private static final List<LocalPackage> getSdkCmakePackages(File sdkFolder) {
        RepoManager sdkManager;
        AndroidSdkHandler androidSdkHandler = AndroidSdkHandler.getInstance((File)sdkFolder);
        RepoManager repoManager = sdkManager = androidSdkHandler.getSdkManager((ProgressIndicator)new LoggerProgressIndicatorWrapper(ThreadLoggingEnvironment.Companion.getILogger(CxxDiagnosticCode.UNKNOWN, CxxDiagnosticCode.UNKNOWN)));
        Intrinsics.checkExpressionValueIsNotNull((Object)repoManager, (String)"sdkManager");
        RepositoryPackages packages = repoManager.getPackages();
        Collection collection = packages.getLocalPackagesForPrefix("cmake");
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"packages.getLocalPackagesForPrefix(FD_CMAKE)");
        return CollectionsKt.toList((Iterable)collection);
    }

    private static final Revision getCmakeRevisionFromExecutable(File cmakeFolder2) {
        if (!cmakeFolder2.exists()) {
            return null;
        }
        String cmakeExecutableName = SdkConstants.CURRENT_PLATFORM == 2 ? "cmake.exe" : "cmake";
        File cmakeExecutable = new File(cmakeFolder2, cmakeExecutableName);
        if (!cmakeExecutable.exists()) {
            return null;
        }
        return CmakeUtils.getVersion(cmakeFolder2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final File findCmakePathLogic(@Nullable String cmakeVersionFromDsl, @Nullable File cmakePathFromLocalProperties, @Nullable Consumer<String> downloader, @NotNull Function0<? extends List<? extends File>> environmentPaths, @NotNull Function0<? extends List<? extends File>> sdkFolders, @NotNull Function1<? super File, ? extends Revision> cmakeVersionGetter, @NotNull Function0<? extends List<? extends LocalPackage>> repositoryPackages) {
        Object object;
        Collection collection;
        Intrinsics.checkParameterIsNotNull(environmentPaths, (String)"environmentPaths");
        Intrinsics.checkParameterIsNotNull(sdkFolders, (String)"sdkFolders");
        Intrinsics.checkParameterIsNotNull(cmakeVersionGetter, (String)"cmakeVersionGetter");
        Intrinsics.checkParameterIsNotNull(repositoryPackages, (String)"repositoryPackages");
        CmakeVersionRequirements dsl = new CmakeVersionRequirements(cmakeVersionFromDsl);
        Function1<File, Revision> $fun$versionGetter$1 = new Function1<File, Revision>(cmakeVersionGetter){
            final /* synthetic */ Function1 $cmakeVersionGetter;

            @Nullable
            public final Revision invoke(@NotNull File cmakePath) {
                Revision revision;
                Intrinsics.checkParameterIsNotNull((Object)cmakePath, (String)"cmakePath");
                try {
                    revision = (Revision)this.$cmakeVersionGetter.invoke((Object)cmakePath);
                }
                catch (IOException e) {
                    LoggingEnvironmentKt.warnln("Could not execute cmake at '" + cmakePath + "' to get version. Skipping.", new Object[0]);
                    revision = null;
                }
                return revision;
            }
            {
                this.$cmakeVersionGetter = function1;
                super(1);
            }
        };
        boolean bl = false;
        List nonsatisfiers = new ArrayList();
        if (cmakePathFromLocalProperties != null) {
            Revision version = $fun$versionGetter$1.invoke(FilesKt.resolve((File)cmakePathFromLocalProperties, (String)"bin"));
            if (version == null) {
                LoggingEnvironmentKt.errorln("Could not get version from cmake.dir path '" + cmakePathFromLocalProperties + "'.", new Object[0]);
            } else {
                if (cmakeVersionFromDsl == null) {
                    return cmakePathFromLocalProperties;
                }
                if (!dsl.isSatisfiedBy(version)) {
                    Collection collection2 = nonsatisfiers;
                    String string = "" + '\'' + version + "' found from cmake.dir";
                    boolean bl2 = false;
                    collection2.add(string);
                } else {
                    return cmakePathFromLocalProperties;
                }
            }
        }
        boolean bl3 = false;
        Set cmakePaths = new LinkedHashSet();
        for (File environmentPath : (List)environmentPaths.invoke()) {
            Revision version;
            if (cmakePaths.contains(environmentPath.getPath())) continue;
            if ($fun$versionGetter$1.invoke(environmentPath) == null) {
                continue;
            }
            if (!dsl.isSatisfiedBy(version)) {
                collection = nonsatisfiers;
                object = "" + '\'' + version + "' found in PATH";
                boolean bl4 = false;
                collection.add(object);
                continue;
            }
            String string = environmentPath.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"environmentPath.path");
            cmakePaths.add(string);
        }
        if (cmakePaths.isEmpty()) {
            for (LocalPackage localPackage : (List)repositoryPackages.invoke()) {
                Revision version;
                File file = localPackage.getLocation();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"localPackage.location");
                File packagePath = FilesKt.resolve((File)file, (String)"bin");
                if (cmakePaths.contains(packagePath.getPath())) continue;
                Revision revision = version = Intrinsics.areEqual((Object)localPackage.getVersion(), (Object)forkCmakeSdkVersionRevision) ? forkCmakeReportedVersion : localPackage.getVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"version");
                if (!dsl.isSatisfiedBy(revision)) {
                    object = nonsatisfiers;
                    String string = "" + '\'' + version + "' found in SDK";
                    boolean bl5 = false;
                    object.add(string);
                    continue;
                }
                String string = packagePath.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packagePath.path");
                cmakePaths.add(string);
            }
        }
        if (cmakePaths.isEmpty()) {
            for (File sdkFolder : (List)sdkFolders.invoke()) {
                Collection collection3;
                if (cmakePaths.contains(sdkFolder.getPath())) continue;
                try {
                    File file = sdkFolder.getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"sdkFolder.parentFile");
                    collection = Revision.parseRevision((String)CmakeUtils.keepWhileNumbersAndDots(file.getName()));
                }
                catch (Throwable e) {
                    collection = null;
                }
                if ((collection3 = collection) == null) {
                    collection3 = $fun$versionGetter$1.invoke(sdkFolder);
                }
                if (collection3 == null) {
                    continue;
                }
                Collection version = collection3;
                if (!dsl.isSatisfiedBy((Revision)version)) continue;
                String string = sdkFolder.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdkFolder.path");
                cmakePaths.add(string);
            }
        }
        if (cmakePaths.isEmpty()) {
            void $this$onEach$iv;
            if (downloader != null && dsl.getDownloadVersion() != null) {
                downloader.accept(dsl.getDownloadVersion());
                return CmakeLocatorKt.findCmakePathLogic(cmakeVersionFromDsl, cmakePathFromLocalProperties, null, environmentPaths, sdkFolders, cmakeVersionGetter, repositoryPackages);
            }
            LoggingEnvironmentKt.errorln("CMake " + dsl.getHumanReadableVersionLanguage() + " was not found in SDK, PATH, or by cmake.dir property.", new Object[0]);
            Iterable sdkFolder = CollectionsKt.distinct((Iterable)nonsatisfiers);
            boolean $i$f$onEach = false;
            void var13_25 = $this$onEach$iv;
            boolean bl6 = false;
            boolean bl7 = false;
            void $this$apply$iv = var13_25;
            boolean bl8 = false;
            for (Object element$iv : $this$apply$iv) {
                String it = (String)element$iv;
                boolean bl9 = false;
                LoggingEnvironmentKt.errorln("- CMake " + it + " did not satisfy requested version.", new Object[0]);
            }
            return null;
        }
        return new File((String)CollectionsKt.first((Iterable)cmakePaths)).getParentFile();
    }

    public static final boolean isCmakeForkVersion(@NotNull Revision $this$isCmakeForkVersion) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isCmakeForkVersion, (String)"$this$isCmakeForkVersion");
        return $this$isCmakeForkVersion.getMajor() == 3 && $this$isCmakeForkVersion.getMinor() == 6 && $this$isCmakeForkVersion.getMicro() == 0;
    }

    public static final /* synthetic */ List access$getEnvironmentPaths() {
        return CmakeLocatorKt.getEnvironmentPaths();
    }

    public static final /* synthetic */ List access$getSdkCmakeFolders(File sdkRoot) {
        return CmakeLocatorKt.getSdkCmakeFolders(sdkRoot);
    }

    public static final /* synthetic */ Revision access$getCmakeRevisionFromExecutable(File cmakeFolder2) {
        return CmakeLocatorKt.getCmakeRevisionFromExecutable(cmakeFolder2);
    }

    public static final /* synthetic */ List access$getSdkCmakePackages(File sdkFolder) {
        return CmakeLocatorKt.getSdkCmakePackages(sdkFolder);
    }
}

