/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.crash;

import com.android.Version;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.crash.PluginExceptionReport;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.analytics.crash.CrashReporter;
import com.android.tools.analytics.crash.GoogleCrashReporter;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\f\u001a\u00020\u00072\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/crash/PluginCrashReporter;", "", "()V", "reporter", "Lcom/android/tools/analytics/crash/CrashReporter;", "getCrashReporter", "forTest", "", "maybeReportException", "ex", "", "maybeReportExceptionForTest", "maybeReportExceptionImpl", "gradle-core"})
public final class PluginCrashReporter {
    private static final CrashReporter reporter;
    @NotNull
    public static final PluginCrashReporter INSTANCE;

    @JvmStatic
    public static final boolean maybeReportException(@NotNull Throwable ex) {
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        return INSTANCE.maybeReportExceptionImpl(reporter, ex);
    }

    @VisibleForTesting
    public final boolean maybeReportExceptionForTest(@NotNull Throwable ex) {
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        CrashReporter crashReporter = this.getCrashReporter(true);
        return this.maybeReportExceptionImpl(crashReporter, ex);
    }

    private final CrashReporter getCrashReporter(boolean forTest) {
        CrashReporter crashReporter;
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(PluginCrashReporter.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)loggerWrapper, (String)"LoggerWrapper.getLogger(\u2026rashReporter::class.java)");
        AnalyticsSettings.initialize$default((ILogger)loggerWrapper, null, null, (int)6, null);
        if (AnalyticsSettings.getOptedIn()) {
            String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Version.ANDROID_GRADLE_PLUGIN_VERSION");
            boolean isDebugBuild = StringsKt.endsWith$default((String)string, (String)"-dev", (boolean)false, (int)2, null);
            crashReporter = (CrashReporter)new GoogleCrashReporter(false, isDebugBuild || forTest);
        } else {
            crashReporter = null;
        }
        return crashReporter;
    }

    static /* synthetic */ CrashReporter getCrashReporter$default(PluginCrashReporter pluginCrashReporter, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return pluginCrashReporter.getCrashReporter(bl);
    }

    private final boolean maybeReportExceptionImpl(CrashReporter reporter, Throwable ex) {
        if (reporter == null) {
            return false;
        }
        PluginExceptionReport pluginExceptionReport = PluginExceptionReport.Companion.create(ex);
        if (pluginExceptionReport != null) {
            PluginExceptionReport pluginExceptionReport2 = pluginExceptionReport;
            boolean bl = false;
            boolean bl2 = false;
            PluginExceptionReport it = pluginExceptionReport2;
            boolean bl3 = false;
            reporter.submit((CrashReport)it);
            return true;
        }
        return false;
    }

    private PluginCrashReporter() {
    }

    static {
        PluginCrashReporter pluginCrashReporter;
        INSTANCE = pluginCrashReporter = new PluginCrashReporter();
        reporter = PluginCrashReporter.getCrashReporter$default(pluginCrashReporter, false, 1, null);
    }
}

