/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.res.shrinker.LinkedResourcesFormat;
import com.android.build.gradle.internal.res.shrinker.LoggerAndFileDebugReporter;
import com.android.build.gradle.internal.res.shrinker.ResourceShrinkerImpl;
import com.android.build.gradle.internal.res.shrinker.ShrinkerDebugReporter;
import com.android.build.gradle.internal.res.shrinker.gatherer.ProtoResourceTableGatherer;
import com.android.build.gradle.internal.res.shrinker.graph.ProtoResourcesGraphBuilder;
import com.android.build.gradle.internal.res.shrinker.obfuscation.ObfuscationMappingsRecorder;
import com.android.build.gradle.internal.res.shrinker.obfuscation.ProguardMappingsRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.DexUsageRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.ProtoAndroidManifestUsageRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.ToolsAttributeUsageRecorder;
import com.android.build.gradle.internal.services.Aapt2Daemon;
import com.android.build.gradle.internal.services.Aapt2DaemonServiceKey;
import com.android.build.gradle.internal.transforms.ShrinkAppBundleResourcesTask;
import com.android.build.gradle.internal.transforms.ShrinkProtoResourcesParams;
import com.android.build.gradle.internal.workeractions.WorkActionAdapter;
import com.android.builder.internal.aapt.AaptConvertConfig;
import com.android.builder.internal.aapt.v2.Aapt2DaemonManager;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/transforms/ShrinkProtoResourcesAction;", "Lcom/android/build/gradle/internal/workeractions/WorkActionAdapter;", "Lcom/android/build/gradle/internal/transforms/ShrinkProtoResourcesParams;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "doExecute", "", "toKbString", "", "size", "", "gradle-core"})
public abstract class ShrinkProtoResourcesAction
implements WorkActionAdapter<ShrinkProtoResourcesParams> {
    private final Logger logger = Logging.getLogger(ShrinkAppBundleResourcesTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void doExecute() {
        Throwable throwable;
        boolean bl;
        Closeable closeable;
        File shrunkFile;
        Aapt2DaemonServiceKey aapt2ServiceKey = (Aapt2DaemonServiceKey)((ShrinkProtoResourcesParams)this.getParameters()).getAapt2ServiceKey().get();
        Object object = ((ShrinkProtoResourcesParams)this.getParameters()).getOriginalFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.originalFile.get()");
        File originalFile = ((RegularFile)object).getAsFile();
        Object object2 = ((ShrinkProtoResourcesParams)this.getParameters()).getOriginalProtoFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameters.originalProtoFile.get()");
        File originalProtoFile = ((RegularFile)object2).getAsFile();
        Object object3 = ((ShrinkProtoResourcesParams)this.getParameters()).getShrunkProtoFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"parameters.shrunkProtoFile.get()");
        File shrunkProtoFile = ((RegularFile)object3).getAsFile();
        Object object4 = ((ShrinkProtoResourcesParams)this.getParameters()).getOutputFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"parameters.outputFile.get()");
        File file = shrunkFile = ((RegularFile)object4).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"shrunkFile");
        FileUtils.mkdirs((File)file.getParentFile());
        Object object5 = ((ShrinkProtoResourcesParams)this.getParameters()).getRequiresInitialConversionToProto().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"parameters.requiresInitialConversionToProto.get()");
        if (((Boolean)object5).booleanValue()) {
            Aapt2DaemonServiceKey aapt2DaemonServiceKey = aapt2ServiceKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)aapt2DaemonServiceKey, (String)"aapt2ServiceKey");
            closeable = (Closeable)Aapt2Daemon.getAaptDaemon$default(aapt2DaemonServiceKey, null, 2, null);
            bl = false;
            throwable = null;
            try {
                Aapt2DaemonManager.LeasedAaptDaemon it = (Aapt2DaemonManager.LeasedAaptDaemon)closeable;
                boolean bl2 = false;
                File file2 = originalFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"originalFile");
                File file3 = originalProtoFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"originalProtoFile");
                it.convert(new AaptConvertConfig(file2, file3, true), (ILogger)new LoggerWrapper(this.logger));
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        closeable = FileUtils.createZipFilesystem((Path)originalProtoFile.toPath());
        bl = false;
        throwable = null;
        try {
            ProguardMappingsRecorder proguardMappingsRecorder;
            Object object6;
            void $this$mapTo$iv$iv;
            FileSystem fs = (FileSystem)closeable;
            boolean bl3 = false;
            Object object7 = ((ShrinkProtoResourcesParams)this.getParameters()).getDex().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object7, (String)"parameters.dex.get()");
            Iterable $this$map$iv = (Iterable)object7;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Directory directory2 = (Directory)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                void v10 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"it");
                Path path = v10.getAsFile().toPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it.asFile.toPath()");
                DexUsageRecorder dexUsageRecorder = new DexUsageRecorder(path);
                collection.add(dexUsageRecorder);
            }
            List dexRecorders = (List)destination$iv$iv;
            Path path = fs.getPath("AndroidManifest.xml", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"fs.getPath(\"AndroidManifest.xml\")");
            ProtoAndroidManifestUsageRecorder manifestRecorder = new ProtoAndroidManifestUsageRecorder(path);
            Path path2 = ((File)((ShrinkProtoResourcesParams)this.getParameters()).getResourceDir().getAsFile().get()).toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"parameters.resourceDir.asFile.get().toPath()");
            ToolsAttributeUsageRecorder toolsRecorder = new ToolsAttributeUsageRecorder(path2);
            Path path3 = fs.getPath("resources.pb", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"fs.getPath(\"resources.pb\")");
            ProtoResourceTableGatherer gatherer = new ProtoResourceTableGatherer(path3);
            Path path4 = fs.getPath("res", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"fs.getPath(\"res\")");
            Path path5 = fs.getPath("resources.pb", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path5, (String)"fs.getPath(\"resources.pb\")");
            ProtoResourcesGraphBuilder graphBuilder = new ProtoResourcesGraphBuilder(path4, path5);
            Object object8 = (RegularFile)((ShrinkProtoResourcesParams)this.getParameters()).getMappingFileSrc().getOrNull();
            if (object8 != null && (object8 = object8.getAsFile()) != null) {
                object6 = object8;
                boolean bl5 = false;
                boolean bl6 = false;
                Object it = object6;
                boolean bl7 = false;
                Path path6 = ((File)it).toPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path6, (String)"it.toPath()");
                proguardMappingsRecorder = new ProguardMappingsRecorder(path6);
            } else {
                proguardMappingsRecorder = null;
            }
            ProguardMappingsRecorder obfuscationMappings = proguardMappingsRecorder;
            List list = CollectionsKt.listOf((Object)gatherer);
            ObfuscationMappingsRecorder obfuscationMappingsRecorder = obfuscationMappings;
            List list2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)dexRecorders, (Object)manifestRecorder), (Object)toolsRecorder);
            List list3 = CollectionsKt.listOf((Object)graphBuilder);
            Logger logger = this.logger;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
            Object object9 = ((ShrinkProtoResourcesParams)this.getParameters()).getReportFile().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object9, (String)"parameters.reportFile.get()");
            ShrinkerDebugReporter shrinkerDebugReporter = new LoggerAndFileDebugReporter(logger, ((RegularFile)object9).getAsFile());
            Object object10 = ((ShrinkProtoResourcesParams)this.getParameters()).getUsePreciseShrinking().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object10, (String)"parameters.usePreciseShrinking.get()");
            object6 = new ResourceShrinkerImpl(list, obfuscationMappingsRecorder, list2, list3, shrinkerDebugReporter, false, (Boolean)object10);
            boolean bl8 = false;
            Throwable throwable2 = null;
            try {
                ResourceShrinkerImpl shrinker = (ResourceShrinkerImpl)object6;
                boolean bl9 = false;
                shrinker.analyze();
                File file4 = originalProtoFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"originalProtoFile");
                File file5 = shrunkProtoFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"shrunkProtoFile");
                shrinker.rewriteResourcesInApkFormat(file4, file5, LinkedResourcesFormat.PROTO);
                if (shrunkProtoFile.length() < originalProtoFile.length()) {
                    Aapt2DaemonServiceKey aapt2DaemonServiceKey = aapt2ServiceKey;
                    Intrinsics.checkExpressionValueIsNotNull((Object)aapt2DaemonServiceKey, (String)"aapt2ServiceKey");
                    Closeable closeable2 = (Closeable)Aapt2Daemon.getAaptDaemon$default(aapt2DaemonServiceKey, null, 2, null);
                    boolean bl10 = false;
                    Throwable throwable3 = null;
                    try {
                        Aapt2DaemonManager.LeasedAaptDaemon it = (Aapt2DaemonManager.LeasedAaptDaemon)closeable2;
                        boolean bl11 = false;
                        it.convert(new AaptConvertConfig(shrunkProtoFile, shrunkFile, false), (ILogger)new LoggerWrapper(this.logger));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                    }
                    if (originalFile.length() < shrunkFile.length()) {
                        Files.copy((File)originalFile, (File)shrunkFile);
                    }
                } else {
                    Files.copy((File)originalFile, (File)shrunkFile);
                }
                if (shrinker.getUnusedResourceCount() > 0) {
                    long before = originalFile.length();
                    long after = shrunkFile.length();
                    int percent = (int)((before - after) * (long)100 / before);
                    String stat = "Removed unused resources: Binary resource data reduced from " + this.toKbString(before) + "KB to " + this.toKbString(after) + "KB. Removed " + percent + '%';
                    this.logger.info(stat);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object6, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String toKbString(long size) {
        return String.valueOf((int)size / 1024);
    }

    @Inject
    public ShrinkProtoResourcesAction() {
    }
}

