/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/ModuleMetadata;", "", "applicationId", "", "versionCode", "versionName", "debuggable", "", "abiFilters", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/util/List;)V", "getAbiFilters", "()Ljava/util/List;", "getApplicationId", "()Ljava/lang/String;", "getDebuggable", "()Z", "getVersionCode", "getVersionName", "save", "", "outputFile", "Ljava/io/File;", "Companion", "gradle-core"})
public final class ModuleMetadata {
    @NotNull
    private final String applicationId;
    @Nullable
    private final String versionCode;
    @Nullable
    private final String versionName;
    private final boolean debuggable;
    @NotNull
    private final List<String> abiFilters;
    @NotNull
    public static final String PERSISTED_FILE_NAME = "application-metadata.json";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void save(@NotNull File outputFile) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson2 = gsonBuilder.create();
        FileUtils.write((File)outputFile, (CharSequence)gson2.toJson((Object)this));
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @Nullable
    public final String getVersionCode() {
        return this.versionCode;
    }

    @Nullable
    public final String getVersionName() {
        return this.versionName;
    }

    public final boolean getDebuggable() {
        return this.debuggable;
    }

    @NotNull
    public final List<String> getAbiFilters() {
        return this.abiFilters;
    }

    public ModuleMetadata(@NotNull String applicationId2, @Nullable String versionCode2, @Nullable String versionName2, boolean debuggable, @NotNull List<String> abiFilters) {
        Intrinsics.checkParameterIsNotNull((Object)applicationId2, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull(abiFilters, (String)"abiFilters");
        this.applicationId = applicationId2;
        this.versionCode = versionCode2;
        this.versionName = versionName2;
        this.debuggable = debuggable;
        this.abiFilters = abiFilters;
    }

    @JvmStatic
    @NotNull
    public static final ModuleMetadata load(@NotNull File input) throws IOException {
        return Companion.load(input);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/tasks/ModuleMetadata$Companion;", "", "()V", "PERSISTED_FILE_NAME", "", "load", "Lcom/android/build/gradle/internal/tasks/ModuleMetadata;", "input", "Ljava/io/File;", "gradle-core"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final ModuleMetadata load(@NotNull File input) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            if (Intrinsics.areEqual((Object)input.getName(), (Object)ModuleMetadata.PERSISTED_FILE_NAME) ^ true) {
                throw (Throwable)new FileNotFoundException("No application declaration present.");
            }
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson2 = gsonBuilder.create();
            Closeable closeable = new FileReader(input);
            boolean bl = false;
            Throwable throwable = null;
            try {
                FileReader fileReader = (FileReader)closeable;
                boolean bl2 = false;
                Object object = gson2.fromJson((Reader)fileReader, ModuleMetadata.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(\n         \u2026ss.java\n                )");
                ModuleMetadata moduleMetadata = (ModuleMetadata)object;
                return moduleMetadata;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

