/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.variant.AndroidVersion;
import com.android.build.gradle.internal.BuildToolsExecutableInput;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsKt;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BundleInstallUtils;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.testing.ConnectedDeviceProvider;
import com.android.builder.internal.InstallUtils;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.builder.testing.api.DeviceConfigProviderImpl;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceProvider;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "apkBundle", "Lorg/gradle/api/file/RegularFileProperty;", "getApkBundle", "()Lorg/gradle/api/file/RegularFileProperty;", "buildTools", "Lcom/android/build/gradle/internal/BuildToolsExecutableInput;", "getBuildTools", "()Lcom/android/build/gradle/internal/BuildToolsExecutableInput;", "installOptions", "", "", "minSdkCodename", "minSdkVersion", "", "timeOutInMs", "doTaskAction", "", "CreationAction", "InstallRunnable", "Params", "gradle-core"})
public abstract class InstallVariantViaBundleTask
extends NonIncrementalTask {
    private int minSdkVersion;
    private String minSdkCodename;
    private int timeOutInMs;
    private List<String> installOptions;

    @Nested
    @NotNull
    public abstract BuildToolsExecutableInput getBuildTools();

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getApkBundle();

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(InstallRunnable.class, (Action)new Action<Params>(this){
            final /* synthetic */ InstallVariantViaBundleTask this$0;

            public final void execute(Params it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                it.getAdbExe().set(this.this$0.getBuildTools().adbExecutable());
                RegularFileProperty regularFileProperty = it.getApkBundle();
                Object object = this.this$0.getApkBundle().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"apkBundle.get()");
                regularFileProperty.set(((RegularFile)object).getAsFile());
                it.getTimeOutInMs().set((Object)InstallVariantViaBundleTask.access$getTimeOutInMs$p(this.this$0));
                it.getInstallOptions().set((Iterable)InstallVariantViaBundleTask.access$getInstallOptions$p(this.this$0));
                it.getVariantName().set((Object)this.this$0.getVariantName());
                it.getMinApiCodeName().set((Object)InstallVariantViaBundleTask.access$getMinSdkCodename$p(this.this$0));
                it.getMinSdkVersion().set((Object)InstallVariantViaBundleTask.access$getMinSdkVersion$p(this.this$0));
            }
            {
                this.this$0 = installVariantViaBundleTask;
            }
        });
    }

    public InstallVariantViaBundleTask() {
        boolean bl = false;
        this.installOptions = new ArrayList();
        this.getOutputs().upToDateWhen((Spec)1.INSTANCE);
    }

    public static final /* synthetic */ int access$getMinSdkVersion$p(InstallVariantViaBundleTask $this) {
        return $this.minSdkVersion;
    }

    public static final /* synthetic */ String access$getMinSdkCodename$p(InstallVariantViaBundleTask $this) {
        return $this.minSdkCodename;
    }

    public static final /* synthetic */ void access$setInstallOptions$p(InstallVariantViaBundleTask $this, List list) {
        $this.installOptions = list;
    }

    public static final /* synthetic */ int access$getTimeOutInMs$p(InstallVariantViaBundleTask $this) {
        return $this.timeOutInMs;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "adbExe", "Lorg/gradle/api/file/RegularFileProperty;", "getAdbExe", "()Lorg/gradle/api/file/RegularFileProperty;", "apkBundle", "getApkBundle", "installOptions", "Lorg/gradle/api/provider/ListProperty;", "", "getInstallOptions", "()Lorg/gradle/api/provider/ListProperty;", "minApiCodeName", "Lorg/gradle/api/provider/Property;", "getMinApiCodeName", "()Lorg/gradle/api/provider/Property;", "minSdkVersion", "", "getMinSdkVersion", "timeOutInMs", "getTimeOutInMs", "variantName", "getVariantName", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract RegularFileProperty getAdbExe();

        @NotNull
        public abstract RegularFileProperty getApkBundle();

        @NotNull
        public abstract Property<Integer> getTimeOutInMs();

        @NotNull
        public abstract ListProperty<String> getInstallOptions();

        @NotNull
        public abstract Property<String> getVariantName();

        @NotNull
        public abstract Property<String> getMinApiCodeName();

        @NotNull
        public abstract Property<Integer> getMinSdkVersion();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0015J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask$InstallRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask$Params;", "()V", "createDeviceProvider", "Lcom/android/builder/testing/api/DeviceProvider;", "iLogger", "Lcom/android/utils/ILogger;", "getApkFiles", "", "Ljava/nio/file/Path;", "device", "Lcom/android/builder/testing/api/DeviceConnector;", "run", "", "gradle-core"})
    public static abstract class InstallRunnable
    extends ProfileAwareWorkAction<Params> {
        @Override
        public void run() {
            Logger logger = Logging.getLogger(InstallVariantViaBundleTask.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(Instal\u2026iaBundleTask::class.java)");
            Logger logger2 = logger;
            LoggerWrapper iLogger = new LoggerWrapper(logger2);
            DeviceProvider deviceProvider = this.createDeviceProvider(iLogger);
            deviceProvider.use((Callable)new Callable<Unit>(this, deviceProvider, iLogger, logger2){
                final /* synthetic */ InstallRunnable this$0;
                final /* synthetic */ DeviceProvider $deviceProvider;
                final /* synthetic */ LoggerWrapper $iLogger;
                final /* synthetic */ Logger $logger;

                /*
                 * WARNING - void declaration
                 */
                public final void call() {
                    int successfulInstallCount = 0;
                    List devices = this.$deviceProvider.getDevices();
                    Object object = ((Params)this.this$0.getParameters()).getMinSdkVersion().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.minSdkVersion.get()");
                    com.android.sdklib.AndroidVersion androidVersion = new com.android.sdklib.AndroidVersion(((Number)object).intValue(), (String)((Params)this.this$0.getParameters()).getMinApiCodeName().getOrNull());
                    for (DeviceConnector device : devices) {
                        void $this$mapTo$iv$iv;
                        if (!InstallUtils.checkDeviceApiLevel((DeviceConnector)device, (com.android.sdklib.AndroidVersion)androidVersion, (ILogger)this.$iLogger, (String)((String)((Params)this.this$0.getParameters()).getProjectName().get()), (String)((String)((Params)this.this$0.getParameters()).getVariantName().get()))) continue;
                        Object[] objectArray = new Object[3];
                        DeviceConnector deviceConnector = device;
                        Intrinsics.checkExpressionValueIsNotNull((Object)deviceConnector, (String)"device");
                        objectArray[0] = deviceConnector.getName();
                        objectArray[1] = ((Params)this.this$0.getParameters()).getProjectName().get();
                        objectArray[2] = ((Params)this.this$0.getParameters()).getVariantName().get();
                        this.$logger.lifecycle("Generating APKs for device '{}' for {}:{}", objectArray);
                        List<Path> apkPaths = this.this$0.getApkFiles(device);
                        if (apkPaths.isEmpty()) {
                            this.$logger.lifecycle("Skipping device '{}' for '{}:{}': No APK generated", new Object[]{device.getName(), ((Params)this.this$0.getParameters()).getProjectName().get(), ((Params)this.this$0.getParameters()).getVariantName().get()});
                            continue;
                        }
                        Iterable $this$map$iv = apkPaths;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Path path = (Path)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            File file = it.toFile();
                            collection.add(file);
                        }
                        List apkFiles = (List)destination$iv$iv;
                        this.$logger.lifecycle("Installing APKs '{}' on '{}' for {}:{}", new Object[]{FileUtils.getNamesAsCommaSeparatedList((Iterable)apkFiles), device.getName(), ((Params)this.this$0.getParameters()).getProjectName().get(), ((Params)this.this$0.getParameters()).getVariantName().get()});
                        if (apkFiles.size() > 1) {
                            Collection collection = (Collection)((Params)this.this$0.getParameters()).getInstallOptions().get();
                            Object object2 = ((Params)this.this$0.getParameters()).getTimeOutInMs().get();
                            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameters.timeOutInMs.get()");
                            device.installPackages(apkFiles, collection, ((Number)object2).intValue(), (ILogger)this.$iLogger);
                            ++successfulInstallCount;
                            continue;
                        }
                        File file = (File)apkFiles.get(0);
                        Collection collection = (Collection)((Params)this.this$0.getParameters()).getInstallOptions().get();
                        Object object3 = ((Params)this.this$0.getParameters()).getTimeOutInMs().get();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"parameters.timeOutInMs.get()");
                        device.installPackage(file, collection, ((Number)object3).intValue(), (ILogger)this.$iLogger);
                        ++successfulInstallCount;
                    }
                    if (successfulInstallCount == 0) {
                        throw (Throwable)new GradleException("Failed to install on any devices.");
                    }
                    this.$logger.quiet("Installed on {} {}.", new Object[]{successfulInstallCount, successfulInstallCount == 1 ? "device" : "devices"});
                }
                {
                    this.this$0 = installRunnable;
                    this.$deviceProvider = deviceProvider;
                    this.$iLogger = loggerWrapper;
                    this.$logger = logger;
                }
            });
        }

        @NotNull
        protected DeviceProvider createDeviceProvider(@NotNull ILogger iLogger) {
            Intrinsics.checkParameterIsNotNull((Object)iLogger, (String)"iLogger");
            Object object = ((Params)this.getParameters()).getAdbExe().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.adbExe.get()");
            File file = ((RegularFile)object).getAsFile();
            Object object2 = ((Params)this.getParameters()).getTimeOutInMs().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameters.timeOutInMs.get()");
            return new ConnectedDeviceProvider(file, ((Number)object2).intValue(), iLogger);
        }

        @VisibleForTesting
        @NotNull
        protected List<Path> getApkFiles(@NotNull DeviceConnector device) {
            Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
            Object object = ((Params)this.getParameters()).getApkBundle().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.apkBundle.get()");
            Path path = ((RegularFile)object).getAsFile().toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"parameters.apkBundle.get().asFile.toPath()");
            return BundleInstallUtils.getApkFiles$default(path, (DeviceConfigProvider)new DeviceConfigProviderImpl(device), null, 4, null);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<InstallVariantViaBundleTask, ApkCreationConfig> {
        @Override
        @NotNull
        public String getName() {
            return VariantTaskCreationAction.computeTaskName$default(this, "install", null, 2, null);
        }

        @Override
        @NotNull
        public Class<InstallVariantViaBundleTask> getType() {
            return InstallVariantViaBundleTask.class;
        }

        @Override
        public void configure(@NotNull InstallVariantViaBundleTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            task.setDescription("Installs the " + ((ApkCreationConfig)this.creationConfig).getDescription() + "");
            task.setGroup("Install");
            Object object = ((ApkCreationConfig)this.creationConfig).getMinSdkVersion();
            boolean bl = false;
            boolean bl2 = false;
            AndroidVersion it = object;
            boolean bl3 = false;
            task.minSdkVersion = it.getApiLevel();
            task.minSdkCodename = it.getCodename();
            Collection<String> collection = ((ApkCreationConfig)this.creationConfig).getGlobalScope().getExtension().getAdbOptions().getInstallOptions();
            if (collection != null) {
                object = collection;
                bl = false;
                bl2 = false;
                it = object;
                boolean bl4 = false;
                task.installOptions.addAll(it);
            }
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.APKS_FROM_BUNDLE.INSTANCE, (Property)task.getApkBundle());
            task.timeOutInMs = ((ApkCreationConfig)this.creationConfig).getGlobalScope().getExtension().getAdbOptions().getTimeOutInMs();
            SdkComponentsKt.initialize(task.getBuildTools(), this.creationConfig);
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<InstallVariantViaBundleTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getTaskContainer().setInstallTask(taskProvider);
        }

        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
        }
    }
}

