/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.options;

import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import org.gradle.api.Project;

public final class SyncOptions {
    private SyncOptions() {
    }

    public static EvaluationMode getModelQueryMode(ProjectOptions options) {
        if (options.get(BooleanOption.IDE_BUILD_MODEL_ONLY_ADVANCED)) {
            return EvaluationMode.IDE;
        }
        return EvaluationMode.STANDARD;
    }

    public static ErrorFormatMode getErrorFormatMode(ProjectOptions options) {
        if (options.get(BooleanOption.IDE_INVOKED_FROM_IDE)) {
            return ErrorFormatMode.MACHINE_PARSABLE;
        }
        return ErrorFormatMode.HUMAN_READABLE;
    }

    public static Integer buildModelOnlyVersion(ProjectOptions options, Project project) {
        Object revision = project.getExtensions().getExtraProperties().getProperties().get(IntegerOption.IDE_BUILD_MODEL_ONLY_VERSION.getPropertyName());
        if (revision != null) {
            return IntegerOption.IDE_BUILD_MODEL_ONLY_VERSION.parse(revision);
        }
        if (options.get(BooleanOption.IDE_BUILD_MODEL_ONLY_ADVANCED)) {
            return 1;
        }
        if (options.get(BooleanOption.IDE_BUILD_MODEL_ONLY)) {
            return 0;
        }
        return null;
    }

    public static enum EvaluationMode {
        STANDARD,
        IDE;

    }

    public static enum ErrorFormatMode {
        MACHINE_PARSABLE,
        HUMAN_READABLE;

    }
}

