/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.Version;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.VariantOutputConfiguration;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsKt;
import com.android.build.gradle.internal.StartParameterUtils;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollections;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.LintClassLoaderBuildService;
import com.android.build.gradle.internal.tasks.NonIncrementalGlobalTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.builder.core.VariantType;
import com.android.builder.errors.DefaultIssueReporter;
import com.android.builder.errors.IssueReporter;
import com.android.repository.Revision;
import com.android.tools.lint.gradle.api.LintClassLoaderProvider;
import com.android.tools.lint.gradle.api.LintExecutionRequest;
import com.android.tools.lint.gradle.api.ReflectiveLintRunner;
import com.android.tools.lint.model.LintModelFactory;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public abstract class LintBaseTask
extends NonIncrementalGlobalTask {
    public static final String LINT_CLASS_PATH = "lintClassPath";
    protected static final Logger LOG = Logging.getLogger(LintBaseTask.class);
    FileCollection lintClassPath;
    protected transient LintOptions lintOptions;
    protected File sdkHome;
    protected ToolingModelBuilderRegistry toolingRegistry;
    protected File reportsDir;

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public FileCollection getLintClassPath() {
        return this.lintClassPath;
    }

    @Internal(value="Temporary to suppress Gradle warnings (bug 135900510), may need more investigation")
    public LintOptions getLintOptions() {
        return this.lintOptions;
    }

    @Internal
    public abstract Property<LintClassLoaderBuildService> getLintClassLoader();

    protected void runLint(LintBaseTaskDescriptor descriptor) {
        if (Boolean.TRUE.equals(StartParameterUtils.isConfigurationCache(this.getProject().getGradle().getStartParameter()))) {
            throw new IllegalStateException("Android Lint in Android Gradle Plugin " + Version.ANDROID_GRADLE_PLUGIN_VERSION + " is incompatible with configuration caching.\n Please try Android Gradle Plugin 7 or above, or disable configuration caching.");
        }
        FileCollection lintClassPath = this.getLintClassPath();
        if (lintClassPath != null) {
            new ReflectiveLintRunner().runLint((LintClassLoaderProvider)this.getLintClassLoader().get(), (LintExecutionRequest)descriptor, lintClassPath.getFiles());
        }
    }

    @Internal
    public abstract Property<Revision> getBuildToolsRevision();

    protected static void addModelArtifactsToInputs(ConfigurableFileCollection inputs, ComponentImpl component2) {
        inputs.from(new Object[]{() -> new ArtifactCollections(component2, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH).getAllCollections()});
        inputs.from(new Object[]{() -> new ArtifactCollections(component2, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH).getAllCollections()});
        if (component2 instanceof VariantImpl) {
            VariantImpl variant = (VariantImpl)component2;
            for (VariantType variantType : VariantType.Companion.getTestComponents()) {
                ComponentImpl testVariant = variant.getTestComponents().get(variantType);
                if (testVariant == null) continue;
                LintBaseTask.addModelArtifactsToInputs(inputs, testVariant);
            }
        }
    }

    public static abstract class BaseCreationAction<T extends LintBaseTask>
    extends GlobalTaskCreationAction<T> {
        public BaseCreationAction(GlobalScope globalScope) {
            super(globalScope);
        }

        protected GlobalScope getGlobalScope() {
            return this.globalScope;
        }

        @Override
        public void configure(T lintTask) {
            super.configure(lintTask);
            lintTask.setGroup("verification");
            ((LintBaseTask)lintTask).lintOptions = this.globalScope.getExtension().getLintOptions();
            ((LintBaseTask)lintTask).sdkHome = SdkComponentsKt.getSdkDir(lintTask.getProject().getRootDir(), (IssueReporter)new DefaultIssueReporter((ILogger)LoggerWrapper.getLogger(LintBaseTask.class)));
            ((LintBaseTask)lintTask).toolingRegistry = this.globalScope.getToolingRegistry();
            ((LintBaseTask)lintTask).reportsDir = this.globalScope.getReportsDir();
            HasConfigurableValuesKt.setDisallowChanges(((LintBaseTask)lintTask).getBuildToolsRevision(), this.getGlobalScope().getProject().provider(this.getGlobalScope().getExtension()::getBuildToolsRevision));
            ((LintBaseTask)lintTask).lintClassPath = this.globalScope.getProject().getConfigurations().getByName(LintBaseTask.LINT_CLASS_PATH);
            ((LintBaseTask)lintTask).getLintClassLoader().set(BuildServicesKt.getBuildService(lintTask.getProject().getGradle().getSharedServices(), LintClassLoaderBuildService.class));
        }
    }

    public static class VariantInputs
    implements com.android.tools.lint.gradle.api.VariantInputs {
        private final String name;
        private final Provider<? extends FileSystemLocation> mergedManifest;
        private final Provider<RegularFile> mergedManifestReport;
        private final FileCollection lintRuleJars;
        private final ConfigurableFileCollection allInputs;

        public VariantInputs(ComponentImpl component2) {
            GlobalScope globalScope = component2.getGlobalScope();
            this.name = component2.getName();
            this.allInputs = globalScope.getProject().files(new Object[0]);
            Object[] objectArray = new Object[1];
            FileCollection localLintJarCollection = globalScope.getLocalCustomLintChecks();
            objectArray[0] = localLintJarCollection;
            this.allInputs.from(objectArray);
            Object[] objectArray2 = new Object[1];
            FileCollection dependencyLintJarCollection = component2.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LINT);
            objectArray2[0] = dependencyLintJarCollection;
            this.allInputs.from(objectArray2);
            this.lintRuleJars = globalScope.getProject().files(new Object[]{localLintJarCollection, dependencyLintJarCollection});
            ArtifactsImpl artifacts2 = component2.getArtifacts();
            Object tmpMergedManifest = artifacts2.get(InternalArtifactType.PACKAGED_MANIFESTS.INSTANCE);
            if (!tmpMergedManifest.isPresent()) {
                tmpMergedManifest = artifacts2.get(ArtifactType.MERGED_MANIFEST.INSTANCE);
            }
            if (!tmpMergedManifest.isPresent()) {
                throw new RuntimeException("VariantInputs initialized with no merged manifest on: " + component2.getVariantType());
            }
            this.mergedManifest = tmpMergedManifest;
            this.allInputs.from(new Object[]{this.mergedManifest});
            this.mergedManifestReport = artifacts2.get(InternalArtifactType.MANIFEST_MERGE_REPORT.INSTANCE);
            if (!this.mergedManifest.isPresent()) {
                throw new RuntimeException("VariantInputs initialized with no merged manifest report on: " + component2.getVariantType());
            }
            this.allInputs.from(new Object[]{this.mergedManifestReport});
            this.allInputs.from(new Object[]{component2.getArtifacts().getAllClasses()});
            LintBaseTask.addModelArtifactsToInputs(this.allInputs, component2);
        }

        public FileCollection getAllInputs() {
            return this.allInputs;
        }

        public String getName() {
            return this.name;
        }

        public FileCollection getRuleJars() {
            return this.lintRuleJars;
        }

        public File getMergedManifest() {
            File file = ((FileSystemLocation)this.mergedManifest.get()).getAsFile();
            if (file.isFile()) {
                return file;
            }
            BuiltArtifactsImpl manifests = BuiltArtifactsLoaderImpl.loadFromDirectory(file);
            if (manifests == null || manifests.getElements().isEmpty()) {
                throw new RuntimeException("Can't find any manifest in folder: " + file);
            }
            Optional<String> mainManifest = manifests.getElements().stream().filter(buildOutput -> buildOutput.getOutputType() == VariantOutputConfiguration.OutputType.SINGLE).map(BuiltArtifact::getOutputFile).findFirst();
            if (mainManifest.isPresent()) {
                return new File(mainManifest.get());
            }
            Optional<String> universalSplit = manifests.getElements().stream().filter(output2 -> output2.getOutputType() == VariantOutputConfiguration.OutputType.UNIVERSAL).map(BuiltArtifact::getOutputFile).findFirst();
            return new File(universalSplit.orElseGet(() -> manifests.getElements().iterator().next().getOutputFile()));
        }

        public File getManifestMergeReport() {
            if (this.mergedManifestReport.isPresent()) {
                return ((RegularFile)this.mergedManifestReport.get()).getAsFile();
            }
            return null;
        }
    }

    protected abstract class LintBaseTaskDescriptor
    extends LintExecutionRequest {
        private final Cache<Pair<String, String>, List<File>> kotlinSourceFoldersCache = CacheBuilder.newBuilder().build();

        protected LintBaseTaskDescriptor() {
        }

        public File getSdkHome() {
            return LintBaseTask.this.sdkHome;
        }

        public ToolingModelBuilderRegistry getToolingRegistry() {
            return LintBaseTask.this.toolingRegistry;
        }

        public LintModelLintOptions getLintOptions() {
            if (LintBaseTask.this.lintOptions != null) {
                return LintModelFactory.getLintOptions((com.android.builder.model.LintOptions)LintBaseTask.this.lintOptions);
            }
            return null;
        }

        public File getReportsDir() {
            return LintBaseTask.this.reportsDir;
        }

        public Project getProject() {
            return LintBaseTask.this.getProject();
        }

        public Revision getBuildToolsRevision() {
            return (Revision)LintBaseTask.this.getBuildToolsRevision().get();
        }

        public void warn(String message, Object ... args2) {
            LOG.warn(message, args2);
        }

        public String getGradlePluginVersion() {
            return Version.ANDROID_GRADLE_PLUGIN_VERSION;
        }

        private List<File> doFetchKotlinSourceFolders(String sourceSetName, Project project) throws Exception {
            BaseExtension extension = (BaseExtension)project.getExtensions().getByName("android");
            Object kotlinSourceSet = ((HasConvention)extension.getSourceSets().getByName(sourceSetName)).getConvention().getPlugins().get("kotlin");
            Method getSourceDirectorySet = kotlinSourceSet.getClass().getDeclaredMethod("getKotlin", new Class[0]);
            SourceDirectorySet sourceDirectorySet = (SourceDirectorySet)getSourceDirectorySet.invoke(kotlinSourceSet, new Object[0]);
            return sourceDirectorySet.getSrcDirs().stream().filter(File::exists).collect(Collectors.toList());
        }

        private List<File> fetchKotlinSourceFolders(String sourceSetName, Project project) {
            try {
                return (List)this.kotlinSourceFoldersCache.get((Object)Pair.of((Object)sourceSetName, (Object)project.getPath()), () -> this.doFetchKotlinSourceFolders(sourceSetName, project));
            }
            catch (Throwable e) {
                LintBaseTask.this.getLogger().warn("Unable to fetch kotlin source folders for source set " + sourceSetName, e);
                return Collections.emptyList();
            }
        }

        public List<File> getKotlinSourceFolders(String variantName, Project project) {
            DomainObjectSet<ApplicationVariant> variants;
            if (project == null || !project.getPlugins().hasPlugin("kotlin-android")) {
                return Collections.emptyList();
            }
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            BaseExtension extension = (BaseExtension)project.getExtensions().getByName("android");
            if (extension instanceof AppExtension) {
                variants = ((AppExtension)extension).getApplicationVariants();
            } else if (extension instanceof LibraryExtension) {
                variants = ((LibraryExtension)extension).getLibraryVariants();
            } else {
                return Collections.emptyList();
            }
            variants.matching(it -> it.getName().equals(variantName)).forEach(variant -> variant.getSourceSets().forEach(sourceProvider -> builder.addAll(this.fetchKotlinSourceFolders(sourceProvider.getName(), project))));
            return builder.build().asList();
        }
    }
}

