/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclaration;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;

public abstract class FeatureSplitDeclarationWriterTask
extends NonIncrementalTask {
    @VisibleForTesting
    String uniqueIdentifier;

    @Input
    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    @Input
    public abstract Property<String> getApplicationId();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Override
    protected void doTaskAction() throws IOException {
        FeatureSplitDeclaration declaration = new FeatureSplitDeclaration(this.uniqueIdentifier, (String)this.getApplicationId().get());
        declaration.save(((Directory)this.getOutputDirectory().get()).getAsFile());
    }

    public static class CreationAction
    extends VariantTaskCreationAction<FeatureSplitDeclarationWriterTask, VariantCreationConfig> {
        public CreationAction(VariantCreationConfig creationConfig) {
            super(creationConfig);
        }

        @Override
        public String getName() {
            return this.computeTaskName("feature", "Writer");
        }

        @Override
        public Class<FeatureSplitDeclarationWriterTask> getType() {
            return FeatureSplitDeclarationWriterTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<FeatureSplitDeclarationWriterTask> taskProvider) {
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, FeatureSplitDeclarationWriterTask::getOutputDirectory).withName("out").on(InternalArtifactType.METADATA_FEATURE_DECLARATION.INSTANCE);
        }

        @Override
        public void configure(FeatureSplitDeclarationWriterTask task) {
            super.configure(task);
            task.uniqueIdentifier = task.getProject().getPath();
            task.getApplicationId().set(((VariantCreationConfig)this.creationConfig).getPackageName());
            task.getApplicationId().disallowChanges();
        }
    }
}

