/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.coverage.JacocoConfigurations;
import com.android.build.gradle.internal.dependency.RecalculateStackFramesTransform;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.DesugarTask$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.DesugarTask$CreationAction$handleProvider$2;
import com.android.build.gradle.internal.tasks.DesugarTask$CreationAction$handleProvider$3;
import com.android.build.gradle.internal.tasks.DesugarTask$CreationAction$handleProvider$4;
import com.android.build.gradle.internal.tasks.DesugarTaskDelegate;
import com.android.build.gradle.internal.tasks.JacocoTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.ide.common.repository.GradleVersion;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Logger;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001%B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010#\u001a\u00020$H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u0014\u0010\u0012\u001a\u00020\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u0014\u0010\u0019\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\bR\u0014\u0010\u001b\u001a\u00020\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0015R\u0014\u0010\u001d\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\bR\u0014\u0010\u001f\u001a\u00020\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0015R\u0014\u0010!\u001a\u00020\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/android/build/gradle/internal/tasks/DesugarTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "bootClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBootClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "desugaringClasspath", "getDesugaringClasspath", "enableBugFixForJacoco", "Lorg/gradle/api/provider/Property;", "", "getEnableBugFixForJacoco", "()Lorg/gradle/api/provider/Property;", "externaLibsClasses", "getExternaLibsClasses", "externalLibsOutput", "Lorg/gradle/api/file/DirectoryProperty;", "getExternalLibsOutput", "()Lorg/gradle/api/file/DirectoryProperty;", "minSdk", "", "getMinSdk", "projectClasses", "getProjectClasses", "projectOutput", "getProjectOutput", "subProjectClasses", "getSubProjectClasses", "subProjectOutput", "getSubProjectOutput", "tmpDir", "getTmpDir", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class DesugarTask
extends NonIncrementalTask {
    @NotNull
    private final Property<Integer> minSdk;
    @NotNull
    private final Property<Boolean> enableBugFixForJacoco;

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getProjectClasses();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getSubProjectClasses();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getExternaLibsClasses();

    @CompileClasspath
    @NotNull
    public abstract ConfigurableFileCollection getDesugaringClasspath();

    @CompileClasspath
    @NotNull
    public abstract ConfigurableFileCollection getBootClasspath();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getProjectOutput();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getSubProjectOutput();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getExternalLibsOutput();

    @LocalState
    @NotNull
    public abstract DirectoryProperty getTmpDir();

    @Input
    @NotNull
    public final Property<Integer> getMinSdk() {
        return this.minSdk;
    }

    @Input
    @NotNull
    public final Property<Boolean> getEnableBugFixForJacoco() {
        return this.enableBugFixForJacoco;
    }

    @Override
    protected void doTaskAction() {
        AndroidVariantTask androidVariantTask = this;
        Set set = this.getProjectClasses().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"projectClasses.files");
        Set set2 = this.getSubProjectClasses().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"subProjectClasses.files");
        Set set3 = this.getExternaLibsClasses().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"externaLibsClasses.files");
        Set set4 = this.getDesugaringClasspath().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set4, (String)"desugaringClasspath.files");
        Object object = this.getProjectOutput().getAsFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"projectOutput.asFile.get()");
        File file = (File)object;
        Object object2 = this.getSubProjectOutput().getAsFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"subProjectOutput.asFile.get()");
        File file2 = (File)object2;
        Object object3 = this.getExternalLibsOutput().getAsFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"externalLibsOutput.asFile.get()");
        File file3 = (File)object3;
        Object object4 = this.getTmpDir().getAsFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"tmpDir.asFile.get()");
        File file4 = (File)object4;
        Set set5 = this.getBootClasspath().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set5, (String)"bootClasspath.files");
        Object object5 = this.minSdk.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"minSdk.get()");
        int n = ((Number)object5).intValue();
        Object object6 = this.enableBugFixForJacoco.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"enableBugFixForJacoco.get()");
        boolean bl = (Boolean)object6;
        Logger logger = Logger.getLogger(DesugarTask.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getLogger(DesugarTask::class.java)");
        new DesugarTaskDelegate(androidVariantTask, set, set2, set3, set4, file, file2, file3, file4, set5, n, bl, logger.isDebugEnabled(), this.getWorkerExecutor()).doProcess();
    }

    @Inject
    public DesugarTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        Property property = objectFactory.property(Integer.TYPE);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"objectFactory.property(Int::class.java)");
        this.minSdk = property;
        Property property2 = objectFactory.property(Boolean.TYPE);
        Intrinsics.checkExpressionValueIsNotNull((Object)property2, (String)"objectFactory.property(Boolean::class.java)");
        this.enableBugFixForJacoco = property2;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/DesugarTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/DesugarTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "projectClasses", "Lorg/gradle/api/file/FileCollection;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<DesugarTask, VariantCreationConfig> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<DesugarTask> type;
        private final FileCollection projectClasses;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<DesugarTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<DesugarTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)DesugarTask$CreationAction$handleProvider$1.INSTANCE).on(InternalArtifactType.DESUGAR_PROJECT_CLASSES.INSTANCE);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)DesugarTask$CreationAction$handleProvider$2.INSTANCE).on(InternalArtifactType.DESUGAR_SUB_PROJECT_CLASSES.INSTANCE);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)DesugarTask$CreationAction$handleProvider$3.INSTANCE).on(InternalArtifactType.DESUGAR_EXTERNAL_LIBS_CLASSES.INSTANCE);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)DesugarTask$CreationAction$handleProvider$4.INSTANCE).on(InternalArtifactType.DESUGAR_LOCAL_STATE_OUTPUT.INSTANCE);
        }

        @Override
        public void configure(@NotNull DesugarTask task) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            VariantScope variantScope = ((VariantCreationConfig)this.creationConfig).getVariantScope();
            task.getMinSdk().set((Object)VariantApiExtensionsKt.getFeatureLevel(((VariantCreationConfig)this.creationConfig).getMinSdkVersion()));
            try {
                GradleVersion current = GradleVersion.parse((String)JacocoTask.getJacocoVersion(this.creationConfig));
                bl = JacocoConfigurations.MIN_WITHOUT_BROKEN_BYTECODE.compareTo(current) > 0;
            }
            catch (Throwable ignored) {
                bl = true;
            }
            boolean enableDesugarBugFixForJacoco = bl;
            task.getEnableBugFixForJacoco().set((Object)enableDesugarBugFixForJacoco);
            task.getProjectClasses().from(new Object[]{this.projectClasses});
            task.getSubProjectClasses().from(new Object[]{VariantDependencies.getArtifactFileCollection$default(((VariantCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.CLASSES_JAR, null, 8, null)});
            task.getExternaLibsClasses().from(new Object[]{((VariantCreationConfig)this.creationConfig).getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES_FIXED_FRAMES_JAR, RecalculateStackFramesTransform.Companion.getAttributesForConfig(this.creationConfig))});
            task.getDesugaringClasspath().from(new Object[]{variantScope.getProvidedOnlyClasspath()});
            task.getBootClasspath().from(new Object[]{variantScope.getBootClasspath()});
            ((VariantCreationConfig)this.creationConfig).onTestedConfig((Function1)new Function1<VariantCreationConfig, ConfigurableFileCollection>(task){
                final /* synthetic */ DesugarTask $task;

                @Nullable
                public final ConfigurableFileCollection invoke(@NotNull VariantCreationConfig it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$task.getDesugaringClasspath().from(new Object[]{VariantDependencies.getArtifactCollection$default(it.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES_JAR, null, 8, null).getArtifactFiles()});
                }
                {
                    this.$task = desugarTask;
                    super(1);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        public CreationAction(@NotNull VariantCreationConfig creationConfig) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
            this.name = VariantTaskCreationAction.computeTaskName$default(this, "desugar", null, 2, null);
            this.type = DesugarTask.class;
            FileCollection fileCollection2 = creationConfig.getTransformManager().getPipelineOutputAsFileCollection(1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"creationConfig.transform\u2026ROJECT)\n                }");
            this.projectClasses = fileCollection2;
            creationConfig.getTransformManager().consumeStreams(SetsKt.mutableSetOf((Object[])new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT, QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.EXTERNAL_LIBRARIES}), SetsKt.setOf((Object)QualifiedContent.DefaultContentType.CLASSES));
            Map $this$forEach$iv = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)InternalArtifactType.DESUGAR_PROJECT_CLASSES.INSTANCE), (Object)QualifiedContent.Scope.PROJECT), TuplesKt.to((Object)((Object)InternalArtifactType.DESUGAR_SUB_PROJECT_CLASSES.INSTANCE), (Object)QualifiedContent.Scope.SUB_PROJECTS), TuplesKt.to((Object)((Object)InternalArtifactType.DESUGAR_EXTERNAL_LIBS_CLASSES.INSTANCE), (Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES)});
            boolean $i$f$forEach = false;
            Map map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                void output2;
                Map.Entry element$iv;
                Map.Entry $dstr$output$scope = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry entry = $dstr$output$scope;
                boolean bl3 = false;
                InternalArtifactType internalArtifactType = (InternalArtifactType)((Object)entry.getKey());
                entry = $dstr$output$scope;
                bl3 = false;
                QualifiedContent.Scope scope = (QualifiedContent.Scope)entry.getValue();
                FileTree processedClasses = creationConfig.getServices().fileCollection(creationConfig.getArtifacts().get((Artifact.SingleArtifact)output2)).getAsFileTree();
                creationConfig.getTransformManager().addStream(OriginalStream.builder("desugared-classes-" + scope.name()).addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)scope).setFileCollection((FileCollection)processedClasses).build());
            }
        }
    }
}

